/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.Util;

public class CommandLine
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<String> args;
    private final List<Option> options;
    private final transient Consumer<Option> deprecatedHandler;

    public static Builder builder() {
        return new Builder();
    }

    protected CommandLine() {
        this(new LinkedList<String>(), new ArrayList<Option>(), Builder.DEPRECATED_HANDLER);
    }

    private CommandLine(List<String> args2, List<Option> options2, Consumer<Option> deprecatedHandler) {
        this.args = Objects.requireNonNull(args2, "args");
        this.options = Objects.requireNonNull(options2, "options");
        this.deprecatedHandler = deprecatedHandler;
    }

    protected void addArg(String arg2) {
        if (arg2 != null) {
            this.args.add(arg2);
        }
    }

    protected void addOption(Option opt) {
        if (opt != null) {
            this.options.add(opt);
        }
    }

    private <T> T get(Supplier<T> supplier) {
        return supplier == null ? null : (T)supplier.get();
    }

    public List<String> getArgList() {
        return this.args;
    }

    public String[] getArgs() {
        return this.args.toArray(Util.EMPTY_STRING_ARRAY);
    }

    @Deprecated
    public Object getOptionObject(char opt) {
        return this.getOptionObject(String.valueOf(opt));
    }

    @Deprecated
    public Object getOptionObject(String opt) {
        try {
            return this.getParsedOptionValue(opt);
        }
        catch (ParseException pe) {
            System.err.println("Exception found converting " + opt + " to desired type: " + pe.getMessage());
            return null;
        }
    }

    public Properties getOptionProperties(Option option) {
        Properties props = new Properties();
        for (Option processedOption : this.options) {
            if (!processedOption.equals(option)) continue;
            this.processPropertiesFromValues(props, processedOption.getValuesList());
        }
        return props;
    }

    public Properties getOptionProperties(String opt) {
        Properties props = new Properties();
        for (Option option : this.options) {
            if (!opt.equals(option.getOpt()) && !opt.equals(option.getLongOpt())) continue;
            this.processPropertiesFromValues(props, option.getValuesList());
        }
        return props;
    }

    public Option[] getOptions() {
        return this.options.toArray(Option.EMPTY_ARRAY);
    }

    public String getOptionValue(char opt) {
        return this.getOptionValue(String.valueOf(opt));
    }

    public String getOptionValue(char opt, String defaultValue) {
        return this.getOptionValue(String.valueOf(opt), () -> defaultValue);
    }

    public String getOptionValue(char opt, Supplier<String> defaultValue) {
        return this.getOptionValue(String.valueOf(opt), defaultValue);
    }

    public String getOptionValue(Option option) {
        String[] values2 = this.getOptionValues(option);
        return values2 == null ? null : values2[0];
    }

    public String getOptionValue(Option option, String defaultValue) {
        return this.getOptionValue(option, () -> defaultValue);
    }

    public String getOptionValue(Option option, Supplier<String> defaultValue) {
        String answer = this.getOptionValue(option);
        return answer != null ? answer : this.get(defaultValue);
    }

    public String getOptionValue(String opt) {
        return this.getOptionValue(this.resolveOption(opt));
    }

    public String getOptionValue(String opt, String defaultValue) {
        return this.getOptionValue(this.resolveOption(opt), () -> defaultValue);
    }

    public String getOptionValue(String opt, Supplier<String> defaultValue) {
        return this.getOptionValue(this.resolveOption(opt), defaultValue);
    }

    public String[] getOptionValues(char opt) {
        return this.getOptionValues(String.valueOf(opt));
    }

    public String[] getOptionValues(Option option) {
        if (option == null) {
            return null;
        }
        if (option.isDeprecated()) {
            this.handleDeprecated(option);
        }
        ArrayList<String> values2 = new ArrayList<String>();
        for (Option processedOption : this.options) {
            if (!processedOption.equals(option)) continue;
            values2.addAll(processedOption.getValuesList());
        }
        return values2.isEmpty() ? null : values2.toArray(Util.EMPTY_STRING_ARRAY);
    }

    public String[] getOptionValues(String opt) {
        return this.getOptionValues(this.resolveOption(opt));
    }

    public <T> T getParsedOptionValue(char opt) throws ParseException {
        return this.getParsedOptionValue(String.valueOf(opt));
    }

    public <T> T getParsedOptionValue(char opt, Supplier<T> defaultValue) throws ParseException {
        return (T)this.getParsedOptionValue(String.valueOf(opt), (T)defaultValue);
    }

    public <T> T getParsedOptionValue(char opt, T defaultValue) throws ParseException {
        return this.getParsedOptionValue(String.valueOf(opt), defaultValue);
    }

    public <T> T getParsedOptionValue(Option option) throws ParseException {
        return (T)this.getParsedOptionValue(option, (T)((Supplier<Object>)() -> null));
    }

    public <T> T getParsedOptionValue(Option option, Supplier<T> defaultValue) throws ParseException {
        if (option == null) {
            return this.get(defaultValue);
        }
        String res = this.getOptionValue(option);
        try {
            if (res == null) {
                return this.get(defaultValue);
            }
            return (T)option.getConverter().apply(res);
        }
        catch (Throwable e) {
            throw ParseException.wrap(e);
        }
    }

    public <T> T getParsedOptionValue(Option option, T defaultValue) throws ParseException {
        return (T)this.getParsedOptionValue(option, (T)((Supplier<Object>)() -> defaultValue));
    }

    public <T> T getParsedOptionValue(String opt) throws ParseException {
        return this.getParsedOptionValue(this.resolveOption(opt));
    }

    public <T> T getParsedOptionValue(String opt, Supplier<T> defaultValue) throws ParseException {
        return (T)this.getParsedOptionValue(this.resolveOption(opt), (T)defaultValue);
    }

    public <T> T getParsedOptionValue(String opt, T defaultValue) throws ParseException {
        return this.getParsedOptionValue(this.resolveOption(opt), defaultValue);
    }

    private void handleDeprecated(Option option) {
        if (this.deprecatedHandler != null) {
            this.deprecatedHandler.accept(option);
        }
    }

    public boolean hasOption(char opt) {
        return this.hasOption(String.valueOf(opt));
    }

    public boolean hasOption(Option opt) {
        boolean result2 = this.options.contains(opt);
        if (result2 && opt.isDeprecated()) {
            this.handleDeprecated(opt);
        }
        return result2;
    }

    public boolean hasOption(String opt) {
        return this.hasOption(this.resolveOption(opt));
    }

    public Iterator<Option> iterator() {
        return this.options.iterator();
    }

    private void processPropertiesFromValues(Properties props, List<String> values2) {
        for (int i2 = 0; i2 < values2.size(); i2 += 2) {
            if (i2 + 1 < values2.size()) {
                props.put(values2.get(i2), values2.get(i2 + 1));
                continue;
            }
            props.put(values2.get(i2), "true");
        }
    }

    private Option resolveOption(String opt) {
        String actual = Util.stripLeadingHyphens(opt);
        if (actual != null) {
            for (Option option : this.options) {
                if (!actual.equals(option.getOpt()) && !actual.equals(option.getLongOpt())) continue;
                return option;
            }
        }
        return null;
    }

    public static final class Builder {
        static final Consumer<Option> DEPRECATED_HANDLER = o -> System.out.println(o.toDeprecatedString());
        private final List<String> args = new LinkedList<String>();
        private final List<Option> options = new ArrayList<Option>();
        private Consumer<Option> deprecatedHandler = DEPRECATED_HANDLER;

        public Builder addArg(String arg2) {
            if (arg2 != null) {
                this.args.add(arg2);
            }
            return this;
        }

        public Builder addOption(Option opt) {
            if (opt != null) {
                this.options.add(opt);
            }
            return this;
        }

        public CommandLine build() {
            return new CommandLine(this.args, this.options, this.deprecatedHandler);
        }

        public Builder setDeprecatedHandler(Consumer<Option> deprecatedHandler) {
            this.deprecatedHandler = deprecatedHandler;
            return this;
        }
    }
}

