/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class JarContents {
    private final BitSet bits1;
    private final BitSet bits2;
    private static final int HASH_PRIME_1 = 31;
    private static final int HASH_PRIME_2 = 17;
    private static final int TABLE_SIZE = 2048;

    public JarContents(JarFile jar) {
        Enumeration<JarEntry> entries2 = jar.entries();
        this.bits1 = new BitSet(2048);
        this.bits2 = new BitSet(2048);
        while (entries2.hasMoreElements()) {
            boolean precedingSlash;
            JarEntry entry = entries2.nextElement();
            String name2 = entry.getName();
            int startPos = 0;
            boolean bl = precedingSlash = name2.charAt(0) == '/';
            if (precedingSlash) {
                startPos = 1;
            }
            int pathHash1 = this.hashcode(name2, startPos, 31);
            int pathHash2 = this.hashcode(name2, startPos, 17);
            this.bits1.set(pathHash1 % 2048);
            this.bits2.set(pathHash2 % 2048);
            if (!entry.isDirectory()) continue;
            pathHash1 = this.hashcode(name2, startPos, name2.length() - 1, 31);
            pathHash2 = this.hashcode(name2, startPos, name2.length() - 1, 17);
            this.bits1.set(pathHash1 % 2048);
            this.bits2.set(pathHash2 % 2048);
        }
    }

    private int hashcode(String content, int startPos, int hashPrime) {
        return this.hashcode(content, startPos, content.length(), hashPrime);
    }

    private int hashcode(String content, int startPos, int endPos, int hashPrime) {
        int h = hashPrime / 2;
        for (int i2 = startPos; i2 < endPos; ++i2) {
            h = hashPrime * h + content.charAt(i2);
        }
        if (h < 0) {
            h *= -1;
        }
        return h;
    }

    public boolean mightContainResource(String path2, String webappRoot) {
        int startPos = 0;
        if (path2.startsWith(webappRoot)) {
            startPos = webappRoot.length();
        }
        if (path2.charAt(startPos) == '/') {
            ++startPos;
        }
        return this.bits1.get(this.hashcode(path2, startPos, 31) % 2048) && this.bits2.get(this.hashcode(path2, startPos, 17) % 2048);
    }
}

