/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.webresources.AbstractResourceSet;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.JrePlatform;
import org.apache.tomcat.util.http.RequestUtil;

public abstract class AbstractFileResourceSet
extends AbstractResourceSet {
    private static final Log log = LogFactory.getLog(AbstractFileResourceSet.class);
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    private File fileBase;
    private String absoluteBase;
    private String canonicalBase;
    private boolean readOnly = false;

    protected AbstractFileResourceSet(String internalPath) {
        this.setInternalPath(internalPath);
    }

    protected final File getFileBase() {
        return this.fileBase;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected final File file(String name2, boolean mustExist) {
        if (name2.equals("/")) {
            name2 = "";
        }
        File file2 = new File(this.fileBase, name2);
        if (name2.endsWith("/") && file2.isFile()) {
            return null;
        }
        if (mustExist && !file2.canRead()) {
            return null;
        }
        if (this.getRoot().getAllowLinking()) {
            return file2;
        }
        if (JrePlatform.IS_WINDOWS && this.isInvalidWindowsFilename(name2)) {
            return null;
        }
        String canPath = null;
        try {
            canPath = file2.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (canPath == null || !canPath.startsWith(this.canonicalBase)) {
            return null;
        }
        String absPath = this.normalize(file2.getAbsolutePath());
        if (absPath == null || this.absoluteBase.length() > absPath.length()) {
            return null;
        }
        absPath = absPath.substring(this.absoluteBase.length());
        if ((canPath = canPath.substring(this.canonicalBase.length())).length() > 0 && canPath.charAt(0) != File.separatorChar) {
            return null;
        }
        if (canPath.length() > 0) {
            canPath = this.normalize(canPath);
        }
        if (!canPath.equals(absPath)) {
            if (!canPath.equalsIgnoreCase(absPath)) {
                this.logIgnoredSymlink(this.getRoot().getContext().getName(), absPath, canPath);
            }
            return null;
        }
        return file2;
    }

    protected void logIgnoredSymlink(String contextPath, String absPath, String canPath) {
        String msg = sm.getString("abstractFileResourceSet.canonicalfileCheckFailed", contextPath, absPath, canPath);
        if (absPath.startsWith("/META-INF/") || absPath.startsWith("/WEB-INF/")) {
            log.error(msg);
        } else {
            log.warn(msg);
        }
    }

    private boolean isInvalidWindowsFilename(String name2) {
        int len = name2.length();
        if (len == 0) {
            return false;
        }
        for (int i2 = 0; i2 < len; ++i2) {
            char c = name2.charAt(i2);
            if (c != '\"' && c != '<' && c != '>' && c != ':') continue;
            return true;
        }
        return name2.charAt(len - 1) == ' ';
    }

    private String normalize(String path2) {
        return RequestUtil.normalize(path2, File.separatorChar == '\\');
    }

    @Override
    public URL getBaseUrl() {
        try {
            return this.getFileBase().toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public void gc() {
    }

    @Override
    protected void initInternal() throws LifecycleException {
        this.fileBase = new File(this.getBase(), this.getInternalPath());
        this.checkType(this.fileBase);
        this.absoluteBase = this.normalize(this.fileBase.getAbsolutePath());
        try {
            this.canonicalBase = this.fileBase.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        if ("/".equals(this.absoluteBase)) {
            this.absoluteBase = "";
        }
        if ("/".equals(this.canonicalBase)) {
            this.canonicalBase = "";
        }
    }

    protected abstract void checkType(File var1);
}

