/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.util.ResourceSet;
import org.apache.catalina.webresources.AbstractResourceSet;
import org.apache.catalina.webresources.EmptyResource;
import org.apache.catalina.webresources.JarContents;
import org.apache.catalina.webresources.JarResourceRoot;

public abstract class AbstractArchiveResourceSet
extends AbstractResourceSet {
    private URL baseUrl;
    private String baseUrlString;
    private JarFile archive = null;
    protected Map<String, JarEntry> archiveEntries = null;
    protected final Object archiveLock = new Object();
    private long archiveUseCount = 0L;
    private JarContents jarContents;
    private boolean retainBloomFilterForArchives = false;

    protected final void setBaseUrl(URL baseUrl) {
        this.baseUrl = baseUrl;
        this.baseUrlString = baseUrl == null ? null : baseUrl.toString();
    }

    @Override
    public final URL getBaseUrl() {
        return this.baseUrl;
    }

    protected final String getBaseUrlString() {
        return this.baseUrlString;
    }

    @Override
    public final String[] list(String path2) {
        this.checkPath((String)path2);
        String webAppMount = this.getWebAppMount();
        ArrayList<String> result2 = new ArrayList<String>();
        if (((String)path2).startsWith(webAppMount)) {
            Object pathInJar = this.getInternalPath() + ((String)path2).substring(webAppMount.length());
            if (((String)pathInJar).length() > 0 && ((String)pathInJar).charAt(0) == '/') {
                pathInJar = ((String)pathInJar).substring(1);
            }
            for (String name2 : this.getArchiveEntries(false).keySet()) {
                if (name2.length() <= ((String)pathInJar).length() || !name2.startsWith((String)pathInJar) || (name2 = name2.charAt(name2.length() - 1) == '/' ? name2.substring(((String)pathInJar).length(), name2.length() - 1) : name2.substring(((String)pathInJar).length())).length() == 0) continue;
                if (name2.charAt(0) == '/') {
                    name2 = name2.substring(1);
                }
                if (name2.length() <= 0 || name2.lastIndexOf(47) != -1) continue;
                result2.add(name2);
            }
        } else {
            if (!((String)path2).endsWith("/")) {
                path2 = (String)path2 + "/";
            }
            if (webAppMount.startsWith((String)path2)) {
                int i2 = webAppMount.indexOf(47, ((String)path2).length());
                if (i2 == -1) {
                    return new String[]{webAppMount.substring(((String)path2).length())};
                }
                return new String[]{webAppMount.substring(((String)path2).length(), i2)};
            }
        }
        return result2.toArray(new String[0]);
    }

    @Override
    public final Set<String> listWebAppPaths(String path2) {
        this.checkPath((String)path2);
        String webAppMount = this.getWebAppMount();
        ResourceSet<String> result2 = new ResourceSet<String>();
        if (((String)path2).startsWith(webAppMount)) {
            Object pathInJar = this.getInternalPath() + ((String)path2).substring(webAppMount.length());
            if (((String)pathInJar).length() > 0) {
                if (((String)pathInJar).charAt(((String)pathInJar).length() - 1) != '/') {
                    pathInJar = ((String)pathInJar).substring(1) + "/";
                }
                if (((String)pathInJar).charAt(0) == '/') {
                    pathInJar = ((String)pathInJar).substring(1);
                }
            }
            for (String name2 : this.getArchiveEntries(false).keySet()) {
                if (name2.length() <= ((String)pathInJar).length() || !name2.startsWith((String)pathInJar)) continue;
                int nextSlash = name2.indexOf(47, ((String)pathInJar).length());
                if (nextSlash != -1 && nextSlash != name2.length() - 1) {
                    name2 = name2.substring(0, nextSlash + 1);
                }
                result2.add(webAppMount + "/" + name2.substring(this.getInternalPath().length()));
            }
        } else {
            if (!((String)path2).endsWith("/")) {
                path2 = (String)path2 + "/";
            }
            if (webAppMount.startsWith((String)path2)) {
                int i2 = webAppMount.indexOf(47, ((String)path2).length());
                if (i2 == -1) {
                    result2.add(webAppMount + "/");
                } else {
                    result2.add(webAppMount.substring(0, i2 + 1));
                }
            }
        }
        result2.setLocked(true);
        return result2;
    }

    protected abstract Map<String, JarEntry> getArchiveEntries(boolean var1);

    protected abstract JarEntry getArchiveEntry(String var1);

    @Override
    public final boolean mkdir(String path2) {
        this.checkPath(path2);
        return false;
    }

    @Override
    public final boolean write(String path2, InputStream is, boolean overwrite) {
        this.checkPath(path2);
        if (is == null) {
            throw new NullPointerException(sm.getString("dirResourceSet.writeNpe"));
        }
        return false;
    }

    @Override
    public final WebResource getResource(String path2) {
        this.checkPath((String)path2);
        String webAppMount = this.getWebAppMount();
        WebResourceRoot root = this.getRoot();
        if (this.jarContents != null && !this.jarContents.mightContainResource((String)(this.getInternalPath().isEmpty() ? path2 : this.getInternalPath() + (String)path2), webAppMount)) {
            return new EmptyResource(root, (String)path2);
        }
        if (((String)path2).startsWith(webAppMount)) {
            Object pathInJar = this.getInternalPath() + ((String)path2).substring(webAppMount.length());
            if (((String)pathInJar).length() > 0 && ((String)pathInJar).charAt(0) == '/') {
                pathInJar = ((String)pathInJar).substring(1);
            }
            if (((String)pathInJar).equals("")) {
                if (!((String)path2).endsWith("/")) {
                    path2 = (String)path2 + "/";
                }
                return new JarResourceRoot(root, new File(this.getBase()), this.baseUrlString, (String)path2);
            }
            JarEntry jarEntry = null;
            if (this.isMultiRelease()) {
                jarEntry = this.getArchiveEntry((String)pathInJar);
            } else {
                Map<String, JarEntry> jarEntries = this.getArchiveEntries(true);
                if (((String)pathInJar).charAt(((String)pathInJar).length() - 1) != '/' && (jarEntry = jarEntries == null ? this.getArchiveEntry((String)pathInJar + "/") : jarEntries.get((String)pathInJar + "/")) != null) {
                    path2 = (String)path2 + "/";
                }
                if (jarEntry == null) {
                    jarEntry = jarEntries == null ? this.getArchiveEntry((String)pathInJar) : jarEntries.get(pathInJar);
                }
            }
            if (jarEntry == null) {
                return new EmptyResource(root, (String)path2);
            }
            return this.createArchiveResource(jarEntry, (String)path2, this.getManifest());
        }
        return new EmptyResource(root, (String)path2);
    }

    protected abstract boolean isMultiRelease();

    protected abstract WebResource createArchiveResource(JarEntry var1, String var2, Manifest var3);

    @Override
    public final boolean isReadOnly() {
        return true;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        if (readOnly) {
            return;
        }
        throw new IllegalArgumentException(sm.getString("abstractArchiveResourceSet.setReadOnlyFalse"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JarFile openJarFile() throws IOException {
        Object object = this.archiveLock;
        synchronized (object) {
            if (this.archive == null) {
                this.archive = new JarFile(new File(this.getBase()), true, 1, Runtime.version());
                WebResourceRoot root = this.getRoot();
                if (root.getArchiveIndexStrategyEnum().getUsesBloom() || root.getContext() != null && root.getContext().getUseBloomFilterForArchives()) {
                    this.jarContents = new JarContents(this.archive);
                    this.retainBloomFilterForArchives = root.getArchiveIndexStrategyEnum().getRetain();
                }
            }
            ++this.archiveUseCount;
            return this.archive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeJarFile() {
        Object object = this.archiveLock;
        synchronized (object) {
            --this.archiveUseCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gc() {
        Object object = this.archiveLock;
        synchronized (object) {
            if (this.archive != null && this.archiveUseCount == 0L) {
                try {
                    this.archive.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.archive = null;
                this.archiveEntries = null;
                if (!this.retainBloomFilterForArchives) {
                    this.jarContents = null;
                }
            }
        }
    }
}

