/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves.rewrite;

import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.catalina.util.URLEncoder;
import org.apache.catalina.valves.rewrite.Resolver;
import org.apache.catalina.valves.rewrite.RewriteMap;
import org.apache.tomcat.util.res.StringManager;

public class Substitution {
    protected static final StringManager sm = StringManager.getManager(Substitution.class);
    protected SubstitutionElement[] elements = null;
    protected String sub = null;
    private boolean escapeBackReferences;

    public String getSub() {
        return this.sub;
    }

    public void setSub(String sub3) {
        this.sub = sub3;
    }

    void setEscapeBackReferences(boolean escapeBackReferences) {
        this.escapeBackReferences = escapeBackReferences;
    }

    public void parse(Map<String, RewriteMap> maps) {
        this.elements = this.parseSubstitution(this.sub, maps);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SubstitutionElement[] parseSubstitution(String sub3, Map<String, RewriteMap> maps) {
        ArrayList<Object> elements = new ArrayList<Object>();
        int pos2 = 0;
        int percentPos = 0;
        int dollarPos = 0;
        int backslashPos = 0;
        while (pos2 < sub3.length()) {
            void var8_24;
            int colon;
            int open2;
            percentPos = sub3.indexOf(37, pos2);
            dollarPos = sub3.indexOf(36, pos2);
            backslashPos = sub3.indexOf(92, pos2);
            if (percentPos == -1 && dollarPos == -1 && backslashPos == -1) {
                StaticElement staticElement = new StaticElement();
                staticElement.value = sub3.substring(pos2);
                pos2 = sub3.length();
                elements.add(staticElement);
                continue;
            }
            if (this.isFirstPos(backslashPos, dollarPos, percentPos)) {
                if (backslashPos + 1 == sub3.length()) {
                    throw new IllegalArgumentException(sm.getString("substitution.invalid", sub3));
                }
                StaticElement staticElement = new StaticElement();
                staticElement.value = sub3.substring(pos2, backslashPos) + sub3.substring(backslashPos + 1, backslashPos + 2);
                pos2 = backslashPos + 2;
                elements.add(staticElement);
                continue;
            }
            if (this.isFirstPos(dollarPos, percentPos)) {
                if (dollarPos + 1 == sub3.length()) {
                    throw new IllegalArgumentException(sm.getString("substitution.invalid", sub3));
                }
                if (pos2 < dollarPos) {
                    StaticElement staticElement = new StaticElement();
                    staticElement.value = sub3.substring(pos2, dollarPos);
                    elements.add(staticElement);
                }
                if (Character.isDigit(sub3.charAt(dollarPos + 1))) {
                    RewriteRuleBackReferenceElement rewriteRuleBackReferenceElement = new RewriteRuleBackReferenceElement();
                    rewriteRuleBackReferenceElement.n = Character.digit(sub3.charAt(dollarPos + 1), 10);
                    pos2 = dollarPos + 2;
                    elements.add(rewriteRuleBackReferenceElement);
                    continue;
                }
                if (sub3.charAt(dollarPos + 1) != '{') throw new IllegalArgumentException(sm.getString("substitution.missingDigit", sub3));
                MapElement mapElement = new MapElement();
                open2 = sub3.indexOf(123, dollarPos);
                colon = Substitution.findMatchingColonOrBar(true, sub3, open2);
                int def = Substitution.findMatchingColonOrBar(false, sub3, open2);
                int close2 = Substitution.findMatchingBrace(sub3, open2);
                if (-1 >= open2 || open2 >= colon || colon >= close2) {
                    throw new IllegalArgumentException(sm.getString("substitution.invalid", sub3));
                }
                mapElement.map = maps.get(sub3.substring(open2 + 1, colon));
                if (mapElement.map == null) {
                    throw new IllegalArgumentException(sm.getString("substitution.noMap", sub3.substring(open2 + 1, colon), sub3));
                }
                String key2 = null;
                String defaultValue = null;
                if (def > -1) {
                    if (colon >= def || def >= close2) {
                        throw new IllegalArgumentException(sm.getString("substitution.invalid", sub3));
                    }
                    key2 = sub3.substring(colon + 1, def);
                    defaultValue = sub3.substring(def + 1, close2);
                } else {
                    key2 = sub3.substring(colon + 1, close2);
                }
                mapElement.key = this.parseSubstitution(key2, maps);
                if (defaultValue != null) {
                    mapElement.defaultValue = this.parseSubstitution(defaultValue, maps);
                }
                pos2 = close2 + 1;
                elements.add(mapElement);
                continue;
            }
            if (percentPos + 1 == sub3.length()) {
                throw new IllegalArgumentException(sm.getString("substitution.invalid", sub3));
            }
            if (pos2 < percentPos) {
                StaticElement staticElement = new StaticElement();
                staticElement.value = sub3.substring(pos2, percentPos);
                elements.add(staticElement);
            }
            if (Character.isDigit(sub3.charAt(percentPos + 1))) {
                RewriteCondBackReferenceElement rewriteCondBackReferenceElement = new RewriteCondBackReferenceElement();
                rewriteCondBackReferenceElement.n = Character.digit(sub3.charAt(percentPos + 1), 10);
                pos2 = percentPos + 2;
                elements.add(rewriteCondBackReferenceElement);
                continue;
            }
            if (sub3.charAt(percentPos + 1) != '{') throw new IllegalArgumentException(sm.getString("substitution.missingDigit", sub3));
            Object var8_18 = null;
            open2 = sub3.indexOf(123, percentPos);
            colon = Substitution.findMatchingColonOrBar(true, sub3, open2);
            int close3 = Substitution.findMatchingBrace(sub3, open2);
            if (-1 >= open2 || open2 >= close3) {
                throw new IllegalArgumentException(sm.getString("substitution.invalid", sub3));
            }
            if (colon > -1 && open2 < colon && colon < close3) {
                String type2 = sub3.substring(open2 + 1, colon);
                if (type2.equals("ENV")) {
                    ServerVariableEnvElement serverVariableEnvElement = new ServerVariableEnvElement();
                    serverVariableEnvElement.key = sub3.substring(colon + 1, close3);
                } else if (type2.equals("SSL")) {
                    ServerVariableSslElement serverVariableSslElement = new ServerVariableSslElement();
                    serverVariableSslElement.key = sub3.substring(colon + 1, close3);
                } else {
                    if (!type2.equals("HTTP")) throw new IllegalArgumentException(sm.getString("substitution.badType", type2, sub3));
                    ServerVariableHttpElement serverVariableHttpElement = new ServerVariableHttpElement();
                    serverVariableHttpElement.key = sub3.substring(colon + 1, close3);
                }
            } else {
                ServerVariableElement serverVariableElement = new ServerVariableElement();
                serverVariableElement.key = sub3.substring(open2 + 1, close3);
            }
            pos2 = close3 + 1;
            elements.add(var8_24);
        }
        return elements.toArray(new SubstitutionElement[0]);
    }

    private static int findMatchingBrace(String sub3, int start2) {
        int nesting2 = 1;
        for (int i2 = start2 + 1; i2 < sub3.length(); ++i2) {
            char c = sub3.charAt(i2);
            if (c == '{') {
                char previousChar = sub3.charAt(i2 - 1);
                if (previousChar != '$' && previousChar != '%') continue;
                ++nesting2;
                continue;
            }
            if (c != '}' || --nesting2 != 0) continue;
            return i2;
        }
        return -1;
    }

    private static int findMatchingColonOrBar(boolean colon, String sub3, int start2) {
        int nesting2 = 0;
        for (int i2 = start2 + 1; i2 < sub3.length(); ++i2) {
            char c = sub3.charAt(i2);
            if (c == '{') {
                char previousChar = sub3.charAt(i2 - 1);
                if (previousChar != '$' && previousChar != '%') continue;
                ++nesting2;
                continue;
            }
            if (c == '}') {
                --nesting2;
                continue;
            }
            if (!(colon ? c == ':' : c == '|') || nesting2 != 0) continue;
            return i2;
        }
        return -1;
    }

    public String evaluate(Matcher rule, Matcher cond, Resolver resolver) {
        return this.evaluateSubstitution(this.elements, rule, cond, resolver);
    }

    private String evaluateSubstitution(SubstitutionElement[] elements, Matcher rule, Matcher cond, Resolver resolver) {
        StringBuilder buf = new StringBuilder();
        for (SubstitutionElement element : elements) {
            buf.append(element.evaluate(rule, cond, resolver));
        }
        return buf.toString();
    }

    private boolean isFirstPos(int testPos, int ... others) {
        if (testPos < 0) {
            return false;
        }
        for (int other : others) {
            if (other < 0 || other >= testPos) continue;
            return false;
        }
        return true;
    }

    public static abstract class SubstitutionElement {
        public abstract String evaluate(Matcher var1, Matcher var2, Resolver var3);
    }

    public static class StaticElement
    extends SubstitutionElement {
        public String value;

        @Override
        public String evaluate(Matcher rule, Matcher cond, Resolver resolver) {
            return this.value;
        }
    }

    public class RewriteRuleBackReferenceElement
    extends SubstitutionElement {
        public int n;

        @Override
        public String evaluate(Matcher rule, Matcher cond, Resolver resolver) {
            String result2 = rule.group(this.n);
            if (result2 == null) {
                result2 = "";
            }
            if (Substitution.this.escapeBackReferences) {
                return URLEncoder.DEFAULT.encode(result2, resolver.getUriCharset());
            }
            return result2;
        }
    }

    public class MapElement
    extends SubstitutionElement {
        public RewriteMap map = null;
        public SubstitutionElement[] defaultValue = null;
        public SubstitutionElement[] key = null;

        @Override
        public String evaluate(Matcher rule, Matcher cond, Resolver resolver) {
            String result2 = this.map.lookup(Substitution.this.evaluateSubstitution(this.key, rule, cond, resolver));
            if (result2 == null && this.defaultValue != null) {
                result2 = Substitution.this.evaluateSubstitution(this.defaultValue, rule, cond, resolver);
            }
            return result2;
        }
    }

    public static class RewriteCondBackReferenceElement
    extends SubstitutionElement {
        public int n;

        @Override
        public String evaluate(Matcher rule, Matcher cond, Resolver resolver) {
            return cond.group(this.n) == null ? "" : cond.group(this.n);
        }
    }

    public static class ServerVariableEnvElement
    extends SubstitutionElement {
        public String key;

        @Override
        public String evaluate(Matcher rule, Matcher cond, Resolver resolver) {
            return resolver.resolveEnv(this.key);
        }
    }

    public static class ServerVariableSslElement
    extends SubstitutionElement {
        public String key;

        @Override
        public String evaluate(Matcher rule, Matcher cond, Resolver resolver) {
            return resolver.resolveSsl(this.key);
        }
    }

    public static class ServerVariableHttpElement
    extends SubstitutionElement {
        public String key;

        @Override
        public String evaluate(Matcher rule, Matcher cond, Resolver resolver) {
            return resolver.resolveHttp(this.key);
        }
    }

    public static class ServerVariableElement
    extends SubstitutionElement {
        public String key;

        @Override
        public String evaluate(Matcher rule, Matcher cond, Resolver resolver) {
            return resolver.resolve(this.key);
        }
    }
}

