/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ErrorReportValve;
import org.apache.coyote.ActionCode;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.json.JSONFilter;
import org.apache.tomcat.util.res.StringManager;

public class JsonErrorReportValve
extends ErrorReportValve {
    @Override
    protected void report(Request request, Response response, Throwable throwable) {
        int statusCode = response.getStatus();
        if (statusCode < 400 || response.getContentWritten() > 0L || !response.setErrorReported()) {
            return;
        }
        AtomicBoolean result2 = new AtomicBoolean(false);
        response.getCoyoteResponse().action(ActionCode.IS_IO_ALLOWED, result2);
        if (!result2.get()) {
            return;
        }
        StringManager smClient = StringManager.getManager("org.apache.catalina.valves", request.getLocales());
        response.setLocale(smClient.getLocale());
        String type2 = null;
        type2 = throwable != null ? smClient.getString("errorReportValve.exceptionReport") : smClient.getString("errorReportValve.statusReport");
        String message2 = response.getMessage();
        if (message2 == null && throwable != null) {
            message2 = throwable.getMessage();
        }
        String description = null;
        description = smClient.getString("http." + statusCode + ".desc");
        if (description == null) {
            if (message2 == null || message2.isEmpty()) {
                return;
            }
            description = smClient.getString("errorReportValve.noDescription");
        }
        String jsonReport = "{\n  \"type\": \"" + JSONFilter.escape(type2) + "\",\n  \"message\": \"" + JSONFilter.escape(message2) + "\",\n  \"description\": \"" + JSONFilter.escape(description) + "\"\n}";
        try {
            block10: {
                try {
                    response.setContentType("application/json");
                    response.setCharacterEncoding("utf-8");
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                    if (!this.container.getLogger().isDebugEnabled()) break block10;
                    this.container.getLogger().debug(sm.getString("errorReportValve.contentTypeFail"), t);
                }
            }
            PrintWriter writer = response.getReporter();
            if (writer != null) {
                ((Writer)writer).write(jsonReport);
                response.finishResponse();
                return;
            }
        }
        catch (IOException | IllegalStateException exception2) {
            // empty catch block
        }
    }
}

