/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.IOException;
import java.io.Writer;
import org.apache.tomcat.util.security.Escape;

public class XMLWriter {
    public static final int OPENING = 0;
    public static final int CLOSING = 1;
    public static final int NO_CONTENT = 2;
    protected StringBuilder buffer = new StringBuilder();
    protected final Writer writer;
    protected boolean lastWriteWasOpen;

    public XMLWriter() {
        this(null);
    }

    public XMLWriter(Writer writer) {
        this.writer = writer;
    }

    public String toString() {
        return this.buffer.toString();
    }

    public void writeProperty(String namespace, String name2, String value2) {
        this.writeElement(namespace, name2, 0);
        this.buffer.append(value2);
        this.writeElement(namespace, name2, 1);
    }

    public void writeElement(String namespace, String name2, int type2) {
        this.writeElement(namespace, null, name2, type2);
    }

    public void writeElement(String namespace, String namespaceInfo, String name2, int type2) {
        if (namespace != null && namespace.length() > 0) {
            switch (type2) {
                case 0: {
                    if (this.lastWriteWasOpen) {
                        this.buffer.append('\n');
                    }
                    if (namespaceInfo != null) {
                        this.buffer.append("<" + namespace + ":" + name2 + " xmlns:" + namespace + "=\"" + namespaceInfo + "\">");
                    } else {
                        this.buffer.append("<" + namespace + ":" + name2 + ">");
                    }
                    this.lastWriteWasOpen = true;
                    break;
                }
                case 1: {
                    this.buffer.append("</" + namespace + ":" + name2 + ">\n");
                    this.lastWriteWasOpen = false;
                    break;
                }
                default: {
                    if (this.lastWriteWasOpen) {
                        this.buffer.append('\n');
                    }
                    if (namespaceInfo != null) {
                        this.buffer.append("<" + namespace + ":" + name2 + " xmlns:" + namespace + "=\"" + namespaceInfo + "\"/>\n");
                    } else {
                        this.buffer.append("<" + namespace + ":" + name2 + "/>\n");
                    }
                    this.lastWriteWasOpen = false;
                    break;
                }
            }
        } else {
            switch (type2) {
                case 0: {
                    if (this.lastWriteWasOpen) {
                        this.buffer.append('\n');
                    }
                    this.buffer.append("<" + name2 + ">");
                    this.lastWriteWasOpen = true;
                    break;
                }
                case 1: {
                    this.buffer.append("</" + name2 + ">\n");
                    this.lastWriteWasOpen = false;
                    break;
                }
                default: {
                    if (this.lastWriteWasOpen) {
                        this.buffer.append('\n');
                    }
                    this.buffer.append("<" + name2 + "/>\n");
                    this.lastWriteWasOpen = false;
                }
            }
        }
    }

    public void writeText(String text) {
        this.buffer.append(Escape.xml(text));
    }

    public void writeRaw(String raw) {
        this.buffer.append(raw);
    }

    public void writeData(String data2) {
        this.buffer.append("<![CDATA[" + data2 + "]]>");
    }

    public void writeXMLHeader() {
        this.buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
    }

    public void sendData() throws IOException {
        if (this.writer != null) {
            this.writer.write(this.buffer.toString());
            this.buffer = new StringBuilder();
        }
    }
}

