/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.catalina.util.NetMask;
import org.apache.tomcat.util.buf.StringUtils;

public class NetMaskSet {
    private final Set<NetMask> netmasks = new HashSet<NetMask>();

    public boolean contains(InetAddress inetAddress) {
        for (NetMask nm : this.netmasks) {
            if (!nm.matches(inetAddress)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String ipAddress) throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByName(ipAddress);
        return this.contains(inetAddress);
    }

    public boolean add(NetMask netmask2) {
        return this.netmasks.add(netmask2);
    }

    public boolean add(String input) {
        NetMask netmask2 = new NetMask(input);
        return this.netmasks.add(netmask2);
    }

    public void clear() {
        this.netmasks.clear();
    }

    public boolean isEmpty() {
        return this.netmasks.isEmpty();
    }

    public List<String> addAll(String input) {
        if (input == null || input.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CallSite> errMessages = new ArrayList<CallSite>();
        for (String s2 : StringUtils.splitCommaSeparated(input)) {
            try {
                this.add(s2);
            }
            catch (IllegalArgumentException e) {
                errMessages.add((CallSite)((Object)(s2 + ": " + e.getMessage())));
            }
        }
        return Collections.unmodifiableList(errMessages);
    }

    public String toString() {
        String result2 = this.netmasks.toString();
        if (result2.startsWith("[")) {
            result2 = result2.substring(1);
        }
        if (result2.endsWith("]")) {
            result2 = result2.substring(0, result2.length() - 1);
        }
        return result2;
    }
}

