/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.PrintWriter;
import java.io.Writer;
import org.apache.tomcat.util.security.Escape;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMWriter {
    private final PrintWriter out;

    public DOMWriter(Writer writer) {
        this.out = new PrintWriter(writer);
    }

    public void print(Node node) {
        if (node == null) {
            return;
        }
        short type2 = node.getNodeType();
        switch (type2) {
            case 9: {
                this.print(((Document)node).getDocumentElement());
                this.out.flush();
                break;
            }
            case 1: {
                Attr[] attrs;
                this.out.print('<');
                this.out.print(node.getLocalName());
                for (Attr attr2 : attrs = this.sortAttributes(node.getAttributes())) {
                    this.out.print(' ');
                    this.out.print(attr2.getLocalName());
                    this.out.print("=\"");
                    this.out.print(Escape.xml("", true, attr2.getNodeValue()));
                    this.out.print('\"');
                }
                this.out.print('>');
                this.printChildren(node);
                break;
            }
            case 5: {
                this.printChildren(node);
                break;
            }
            case 4: {
                this.out.print(Escape.xml("", true, node.getNodeValue()));
                break;
            }
            case 3: {
                this.out.print(Escape.xml("", true, node.getNodeValue()));
                break;
            }
            case 7: {
                this.out.print("<?");
                this.out.print(node.getLocalName());
                String data2 = node.getNodeValue();
                if (data2 != null && data2.length() > 0) {
                    this.out.print(' ');
                    this.out.print(data2);
                }
                this.out.print("?>");
            }
        }
        if (type2 == 1) {
            this.out.print("</");
            this.out.print(node.getLocalName());
            this.out.print('>');
        }
        this.out.flush();
    }

    private void printChildren(Node node) {
        NodeList children2 = node.getChildNodes();
        if (children2 != null) {
            int len = children2.getLength();
            for (int i2 = 0; i2 < len; ++i2) {
                this.print(children2.item(i2));
            }
        }
    }

    private Attr[] sortAttributes(NamedNodeMap attrs) {
        int i2;
        if (attrs == null) {
            return new Attr[0];
        }
        int len = attrs.getLength();
        Attr[] array2 = new Attr[len];
        for (i2 = 0; i2 < len; ++i2) {
            array2[i2] = (Attr)attrs.item(i2);
        }
        for (i2 = 0; i2 < len - 1; ++i2) {
            String name2 = null;
            name2 = array2[i2].getLocalName();
            int index2 = i2;
            for (int j = i2 + 1; j < len; ++j) {
                String curName = null;
                curName = array2[j].getLocalName();
                if (curName.compareTo(name2) >= 0) continue;
                name2 = curName;
                index2 = j;
            }
            if (index2 == i2) continue;
            Attr temp = array2[i2];
            array2[i2] = array2[index2];
            array2[index2] = temp;
        }
        return array2;
    }
}

