/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.res.StringManager;

public final class CustomObjectInputStream
extends ObjectInputStream {
    private static final StringManager sm = StringManager.getManager(CustomObjectInputStream.class);
    private static final WeakHashMap<ClassLoader, Set<String>> reportedClassCache = new WeakHashMap();
    private final ClassLoader classLoader;
    private final Set<String> reportedClasses;
    private final Log log;
    private final Pattern allowedClassNamePattern;
    private final String allowedClassNameFilter;
    private final boolean warnOnFailure;

    public CustomObjectInputStream(InputStream stream, ClassLoader classLoader) throws IOException {
        this(stream, classLoader, null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomObjectInputStream(InputStream stream, ClassLoader classLoader, Log log3, Pattern allowedClassNamePattern, boolean warnOnFailure) throws IOException {
        super(stream);
        Set<String> reportedClasses;
        if (log3 == null && allowedClassNamePattern != null && warnOnFailure) {
            throw new IllegalArgumentException(sm.getString("customObjectInputStream.logRequired"));
        }
        this.classLoader = classLoader;
        this.log = log3;
        this.allowedClassNamePattern = allowedClassNamePattern;
        this.allowedClassNameFilter = allowedClassNamePattern == null ? null : allowedClassNamePattern.toString();
        this.warnOnFailure = warnOnFailure;
        WeakHashMap<ClassLoader, Set<String>> weakHashMap = reportedClassCache;
        synchronized (weakHashMap) {
            reportedClasses = reportedClassCache.get(classLoader);
        }
        if (reportedClasses == null) {
            Set<String> original;
            reportedClasses = ConcurrentHashMap.newKeySet();
            WeakHashMap<ClassLoader, Set<String>> weakHashMap2 = reportedClassCache;
            synchronized (weakHashMap2) {
                original = reportedClassCache.putIfAbsent(classLoader, reportedClasses);
            }
            if (original != null) {
                reportedClasses = original;
            }
        }
        this.reportedClasses = reportedClasses;
    }

    @Override
    public Class<?> resolveClass(ObjectStreamClass classDesc) throws ClassNotFoundException, IOException {
        boolean allowed;
        String name2 = classDesc.getName();
        if (this.allowedClassNamePattern != null && !(allowed = this.allowedClassNamePattern.matcher(name2).matches())) {
            boolean doLog = this.warnOnFailure && this.reportedClasses.add(name2);
            String msg = sm.getString("customObjectInputStream.nomatch", name2, this.allowedClassNameFilter);
            if (doLog) {
                this.log.warn(msg);
            } else if (this.log.isDebugEnabled()) {
                this.log.debug(msg);
            }
            throw new InvalidClassException(msg);
        }
        try {
            return Class.forName(name2, false, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            try {
                return super.resolveClass(classDesc);
            }
            catch (ClassNotFoundException e2) {
                throw e;
            }
        }
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaces2) throws IOException, ClassNotFoundException {
        Class[] cinterfaces = new Class[interfaces2.length];
        for (int i2 = 0; i2 < interfaces2.length; ++i2) {
            cinterfaces[i2] = this.classLoader.loadClass(interfaces2[i2]);
        }
        try {
            Class<?> proxyClass = Proxy.getProxyClass(this.classLoader, cinterfaces);
            return proxyClass;
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }
}

