/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.util.Locale;

public final class ContextName {
    public static final String ROOT_NAME = "ROOT";
    private static final String VERSION_MARKER = "##";
    private static final char FWD_SLASH_REPLACEMENT = '#';
    private final String baseName;
    private final String path;
    private final String version;
    private final String name;

    public ContextName(String name2, boolean stripFileExtension) {
        String tmp2;
        Object tmp1 = name2;
        if (((String)tmp1).startsWith("/")) {
            tmp1 = ((String)tmp1).substring(1);
        }
        if (((String)(tmp1 = ((String)tmp1).replace('/', '#'))).startsWith(VERSION_MARKER) || ((String)tmp1).isEmpty()) {
            tmp1 = ROOT_NAME + (String)tmp1;
        }
        if (stripFileExtension && (((String)tmp1).toLowerCase(Locale.ENGLISH).endsWith(".war") || ((String)tmp1).toLowerCase(Locale.ENGLISH).endsWith(".xml"))) {
            tmp1 = ((String)tmp1).substring(0, ((String)tmp1).length() - 4);
        }
        this.baseName = tmp1;
        int versionIndex = this.baseName.indexOf(VERSION_MARKER);
        if (versionIndex > -1) {
            this.version = this.baseName.substring(versionIndex + 2);
            tmp2 = this.baseName.substring(0, versionIndex);
        } else {
            this.version = "";
            tmp2 = this.baseName;
        }
        this.path = ROOT_NAME.equals(tmp2) ? "" : "/" + tmp2.replace('#', '/');
        this.name = versionIndex > -1 ? this.path + VERSION_MARKER + this.version : this.path;
    }

    public ContextName(String path2, String version) {
        this.path = path2 == null || "/".equals(path2) || "/ROOT".equals(path2) ? "" : path2;
        this.version = version == null ? "" : version;
        this.name = this.version.isEmpty() ? this.path : this.path + VERSION_MARKER + this.version;
        StringBuilder tmp = new StringBuilder();
        if (this.path.isEmpty()) {
            tmp.append(ROOT_NAME);
        } else {
            tmp.append(this.path.substring(1).replace('/', '#'));
        }
        if (!this.version.isEmpty()) {
            tmp.append(VERSION_MARKER);
            tmp.append(this.version);
        }
        this.baseName = tmp.toString();
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getPath() {
        return this.path;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        StringBuilder tmp = new StringBuilder();
        if ("".equals(this.path)) {
            tmp.append('/');
        } else {
            tmp.append(this.path);
        }
        if (!this.version.isEmpty()) {
            tmp.append(VERSION_MARKER);
            tmp.append(this.version);
        }
        return tmp.toString();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public static ContextName extractFromPath(String path2) {
        path2 = path2.replace("\\", "/");
        while (path2.endsWith("/")) {
            path2 = path2.substring(0, path2.length() - 1);
        }
        int lastSegment = path2.lastIndexOf(47);
        if (lastSegment > 0) {
            path2 = path2.substring(lastSegment + 1);
        }
        return new ContextName(path2, true);
    }
}

