/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.apache.catalina.Host;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class ExpandWar {
    private static final Log log = LogFactory.getLog(ExpandWar.class);
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");

    public static String expand(Host host, URL war, String pathname2) throws IOException {
        JarURLConnection juc = (JarURLConnection)war.openConnection();
        juc.setUseCaches(false);
        URL jarFileUrl = juc.getJarFileURL();
        URLConnection jfuc = jarFileUrl.openConnection();
        boolean success = false;
        File docBase = new File(host.getAppBaseFile(), pathname2);
        File warTracker = new File(host.getAppBaseFile(), pathname2 + "/META-INF/war-tracker");
        long warLastModified = -1L;
        try (InputStream is = jfuc.getInputStream();){
            warLastModified = jfuc.getLastModified();
        }
        if (docBase.exists()) {
            if (!warTracker.exists() || warTracker.lastModified() == warLastModified) {
                success = true;
                return docBase.getAbsolutePath();
            }
            log.info(sm.getString("expandWar.deleteOld", docBase));
            if (!ExpandWar.delete(docBase)) {
                throw new IOException(sm.getString("expandWar.deleteFailed", docBase));
            }
        }
        if (!docBase.mkdir() && !docBase.isDirectory()) {
            throw new IOException(sm.getString("expandWar.createFailed", docBase));
        }
        Path canonicalDocBasePath = docBase.getCanonicalFile().toPath();
        File warTrackerParent = warTracker.getParentFile();
        if (!warTrackerParent.isDirectory() && !warTrackerParent.mkdirs()) {
            throw new IOException(sm.getString("expandWar.createFailed", warTrackerParent.getAbsolutePath()));
        }
        try (JarFile jarFile = juc.getJarFile();){
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                File parent;
                JarEntry jarEntry = jarEntries.nextElement();
                String name2 = jarEntry.getName();
                File expandedFile = new File(docBase, name2);
                if (!expandedFile.getCanonicalFile().toPath().startsWith(canonicalDocBasePath)) {
                    throw new IllegalArgumentException(sm.getString("expandWar.illegalPath", war, name2, expandedFile.getCanonicalPath(), canonicalDocBasePath));
                }
                int last2 = name2.lastIndexOf(47);
                if (last2 >= 0 && !(parent = new File(docBase, name2.substring(0, last2))).mkdirs() && !parent.isDirectory()) {
                    throw new IOException(sm.getString("expandWar.createFailed", parent));
                }
                if (name2.endsWith("/")) continue;
                InputStream input = jarFile.getInputStream(jarEntry);
                try {
                    if (null == input) {
                        throw new ZipException(sm.getString("expandWar.missingJarEntry", jarEntry.getName()));
                    }
                    ExpandWar.expand(input, expandedFile);
                    long lastModified = jarEntry.getTime();
                    if (lastModified == -1L || lastModified == 0L || expandedFile.setLastModified(lastModified)) continue;
                    throw new IOException(sm.getString("expandWar.lastModifiedFailed", expandedFile));
                }
                finally {
                    if (input == null) continue;
                    input.close();
                }
            }
            if (!warTracker.createNewFile()) {
                throw new IOException(sm.getString("expandWar.createFileFailed", warTracker));
            }
            if (!warTracker.setLastModified(warLastModified)) {
                throw new IOException(sm.getString("expandWar.lastModifiedFailed", warTracker));
            }
            success = true;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (!success) {
                ExpandWar.deleteDir(docBase);
            }
        }
        return docBase.getAbsolutePath();
    }

    public static void validate(Host host, URL war, String pathname2) throws IOException {
        File docBase = new File(host.getAppBaseFile(), pathname2);
        Path canonicalDocBasePath = docBase.getCanonicalFile().toPath();
        JarURLConnection juc = (JarURLConnection)war.openConnection();
        juc.setUseCaches(false);
        try (JarFile jarFile = juc.getJarFile();){
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                String name2 = jarEntry.getName();
                File expandedFile = new File(docBase, name2);
                if (expandedFile.getCanonicalFile().toPath().startsWith(canonicalDocBasePath)) continue;
                throw new IllegalArgumentException(sm.getString("expandWar.illegalPath", war, name2, expandedFile.getCanonicalPath(), canonicalDocBasePath));
            }
        }
    }

    public static boolean copy(File src, File dest) {
        boolean result2 = true;
        String[] files = null;
        if (src.isDirectory()) {
            files = src.list();
            result2 = dest.mkdir();
        } else {
            files = new String[]{""};
        }
        if (files == null) {
            files = new String[]{};
        }
        for (int i2 = 0; i2 < files.length && result2; ++i2) {
            File fileSrc = new File(src, files[i2]);
            File fileDest = new File(dest, files[i2]);
            if (fileSrc.isDirectory()) {
                result2 = ExpandWar.copy(fileSrc, fileDest);
                continue;
            }
            try (FileInputStream fis = new FileInputStream(fileSrc);
                 FileChannel ic = fis.getChannel();
                 FileOutputStream fos = new FileOutputStream(fileDest);
                 FileChannel oc = fos.getChannel();){
                long count2;
                long position = 0L;
                for (long size2 = ic.size(); size2 > 0L; size2 -= count2) {
                    count2 = ic.transferTo(position, size2, oc);
                    if (count2 > 0L) {
                        position += count2;
                        continue;
                    }
                    throw new EOFException();
                }
                continue;
            }
            catch (IOException e) {
                log.error(sm.getString("expandWar.copy", fileSrc, fileDest), e);
                result2 = false;
            }
        }
        return result2;
    }

    public static boolean delete(File dir) {
        return ExpandWar.delete(dir, true);
    }

    public static boolean delete(File dir, boolean logFailure) {
        boolean result2 = dir.isDirectory() ? ExpandWar.deleteDir(dir, logFailure) : (dir.exists() ? dir.delete() : true);
        if (logFailure && !result2) {
            log.error(sm.getString("expandWar.deleteFailed", dir.getAbsolutePath()));
        }
        return result2;
    }

    public static boolean deleteDir(File dir) {
        return ExpandWar.deleteDir(dir, true);
    }

    public static boolean deleteDir(File dir, boolean logFailure) {
        String[] files = dir.list();
        if (files == null) {
            files = new String[]{};
        }
        for (String s2 : files) {
            File file2 = new File(dir, s2);
            if (file2.isDirectory()) {
                ExpandWar.deleteDir(file2, logFailure);
                continue;
            }
            file2.delete();
        }
        boolean result2 = dir.exists() ? dir.delete() : true;
        if (logFailure && !result2) {
            log.error(sm.getString("expandWar.deleteFailed", dir.getAbsolutePath()));
        }
        return result2;
    }

    private static void expand(InputStream input, File file2) throws IOException {
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file2));){
            int n;
            byte[] buffer = new byte[2048];
            while ((n = input.read(buffer)) > 0) {
                output.write(buffer, 0, n);
            }
        }
    }
}

