/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class EngineConfig
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(EngineConfig.class);
    protected Engine engine = null;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");

    @Override
    public void lifecycleEvent(LifecycleEvent event2) {
        try {
            this.engine = (Engine)event2.getLifecycle();
        }
        catch (ClassCastException e) {
            log.error(sm.getString("engineConfig.cce", event2.getLifecycle()), e);
            return;
        }
        if (event2.getType().equals("start")) {
            this.start();
        } else if (event2.getType().equals("stop")) {
            this.stop();
        }
    }

    protected void start() {
        if (this.engine.getLogger().isTraceEnabled()) {
            this.engine.getLogger().trace(sm.getString("engineConfig.start"));
        }
    }

    protected void stop() {
        if (this.engine.getLogger().isTraceEnabled()) {
            this.engine.getLogger().trace(sm.getString("engineConfig.stop"));
        }
    }
}

