/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import org.apache.catalina.startup.Bootstrap;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public final class ClassLoaderFactory {
    private static final Log log = LogFactory.getLog(ClassLoaderFactory.class);

    public static ClassLoader createClassLoader(File[] unpacked, File[] packed, ClassLoader parent) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Creating new class loader");
        }
        LinkedHashSet<URL> set2 = new LinkedHashSet<URL>();
        if (unpacked != null) {
            for (File file2 : unpacked) {
                if (!file2.canRead()) continue;
                file2 = new File(file2.getCanonicalPath());
                URL url = file2.toURI().toURL();
                if (log.isDebugEnabled()) {
                    log.debug("  Including directory " + String.valueOf(url));
                }
                set2.add(url);
            }
        }
        if (packed != null) {
            for (File directory : packed) {
                String[] filenames;
                if (!directory.isDirectory() || !directory.canRead() || (filenames = directory.list()) == null) continue;
                for (String s2 : filenames) {
                    String filename2 = s2.toLowerCase(Locale.ENGLISH);
                    if (!filename2.endsWith(".jar")) continue;
                    File file3 = new File(directory, s2);
                    if (log.isDebugEnabled()) {
                        log.debug("  Including jar file " + file3.getAbsolutePath());
                    }
                    URL url = file3.toURI().toURL();
                    set2.add(url);
                }
            }
        }
        URL[] array2 = set2.toArray(new URL[0]);
        return AccessController.doPrivileged(() -> {
            if (parent == null) {
                return new URLClassLoader(array2);
            }
            return new URLClassLoader(array2, parent);
        });
    }

    public static ClassLoader createClassLoader(List<Repository> repositories, ClassLoader parent) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Creating new class loader");
        }
        LinkedHashSet<URL> set2 = new LinkedHashSet<URL>();
        if (repositories != null) {
            for (Repository repository : repositories) {
                String[] filenames;
                URL url;
                File directory;
                if (repository.getType() == RepositoryType.URL) {
                    URL url2 = ClassLoaderFactory.buildClassLoaderUrl(repository.getLocation());
                    if (log.isDebugEnabled()) {
                        log.debug("  Including URL " + String.valueOf(url2));
                    }
                    set2.add(url2);
                    continue;
                }
                if (repository.getType() == RepositoryType.DIR) {
                    directory = new File(repository.getLocation());
                    if (!ClassLoaderFactory.validateFile(directory = directory.getCanonicalFile(), RepositoryType.DIR)) continue;
                    url = ClassLoaderFactory.buildClassLoaderUrl(directory);
                    if (log.isDebugEnabled()) {
                        log.debug("  Including directory " + String.valueOf(url));
                    }
                    set2.add(url);
                    continue;
                }
                if (repository.getType() == RepositoryType.JAR) {
                    File file2 = new File(repository.getLocation());
                    if (!ClassLoaderFactory.validateFile(file2 = file2.getCanonicalFile(), RepositoryType.JAR)) continue;
                    url = ClassLoaderFactory.buildClassLoaderUrl(file2);
                    if (log.isDebugEnabled()) {
                        log.debug("  Including jar file " + String.valueOf(url));
                    }
                    set2.add(url);
                    continue;
                }
                if (repository.getType() != RepositoryType.GLOB) continue;
                directory = new File(repository.getLocation());
                if (!ClassLoaderFactory.validateFile(directory = directory.getCanonicalFile(), RepositoryType.GLOB)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("  Including directory glob " + directory.getAbsolutePath());
                }
                if ((filenames = directory.list()) == null) continue;
                for (String s2 : filenames) {
                    String filename2 = s2.toLowerCase(Locale.ENGLISH);
                    if (!filename2.endsWith(".jar")) continue;
                    File file3 = new File(directory, s2);
                    if (!ClassLoaderFactory.validateFile(file3 = file3.getCanonicalFile(), RepositoryType.JAR)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("    Including glob jar file " + file3.getAbsolutePath());
                    }
                    URL url3 = ClassLoaderFactory.buildClassLoaderUrl(file3);
                    set2.add(url3);
                }
            }
        }
        URL[] array2 = set2.toArray(new URL[0]);
        if (log.isTraceEnabled()) {
            for (int i2 = 0; i2 < array2.length; ++i2) {
                log.trace("  location " + i2 + " is " + String.valueOf(array2[i2]));
            }
        }
        return AccessController.doPrivileged(() -> {
            if (parent == null) {
                return new URLClassLoader(array2);
            }
            return new URLClassLoader(array2, parent);
        });
    }

    private static boolean validateFile(File file2, RepositoryType type2) throws IOException {
        if (RepositoryType.DIR == type2 || RepositoryType.GLOB == type2) {
            if (!file2.isDirectory() || !file2.canRead()) {
                String msg = "Problem with directory [" + String.valueOf(file2) + "], exists: [" + file2.exists() + "], isDirectory: [" + file2.isDirectory() + "], canRead: [" + file2.canRead() + "]";
                File home2 = new File(Bootstrap.getCatalinaHome());
                home2 = home2.getCanonicalFile();
                File base = new File(Bootstrap.getCatalinaBase());
                base = base.getCanonicalFile();
                File defaultValue = new File(base, "lib");
                if (!home2.getPath().equals(base.getPath()) && file2.getPath().equals(defaultValue.getPath()) && !file2.exists()) {
                    log.debug(msg);
                } else {
                    log.warn(msg);
                }
                return false;
            }
        } else if (RepositoryType.JAR == type2 && !file2.canRead()) {
            log.warn("Problem with JAR file [" + String.valueOf(file2) + "], exists: [" + file2.exists() + "], canRead: [" + file2.canRead() + "]");
            return false;
        }
        return true;
    }

    private static URL buildClassLoaderUrl(String urlString) throws MalformedURLException, URISyntaxException {
        String result2 = urlString.replace("!/", "%21/");
        return new URI(result2).toURL();
    }

    private static URL buildClassLoaderUrl(File file2) throws MalformedURLException, URISyntaxException {
        String fileUrlString = file2.toURI().toString();
        fileUrlString = fileUrlString.replace("!/", "%21/");
        return new URI(fileUrlString).toURL();
    }

    public static class Repository {
        private final String location;
        private final RepositoryType type;

        public Repository(String location, RepositoryType type2) {
            this.location = location;
            this.type = type2;
        }

        public String getLocation() {
            return this.location;
        }

        public RepositoryType getType() {
            return this.type;
        }
    }

    public static enum RepositoryType {
        DIR,
        GLOB,
        JAR,
        URL;

    }
}

