/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.tomcat.util.buf.UriUtil;
import org.apache.tomcat.util.file.ConfigurationSource;
import org.apache.tomcat.util.res.StringManager;

public class CatalinaBaseConfigurationSource
implements ConfigurationSource {
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");
    public static final String LEGACY_SERVER_EMBED_XML = "server-embed.xml";
    private final String serverXmlPath;
    private final File catalinaBaseFile;
    private final URI catalinaBaseUri;

    public CatalinaBaseConfigurationSource(File catalinaBaseFile, String serverXmlPath) {
        this.catalinaBaseFile = catalinaBaseFile;
        this.catalinaBaseUri = catalinaBaseFile.toURI();
        this.serverXmlPath = serverXmlPath;
    }

    @Override
    public ConfigurationSource.Resource getServerXml() throws IOException {
        InputStream stream;
        IOException ioe = null;
        ConfigurationSource.Resource result2 = null;
        try {
            result2 = this.serverXmlPath == null || this.serverXmlPath.equals("conf/server.xml") ? ConfigurationSource.super.getServerXml() : this.getResource(this.serverXmlPath);
        }
        catch (IOException e) {
            ioe = e;
        }
        if (result2 == null && (stream = this.getClass().getClassLoader().getResourceAsStream(LEGACY_SERVER_EMBED_XML)) != null) {
            try {
                result2 = new ConfigurationSource.Resource(stream, this.getClass().getClassLoader().getResource(LEGACY_SERVER_EMBED_XML).toURI());
            }
            catch (URISyntaxException e) {
                stream.close();
            }
        }
        if (result2 == null && ioe != null) {
            throw ioe;
        }
        return result2;
    }

    @Override
    public ConfigurationSource.Resource getResource(String name2) throws IOException {
        if (!UriUtil.isAbsoluteURI(name2)) {
            File f = new File(name2);
            if (!f.isAbsolute()) {
                f = new File(this.catalinaBaseFile, name2);
            }
            if (f.isFile()) {
                FileInputStream fis = new FileInputStream(f);
                return new ConfigurationSource.Resource(fis, f.toURI());
            }
            InputStream stream = null;
            try {
                stream = this.getClass().getClassLoader().getResourceAsStream(name2);
                if (stream != null) {
                    return new ConfigurationSource.Resource(stream, this.getClass().getClassLoader().getResource(name2).toURI());
                }
            }
            catch (URISyntaxException e) {
                stream.close();
                throw new IOException(sm.getString("catalinaConfigurationSource.cannotObtainURL", name2), e);
            }
        }
        URI uri = null;
        try {
            uri = this.getURIInternal(name2);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(sm.getString("catalinaConfigurationSource.cannotObtainURL", name2));
        }
        try {
            URL url = uri.toURL();
            return new ConfigurationSource.Resource(url.openConnection().getInputStream(), uri);
        }
        catch (MalformedURLException e) {
            throw new IOException(sm.getString("catalinaConfigurationSource.cannotObtainURL", name2), e);
        }
    }

    @Override
    public URI getURI(String name2) {
        if (!UriUtil.isAbsoluteURI(name2)) {
            File f = new File(name2);
            if (!f.isAbsolute()) {
                f = new File(this.catalinaBaseFile, name2);
            }
            if (f.isFile()) {
                return f.toURI();
            }
            try {
                URL resource = this.getClass().getClassLoader().getResource(name2);
                if (resource != null) {
                    return resource.toURI();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return this.getURIInternal(name2);
    }

    private URI getURIInternal(String name2) {
        URI uri = this.catalinaBaseUri != null ? this.catalinaBaseUri.resolve(name2) : URI.create(name2);
        return uri;
    }
}

