/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Session;
import org.apache.catalina.Store;
import org.apache.catalina.StoreManager;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.session.StoreBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public abstract class PersistentManagerBase
extends ManagerBase
implements StoreManager {
    private final Log log = LogFactory.getLog(PersistentManagerBase.class);
    private static final String name = "PersistentManagerBase";
    private static final String PERSISTED_LAST_ACCESSED_TIME = "org.apache.catalina.session.PersistentManagerBase.persistedLastAccessedTime";
    protected Store store = null;
    protected boolean saveOnRestart = true;
    protected int maxIdleBackup = -1;
    protected int minIdleSwap = -1;
    protected int maxIdleSwap = -1;
    private final Map<String, Object> sessionSwapInLocks = new HashMap<String, Object>();
    private final ThreadLocal<Session> sessionToSwapIn = new ThreadLocal();

    public int getMaxIdleBackup() {
        return this.maxIdleBackup;
    }

    public void setMaxIdleBackup(int backup) {
        if (backup == this.maxIdleBackup) {
            return;
        }
        int oldBackup = this.maxIdleBackup;
        this.maxIdleBackup = backup;
        this.support.firePropertyChange("maxIdleBackup", (Object)oldBackup, (Object)this.maxIdleBackup);
    }

    public int getMaxIdleSwap() {
        return this.maxIdleSwap;
    }

    public void setMaxIdleSwap(int max2) {
        if (max2 == this.maxIdleSwap) {
            return;
        }
        int oldMaxIdleSwap = this.maxIdleSwap;
        this.maxIdleSwap = max2;
        this.support.firePropertyChange("maxIdleSwap", (Object)oldMaxIdleSwap, (Object)this.maxIdleSwap);
    }

    public int getMinIdleSwap() {
        return this.minIdleSwap;
    }

    public void setMinIdleSwap(int min2) {
        if (this.minIdleSwap == min2) {
            return;
        }
        int oldMinIdleSwap = this.minIdleSwap;
        this.minIdleSwap = min2;
        this.support.firePropertyChange("minIdleSwap", (Object)oldMinIdleSwap, (Object)this.minIdleSwap);
    }

    public boolean isLoaded(String id2) {
        try {
            if (super.findSession(id2) != null) {
                return true;
            }
        }
        catch (IOException e) {
            this.log.error(sm.getString("persistentManager.isLoadedError", id2), e);
        }
        return false;
    }

    @Override
    public String getName() {
        return name;
    }

    public void setStore(Store store) {
        this.store = store;
        store.setManager(this);
    }

    @Override
    public Store getStore() {
        return this.store;
    }

    public boolean getSaveOnRestart() {
        return this.saveOnRestart;
    }

    public void setSaveOnRestart(boolean saveOnRestart) {
        if (saveOnRestart == this.saveOnRestart) {
            return;
        }
        boolean oldSaveOnRestart = this.saveOnRestart;
        this.saveOnRestart = saveOnRestart;
        this.support.firePropertyChange("saveOnRestart", (Object)oldSaveOnRestart, (Object)this.saveOnRestart);
    }

    public void clearStore() {
        if (this.store == null) {
            return;
        }
        try {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                try {
                    AccessController.doPrivileged(new PrivilegedStoreClear());
                }
                catch (PrivilegedActionException e) {
                    this.log.error(sm.getString("persistentManager.storeClearError"), e.getException());
                }
            } else {
                this.store.clear();
            }
        }
        catch (IOException e) {
            this.log.error(sm.getString("persistentManager.storeClearError"), e);
        }
    }

    @Override
    public void processExpires() {
        long timeNow = System.currentTimeMillis();
        Session[] sessions = this.findSessions();
        int expireHere = 0;
        if (this.log.isTraceEnabled()) {
            this.log.trace("Start expire sessions " + this.getName() + " at " + timeNow + " sessioncount " + sessions.length);
        }
        for (Session session : sessions) {
            if (session.isValid()) continue;
            this.expiredSessions.incrementAndGet();
            ++expireHere;
        }
        this.processPersistenceChecks();
        if (this.getStore() instanceof StoreBase) {
            ((StoreBase)this.getStore()).processExpires();
        }
        long timeEnd = System.currentTimeMillis();
        if (this.log.isTraceEnabled()) {
            this.log.trace("End expire sessions " + this.getName() + " processingTime " + (timeEnd - timeNow) + " expired sessions: " + expireHere);
        }
        this.processingTime += timeEnd - timeNow;
    }

    public void processPersistenceChecks() {
        this.processMaxIdleSwaps();
        this.processMaxActiveSwaps();
        this.processMaxIdleBackups();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session findSession(String id2) throws IOException {
        Session session = super.findSession(id2);
        if (session != null) {
            Session session2 = session;
            synchronized (session2) {
                session = super.findSession(session.getIdInternal());
                if (session != null) {
                    session.access();
                    session.endAccess();
                }
            }
        }
        if (session != null) {
            return session;
        }
        session = this.swapIn(id2);
        return session;
    }

    @Override
    public void removeSuper(Session session) {
        super.remove(session, false);
    }

    @Override
    public void load() {
        String[] ids;
        block11: {
            this.sessions.clear();
            if (this.store == null) {
                return;
            }
            ids = null;
            try {
                if (SecurityUtil.isPackageProtectionEnabled()) {
                    try {
                        ids = AccessController.doPrivileged(new PrivilegedStoreKeys());
                        break block11;
                    }
                    catch (PrivilegedActionException e) {
                        this.log.error(sm.getString("persistentManager.storeLoadKeysError"), e.getException());
                        return;
                    }
                }
                ids = this.store.keys();
            }
            catch (IOException e) {
                this.log.error(sm.getString("persistentManager.storeLoadKeysError"), e);
                return;
            }
        }
        int n = ids.length;
        if (n == 0) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(sm.getString("persistentManager.loading", String.valueOf(n)));
        }
        for (String id2 : ids) {
            try {
                this.swapIn(id2);
            }
            catch (IOException e) {
                this.log.error(sm.getString("persistentManager.storeLoadError"), e);
            }
        }
    }

    @Override
    public void remove(Session session, boolean update2) {
        super.remove(session, update2);
        if (this.store != null) {
            this.removeSession(session.getIdInternal());
        }
    }

    protected void removeSession(String id2) {
        try {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                try {
                    AccessController.doPrivileged(new PrivilegedStoreRemove(id2));
                }
                catch (PrivilegedActionException e) {
                    this.log.error(sm.getString("persistentManager.removeError"), e.getException());
                }
            } else {
                this.store.remove(id2);
            }
        }
        catch (IOException e) {
            this.log.error(sm.getString("persistentManager.removeError"), e);
        }
    }

    @Override
    public void unload() {
        if (this.store == null) {
            return;
        }
        Session[] sessions = this.findSessions();
        int n = sessions.length;
        if (n == 0) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(sm.getString("persistentManager.unloading", String.valueOf(n)));
        }
        for (Session session : sessions) {
            try {
                this.swapOut(session);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public int getActiveSessionsFull() {
        int result2 = this.getActiveSessions();
        try {
            result2 += this.getStore().getSize();
        }
        catch (IOException ioe) {
            this.log.warn(sm.getString("persistentManager.storeSizeException"));
        }
        return result2;
    }

    @Override
    public Set<String> getSessionIdsFull() {
        HashSet<String> sessionIds = new HashSet<String>(this.sessions.keySet());
        try {
            sessionIds.addAll(Arrays.asList(this.getStore().keys()));
        }
        catch (IOException e) {
            this.log.warn(sm.getString("persistentManager.storeKeysException"));
        }
        return sessionIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session swapIn(String id2) throws IOException {
        if (this.store == null) {
            return null;
        }
        Object swapInLock = null;
        PersistentManagerBase persistentManagerBase = this;
        synchronized (persistentManagerBase) {
            swapInLock = this.sessionSwapInLocks.computeIfAbsent(id2, k -> new Object());
        }
        Session session = null;
        Object object = swapInLock;
        synchronized (object) {
            session = (Session)this.sessions.get(id2);
            if (session == null) {
                Session currentSwapInSession = this.sessionToSwapIn.get();
                try {
                    if (currentSwapInSession == null || !id2.equals(currentSwapInSession.getId())) {
                        session = this.loadSessionFromStore(id2);
                        this.sessionToSwapIn.set(session);
                        if (session != null && !session.isValid()) {
                            this.log.error(sm.getString("persistentManager.swapInInvalid", id2));
                            session.expire();
                            this.removeSession(id2);
                            session = null;
                        }
                        if (session != null) {
                            this.reactivateLoadedSession(id2, session);
                        }
                    }
                }
                finally {
                    this.sessionToSwapIn.remove();
                }
            }
        }
        object = this;
        synchronized (object) {
            this.sessionSwapInLocks.remove(id2);
        }
        return session;
    }

    private void reactivateLoadedSession(String id2, Session session) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(sm.getString("persistentManager.swapIn", id2));
        }
        session.setManager(this);
        ((StandardSession)session).tellNew();
        this.add(session);
        ((StandardSession)session).activate();
        session.access();
        session.endAccess();
    }

    private Session loadSessionFromStore(String id2) throws IOException {
        try {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                return this.securedStoreLoad(id2);
            }
            return this.store.load(id2);
        }
        catch (ClassNotFoundException e) {
            String msg = sm.getString("persistentManager.deserializeError", id2);
            this.log.error(msg, e);
            throw new IllegalStateException(msg, e);
        }
    }

    private Session securedStoreLoad(String id2) throws IOException, ClassNotFoundException {
        try {
            return AccessController.doPrivileged(new PrivilegedStoreLoad(id2));
        }
        catch (PrivilegedActionException ex) {
            Exception e = ex.getException();
            this.log.error(sm.getString("persistentManager.swapInException", id2), e);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)e;
            }
            return null;
        }
    }

    protected void swapOut(Session session) throws IOException {
        if (this.store == null || !session.isValid()) {
            return;
        }
        ((StandardSession)session).passivate();
        this.writeSession(session);
        super.remove(session, true);
        session.recycle();
    }

    protected void writeSession(Session session) throws IOException {
        if (this.store == null || !session.isValid()) {
            return;
        }
        try {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                try {
                    AccessController.doPrivileged(new PrivilegedStoreSave(session));
                }
                catch (PrivilegedActionException ex) {
                    Exception exception2 = ex.getException();
                    if (exception2 instanceof IOException) {
                        throw (IOException)exception2;
                    }
                    this.log.error(sm.getString("persistentManager.serializeError", session.getIdInternal(), exception2));
                }
            } else {
                this.store.save(session);
            }
        }
        catch (IOException e) {
            this.log.error(sm.getString("persistentManager.serializeError", session.getIdInternal(), e));
            throw e;
        }
    }

    @Override
    protected void startInternal() throws LifecycleException {
        super.startInternal();
        if (this.store == null) {
            this.log.error(sm.getString("persistentManager.noStore"));
        } else if (this.store instanceof Lifecycle) {
            ((Lifecycle)((Object)this.store)).start();
        }
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Stopping");
        }
        this.setState(LifecycleState.STOPPING);
        if (this.getStore() != null && this.saveOnRestart) {
            this.unload();
        } else {
            Session[] sessions;
            for (Session value2 : sessions = this.findSessions()) {
                StandardSession session = (StandardSession)value2;
                if (!session.isValid()) continue;
                session.expire();
            }
        }
        if (this.getStore() instanceof Lifecycle) {
            ((Lifecycle)((Object)this.getStore())).stop();
        }
        super.stopInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMaxIdleSwaps() {
        if (!this.getState().isAvailable() || this.maxIdleSwap < 0) {
            return;
        }
        Session[] sessions = this.findSessions();
        if (this.maxIdleSwap >= 0) {
            for (Session value2 : sessions) {
                StandardSession session;
                StandardSession standardSession = session = (StandardSession)value2;
                synchronized (standardSession) {
                    if (!session.isValid()) {
                        continue;
                    }
                    int timeIdle = (int)(session.getIdleTimeInternal() / 1000L);
                    if (timeIdle >= this.maxIdleSwap && timeIdle >= this.minIdleSwap) {
                        if (session.accessCount != null && session.accessCount.get() > 0) {
                            continue;
                        }
                        if (this.log.isTraceEnabled()) {
                            this.log.trace(sm.getString("persistentManager.swapMaxIdle", session.getIdInternal(), timeIdle));
                        }
                        try {
                            this.swapOut(session);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMaxActiveSwaps() {
        if (!this.getState().isAvailable() || this.minIdleSwap < 0 || this.getMaxActiveSessions() < 0) {
            return;
        }
        Session[] sessions = this.findSessions();
        int limit2 = (int)((double)this.getMaxActiveSessions() * 0.9);
        if (limit2 >= sessions.length) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(sm.getString("persistentManager.tooManyActive", sessions.length));
        }
        int toswap = sessions.length - limit2;
        for (int i2 = 0; i2 < sessions.length && toswap > 0; ++i2) {
            StandardSession session;
            StandardSession standardSession = session = (StandardSession)sessions[i2];
            synchronized (standardSession) {
                int timeIdle = (int)(session.getIdleTimeInternal() / 1000L);
                if (timeIdle >= this.minIdleSwap) {
                    if (session.accessCount != null && session.accessCount.get() > 0) {
                        continue;
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace(sm.getString("persistentManager.swapTooManyActive", session.getIdInternal(), timeIdle));
                    }
                    try {
                        this.swapOut(session);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    --toswap;
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMaxIdleBackups() {
        if (!this.getState().isAvailable() || this.maxIdleBackup < 0) {
            return;
        }
        Session[] sessions = this.findSessions();
        if (this.maxIdleBackup >= 0) {
            for (Session value2 : sessions) {
                StandardSession session;
                StandardSession standardSession = session = (StandardSession)value2;
                synchronized (standardSession) {
                    if (!session.isValid()) {
                        continue;
                    }
                    long lastAccessedTime = session.getLastAccessedTimeInternal();
                    Long persistedLastAccessedTime = (Long)session.getNote(PERSISTED_LAST_ACCESSED_TIME);
                    if (persistedLastAccessedTime != null && lastAccessedTime == persistedLastAccessedTime) {
                        continue;
                    }
                    int timeIdle = (int)(session.getIdleTimeInternal() / 1000L);
                    if (timeIdle >= this.maxIdleBackup) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace(sm.getString("persistentManager.backupMaxIdle", session.getIdInternal(), timeIdle));
                        }
                        try {
                            this.writeSession(session);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        session.setNote(PERSISTED_LAST_ACCESSED_TIME, lastAccessedTime);
                    }
                }
            }
        }
    }

    private class PrivilegedStoreClear
    implements PrivilegedExceptionAction<Void> {
        PrivilegedStoreClear() {
        }

        @Override
        public Void run() throws Exception {
            PersistentManagerBase.this.store.clear();
            return null;
        }
    }

    private class PrivilegedStoreKeys
    implements PrivilegedExceptionAction<String[]> {
        PrivilegedStoreKeys() {
        }

        @Override
        public String[] run() throws Exception {
            return PersistentManagerBase.this.store.keys();
        }
    }

    private class PrivilegedStoreRemove
    implements PrivilegedExceptionAction<Void> {
        private String id;

        PrivilegedStoreRemove(String id2) {
            this.id = id2;
        }

        @Override
        public Void run() throws Exception {
            PersistentManagerBase.this.store.remove(this.id);
            return null;
        }
    }

    private class PrivilegedStoreLoad
    implements PrivilegedExceptionAction<Session> {
        private String id;

        PrivilegedStoreLoad(String id2) {
            this.id = id2;
        }

        @Override
        public Session run() throws Exception {
            return PersistentManagerBase.this.store.load(this.id);
        }
    }

    private class PrivilegedStoreSave
    implements PrivilegedExceptionAction<Void> {
        private Session session;

        PrivilegedStoreSave(Session session) {
            this.session = session;
        }

        @Override
        public Void run() throws Exception {
            PersistentManagerBase.this.store.save(this.session);
            return null;
        }
    }
}

