/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import jakarta.servlet.ServletContext;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import org.apache.catalina.Context;
import org.apache.catalina.Session;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.session.StoreBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public final class FileStore
extends StoreBase {
    private static final Log log = LogFactory.getLog(FileStore.class);
    private static final StringManager sm = StringManager.getManager(FileStore.class);
    private static final String FILE_EXT = ".session";
    private String directory = ".";
    private File directoryFile = null;
    private static final String storeName = "fileStore";
    private static final String threadName = "FileStore";

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String path2) {
        String oldDirectory = this.directory;
        this.directory = path2;
        this.directoryFile = null;
        this.support.firePropertyChange("directory", oldDirectory, this.directory);
    }

    public String getThreadName() {
        return threadName;
    }

    @Override
    public String getStoreName() {
        return storeName;
    }

    @Override
    public int getSize() throws IOException {
        File dir = this.directory();
        if (dir == null) {
            return 0;
        }
        String[] files = dir.list();
        int keycount = 0;
        if (files != null) {
            for (String file2 : files) {
                if (!file2.endsWith(FILE_EXT)) continue;
                ++keycount;
            }
        }
        return keycount;
    }

    @Override
    public void clear() throws IOException {
        String[] keys2;
        for (String key2 : keys2 = this.keys()) {
            this.remove(key2);
        }
    }

    @Override
    public String[] keys() throws IOException {
        File dir = this.directory();
        if (dir == null) {
            return new String[0];
        }
        String[] files = dir.list();
        if (files == null || files.length < 1) {
            return new String[0];
        }
        ArrayList<String> list2 = new ArrayList<String>();
        int n = FILE_EXT.length();
        for (String file2 : files) {
            if (!file2.endsWith(FILE_EXT)) continue;
            list2.add(file2.substring(0, file2.length() - n));
        }
        return list2.toArray(new String[0]);
    }

    /*
     * Exception decompiling
     */
    @Override
    public Session load(String id) throws ClassNotFoundException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void remove(String id2) throws IOException {
        File file2 = this.file(id2);
        if (file2 == null) {
            return;
        }
        if (this.manager.getContext().getLogger().isTraceEnabled()) {
            this.manager.getContext().getLogger().trace(sm.getString(this.getStoreName() + ".removing", id2, file2.getAbsolutePath()));
        }
        if (file2.exists() && !file2.delete()) {
            throw new IOException(sm.getString("fileStore.deleteSessionFailed", file2));
        }
    }

    @Override
    public void save(Session session) throws IOException {
        File file2 = this.file(session.getIdInternal());
        if (file2 == null) {
            return;
        }
        if (this.manager.getContext().getLogger().isTraceEnabled()) {
            this.manager.getContext().getLogger().trace(sm.getString(this.getStoreName() + ".saving", session.getIdInternal(), file2.getAbsolutePath()));
        }
        try (FileOutputStream fos = new FileOutputStream(file2.getAbsolutePath());
             ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(fos));){
            ((StandardSession)session).writeObjectData(oos);
        }
    }

    private File directory() throws IOException {
        if (this.directory == null) {
            return null;
        }
        if (this.directoryFile != null) {
            return this.directoryFile;
        }
        File file2 = new File(this.directory);
        if (!file2.isAbsolute()) {
            Context context = this.manager.getContext();
            ServletContext servletContext = context.getServletContext();
            File work = (File)servletContext.getAttribute("jakarta.servlet.context.tempdir");
            file2 = new File(work, this.directory);
        }
        if (!file2.exists() || !file2.isDirectory()) {
            if (!file2.delete() && file2.exists()) {
                throw new IOException(sm.getString("fileStore.deleteFailed", file2));
            }
            if (!file2.mkdirs() && !file2.isDirectory()) {
                throw new IOException(sm.getString("fileStore.createFailed", file2));
            }
        }
        this.directoryFile = file2;
        return file2;
    }

    private File file(String id2) throws IOException {
        File storageDir = this.directory();
        if (storageDir == null) {
            return null;
        }
        String filename2 = id2 + FILE_EXT;
        File file2 = new File(storageDir, filename2);
        File canonicalFile = file2.getCanonicalFile();
        if (!canonicalFile.toPath().startsWith(storageDir.getCanonicalFile().toPath())) {
            log.warn(sm.getString("fileStore.invalid", file2.getPath(), id2));
            return null;
        }
        return canonicalFile;
    }
}

