/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.catalina.WebResource;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.servlets.DefaultServlet;
import org.apache.catalina.util.DOMWriter;
import org.apache.catalina.util.XMLWriter;
import org.apache.tomcat.PeriodicEventListener;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.http.ConcurrentDateFormat;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.RequestUtil;
import org.apache.tomcat.util.security.ConcurrentMessageDigest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WebdavServlet
extends DefaultServlet
implements PeriodicEventListener {
    private static final long serialVersionUID = 1L;
    private static final String METHOD_PROPFIND = "PROPFIND";
    private static final String METHOD_PROPPATCH = "PROPPATCH";
    private static final String METHOD_MKCOL = "MKCOL";
    private static final String METHOD_COPY = "COPY";
    private static final String METHOD_MOVE = "MOVE";
    private static final String METHOD_LOCK = "LOCK";
    private static final String METHOD_UNLOCK = "UNLOCK";
    private static final int FIND_BY_PROPERTY = 0;
    private static final int FIND_ALL_PROP = 1;
    private static final int FIND_PROPERTY_NAMES = 2;
    private static final int LOCK_CREATION = 0;
    private static final int LOCK_REFRESH = 1;
    private static final int DEFAULT_TIMEOUT = 3600;
    private static final int MAX_TIMEOUT = 604800;
    protected static final String DEFAULT_NAMESPACE = "DAV:";
    protected static final ConcurrentDateFormat creationDateFormat = new ConcurrentDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US, TimeZone.getTimeZone("GMT"));
    private final Map<String, LockInfo> resourceLocks = new ConcurrentHashMap<String, LockInfo>();
    private final Map<String, List<String>> lockNullResources = new ConcurrentHashMap<String, List<String>>();
    private final List<LockInfo> collectionLocks = Collections.synchronizedList(new ArrayList());
    private String secret = "catalina";
    private int maxDepth = 3;
    private boolean allowSpecialPaths = false;

    @Override
    public void init() throws ServletException {
        super.init();
        if (this.getServletConfig().getInitParameter("secret") != null) {
            this.secret = this.getServletConfig().getInitParameter("secret");
        }
        if (this.getServletConfig().getInitParameter("maxDepth") != null) {
            this.maxDepth = Integer.parseInt(this.getServletConfig().getInitParameter("maxDepth"));
        }
        if (this.getServletConfig().getInitParameter("allowSpecialPaths") != null) {
            this.allowSpecialPaths = Boolean.parseBoolean(this.getServletConfig().getInitParameter("allowSpecialPaths"));
        }
    }

    @Override
    public void periodicEvent() {
        for (LockInfo currentLock : this.resourceLocks.values()) {
            if (!currentLock.hasExpired()) continue;
            this.resourceLocks.remove(currentLock.path);
            this.removeLockNull(currentLock.path);
        }
        Iterator<LockInfo> collectionLocksIterator = this.collectionLocks.iterator();
        while (collectionLocksIterator.hasNext()) {
            LockInfo currentLock;
            currentLock = collectionLocksIterator.next();
            if (!currentLock.hasExpired()) continue;
            collectionLocksIterator.remove();
            this.removeLockNull(currentLock.path);
        }
    }

    protected DocumentBuilder getDocumentBuilder() throws ServletException {
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = null;
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setExpandEntityReferences(false);
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new WebdavResolver(this.getServletContext()));
        }
        catch (ParserConfigurationException e) {
            throw new ServletException(sm.getString("webdavservlet.jaxpfailed"));
        }
        return documentBuilder;
    }

    @Override
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path2 = this.getRelativePath(req);
        if (req.getDispatcherType() == DispatcherType.ERROR) {
            this.doGet(req, resp);
            return;
        }
        if (this.isSpecialPath(path2)) {
            resp.sendError(404);
            return;
        }
        String method2 = req.getMethod();
        if (this.debug > 0) {
            this.log("[" + method2 + "] " + path2);
        }
        if (method2.equals(METHOD_PROPFIND)) {
            this.doPropfind(req, resp);
        } else if (method2.equals(METHOD_PROPPATCH)) {
            this.doProppatch(req, resp);
        } else if (method2.equals(METHOD_MKCOL)) {
            this.doMkcol(req, resp);
        } else if (method2.equals(METHOD_COPY)) {
            this.doCopy(req, resp);
        } else if (method2.equals(METHOD_MOVE)) {
            this.doMove(req, resp);
        } else if (method2.equals(METHOD_LOCK)) {
            this.doLock(req, resp);
        } else if (method2.equals(METHOD_UNLOCK)) {
            this.doUnlock(req, resp);
        } else {
            super.service(req, resp);
        }
    }

    private boolean isSpecialPath(String path2) {
        return !this.allowSpecialPaths && (path2.toUpperCase(Locale.ENGLISH).startsWith("/WEB-INF") || path2.toUpperCase(Locale.ENGLISH).startsWith("/META-INF"));
    }

    @Override
    protected boolean checkIfHeaders(HttpServletRequest request, HttpServletResponse response, WebResource resource) throws IOException {
        return super.checkIfHeaders(request, response, resource);
    }

    @Override
    protected String getRelativePath(HttpServletRequest request) {
        return this.getRelativePath(request, false);
    }

    @Override
    protected String getRelativePath(HttpServletRequest request, boolean allowEmptyPath) {
        String pathInfo = request.getAttribute("jakarta.servlet.include.request_uri") != null ? (String)request.getAttribute("jakarta.servlet.include.path_info") : request.getPathInfo();
        StringBuilder result2 = new StringBuilder();
        if (pathInfo != null) {
            result2.append(pathInfo);
        }
        if (result2.length() == 0) {
            result2.append('/');
        }
        return result2.toString();
    }

    @Override
    protected String getPathPrefix(HttpServletRequest request) {
        Object contextPath = request.getContextPath();
        if (request.getServletPath() != null) {
            contextPath = (String)contextPath + request.getServletPath();
        }
        return contextPath;
    }

    @Override
    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.addHeader("DAV", "1,2");
        resp.addHeader("Allow", this.determineMethodsAllowed(req));
        resp.addHeader("MS-Author-Via", "DAV");
    }

    protected void doPropfind(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String parentPath;
        List<String> currentLockNullResources;
        int slash;
        WebResource resource;
        if (!this.listings) {
            this.sendNotAllowed(req, resp);
            return;
        }
        String path2 = this.getRelativePath(req);
        if (path2.length() > 1 && path2.endsWith("/")) {
            path2 = path2.substring(0, path2.length() - 1);
        }
        ArrayList<String> properties = null;
        int depth = this.maxDepth;
        int type2 = 1;
        String depthStr = req.getHeader("Depth");
        if (depthStr == null) {
            depth = this.maxDepth;
        } else if (depthStr.equals("0")) {
            depth = 0;
        } else if (depthStr.equals("1")) {
            depth = 1;
        } else if (depthStr.equals("infinity")) {
            depth = this.maxDepth;
        }
        Node propNode = null;
        if (req.getContentLengthLong() > 0L) {
            DocumentBuilder documentBuilder = this.getDocumentBuilder();
            try {
                Document document = documentBuilder.parse(new InputSource(req.getInputStream()));
                Element rootElement = document.getDocumentElement();
                NodeList childList = rootElement.getChildNodes();
                block10: for (int i2 = 0; i2 < childList.getLength(); ++i2) {
                    Node currentNode = childList.item(i2);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            continue block10;
                        }
                        case 1: {
                            if (currentNode.getNodeName().endsWith("prop")) {
                                type2 = 0;
                                propNode = currentNode;
                            }
                            if (currentNode.getNodeName().endsWith("propname")) {
                                type2 = 2;
                            }
                            if (!currentNode.getNodeName().endsWith("allprop")) continue block10;
                            type2 = 1;
                        }
                    }
                }
            }
            catch (IOException | SAXException e) {
                resp.sendError(400);
                return;
            }
        }
        if (type2 == 0) {
            properties = new ArrayList<String>();
            NodeList childList = propNode.getChildNodes();
            block11: for (int i3 = 0; i3 < childList.getLength(); ++i3) {
                Node currentNode = childList.item(i3);
                switch (currentNode.getNodeType()) {
                    case 3: {
                        continue block11;
                    }
                    case 1: {
                        String nodeName = currentNode.getNodeName();
                        String propertyName = null;
                        propertyName = nodeName.indexOf(58) != -1 ? nodeName.substring(nodeName.indexOf(58) + 1) : nodeName;
                        properties.add(propertyName);
                    }
                }
            }
        }
        if (!(resource = this.resources.getResource(path2)).exists() && (slash = path2.lastIndexOf(47)) != -1 && (currentLockNullResources = this.lockNullResources.get(parentPath = path2.substring(0, slash))) != null) {
            for (String lockNullPath : currentLockNullResources) {
                if (!lockNullPath.equals(path2)) continue;
                resp.setStatus(207);
                resp.setContentType("text/xml; charset=UTF-8");
                XMLWriter generatedXML = new XMLWriter(resp.getWriter());
                generatedXML.writeXMLHeader();
                generatedXML.writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
                this.parseLockNullProperties(req, generatedXML, lockNullPath, type2, properties);
                generatedXML.writeElement("D", "multistatus", 1);
                generatedXML.sendData();
                return;
            }
        }
        if (!resource.exists()) {
            resp.sendError(404);
            return;
        }
        resp.setStatus(207);
        resp.setContentType("text/xml; charset=UTF-8");
        XMLWriter generatedXML = new XMLWriter(resp.getWriter());
        generatedXML.writeXMLHeader();
        generatedXML.writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
        if (depth == 0) {
            this.parseProperties(req, generatedXML, path2, type2, properties);
        } else {
            ArrayDeque<String> stack = new ArrayDeque<String>();
            stack.addFirst(path2);
            ArrayDeque<Object> stackBelow = new ArrayDeque<Object>();
            while (!stack.isEmpty() && depth >= 0) {
                String currentPath = (String)stack.remove();
                this.parseProperties(req, generatedXML, currentPath, type2, properties);
                resource = this.resources.getResource(currentPath);
                if (resource.isDirectory() && depth > 0) {
                    List<String> currentLockNullResources2;
                    String[] entries2;
                    for (String entry : entries2 = this.resources.list(currentPath)) {
                        Object newPath = currentPath;
                        if (!((String)newPath).endsWith("/")) {
                            newPath = (String)newPath + "/";
                        }
                        newPath = (String)newPath + entry;
                        stackBelow.addFirst(newPath);
                    }
                    String lockPath = currentPath;
                    if (lockPath.endsWith("/")) {
                        lockPath = lockPath.substring(0, lockPath.length() - 1);
                    }
                    if ((currentLockNullResources2 = this.lockNullResources.get(lockPath)) != null) {
                        for (String lockNullPath : currentLockNullResources2) {
                            this.parseLockNullProperties(req, generatedXML, lockNullPath, type2, properties);
                        }
                    }
                }
                if (stack.isEmpty()) {
                    --depth;
                    stack = stackBelow;
                    stackBelow = new ArrayDeque();
                }
                generatedXML.sendData();
            }
        }
        generatedXML.writeElement("D", "multistatus", 1);
        generatedXML.sendData();
    }

    protected void doProppatch(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        resp.sendError(501);
    }

    protected void doMkcol(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path2 = this.getRelativePath(req);
        WebResource resource = this.resources.getResource(path2);
        if (resource.exists()) {
            this.sendNotAllowed(req, resp);
            return;
        }
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        if (req.getContentLengthLong() > 0L) {
            DocumentBuilder documentBuilder = this.getDocumentBuilder();
            try {
                documentBuilder.parse(new InputSource(req.getInputStream()));
                resp.sendError(501);
                return;
            }
            catch (SAXException saxe) {
                resp.sendError(415);
                return;
            }
        }
        if (this.resources.mkdir(path2)) {
            resp.setStatus(201);
            this.removeLockNull(path2);
        } else {
            resp.sendError(409);
        }
    }

    @Override
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.readOnly) {
            this.sendNotAllowed(req, resp);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        this.deleteResource(req, resp);
    }

    @Override
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        String path2 = this.getRelativePath(req);
        WebResource resource = this.resources.getResource(path2);
        if (resource.isDirectory()) {
            this.sendNotAllowed(req, resp);
            return;
        }
        super.doPut(req, resp);
        this.removeLockNull(path2);
    }

    protected void doCopy(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        this.copyResource(req, resp);
    }

    protected void doMove(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        String path2 = this.getRelativePath(req);
        if (this.copyResource(req, resp)) {
            this.deleteResource(path2, req, resp, false);
        }
    }

    protected void doLock(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path2;
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        LockInfo lock2 = new LockInfo(this.maxDepth);
        String depthStr = req.getHeader("Depth");
        lock2.depth = depthStr == null ? this.maxDepth : (depthStr.equals("0") ? 0 : this.maxDepth);
        int lockDuration = 3600;
        String lockDurationStr = req.getHeader("Timeout");
        if (lockDurationStr != null) {
            int commaPos = lockDurationStr.indexOf(44);
            if (commaPos != -1) {
                lockDurationStr = lockDurationStr.substring(0, commaPos);
            }
            if (lockDurationStr.startsWith("Second-")) {
                lockDuration = Integer.parseInt(lockDurationStr.substring(7));
            } else if (lockDurationStr.equalsIgnoreCase("infinity")) {
                lockDuration = 604800;
            } else {
                try {
                    lockDuration = Integer.parseInt(lockDurationStr);
                }
                catch (NumberFormatException e) {
                    lockDuration = 604800;
                }
            }
            if (lockDuration == 0) {
                lockDuration = 3600;
            }
            if (lockDuration > 604800) {
                lockDuration = 604800;
            }
        }
        lock2.expiresAt = System.currentTimeMillis() + (long)(lockDuration * 1000);
        boolean lockRequestType = false;
        Node lockInfoNode = null;
        DocumentBuilder documentBuilder = this.getDocumentBuilder();
        try {
            Document document = documentBuilder.parse(new InputSource(req.getInputStream()));
            Element rootElement = document.getDocumentElement();
            lockInfoNode = rootElement;
        }
        catch (IOException | SAXException e) {
            lockRequestType = true;
        }
        if (lockInfoNode != null) {
            int i2;
            NodeList childList = lockInfoNode.getChildNodes();
            StringWriter strWriter = null;
            DOMWriter domWriter = null;
            Node lockScopeNode = null;
            Node lockTypeNode = null;
            Node lockOwnerNode = null;
            block20: for (int i22 = 0; i22 < childList.getLength(); ++i22) {
                Node node = childList.item(i22);
                switch (node.getNodeType()) {
                    case 3: {
                        continue block20;
                    }
                    case 1: {
                        String nodeName = node.getNodeName();
                        if (nodeName.endsWith("lockscope")) {
                            lockScopeNode = node;
                        }
                        if (nodeName.endsWith("locktype")) {
                            lockTypeNode = node;
                        }
                        if (!nodeName.endsWith("owner")) continue block20;
                        lockOwnerNode = node;
                    }
                }
            }
            if (lockScopeNode != null) {
                childList = lockScopeNode.getChildNodes();
                block21: for (i2 = 0; i2 < childList.getLength(); ++i2) {
                    Node node = childList.item(i2);
                    switch (node.getNodeType()) {
                        case 3: {
                            continue block21;
                        }
                        case 1: {
                            String tempScope = node.getNodeName();
                            lock2.scope = tempScope.indexOf(58) != -1 ? tempScope.substring(tempScope.indexOf(58) + 1) : tempScope;
                        }
                    }
                }
                if (lock2.scope == null) {
                    resp.setStatus(400);
                }
            } else {
                resp.setStatus(400);
            }
            if (lockTypeNode != null) {
                childList = lockTypeNode.getChildNodes();
                block22: for (i2 = 0; i2 < childList.getLength(); ++i2) {
                    Node node = childList.item(i2);
                    switch (node.getNodeType()) {
                        case 3: {
                            continue block22;
                        }
                        case 1: {
                            String tempType = node.getNodeName();
                            lock2.type = tempType.indexOf(58) != -1 ? tempType.substring(tempType.indexOf(58) + 1) : tempType;
                        }
                    }
                }
                if (lock2.type == null) {
                    resp.setStatus(400);
                }
            } else {
                resp.setStatus(400);
            }
            if (lockOwnerNode != null) {
                childList = lockOwnerNode.getChildNodes();
                block23: for (i2 = 0; i2 < childList.getLength(); ++i2) {
                    Node node = childList.item(i2);
                    switch (node.getNodeType()) {
                        case 3: {
                            lock2.owner = lock2.owner + node.getNodeValue();
                            continue block23;
                        }
                        case 1: {
                            strWriter = new StringWriter();
                            domWriter = new DOMWriter(strWriter);
                            domWriter.print(node);
                            lock2.owner = lock2.owner + strWriter.toString();
                        }
                    }
                }
                if (lock2.owner == null) {
                    resp.setStatus(400);
                }
            } else {
                lock2.owner = "";
            }
        }
        lock2.path = path2 = this.getRelativePath(req);
        WebResource resource = this.resources.getResource(path2);
        if (!lockRequestType) {
            String lockTokenStr = req.getServletPath() + "-" + lock2.type + "-" + lock2.scope + "-" + String.valueOf(req.getUserPrincipal()) + "-" + lock2.depth + "-" + lock2.owner + "-" + String.valueOf(lock2.tokens) + "-" + lock2.expiresAt + "-" + System.currentTimeMillis() + "-" + this.secret;
            String lockToken = HexUtils.toHexString(ConcurrentMessageDigest.digestMD5(new byte[][]{lockTokenStr.getBytes(StandardCharsets.ISO_8859_1)}));
            if (resource.isDirectory() && lock2.depth == this.maxDepth) {
                ArrayList<String> lockPaths = new ArrayList<String>();
                Iterator<LockInfo> collectionLocksIterator = this.collectionLocks.iterator();
                while (collectionLocksIterator.hasNext()) {
                    LockInfo currentLock = collectionLocksIterator.next();
                    if (currentLock.hasExpired()) {
                        collectionLocksIterator.remove();
                        continue;
                    }
                    if (!currentLock.path.startsWith(lock2.path) || !currentLock.isExclusive() && !lock2.isExclusive()) continue;
                    lockPaths.add(currentLock.path);
                }
                for (LockInfo lockInfo : this.resourceLocks.values()) {
                    if (lockInfo.hasExpired()) {
                        this.resourceLocks.remove(lockInfo.path);
                        continue;
                    }
                    if (!lockInfo.path.startsWith(lock2.path) || !lockInfo.isExclusive() && !lock2.isExclusive()) continue;
                    lockPaths.add(lockInfo.path);
                }
                if (!lockPaths.isEmpty()) {
                    resp.setStatus(409);
                    XMLWriter generatedXML = new XMLWriter();
                    generatedXML.writeXMLHeader();
                    generatedXML.writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
                    for (String lockPath : lockPaths) {
                        generatedXML.writeElement("D", "response", 0);
                        generatedXML.writeElement("D", "href", 0);
                        generatedXML.writeText(lockPath);
                        generatedXML.writeElement("D", "href", 1);
                        generatedXML.writeElement("D", "status", 0);
                        generatedXML.writeText("HTTP/1.1 423 ");
                        generatedXML.writeElement("D", "status", 1);
                        generatedXML.writeElement("D", "response", 1);
                    }
                    generatedXML.writeElement("D", "multistatus", 1);
                    PrintWriter printWriter = resp.getWriter();
                    ((Writer)printWriter).write(generatedXML.toString());
                    ((Writer)printWriter).close();
                    return;
                }
                boolean addLock = true;
                for (LockInfo currentLock : this.collectionLocks) {
                    if (!currentLock.path.equals(lock2.path)) continue;
                    if (currentLock.isExclusive()) {
                        resp.sendError(423);
                        return;
                    }
                    if (lock2.isExclusive()) {
                        resp.sendError(423);
                        return;
                    }
                    currentLock.tokens.add(lockToken);
                    lock2 = currentLock;
                    addLock = false;
                }
                if (addLock) {
                    lock2.tokens.add(lockToken);
                    this.collectionLocks.add(lock2);
                }
            } else {
                LockInfo presentLock = this.resourceLocks.get(lock2.path);
                if (presentLock != null) {
                    if (presentLock.isExclusive() || lock2.isExclusive()) {
                        resp.sendError(412);
                        return;
                    }
                    presentLock.tokens.add(lockToken);
                    lock2 = presentLock;
                } else {
                    lock2.tokens.add(lockToken);
                    this.resourceLocks.put(lock2.path, lock2);
                    if (!resource.exists()) {
                        int slash = lock2.path.lastIndexOf(47);
                        String parentPath = lock2.path.substring(0, slash);
                        this.lockNullResources.computeIfAbsent(parentPath, k -> new CopyOnWriteArrayList()).add(lock2.path);
                    }
                    resp.addHeader("Lock-Token", "<opaquelocktoken:" + lockToken + ">");
                }
            }
        }
        if (lockRequestType) {
            LockInfo toRenew;
            String ifHeader = req.getHeader("If");
            if (ifHeader == null) {
                ifHeader = "";
            }
            if ((toRenew = this.resourceLocks.get(path2)) != null) {
                for (String token2 : toRenew.tokens) {
                    if (!ifHeader.contains(token2)) continue;
                    toRenew.expiresAt = lock2.expiresAt;
                    lock2 = toRenew;
                }
            }
            for (LockInfo collecionLock : this.collectionLocks) {
                if (!path2.equals(collecionLock.path)) continue;
                for (String string2 : collecionLock.tokens) {
                    if (!ifHeader.contains(string2)) continue;
                    collecionLock.expiresAt = lock2.expiresAt;
                    lock2 = collecionLock;
                }
            }
        }
        XMLWriter generatedXML = new XMLWriter();
        generatedXML.writeXMLHeader();
        generatedXML.writeElement("D", DEFAULT_NAMESPACE, "prop", 0);
        generatedXML.writeElement("D", "lockdiscovery", 0);
        lock2.toXML(generatedXML);
        generatedXML.writeElement("D", "lockdiscovery", 1);
        generatedXML.writeElement("D", "prop", 1);
        resp.setStatus(200);
        resp.setContentType("text/xml; charset=UTF-8");
        PrintWriter writer = resp.getWriter();
        ((Writer)writer).write(generatedXML.toString());
        ((Writer)writer).close();
    }

    protected void doUnlock(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LockInfo lock2;
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        String path2 = this.getRelativePath(req);
        String lockTokenHeader = req.getHeader("Lock-Token");
        if (lockTokenHeader == null) {
            lockTokenHeader = "";
        }
        if ((lock2 = this.resourceLocks.get(path2)) != null) {
            Iterator<String> tokenList = lock2.tokens.iterator();
            while (tokenList.hasNext()) {
                String token2 = tokenList.next();
                if (!lockTokenHeader.contains(token2)) continue;
                tokenList.remove();
            }
            if (lock2.tokens.isEmpty()) {
                this.resourceLocks.remove(path2);
                this.removeLockNull(path2);
            }
        }
        Iterator<LockInfo> collectionLocksList = this.collectionLocks.iterator();
        while (collectionLocksList.hasNext()) {
            lock2 = collectionLocksList.next();
            if (!path2.equals(lock2.path)) continue;
            Iterator<String> tokenList = lock2.tokens.iterator();
            while (tokenList.hasNext()) {
                String token3 = tokenList.next();
                if (!lockTokenHeader.contains(token3)) continue;
                tokenList.remove();
                break;
            }
            if (!lock2.tokens.isEmpty()) continue;
            collectionLocksList.remove();
            this.removeLockNull(path2);
        }
        resp.setStatus(204);
    }

    private boolean isLocked(HttpServletRequest req) {
        String lockTokenHeader;
        String path2 = this.getRelativePath(req);
        String ifHeader = req.getHeader("If");
        if (ifHeader == null) {
            ifHeader = "";
        }
        if ((lockTokenHeader = req.getHeader("Lock-Token")) == null) {
            lockTokenHeader = "";
        }
        return this.isLocked(path2, ifHeader + lockTokenHeader);
    }

    private boolean isLocked(String path2, String ifHeader) {
        LockInfo lock2 = this.resourceLocks.get(path2);
        if (lock2 != null && lock2.hasExpired()) {
            this.resourceLocks.remove(path2);
        } else if (lock2 != null) {
            boolean tokenMatch = false;
            for (String token2 : lock2.tokens) {
                if (!ifHeader.contains(token2)) continue;
                tokenMatch = true;
                break;
            }
            if (!tokenMatch) {
                return true;
            }
        }
        Iterator<LockInfo> collectionLockList = this.collectionLocks.iterator();
        while (collectionLockList.hasNext()) {
            lock2 = collectionLockList.next();
            if (lock2.hasExpired()) {
                collectionLockList.remove();
                continue;
            }
            if (!path2.startsWith(lock2.path)) continue;
            boolean tokenMatch = false;
            for (String token3 : lock2.tokens) {
                if (!ifHeader.contains(token3)) continue;
                tokenMatch = true;
                break;
            }
            if (tokenMatch) continue;
            return true;
        }
        return false;
    }

    private boolean copyResource(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean result2;
        String reqContextPath;
        URI destinationUri;
        String path2 = this.getRelativePath(req);
        WebResource source2 = this.resources.getResource(path2);
        if (!source2.exists()) {
            resp.sendError(404);
            return false;
        }
        String destinationHeader = req.getHeader("Destination");
        if (destinationHeader == null || destinationHeader.isEmpty()) {
            resp.sendError(400);
            return false;
        }
        try {
            destinationUri = new URI(destinationHeader);
        }
        catch (URISyntaxException e) {
            resp.sendError(400);
            return false;
        }
        String destinationPath = destinationUri.getPath();
        if (!destinationPath.equals(RequestUtil.normalize(destinationPath))) {
            resp.sendError(400);
            return false;
        }
        if (destinationUri.isAbsolute()) {
            if (!req.getScheme().equals(destinationUri.getScheme()) || !req.getServerName().equals(destinationUri.getHost())) {
                resp.sendError(403);
                return false;
            }
            if (!(req.getServerPort() == destinationUri.getPort() || destinationUri.getPort() == -1 && ("http".equals(req.getScheme()) && req.getServerPort() == 80 || "https".equals(req.getScheme()) && req.getServerPort() == 443))) {
                resp.sendError(403);
                return false;
            }
        }
        if (!destinationPath.startsWith((reqContextPath = req.getContextPath()) + "/")) {
            resp.sendError(403);
            return false;
        }
        destinationPath = destinationPath.substring(reqContextPath.length() + req.getServletPath().length());
        if (this.debug > 0) {
            this.log("Dest path :" + destinationPath);
        }
        if (this.isSpecialPath(destinationPath)) {
            resp.sendError(403);
            return false;
        }
        if (destinationPath.equals(path2)) {
            resp.sendError(403);
            return false;
        }
        if (destinationPath.startsWith(path2) && destinationPath.charAt(path2.length()) == '/' || path2.startsWith(destinationPath) && path2.charAt(destinationPath.length()) == '/') {
            resp.sendError(403);
            return false;
        }
        boolean overwrite = true;
        String overwriteHeader = req.getHeader("Overwrite");
        if (overwriteHeader != null) {
            overwrite = overwriteHeader.equalsIgnoreCase("T");
        }
        WebResource destination = this.resources.getResource(destinationPath);
        if (overwrite) {
            if (destination.exists()) {
                if (!this.deleteResource(destinationPath, req, resp, true)) {
                    return false;
                }
            } else {
                resp.setStatus(201);
            }
        } else if (destination.exists()) {
            resp.sendError(412);
            return false;
        }
        HashMap<String, Integer> errorList = new HashMap<String, Integer>();
        boolean infiniteCopy = true;
        String depthHeader = req.getHeader("Depth");
        if (depthHeader != null && !depthHeader.equals("infinity")) {
            if (depthHeader.equals("0")) {
                infiniteCopy = false;
            } else {
                resp.sendError(400);
                return false;
            }
        }
        if (!(result2 = this.copyResource(errorList, path2, destinationPath, infiniteCopy)) || !errorList.isEmpty()) {
            if (errorList.size() == 1) {
                resp.sendError((Integer)errorList.values().iterator().next());
            } else {
                this.sendReport(req, resp, errorList);
            }
            return false;
        }
        if (destination.exists()) {
            resp.setStatus(204);
        } else {
            resp.setStatus(201);
        }
        this.removeLockNull(destinationPath);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean copyResource(Map<String, Integer> errorList, String source2, String dest, boolean infiniteCopy) {
        String parent;
        WebResource parentResource;
        int lastSlash;
        WebResource sourceResource;
        if (this.debug > 1) {
            this.log("Copy: " + source2 + " To: " + dest + " Infinite: " + infiniteCopy);
        }
        if ((sourceResource = this.resources.getResource(source2)).isDirectory()) {
            String[] entries2;
            WebResource destResource;
            if (!this.resources.mkdir(dest) && !(destResource = this.resources.getResource(dest)).isDirectory()) {
                errorList.put(dest, 409);
                return false;
            }
            if (!infiniteCopy) return true;
            String[] stringArray = entries2 = this.resources.list(source2);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                Object childDest = dest;
                if (!((String)childDest).equals("/")) {
                    childDest = (String)childDest + "/";
                }
                childDest = (String)childDest + entry;
                Object childSrc = source2;
                if (!((String)childSrc).equals("/")) {
                    childSrc = (String)childSrc + "/";
                }
                childSrc = (String)childSrc + entry;
                this.copyResource(errorList, (String)childSrc, (String)childDest, true);
                ++n2;
            }
            return true;
        }
        if (!sourceResource.isFile()) {
            errorList.put(source2, 500);
            return false;
        }
        WebResource destResource = this.resources.getResource(dest);
        if (!(destResource.exists() || destResource.getWebappPath().endsWith("/") || (lastSlash = destResource.getWebappPath().lastIndexOf(47)) <= 0 || (parentResource = this.resources.getResource(parent = destResource.getWebappPath().substring(0, lastSlash))).isDirectory())) {
            errorList.put(source2, 409);
            return false;
        }
        if (!destResource.exists() && dest.endsWith("/") && dest.length() > 1) {
            dest = dest.substring(0, dest.length() - 1);
        }
        try (InputStream is = sourceResource.getInputStream();){
            if (this.resources.write(dest, is, false)) return true;
            errorList.put(source2, 500);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            this.log(sm.getString("webdavservlet.inputstreamclosefail", source2), e);
            return true;
        }
    }

    private boolean deleteResource(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String path2 = this.getRelativePath(req);
        return this.deleteResource(path2, req, resp, true);
    }

    private boolean deleteResource(String path2, HttpServletRequest req, HttpServletResponse resp, boolean setStatus) throws IOException {
        String lockTokenHeader;
        String ifHeader = req.getHeader("If");
        if (ifHeader == null) {
            ifHeader = "";
        }
        if ((lockTokenHeader = req.getHeader("Lock-Token")) == null) {
            lockTokenHeader = "";
        }
        if (this.isLocked(path2, ifHeader + lockTokenHeader)) {
            resp.sendError(423);
            return false;
        }
        WebResource resource = this.resources.getResource(path2);
        if (!resource.exists()) {
            resp.sendError(404);
            return false;
        }
        if (!resource.isDirectory()) {
            if (!resource.delete()) {
                resp.sendError(500);
                return false;
            }
        } else {
            HashMap<String, Integer> errorList = new HashMap<String, Integer>();
            this.deleteCollection(req, path2, errorList);
            if (!resource.delete()) {
                errorList.put(path2, 500);
            }
            if (!errorList.isEmpty()) {
                this.sendReport(req, resp, errorList);
                return false;
            }
        }
        if (setStatus) {
            resp.setStatus(204);
        }
        return true;
    }

    private void deleteCollection(HttpServletRequest req, String path2, Map<String, Integer> errorList) {
        String[] entries2;
        String lockTokenHeader;
        if (this.debug > 1) {
            this.log("Delete:" + path2);
        }
        if (this.isSpecialPath(path2)) {
            errorList.put(path2, 403);
            return;
        }
        String ifHeader = req.getHeader("If");
        if (ifHeader == null) {
            ifHeader = "";
        }
        if ((lockTokenHeader = req.getHeader("Lock-Token")) == null) {
            lockTokenHeader = "";
        }
        for (String entry : entries2 = this.resources.list(path2)) {
            Object childName = path2;
            if (!((String)childName).equals("/")) {
                childName = (String)childName + "/";
            }
            if (this.isLocked((String)(childName = (String)childName + entry), ifHeader + lockTokenHeader)) {
                errorList.put((String)childName, 423);
                continue;
            }
            WebResource childResource = this.resources.getResource((String)childName);
            if (childResource.isDirectory()) {
                this.deleteCollection(req, (String)childName, errorList);
            }
            if (childResource.delete() || childResource.isDirectory()) continue;
            errorList.put((String)childName, 500);
        }
    }

    private void sendReport(HttpServletRequest req, HttpServletResponse resp, Map<String, Integer> errorList) throws IOException {
        resp.setStatus(207);
        XMLWriter generatedXML = new XMLWriter();
        generatedXML.writeXMLHeader();
        generatedXML.writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
        for (Map.Entry<String, Integer> errorEntry : errorList.entrySet()) {
            String errorPath = errorEntry.getKey();
            int errorCode = errorEntry.getValue();
            generatedXML.writeElement("D", "response", 0);
            generatedXML.writeElement("D", "href", 0);
            generatedXML.writeText(this.getServletContext().getContextPath() + errorPath);
            generatedXML.writeElement("D", "href", 1);
            generatedXML.writeElement("D", "status", 0);
            generatedXML.writeText("HTTP/1.1 " + errorCode + " ");
            generatedXML.writeElement("D", "status", 1);
            generatedXML.writeElement("D", "response", 1);
        }
        generatedXML.writeElement("D", "multistatus", 1);
        PrintWriter writer = resp.getWriter();
        ((Writer)writer).write(generatedXML.toString());
        ((Writer)writer).close();
    }

    private void parseProperties(HttpServletRequest req, XMLWriter generatedXML, String path2, int type2, List<String> properties) {
        if (this.isSpecialPath(path2)) {
            return;
        }
        WebResource resource = this.resources.getResource(path2);
        if (!resource.exists()) {
            return;
        }
        String href = req.getContextPath() + req.getServletPath();
        href = href.endsWith("/") && path2.startsWith("/") ? href + path2.substring(1) : href + path2;
        if (resource.isDirectory() && !href.endsWith("/")) {
            href = href + "/";
        }
        String rewrittenUrl = this.rewriteUrl(href);
        this.generatePropFindResponse(generatedXML, rewrittenUrl, path2, type2, properties, resource.isFile(), false, resource.getCreation(), resource.getLastModified(), resource.getContentLength(), this.getServletContext().getMimeType(resource.getName()), this.generateETag(resource));
    }

    private void parseLockNullProperties(HttpServletRequest req, XMLWriter generatedXML, String path2, int type2, List<String> properties) {
        if (this.isSpecialPath(path2)) {
            return;
        }
        LockInfo lock2 = this.resourceLocks.get(path2);
        if (lock2 == null) {
            return;
        }
        String absoluteUri = req.getRequestURI();
        String relativePath = this.getRelativePath(req);
        Object toAppend = path2.substring(relativePath.length());
        if (!((String)toAppend).startsWith("/")) {
            toAppend = "/" + (String)toAppend;
        }
        String rewrittenUrl = this.rewriteUrl(RequestUtil.normalize(absoluteUri + (String)toAppend));
        this.generatePropFindResponse(generatedXML, rewrittenUrl, path2, type2, properties, true, true, lock2.creationDate.getTime(), lock2.creationDate.getTime(), 0L, "", "");
    }

    private void generatePropFindResponse(XMLWriter generatedXML, String rewrittenUrl, String path2, int propFindType, List<String> properties, boolean isFile, boolean isLockNull, long created, long lastModified, long contentLength, String contentType, String eTag) {
        generatedXML.writeElement("D", "response", 0);
        String status2 = "HTTP/1.1 200 ";
        generatedXML.writeElement("D", "href", 0);
        generatedXML.writeText(rewrittenUrl);
        generatedXML.writeElement("D", "href", 1);
        String resourceName = path2;
        int lastSlash = path2.lastIndexOf(47);
        if (lastSlash != -1) {
            resourceName = resourceName.substring(lastSlash + 1);
        }
        switch (propFindType) {
            case 1: {
                generatedXML.writeElement("D", "propstat", 0);
                generatedXML.writeElement("D", "prop", 0);
                generatedXML.writeProperty("D", "creationdate", this.getISOCreationDate(created));
                generatedXML.writeElement("D", "displayname", 0);
                generatedXML.writeData(resourceName);
                generatedXML.writeElement("D", "displayname", 1);
                if (isFile) {
                    generatedXML.writeProperty("D", "getlastmodified", FastHttpDateFormat.formatDate(lastModified));
                    generatedXML.writeProperty("D", "getcontentlength", Long.toString(contentLength));
                    if (contentType != null) {
                        generatedXML.writeProperty("D", "getcontenttype", contentType);
                    }
                    generatedXML.writeProperty("D", "getetag", eTag);
                    if (isLockNull) {
                        generatedXML.writeElement("D", "resourcetype", 0);
                        generatedXML.writeElement("D", "lock-null", 2);
                        generatedXML.writeElement("D", "resourcetype", 1);
                    } else {
                        generatedXML.writeElement("D", "resourcetype", 2);
                    }
                } else {
                    generatedXML.writeProperty("D", "getlastmodified", FastHttpDateFormat.formatDate(lastModified));
                    generatedXML.writeElement("D", "resourcetype", 0);
                    generatedXML.writeElement("D", "collection", 2);
                    generatedXML.writeElement("D", "resourcetype", 1);
                }
                generatedXML.writeProperty("D", "source", "");
                String supportedLocks = "<D:lockentry><D:lockscope><D:exclusive/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry><D:lockentry><D:lockscope><D:shared/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry>";
                generatedXML.writeElement("D", "supportedlock", 0);
                generatedXML.writeRaw(supportedLocks);
                generatedXML.writeElement("D", "supportedlock", 1);
                this.generateLockDiscovery(path2, generatedXML);
                generatedXML.writeElement("D", "prop", 1);
                generatedXML.writeElement("D", "status", 0);
                generatedXML.writeText(status2);
                generatedXML.writeElement("D", "status", 1);
                generatedXML.writeElement("D", "propstat", 1);
                break;
            }
            case 2: {
                generatedXML.writeElement("D", "propstat", 0);
                generatedXML.writeElement("D", "prop", 0);
                generatedXML.writeElement("D", "creationdate", 2);
                generatedXML.writeElement("D", "displayname", 2);
                if (isFile) {
                    generatedXML.writeElement("D", "getcontentlanguage", 2);
                    generatedXML.writeElement("D", "getcontentlength", 2);
                    generatedXML.writeElement("D", "getcontenttype", 2);
                    generatedXML.writeElement("D", "getetag", 2);
                    generatedXML.writeElement("D", "getlastmodified", 2);
                }
                generatedXML.writeElement("D", "resourcetype", 2);
                generatedXML.writeElement("D", "source", 2);
                generatedXML.writeElement("D", "lockdiscovery", 2);
                generatedXML.writeElement("D", "prop", 1);
                generatedXML.writeElement("D", "status", 0);
                generatedXML.writeText(status2);
                generatedXML.writeElement("D", "status", 1);
                generatedXML.writeElement("D", "propstat", 1);
                break;
            }
            case 0: {
                ArrayList<String> propertiesNotFound = new ArrayList<String>();
                generatedXML.writeElement("D", "propstat", 0);
                generatedXML.writeElement("D", "prop", 0);
                for (String property : properties) {
                    if (property.equals("creationdate")) {
                        generatedXML.writeProperty("D", "creationdate", this.getISOCreationDate(created));
                        continue;
                    }
                    if (property.equals("displayname")) {
                        generatedXML.writeElement("D", "displayname", 0);
                        generatedXML.writeData(resourceName);
                        generatedXML.writeElement("D", "displayname", 1);
                        continue;
                    }
                    if (property.equals("getcontentlanguage")) {
                        if (isFile) {
                            generatedXML.writeElement("D", "getcontentlanguage", 2);
                            continue;
                        }
                        propertiesNotFound.add(property);
                        continue;
                    }
                    if (property.equals("getcontentlength")) {
                        if (isFile) {
                            generatedXML.writeProperty("D", "getcontentlength", Long.toString(contentLength));
                            continue;
                        }
                        propertiesNotFound.add(property);
                        continue;
                    }
                    if (property.equals("getcontenttype")) {
                        if (isFile) {
                            generatedXML.writeProperty("D", "getcontenttype", contentType);
                            continue;
                        }
                        propertiesNotFound.add(property);
                        continue;
                    }
                    if (property.equals("getetag")) {
                        if (isFile) {
                            generatedXML.writeProperty("D", "getetag", eTag);
                            continue;
                        }
                        propertiesNotFound.add(property);
                        continue;
                    }
                    if (property.equals("getlastmodified")) {
                        if (isFile) {
                            generatedXML.writeProperty("D", "getlastmodified", FastHttpDateFormat.formatDate(lastModified));
                            continue;
                        }
                        propertiesNotFound.add(property);
                        continue;
                    }
                    if (property.equals("resourcetype")) {
                        if (isFile) {
                            if (isLockNull) {
                                generatedXML.writeElement("D", "resourcetype", 0);
                                generatedXML.writeElement("D", "lock-null", 2);
                                generatedXML.writeElement("D", "resourcetype", 1);
                                continue;
                            }
                            generatedXML.writeElement("D", "resourcetype", 2);
                            continue;
                        }
                        generatedXML.writeElement("D", "resourcetype", 0);
                        generatedXML.writeElement("D", "collection", 2);
                        generatedXML.writeElement("D", "resourcetype", 1);
                        continue;
                    }
                    if (property.equals("source")) {
                        generatedXML.writeProperty("D", "source", "");
                        continue;
                    }
                    if (property.equals("supportedlock")) {
                        String supportedLocks = "<D:lockentry><D:lockscope><D:exclusive/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry><D:lockentry><D:lockscope><D:shared/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry>";
                        generatedXML.writeElement("D", "supportedlock", 0);
                        generatedXML.writeRaw(supportedLocks);
                        generatedXML.writeElement("D", "supportedlock", 1);
                        continue;
                    }
                    if (property.equals("lockdiscovery")) {
                        if (this.generateLockDiscovery(path2, generatedXML)) continue;
                        propertiesNotFound.add(property);
                        continue;
                    }
                    propertiesNotFound.add(property);
                }
                generatedXML.writeElement("D", "prop", 1);
                generatedXML.writeElement("D", "status", 0);
                generatedXML.writeText(status2);
                generatedXML.writeElement("D", "status", 1);
                generatedXML.writeElement("D", "propstat", 1);
                if (propertiesNotFound.isEmpty()) break;
                status2 = "HTTP/1.1 404 ";
                generatedXML.writeElement("D", "propstat", 0);
                generatedXML.writeElement("D", "prop", 0);
                for (String propertyNotFound : propertiesNotFound) {
                    generatedXML.writeElement("D", propertyNotFound, 2);
                }
                generatedXML.writeElement("D", "prop", 1);
                generatedXML.writeElement("D", "status", 0);
                generatedXML.writeText(status2);
                generatedXML.writeElement("D", "status", 1);
                generatedXML.writeElement("D", "propstat", 1);
            }
        }
        generatedXML.writeElement("D", "response", 1);
    }

    private boolean generateLockDiscovery(String path2, XMLWriter generatedXML) {
        LockInfo resourceLock = this.resourceLocks.get(path2);
        boolean wroteStart = false;
        if (resourceLock != null) {
            wroteStart = true;
            generatedXML.writeElement("D", "lockdiscovery", 0);
            resourceLock.toXML(generatedXML);
        }
        for (LockInfo currentLock : this.collectionLocks) {
            if (!path2.startsWith(currentLock.path)) continue;
            if (!wroteStart) {
                wroteStart = true;
                generatedXML.writeElement("D", "lockdiscovery", 0);
            }
            currentLock.toXML(generatedXML);
        }
        if (!wroteStart) {
            return false;
        }
        generatedXML.writeElement("D", "lockdiscovery", 1);
        return true;
    }

    private String getISOCreationDate(long creationDate) {
        return creationDateFormat.format(new Date(creationDate));
    }

    @Override
    protected String determineMethodsAllowed(HttpServletRequest req) {
        WebResource resource = this.resources.getResource(this.getRelativePath(req));
        StringBuilder methodsAllowed = new StringBuilder("OPTIONS, GET, POST, HEAD");
        if (!this.readOnly) {
            methodsAllowed.append(", DELETE");
            if (!resource.isDirectory()) {
                methodsAllowed.append(", PUT");
            }
        }
        if (req instanceof RequestFacade && ((RequestFacade)req).getAllowTrace()) {
            methodsAllowed.append(", TRACE");
        }
        methodsAllowed.append(", LOCK, UNLOCK, PROPPATCH, COPY, MOVE");
        if (this.listings) {
            methodsAllowed.append(", PROPFIND");
        }
        if (!resource.exists()) {
            methodsAllowed.append(", MKCOL");
        }
        return methodsAllowed.toString();
    }

    private void removeLockNull(String path2) {
        String parentPath;
        List<String> paths;
        int slash = path2.lastIndexOf(47);
        if (slash >= 0 && (paths = this.lockNullResources.get(parentPath = path2.substring(0, slash))) != null) {
            paths.remove(path2);
            if (paths.isEmpty()) {
                this.lockNullResources.remove(parentPath);
            }
        }
    }

    private static class LockInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int maxDepth;
        String path = "/";
        String type = "write";
        String scope = "exclusive";
        int depth = 0;
        String owner = "";
        List<String> tokens = Collections.synchronizedList(new ArrayList());
        long expiresAt = 0L;
        Date creationDate = new Date();

        LockInfo(int maxDepth) {
            this.maxDepth = maxDepth;
        }

        public String toString() {
            StringBuilder result2 = new StringBuilder("Type:");
            result2.append(this.type);
            result2.append("\nScope:");
            result2.append(this.scope);
            result2.append("\nDepth:");
            result2.append(this.depth);
            result2.append("\nOwner:");
            result2.append(this.owner);
            result2.append("\nExpiration:");
            result2.append(FastHttpDateFormat.formatDate(this.expiresAt));
            for (String token2 : this.tokens) {
                result2.append("\nToken:");
                result2.append(token2);
            }
            result2.append("\n");
            return result2.toString();
        }

        public boolean hasExpired() {
            return System.currentTimeMillis() > this.expiresAt;
        }

        public boolean isExclusive() {
            return this.scope.equals("exclusive");
        }

        public void toXML(XMLWriter generatedXML) {
            generatedXML.writeElement("D", "activelock", 0);
            generatedXML.writeElement("D", "locktype", 0);
            generatedXML.writeElement("D", this.type, 2);
            generatedXML.writeElement("D", "locktype", 1);
            generatedXML.writeElement("D", "lockscope", 0);
            generatedXML.writeElement("D", this.scope, 2);
            generatedXML.writeElement("D", "lockscope", 1);
            generatedXML.writeElement("D", "depth", 0);
            if (this.depth == this.maxDepth) {
                generatedXML.writeText("Infinity");
            } else {
                generatedXML.writeText("0");
            }
            generatedXML.writeElement("D", "depth", 1);
            generatedXML.writeElement("D", "owner", 0);
            generatedXML.writeText(this.owner);
            generatedXML.writeElement("D", "owner", 1);
            generatedXML.writeElement("D", "timeout", 0);
            long timeout2 = (this.expiresAt - System.currentTimeMillis()) / 1000L;
            generatedXML.writeText("Second-" + timeout2);
            generatedXML.writeElement("D", "timeout", 1);
            generatedXML.writeElement("D", "locktoken", 0);
            for (String token2 : this.tokens) {
                generatedXML.writeElement("D", "href", 0);
                generatedXML.writeText("opaquelocktoken:" + token2);
                generatedXML.writeElement("D", "href", 1);
            }
            generatedXML.writeElement("D", "locktoken", 1);
            generatedXML.writeElement("D", "activelock", 1);
        }
    }

    private static class WebdavResolver
    implements EntityResolver {
        private ServletContext context;

        WebdavResolver(ServletContext theContext) {
            this.context = theContext;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            this.context.log(DefaultServlet.sm.getString("webdavservlet.externalEntityIgnored", publicId, systemId));
            return new InputSource(new StringReader("Ignored external entity"));
        }
    }
}

