/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import javax.management.MBeanException;
import org.apache.catalina.Executor;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.mbeans.BaseCatalinaMBean;

public class ServiceMBean
extends BaseCatalinaMBean<Service> {
    public void addConnector(String address2, int port, boolean isAjp, boolean isSSL) throws MBeanException {
        Service service = (Service)this.doGetManagedResource();
        String protocol2 = isAjp ? "AJP/1.3" : "HTTP/1.1";
        Connector connector = new Connector(protocol2);
        if (address2 != null && address2.length() > 0) {
            connector.setProperty("address", address2);
        }
        connector.setPort(port);
        connector.setSecure(isSSL);
        connector.setScheme(isSSL ? "https" : "http");
        service.addConnector(connector);
    }

    public void addExecutor(String type2) throws MBeanException {
        Service service = (Service)this.doGetManagedResource();
        Executor executor = (Executor)ServiceMBean.newInstance(type2);
        service.addExecutor(executor);
    }

    public String[] findConnectors() throws MBeanException {
        Service service = (Service)this.doGetManagedResource();
        Connector[] connectors = service.findConnectors();
        String[] str = new String[connectors.length];
        for (int i2 = 0; i2 < connectors.length; ++i2) {
            str[i2] = connectors[i2].toString();
        }
        return str;
    }

    public String[] findExecutors() throws MBeanException {
        Service service = (Service)this.doGetManagedResource();
        Executor[] executors = service.findExecutors();
        String[] str = new String[executors.length];
        for (int i2 = 0; i2 < executors.length; ++i2) {
            str[i2] = executors[i2].toString();
        }
        return str;
    }

    public String getExecutor(String name2) throws MBeanException {
        Service service = (Service)this.doGetManagedResource();
        Executor executor = service.getExecutor(name2);
        if (executor != null) {
            return executor.toString();
        }
        return null;
    }
}

