/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.util.Iterator;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import org.apache.catalina.Group;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Role;
import org.apache.catalina.Server;
import org.apache.catalina.User;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class GlobalResourcesLifecycleListener
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(GlobalResourcesLifecycleListener.class);
    protected static final StringManager sm = StringManager.getManager(GlobalResourcesLifecycleListener.class);
    protected Lifecycle component = null;

    @Override
    public void lifecycleEvent(LifecycleEvent event2) {
        if ("start".equals(event2.getType())) {
            if (!(event2.getLifecycle() instanceof Server)) {
                log.warn(sm.getString("listener.notServer", event2.getLifecycle().getClass().getSimpleName()));
            }
            this.component = event2.getLifecycle();
            this.createMBeans();
        } else if ("stop".equals(event2.getType())) {
            this.destroyMBeans();
            this.component = null;
        }
    }

    protected void createMBeans() {
        Context context = null;
        try {
            context = (Context)new InitialContext().lookup("java:/");
        }
        catch (NamingException e) {
            log.error(sm.getString("globalResources.noNamingContext"));
            return;
        }
        try {
            this.createMBeans("", context);
        }
        catch (NamingException e) {
            log.error(sm.getString("globalResources.createError"), e);
        }
    }

    protected void createMBeans(String prefix, Context context) throws NamingException {
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("globalResources.create", prefix));
        }
        try {
            NamingEnumeration<Binding> bindings = context.listBindings("");
            while (bindings.hasMore()) {
                Binding binding2 = bindings.next();
                String name2 = prefix + binding2.getName();
                Object value2 = context.lookup(binding2.getName());
                if (log.isTraceEnabled()) {
                    log.trace("Checking resource " + name2);
                }
                if (value2 instanceof Context) {
                    this.createMBeans(name2 + "/", (Context)value2);
                    continue;
                }
                if (!(value2 instanceof UserDatabase)) continue;
                try {
                    this.createMBeans(name2, (UserDatabase)value2);
                }
                catch (Exception e) {
                    log.error(sm.getString("globalResources.userDatabaseCreateError", name2), e);
                }
            }
        }
        catch (RuntimeException ex) {
            log.error(sm.getString("globalResources.createError.runtime"), ex);
        }
        catch (OperationNotSupportedException ex) {
            log.error(sm.getString("globalResources.createError.operation"), ex);
        }
    }

    protected void createMBeans(String name2, UserDatabase database) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("Creating UserDatabase MBeans for resource " + name2);
            log.trace("Database=" + String.valueOf(database));
        }
        try {
            MBeanUtils.createMBean(database);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(sm.getString("globalResources.createError.userDatabase", name2), e);
        }
        if (database.isSparse()) {
            return;
        }
        Iterator<Role> roles = database.getRoles();
        while (roles.hasNext()) {
            Role role = roles.next();
            if (log.isTraceEnabled()) {
                log.trace("  Creating Role MBean for role " + String.valueOf(role));
            }
            try {
                MBeanUtils.createMBean(role);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(sm.getString("globalResources.createError.userDatabase.role", role), e);
            }
        }
        Iterator<Group> groups2 = database.getGroups();
        while (groups2.hasNext()) {
            Group group2 = groups2.next();
            if (log.isTraceEnabled()) {
                log.trace("  Creating Group MBean for group " + String.valueOf(group2));
            }
            try {
                MBeanUtils.createMBean(group2);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(sm.getString("globalResources.createError.userDatabase.group", group2), e);
            }
        }
        Iterator<User> users = database.getUsers();
        while (users.hasNext()) {
            User user = users.next();
            if (log.isTraceEnabled()) {
                log.trace("  Creating User MBean for user " + String.valueOf(user));
            }
            try {
                MBeanUtils.createMBean(user);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(sm.getString("globalResources.createError.userDatabase.user", user), e);
            }
        }
    }

    protected void destroyMBeans() {
        if (log.isTraceEnabled()) {
            log.trace("Destroying MBeans for Global JNDI Resources");
        }
    }
}

