/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mapper;

import jakarta.servlet.http.MappingMatch;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.Wrapper;
import org.apache.catalina.mapper.MappingData;
import org.apache.catalina.mapper.WrapperMappingInfo;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.Ascii;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.res.StringManager;

public final class Mapper {
    private static final Log log = LogFactory.getLog(Mapper.class);
    private static final StringManager sm = StringManager.getManager(Mapper.class);
    volatile MappedHost[] hosts = new MappedHost[0];
    private volatile String defaultHostName = null;
    private volatile MappedHost defaultHost = null;
    private final Map<Context, ContextVersion> contextObjectToContextVersionMap = new ConcurrentHashMap<Context, ContextVersion>();

    public synchronized void setDefaultHostName(String defaultHostName) {
        this.defaultHostName = Mapper.renameWildcardHost(defaultHostName);
        this.defaultHost = this.defaultHostName == null ? null : (MappedHost)Mapper.exactFind((MapElement[])this.hosts, (String)this.defaultHostName);
    }

    public synchronized void addHost(String name2, String[] aliases2, Host host) {
        MappedHost[] newHosts = new MappedHost[this.hosts.length + 1];
        MappedHost newHost = new MappedHost(name2 = Mapper.renameWildcardHost(name2), host);
        if (Mapper.insertMap(this.hosts, newHosts, newHost)) {
            this.hosts = newHosts;
            if (newHost.name.equals(this.defaultHostName)) {
                this.defaultHost = newHost;
            }
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("mapper.addHost.success", name2));
            }
        } else {
            MappedHost duplicate = this.hosts[Mapper.find(this.hosts, name2)];
            if (duplicate.object == host) {
                if (log.isDebugEnabled()) {
                    log.debug(sm.getString("mapper.addHost.sameHost", name2));
                }
                newHost = duplicate;
            } else {
                log.error(sm.getString("mapper.duplicateHost", name2, duplicate.getRealHostName()));
                return;
            }
        }
        ArrayList<MappedHost> newAliases = new ArrayList<MappedHost>(aliases2.length);
        for (String alias : aliases2) {
            MappedHost newAlias = new MappedHost(alias = Mapper.renameWildcardHost(alias), newHost);
            if (!this.addHostAliasImpl(newAlias)) continue;
            newAliases.add(newAlias);
        }
        newHost.addAliases(newAliases);
    }

    public synchronized void removeHost(String name2) {
        MappedHost host = (MappedHost)Mapper.exactFind((MapElement[])this.hosts, (String)(name2 = Mapper.renameWildcardHost(name2)));
        if (host == null || host.isAlias()) {
            return;
        }
        MappedHost[] newHosts = (MappedHost[])this.hosts.clone();
        int j = 0;
        for (int i2 = 0; i2 < newHosts.length; ++i2) {
            if (newHosts[i2].getRealHost() == host) continue;
            newHosts[j++] = newHosts[i2];
        }
        this.hosts = Arrays.copyOf(newHosts, j);
    }

    public synchronized void addHostAlias(String name2, String alias) {
        MappedHost realHost = (MappedHost)Mapper.exactFind((MapElement[])this.hosts, (String)name2);
        if (realHost == null) {
            return;
        }
        MappedHost newAlias = new MappedHost(alias = Mapper.renameWildcardHost(alias), realHost);
        if (this.addHostAliasImpl(newAlias)) {
            realHost.addAlias(newAlias);
        }
    }

    private synchronized boolean addHostAliasImpl(MappedHost newAlias) {
        MappedHost[] newHosts = new MappedHost[this.hosts.length + 1];
        if (Mapper.insertMap(this.hosts, newHosts, newAlias)) {
            this.hosts = newHosts;
            if (newAlias.name.equals(this.defaultHostName)) {
                this.defaultHost = newAlias;
            }
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("mapper.addHostAlias.success", newAlias.name, newAlias.getRealHostName()));
            }
            return true;
        }
        MappedHost duplicate = this.hosts[Mapper.find(this.hosts, newAlias.name)];
        if (duplicate.getRealHost() == newAlias.getRealHost()) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("mapper.addHostAlias.sameHost", newAlias.name, newAlias.getRealHostName()));
            }
            return false;
        }
        log.error(sm.getString("mapper.duplicateHostAlias", newAlias.name, newAlias.getRealHostName(), duplicate.getRealHostName()));
        return false;
    }

    public synchronized void removeHostAlias(String alias) {
        MappedHost hostMapping = (MappedHost)Mapper.exactFind((MapElement[])this.hosts, (String)(alias = Mapper.renameWildcardHost(alias)));
        if (hostMapping == null || !hostMapping.isAlias()) {
            return;
        }
        MappedHost[] newHosts = new MappedHost[this.hosts.length - 1];
        if (Mapper.removeMap(this.hosts, newHosts, alias)) {
            this.hosts = newHosts;
            hostMapping.getRealHost().removeAlias(hostMapping);
        }
    }

    private void updateContextList(MappedHost realHost, ContextList newContextList) {
        realHost.contextList = newContextList;
        for (MappedHost alias : realHost.getAliases()) {
            alias.contextList = newContextList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContextVersion(String hostName, Host host, String path2, String version, Context context, String[] welcomeResources, WebResourceRoot resources, Collection<WrapperMappingInfo> wrappers) {
        MappedHost mappedHost = (MappedHost)Mapper.exactFind((MapElement[])this.hosts, (String)(hostName = Mapper.renameWildcardHost(hostName)));
        if (mappedHost == null) {
            this.addHost(hostName, new String[0], host);
            mappedHost = (MappedHost)Mapper.exactFind((MapElement[])this.hosts, (String)hostName);
            if (mappedHost == null) {
                log.error(sm.getString("mapper.addContext.noHost", hostName));
                return;
            }
        }
        if (mappedHost.isAlias()) {
            log.error(sm.getString("mapper.addContext.hostIsAlias", hostName));
            return;
        }
        int slashCount = Mapper.slashCount(path2);
        MappedHost mappedHost2 = mappedHost;
        synchronized (mappedHost2) {
            ContextVersion newContextVersion = new ContextVersion(version, path2, slashCount, context, resources, welcomeResources);
            if (wrappers != null) {
                this.addWrappers(newContextVersion, wrappers);
            }
            ContextList contextList = mappedHost.contextList;
            MappedContext mappedContext = (MappedContext)Mapper.exactFind((MapElement[])contextList.contexts, (String)path2);
            if (mappedContext == null) {
                mappedContext = new MappedContext(path2, newContextVersion);
                ContextList newContextList = contextList.addContext(mappedContext, slashCount);
                if (newContextList != null) {
                    this.updateContextList(mappedHost, newContextList);
                    this.contextObjectToContextVersionMap.put(context, newContextVersion);
                }
            } else {
                ContextVersion[] contextVersions = mappedContext.versions;
                ContextVersion[] newContextVersions = new ContextVersion[contextVersions.length + 1];
                if (Mapper.insertMap(contextVersions, newContextVersions, newContextVersion)) {
                    mappedContext.versions = newContextVersions;
                    this.contextObjectToContextVersionMap.put(context, newContextVersion);
                } else {
                    int pos2 = Mapper.find(contextVersions, version);
                    if (pos2 >= 0 && contextVersions[pos2].name.equals(version)) {
                        contextVersions[pos2] = newContextVersion;
                        this.contextObjectToContextVersionMap.put(context, newContextVersion);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContextVersion(Context ctxt, String hostName, String path2, String version) {
        hostName = Mapper.renameWildcardHost(hostName);
        this.contextObjectToContextVersionMap.remove(ctxt);
        MappedHost host = (MappedHost)Mapper.exactFind((MapElement[])this.hosts, (String)hostName);
        if (host == null || host.isAlias()) {
            return;
        }
        MappedHost mappedHost = host;
        synchronized (mappedHost) {
            ContextList contextList = host.contextList;
            MappedContext context = (MappedContext)Mapper.exactFind((MapElement[])contextList.contexts, (String)path2);
            if (context == null) {
                return;
            }
            ContextVersion[] contextVersions = context.versions;
            ContextVersion[] newContextVersions = new ContextVersion[contextVersions.length - 1];
            if (Mapper.removeMap(contextVersions, newContextVersions, version)) {
                if (newContextVersions.length == 0) {
                    ContextList newContextList = contextList.removeContext(path2);
                    if (newContextList != null) {
                        this.updateContextList(host, newContextList);
                    }
                } else {
                    context.versions = newContextVersions;
                }
            }
        }
    }

    public void pauseContextVersion(Context ctxt, String hostName, String contextPath, String version) {
        ContextVersion contextVersion = this.findContextVersion(hostName = Mapper.renameWildcardHost(hostName), contextPath, version, true);
        if (contextVersion == null || !ctxt.equals(contextVersion.object)) {
            return;
        }
        contextVersion.markPaused();
    }

    private ContextVersion findContextVersion(String hostName, String contextPath, String version, boolean silent) {
        MappedHost host = (MappedHost)Mapper.exactFind((MapElement[])this.hosts, (String)hostName);
        if (host == null || host.isAlias()) {
            if (!silent) {
                log.error(sm.getString("mapper.findContext.noHostOrAlias", hostName));
            }
            return null;
        }
        MappedContext context = (MappedContext)Mapper.exactFind((MapElement[])host.contextList.contexts, (String)contextPath);
        if (context == null) {
            if (!silent) {
                log.error(sm.getString("mapper.findContext.noContext", contextPath));
            }
            return null;
        }
        ContextVersion contextVersion = (ContextVersion)Mapper.exactFind((MapElement[])context.versions, (String)version);
        if (contextVersion == null) {
            if (!silent) {
                log.error(sm.getString("mapper.findContext.noContextVersion", contextPath, version));
            }
            return null;
        }
        return contextVersion;
    }

    public void addWrapper(String hostName, String contextPath, String version, String path2, Wrapper wrapper, boolean jspWildCard, boolean resourceOnly) {
        ContextVersion contextVersion = this.findContextVersion(hostName = Mapper.renameWildcardHost(hostName), contextPath, version, false);
        if (contextVersion == null) {
            return;
        }
        this.addWrapper(contextVersion, path2, wrapper, jspWildCard, resourceOnly);
    }

    public void addWrappers(String hostName, String contextPath, String version, Collection<WrapperMappingInfo> wrappers) {
        ContextVersion contextVersion = this.findContextVersion(hostName = Mapper.renameWildcardHost(hostName), contextPath, version, false);
        if (contextVersion == null) {
            return;
        }
        this.addWrappers(contextVersion, wrappers);
    }

    private void addWrappers(ContextVersion contextVersion, Collection<WrapperMappingInfo> wrappers) {
        for (WrapperMappingInfo wrapper : wrappers) {
            this.addWrapper(contextVersion, wrapper.getMapping(), wrapper.getWrapper(), wrapper.isJspWildCard(), wrapper.isResourceOnly());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addWrapper(ContextVersion context, String path2, Wrapper wrapper, boolean jspWildCard, boolean resourceOnly) {
        ContextVersion contextVersion = context;
        synchronized (contextVersion) {
            if (path2.endsWith("/*")) {
                MappedWrapper[] oldWrappers = context.wildcardWrappers;
                MappedWrapper[] newWrappers = new MappedWrapper[oldWrappers.length + 1];
                String name2 = path2.substring(0, path2.length() - 2);
                MappedWrapper newWrapper = new MappedWrapper(name2, wrapper, jspWildCard, resourceOnly);
                if (Mapper.insertMap(oldWrappers, newWrappers, newWrapper)) {
                    context.wildcardWrappers = newWrappers;
                    int slashCount = Mapper.slashCount(newWrapper.name);
                    if (slashCount > context.nesting) {
                        context.nesting = slashCount;
                    }
                }
            } else if (path2.startsWith("*.")) {
                MappedWrapper[] oldWrappers = context.extensionWrappers;
                MappedWrapper[] newWrappers = new MappedWrapper[oldWrappers.length + 1];
                String name3 = path2.substring(2);
                MappedWrapper newWrapper = new MappedWrapper(name3, wrapper, jspWildCard, resourceOnly);
                if (Mapper.insertMap(oldWrappers, newWrappers, newWrapper)) {
                    context.extensionWrappers = newWrappers;
                }
            } else if (path2.equals("/")) {
                MappedWrapper newWrapper;
                context.defaultWrapper = newWrapper = new MappedWrapper("", wrapper, jspWildCard, resourceOnly);
            } else {
                MappedWrapper[] oldWrappers = context.exactWrappers;
                MappedWrapper[] newWrappers = new MappedWrapper[oldWrappers.length + 1];
                String name4 = path2.length() == 0 ? "/" : path2;
                MappedWrapper newWrapper = new MappedWrapper(name4, wrapper, jspWildCard, resourceOnly);
                if (Mapper.insertMap(oldWrappers, newWrappers, newWrapper)) {
                    context.exactWrappers = newWrappers;
                }
            }
        }
    }

    public void removeWrapper(String hostName, String contextPath, String version, String path2) {
        ContextVersion contextVersion = this.findContextVersion(hostName = Mapper.renameWildcardHost(hostName), contextPath, version, true);
        if (contextVersion == null || contextVersion.isPaused()) {
            return;
        }
        this.removeWrapper(contextVersion, path2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeWrapper(ContextVersion context, String path2) {
        if (log.isTraceEnabled()) {
            log.trace(sm.getString("mapper.removeWrapper", context.name, path2));
        }
        ContextVersion contextVersion = context;
        synchronized (contextVersion) {
            if (path2.endsWith("/*")) {
                String name2 = path2.substring(0, path2.length() - 2);
                MappedWrapper[] oldWrappers = context.wildcardWrappers;
                if (oldWrappers.length == 0) {
                    return;
                }
                MappedWrapper[] newWrappers = new MappedWrapper[oldWrappers.length - 1];
                if (Mapper.removeMap(oldWrappers, newWrappers, name2)) {
                    context.nesting = 0;
                    for (MappedWrapper newWrapper : newWrappers) {
                        int slashCount = Mapper.slashCount(newWrapper.name);
                        if (slashCount <= context.nesting) continue;
                        context.nesting = slashCount;
                    }
                    context.wildcardWrappers = newWrappers;
                }
            } else if (path2.startsWith("*.")) {
                String name3 = path2.substring(2);
                MappedWrapper[] oldWrappers = context.extensionWrappers;
                if (oldWrappers.length == 0) {
                    return;
                }
                MappedWrapper[] newWrappers = new MappedWrapper[oldWrappers.length - 1];
                if (Mapper.removeMap(oldWrappers, newWrappers, name3)) {
                    context.extensionWrappers = newWrappers;
                }
            } else if (path2.equals("/")) {
                context.defaultWrapper = null;
            } else {
                String name4 = path2.length() == 0 ? "/" : path2;
                MappedWrapper[] oldWrappers = context.exactWrappers;
                if (oldWrappers.length == 0) {
                    return;
                }
                MappedWrapper[] newWrappers = new MappedWrapper[oldWrappers.length - 1];
                if (Mapper.removeMap(oldWrappers, newWrappers, name4)) {
                    context.exactWrappers = newWrappers;
                }
            }
        }
    }

    public void addWelcomeFile(String hostName, String contextPath, String version, String welcomeFile) {
        ContextVersion contextVersion = this.findContextVersion(hostName = Mapper.renameWildcardHost(hostName), contextPath, version, false);
        if (contextVersion == null) {
            return;
        }
        int len = contextVersion.welcomeResources.length + 1;
        String[] newWelcomeResources = new String[len];
        System.arraycopy(contextVersion.welcomeResources, 0, newWelcomeResources, 0, len - 1);
        newWelcomeResources[len - 1] = welcomeFile;
        contextVersion.welcomeResources = newWelcomeResources;
    }

    public void removeWelcomeFile(String hostName, String contextPath, String version, String welcomeFile) {
        ContextVersion contextVersion = this.findContextVersion(hostName = Mapper.renameWildcardHost(hostName), contextPath, version, false);
        if (contextVersion == null || contextVersion.isPaused()) {
            return;
        }
        int match2 = -1;
        for (int i2 = 0; i2 < contextVersion.welcomeResources.length; ++i2) {
            if (!welcomeFile.equals(contextVersion.welcomeResources[i2])) continue;
            match2 = i2;
            break;
        }
        if (match2 > -1) {
            int len = contextVersion.welcomeResources.length - 1;
            String[] newWelcomeResources = new String[len];
            System.arraycopy(contextVersion.welcomeResources, 0, newWelcomeResources, 0, match2);
            if (match2 < len) {
                System.arraycopy(contextVersion.welcomeResources, match2 + 1, newWelcomeResources, match2, len - match2);
            }
            contextVersion.welcomeResources = newWelcomeResources;
        }
    }

    public void clearWelcomeFiles(String hostName, String contextPath, String version) {
        ContextVersion contextVersion = this.findContextVersion(hostName = Mapper.renameWildcardHost(hostName), contextPath, version, false);
        if (contextVersion == null) {
            return;
        }
        contextVersion.welcomeResources = new String[0];
    }

    public void map(MessageBytes host, MessageBytes uri, String version, MappingData mappingData) throws IOException {
        if (host.isNull()) {
            String defaultHostName = this.defaultHostName;
            if (defaultHostName == null) {
                return;
            }
            host.setChars(MessageBytes.EMPTY_CHAR_ARRAY, 0, 0);
            host.getCharChunk().append(defaultHostName);
        }
        host.toChars();
        uri.toChars();
        this.internalMap(host.getCharChunk(), uri.getCharChunk(), version, mappingData);
    }

    public void map(Context context, MessageBytes uri, MappingData mappingData) throws IOException {
        ContextVersion contextVersion = this.contextObjectToContextVersionMap.get(context);
        uri.toChars();
        CharChunk uricc = uri.getCharChunk();
        uricc.setLimit(-1);
        this.internalMapWrapper(contextVersion, uricc, mappingData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalMap(CharChunk host, CharChunk uri, String version, MappingData mappingData) throws IOException {
        if (mappingData.host != null) {
            throw new AssertionError();
        }
        MapElement[] hosts = this.hosts;
        MappedHost mappedHost = (MappedHost)Mapper.exactFindIgnoreCase((MapElement[])hosts, (CharChunk)host);
        if (mappedHost == null) {
            int firstDot = host.indexOf('.');
            if (firstDot > -1) {
                int start2 = host.getStart();
                try {
                    host.setStart(firstDot + start2);
                    mappedHost = (MappedHost)Mapper.exactFindIgnoreCase((MapElement[])hosts, (CharChunk)host);
                }
                finally {
                    host.setStart(start2);
                }
            }
            if (mappedHost == null && (mappedHost = this.defaultHost) == null) {
                return;
            }
        }
        mappingData.host = (Host)mappedHost.object;
        if (uri.isNull()) {
            return;
        }
        uri.setLimit(-1);
        ContextList contextList = mappedHost.contextList;
        MappedContext[] contexts = contextList.contexts;
        int pos2 = Mapper.find(contexts, uri);
        if (pos2 == -1) {
            return;
        }
        int lastSlash = -1;
        int uriEnd = uri.getEnd();
        int length2 = -1;
        boolean found = false;
        MappedContext context = null;
        while (pos2 >= 0) {
            context = contexts[pos2];
            if (uri.startsWith(context.name)) {
                length2 = context.name.length();
                if (uri.getLength() == length2) {
                    found = true;
                    break;
                }
                if (uri.startsWithIgnoreCase("/", length2)) {
                    found = true;
                    break;
                }
            }
            lastSlash = lastSlash == -1 ? Mapper.nthSlash(uri, contextList.nesting + 1) : Mapper.lastSlash(uri);
            uri.setEnd(lastSlash);
            pos2 = Mapper.find(contexts, uri);
        }
        uri.setEnd(uriEnd);
        if (!found) {
            context = contexts[0].name.equals("") ? contexts[0] : null;
        }
        if (context == null) {
            return;
        }
        ContextVersion contextVersion = null;
        MapElement[] contextVersions = context.versions;
        int versionCount = contextVersions.length;
        if (versionCount > 1) {
            Context[] contextObjects = new Context[contextVersions.length];
            for (int i2 = 0; i2 < contextObjects.length; ++i2) {
                contextObjects[i2] = (Context)contextVersions[i2].object;
            }
            mappingData.contexts = contextObjects;
            if (version != null) {
                contextVersion = (ContextVersion)Mapper.exactFind((MapElement[])contextVersions, (String)version);
            }
        }
        if (contextVersion == null) {
            contextVersion = contextVersions[versionCount - 1];
        }
        mappingData.context = (Context)contextVersion.object;
        mappingData.contextSlashCount = contextVersion.slashCount;
        if (!contextVersion.isPaused()) {
            this.internalMapWrapper(contextVersion, uri, mappingData);
        }
    }

    private void internalMapWrapper(ContextVersion contextVersion, CharChunk path2, MappingData mappingData) throws IOException {
        char[] buf;
        boolean checkWelcomeFiles;
        int pathStart = path2.getStart();
        int pathEnd = path2.getEnd();
        boolean noServletPath = false;
        int length2 = contextVersion.path.length();
        if (length2 == pathEnd - pathStart) {
            noServletPath = true;
        }
        int servletPath = pathStart + length2;
        path2.setStart(servletPath);
        MappedWrapper[] exactWrappers = contextVersion.exactWrappers;
        this.internalMapExactWrapper(exactWrappers, path2, mappingData);
        boolean checkJspWelcomeFiles = false;
        MappedWrapper[] wildcardWrappers = contextVersion.wildcardWrappers;
        if (mappingData.wrapper == null) {
            this.internalMapWildcardWrapper(wildcardWrappers, contextVersion.nesting, path2, mappingData);
            if (mappingData.wrapper != null && mappingData.jspWildCard) {
                char[] buf2 = path2.getBuffer();
                if (buf2[pathEnd - 1] == '/') {
                    mappingData.wrapper = null;
                    checkJspWelcomeFiles = true;
                } else {
                    mappingData.wrapperPath.setChars(buf2, path2.getStart(), path2.getLength());
                    mappingData.pathInfo.recycle();
                }
            }
        }
        if (mappingData.wrapper == null && noServletPath && ((Context)contextVersion.object).getMapperContextRootRedirectEnabled()) {
            path2.append('/');
            pathEnd = path2.getEnd();
            mappingData.redirectPath.setChars(path2.getBuffer(), pathStart, pathEnd - pathStart);
            path2.setEnd(pathEnd - 1);
            return;
        }
        MappedWrapper[] extensionWrappers = contextVersion.extensionWrappers;
        if (mappingData.wrapper == null && !checkJspWelcomeFiles) {
            this.internalMapExtensionWrapper(extensionWrappers, path2, mappingData, true);
        }
        if (mappingData.wrapper == null) {
            checkWelcomeFiles = checkJspWelcomeFiles;
            if (!checkWelcomeFiles) {
                buf = path2.getBuffer();
                boolean bl = checkWelcomeFiles = buf[pathEnd - 1] == '/';
            }
            if (checkWelcomeFiles) {
                for (int i2 = 0; i2 < contextVersion.welcomeResources.length && mappingData.wrapper == null; ++i2) {
                    String pathStr;
                    WebResource file2;
                    path2.setStart(pathStart);
                    path2.setEnd(pathEnd);
                    path2.append(contextVersion.welcomeResources[i2], 0, contextVersion.welcomeResources[i2].length());
                    path2.setStart(servletPath);
                    this.internalMapExactWrapper(exactWrappers, path2, mappingData);
                    if (mappingData.wrapper == null) {
                        this.internalMapWildcardWrapper(wildcardWrappers, contextVersion.nesting, path2, mappingData);
                    }
                    if (mappingData.wrapper != null || contextVersion.resources == null || (file2 = contextVersion.resources.getResource(pathStr = path2.toString())) == null || !file2.isFile()) continue;
                    this.internalMapExtensionWrapper(extensionWrappers, path2, mappingData, true);
                    if (mappingData.wrapper != null || contextVersion.defaultWrapper == null) continue;
                    mappingData.wrapper = (Wrapper)contextVersion.defaultWrapper.object;
                    mappingData.requestPath.setChars(path2.getBuffer(), path2.getStart(), path2.getLength());
                    mappingData.wrapperPath.setChars(path2.getBuffer(), path2.getStart(), path2.getLength());
                    mappingData.requestPath.setString(pathStr);
                    mappingData.wrapperPath.setString(pathStr);
                }
                path2.setStart(servletPath);
                path2.setEnd(pathEnd);
            }
        }
        if (mappingData.wrapper == null) {
            checkWelcomeFiles = checkJspWelcomeFiles;
            if (!checkWelcomeFiles) {
                buf = path2.getBuffer();
                boolean bl = checkWelcomeFiles = buf[pathEnd - 1] == '/';
            }
            if (checkWelcomeFiles) {
                for (int i3 = 0; i3 < contextVersion.welcomeResources.length && mappingData.wrapper == null; ++i3) {
                    path2.setStart(pathStart);
                    path2.setEnd(pathEnd);
                    path2.append(contextVersion.welcomeResources[i3], 0, contextVersion.welcomeResources[i3].length());
                    path2.setStart(servletPath);
                    this.internalMapExtensionWrapper(extensionWrappers, path2, mappingData, false);
                }
                path2.setStart(servletPath);
                path2.setEnd(pathEnd);
            }
        }
        if (mappingData.wrapper == null && !checkJspWelcomeFiles) {
            if (contextVersion.defaultWrapper != null) {
                mappingData.wrapper = (Wrapper)contextVersion.defaultWrapper.object;
                mappingData.requestPath.setChars(path2.getBuffer(), path2.getStart(), path2.getLength());
                mappingData.wrapperPath.setChars(path2.getBuffer(), path2.getStart(), path2.getLength());
                mappingData.matchType = MappingMatch.DEFAULT;
            }
            char[] buf3 = path2.getBuffer();
            if (contextVersion.resources != null && buf3[pathEnd - 1] != '/') {
                String pathStr = path2.toString();
                if (((Context)contextVersion.object).getMapperDirectoryRedirectEnabled()) {
                    WebResource file3 = pathStr.length() == 0 ? contextVersion.resources.getResource("/") : contextVersion.resources.getResource(pathStr);
                    if (file3 != null && file3.isDirectory()) {
                        path2.setStart(pathStart);
                        path2.append('/');
                        mappingData.redirectPath.setChars(path2.getBuffer(), path2.getStart(), path2.getLength());
                    } else {
                        mappingData.requestPath.setString(pathStr);
                        mappingData.wrapperPath.setString(pathStr);
                    }
                } else {
                    mappingData.requestPath.setString(pathStr);
                    mappingData.wrapperPath.setString(pathStr);
                }
            }
        }
        path2.setStart(pathStart);
        path2.setEnd(pathEnd);
    }

    private void internalMapExactWrapper(MappedWrapper[] wrappers, CharChunk path2, MappingData mappingData) {
        MappedWrapper wrapper = (MappedWrapper)Mapper.exactFind((MapElement[])wrappers, (CharChunk)path2);
        if (wrapper != null) {
            mappingData.requestPath.setString(wrapper.name);
            mappingData.wrapper = (Wrapper)wrapper.object;
            if (path2.equals("/")) {
                mappingData.pathInfo.setString("/");
                mappingData.wrapperPath.setString("");
                mappingData.matchType = MappingMatch.CONTEXT_ROOT;
            } else {
                mappingData.wrapperPath.setString(wrapper.name);
                mappingData.matchType = MappingMatch.EXACT;
            }
        }
    }

    private void internalMapWildcardWrapper(MappedWrapper[] wrappers, int nesting2, CharChunk path2, MappingData mappingData) {
        int pathEnd = path2.getEnd();
        int lastSlash = -1;
        int length2 = -1;
        int pos2 = Mapper.find(wrappers, path2);
        if (pos2 != -1) {
            boolean found = false;
            while (pos2 >= 0) {
                if (path2.startsWith(wrappers[pos2].name)) {
                    length2 = wrappers[pos2].name.length();
                    if (path2.getLength() == length2) {
                        found = true;
                        break;
                    }
                    if (path2.startsWithIgnoreCase("/", length2)) {
                        found = true;
                        break;
                    }
                }
                lastSlash = lastSlash == -1 ? Mapper.nthSlash(path2, nesting2 + 1) : Mapper.lastSlash(path2);
                path2.setEnd(lastSlash);
                pos2 = Mapper.find(wrappers, path2);
            }
            path2.setEnd(pathEnd);
            if (found) {
                mappingData.wrapperPath.setString(wrappers[pos2].name);
                if (path2.getLength() > length2) {
                    mappingData.pathInfo.setChars(path2.getBuffer(), path2.getStart() + length2, path2.getLength() - length2);
                }
                mappingData.requestPath.setChars(path2.getBuffer(), path2.getStart(), path2.getLength());
                mappingData.wrapper = (Wrapper)wrappers[pos2].object;
                mappingData.jspWildCard = wrappers[pos2].jspWildCard;
                mappingData.matchType = MappingMatch.PATH;
            }
        }
    }

    private void internalMapExtensionWrapper(MappedWrapper[] wrappers, CharChunk path2, MappingData mappingData, boolean resourceExpected) {
        char[] buf = path2.getBuffer();
        int pathEnd = path2.getEnd();
        int servletPath = path2.getStart();
        int slash = -1;
        for (int i2 = pathEnd - 1; i2 >= servletPath; --i2) {
            if (buf[i2] != '/') continue;
            slash = i2;
            break;
        }
        if (slash >= 0) {
            int period = -1;
            for (int i3 = pathEnd - 1; i3 > slash; --i3) {
                if (buf[i3] != '.') continue;
                period = i3;
                break;
            }
            if (period >= 0) {
                path2.setStart(period + 1);
                path2.setEnd(pathEnd);
                MappedWrapper wrapper = (MappedWrapper)Mapper.exactFind((MapElement[])wrappers, (CharChunk)path2);
                if (wrapper != null && (resourceExpected || !wrapper.resourceOnly)) {
                    mappingData.wrapperPath.setChars(buf, servletPath, pathEnd - servletPath);
                    mappingData.requestPath.setChars(buf, servletPath, pathEnd - servletPath);
                    mappingData.wrapper = (Wrapper)wrapper.object;
                    mappingData.matchType = MappingMatch.EXTENSION;
                }
                path2.setStart(servletPath);
                path2.setEnd(pathEnd);
            }
        }
    }

    private static <T> int find(MapElement<T>[] map2, CharChunk name2) {
        return Mapper.find(map2, name2, name2.getStart(), name2.getEnd());
    }

    private static <T> int find(MapElement<T>[] map2, CharChunk name2, int start2, int end2) {
        int a = 0;
        int b2 = map2.length - 1;
        if (b2 == -1) {
            return -1;
        }
        if (Mapper.compare(name2, start2, end2, map2[0].name) < 0) {
            return -1;
        }
        if (b2 == 0) {
            return 0;
        }
        int i2 = 0;
        do {
            i2 = b2 + a >>> 1;
            int result2 = Mapper.compare(name2, start2, end2, map2[i2].name);
            if (result2 == 1) {
                a = i2;
                continue;
            }
            if (result2 == 0) {
                return i2;
            }
            b2 = i2;
        } while (b2 - a != 1);
        int result2 = Mapper.compare(name2, start2, end2, map2[b2].name);
        if (result2 < 0) {
            return a;
        }
        return b2;
    }

    private static <T> int findIgnoreCase(MapElement<T>[] map2, CharChunk name2) {
        return Mapper.findIgnoreCase(map2, name2, name2.getStart(), name2.getEnd());
    }

    private static <T> int findIgnoreCase(MapElement<T>[] map2, CharChunk name2, int start2, int end2) {
        int a = 0;
        int b2 = map2.length - 1;
        if (b2 == -1) {
            return -1;
        }
        if (Mapper.compareIgnoreCase(name2, start2, end2, map2[0].name) < 0) {
            return -1;
        }
        if (b2 == 0) {
            return 0;
        }
        int i2 = 0;
        do {
            i2 = b2 + a >>> 1;
            int result2 = Mapper.compareIgnoreCase(name2, start2, end2, map2[i2].name);
            if (result2 == 1) {
                a = i2;
                continue;
            }
            if (result2 == 0) {
                return i2;
            }
            b2 = i2;
        } while (b2 - a != 1);
        int result2 = Mapper.compareIgnoreCase(name2, start2, end2, map2[b2].name);
        if (result2 < 0) {
            return a;
        }
        return b2;
    }

    private static <T> int find(MapElement<T>[] map2, String name2) {
        int a = 0;
        int b2 = map2.length - 1;
        if (b2 == -1) {
            return -1;
        }
        if (name2.compareTo(map2[0].name) < 0) {
            return -1;
        }
        if (b2 == 0) {
            return 0;
        }
        int i2 = 0;
        do {
            i2 = b2 + a >>> 1;
            int result2 = name2.compareTo(map2[i2].name);
            if (result2 > 0) {
                a = i2;
                continue;
            }
            if (result2 == 0) {
                return i2;
            }
            b2 = i2;
        } while (b2 - a != 1);
        int result2 = name2.compareTo(map2[b2].name);
        if (result2 < 0) {
            return a;
        }
        return b2;
    }

    private static <T, E extends MapElement<T>> E exactFind(E[] map2, String name2) {
        int pos2 = Mapper.find(map2, name2);
        if (pos2 >= 0) {
            E result2 = map2[pos2];
            if (name2.equals(((MapElement)result2).name)) {
                return result2;
            }
        }
        return null;
    }

    private static <T, E extends MapElement<T>> E exactFind(E[] map2, CharChunk name2) {
        int pos2 = Mapper.find(map2, name2);
        if (pos2 >= 0) {
            E result2 = map2[pos2];
            if (name2.equals(((MapElement)result2).name)) {
                return result2;
            }
        }
        return null;
    }

    private static <T, E extends MapElement<T>> E exactFindIgnoreCase(E[] map2, CharChunk name2) {
        int pos2 = Mapper.findIgnoreCase(map2, name2);
        if (pos2 >= 0) {
            E result2 = map2[pos2];
            if (name2.equalsIgnoreCase(((MapElement)result2).name)) {
                return result2;
            }
        }
        return null;
    }

    private static int compare(CharChunk name2, int start2, int end2, String compareTo) {
        int result2 = 0;
        char[] c = name2.getBuffer();
        int compareLen = compareTo.length();
        int len = compareLen;
        if (end2 - start2 < len) {
            len = end2 - start2;
        }
        for (int i2 = 0; i2 < len && result2 == 0; ++i2) {
            char nameChar = c[i2 + start2];
            char compareToChar = compareTo.charAt(i2);
            if (nameChar > compareToChar) {
                result2 = 1;
                continue;
            }
            if (nameChar >= compareToChar) continue;
            result2 = -1;
        }
        if (result2 == 0) {
            if (compareLen > end2 - start2) {
                result2 = -1;
            } else if (compareLen < end2 - start2) {
                result2 = 1;
            }
        }
        return result2;
    }

    private static int compareIgnoreCase(CharChunk name2, int start2, int end2, String compareTo) {
        int result2 = 0;
        char[] c = name2.getBuffer();
        int compareLen = compareTo.length();
        int len = compareLen;
        if (end2 - start2 < len) {
            len = end2 - start2;
        }
        for (int i2 = 0; i2 < len && result2 == 0; ++i2) {
            int compareLower;
            int nameLower = Ascii.toLower(c[i2 + start2]);
            if (nameLower > (compareLower = Ascii.toLower(compareTo.charAt(i2)))) {
                result2 = 1;
                continue;
            }
            if (nameLower >= compareLower) continue;
            result2 = -1;
        }
        if (result2 == 0) {
            if (compareLen > end2 - start2) {
                result2 = -1;
            } else if (compareLen < end2 - start2) {
                result2 = 1;
            }
        }
        return result2;
    }

    private static int lastSlash(CharChunk name2) {
        char[] c = name2.getBuffer();
        int end2 = name2.getEnd();
        int start2 = name2.getStart();
        int pos2 = end2;
        while (pos2 > start2 && c[--pos2] != '/') {
        }
        return pos2;
    }

    private static int nthSlash(CharChunk name2, int n) {
        int start2;
        char[] c = name2.getBuffer();
        int end2 = name2.getEnd();
        int pos2 = start2 = name2.getStart();
        int count2 = 0;
        while (pos2 < end2) {
            if (c[pos2++] != '/' || ++count2 != n) continue;
            --pos2;
            break;
        }
        return pos2;
    }

    private static int slashCount(String name2) {
        int pos2 = -1;
        int count2 = 0;
        while ((pos2 = name2.indexOf(47, pos2 + 1)) != -1) {
            ++count2;
        }
        return count2;
    }

    private static <T> boolean insertMap(MapElement<T>[] oldMap, MapElement<T>[] newMap, MapElement<T> newElement) {
        int pos2 = Mapper.find(oldMap, newElement.name);
        if (pos2 != -1 && newElement.name.equals(oldMap[pos2].name)) {
            return false;
        }
        System.arraycopy(oldMap, 0, newMap, 0, pos2 + 1);
        newMap[pos2 + 1] = newElement;
        System.arraycopy(oldMap, pos2 + 1, newMap, pos2 + 2, oldMap.length - pos2 - 1);
        return true;
    }

    private static <T> boolean removeMap(MapElement<T>[] oldMap, MapElement<T>[] newMap, String name2) {
        int pos2 = Mapper.find(oldMap, name2);
        if (pos2 != -1 && name2.equals(oldMap[pos2].name)) {
            System.arraycopy(oldMap, 0, newMap, 0, pos2);
            System.arraycopy(oldMap, pos2 + 1, newMap, pos2, oldMap.length - pos2 - 1);
            return true;
        }
        return false;
    }

    private static String renameWildcardHost(String hostName) {
        if (hostName != null && hostName.startsWith("*.")) {
            return hostName.substring(1);
        }
        return hostName;
    }

    protected static final class MappedHost
    extends MapElement<Host> {
        public volatile ContextList contextList;
        private final MappedHost realHost;
        private final List<MappedHost> aliases;

        public MappedHost(String name2, Host host) {
            super(name2, host);
            this.realHost = this;
            this.contextList = new ContextList();
            this.aliases = new CopyOnWriteArrayList<MappedHost>();
        }

        public MappedHost(String alias, MappedHost realHost) {
            super(alias, (Host)realHost.object);
            this.realHost = realHost;
            this.contextList = realHost.contextList;
            this.aliases = null;
        }

        public boolean isAlias() {
            return this.realHost != this;
        }

        public MappedHost getRealHost() {
            return this.realHost;
        }

        public String getRealHostName() {
            return this.realHost.name;
        }

        public Collection<MappedHost> getAliases() {
            return this.aliases;
        }

        public void addAlias(MappedHost alias) {
            this.aliases.add(alias);
        }

        public void addAliases(Collection<? extends MappedHost> c) {
            this.aliases.addAll(c);
        }

        public void removeAlias(MappedHost alias) {
            this.aliases.remove(alias);
        }
    }

    protected static abstract class MapElement<T> {
        public final String name;
        public final T object;

        public MapElement(String name2, T object) {
            this.name = name2;
            this.object = object;
        }
    }

    protected static final class ContextList {
        public final MappedContext[] contexts;
        public final int nesting;

        public ContextList() {
            this(new MappedContext[0], 0);
        }

        private ContextList(MappedContext[] contexts, int nesting2) {
            this.contexts = contexts;
            this.nesting = nesting2;
        }

        public ContextList addContext(MappedContext mappedContext, int slashCount) {
            MappedContext[] newContexts = new MappedContext[this.contexts.length + 1];
            if (Mapper.insertMap(this.contexts, newContexts, mappedContext)) {
                return new ContextList(newContexts, Math.max(this.nesting, slashCount));
            }
            return null;
        }

        public ContextList removeContext(String path2) {
            MappedContext[] newContexts = new MappedContext[this.contexts.length - 1];
            if (Mapper.removeMap(this.contexts, newContexts, path2)) {
                int newNesting = 0;
                for (MappedContext context : newContexts) {
                    newNesting = Math.max(newNesting, Mapper.slashCount(context.name));
                }
                return new ContextList(newContexts, newNesting);
            }
            return null;
        }
    }

    protected static final class ContextVersion
    extends MapElement<Context> {
        public final String path;
        public final int slashCount;
        public final WebResourceRoot resources;
        public String[] welcomeResources;
        public MappedWrapper defaultWrapper = null;
        public MappedWrapper[] exactWrappers = new MappedWrapper[0];
        public MappedWrapper[] wildcardWrappers = new MappedWrapper[0];
        public MappedWrapper[] extensionWrappers = new MappedWrapper[0];
        public int nesting = 0;
        private volatile boolean paused;

        public ContextVersion(String version, String path2, int slashCount, Context context, WebResourceRoot resources, String[] welcomeResources) {
            super(version, context);
            this.path = path2;
            this.slashCount = slashCount;
            this.resources = resources;
            this.welcomeResources = welcomeResources;
        }

        public boolean isPaused() {
            return this.paused;
        }

        public void markPaused() {
            this.paused = true;
        }
    }

    protected static final class MappedContext
    extends MapElement<Void> {
        public volatile ContextVersion[] versions;

        public MappedContext(String name2, ContextVersion firstVersion) {
            super(name2, null);
            this.versions = new ContextVersion[]{firstVersion};
        }
    }

    protected static class MappedWrapper
    extends MapElement<Wrapper> {
        public final boolean jspWildCard;
        public final boolean resourceOnly;

        public MappedWrapper(String name2, Wrapper wrapper, boolean jspWildCard, boolean resourceOnly) {
            super(name2, wrapper);
            this.jspWildCard = jspWildCard;
            this.resourceOnly = resourceOnly;
        }
    }
}

