/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.manager.host;

import jakarta.servlet.ServletException;
import jakarta.servlet.UnavailableException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.StringTokenizer;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerServlet;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.HostConfig;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.StringUtils;
import org.apache.tomcat.util.res.StringManager;

public class HostManagerServlet
extends HttpServlet
implements ContainerServlet {
    private static final long serialVersionUID = 1L;
    protected transient Context context = null;
    protected int debug = 1;
    protected transient Host installedHost = null;
    protected transient Engine engine = null;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.manager.host");
    protected transient Wrapper wrapper = null;

    @Override
    public Wrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
        if (wrapper == null) {
            this.context = null;
            this.installedHost = null;
            this.engine = null;
        } else {
            this.context = (Context)wrapper.getParent();
            this.installedHost = (Host)this.context.getParent();
            this.engine = (Engine)this.installedHost.getParent();
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        StringManager smClient = StringManager.getManager("org.apache.catalina.manager.host", request.getLocales());
        String command = request.getPathInfo();
        if (command == null) {
            command = request.getServletPath();
        }
        String name2 = request.getParameter("name");
        response.setContentType("text/plain; charset=utf-8");
        response.setHeader("X-Content-Type-Options", "nosniff");
        PrintWriter writer = response.getWriter();
        if (command == null) {
            writer.println(smClient.getString("hostManagerServlet.noCommand"));
        } else if (command.equals("/add")) {
            this.add(request, writer, name2, false, smClient);
        } else if (command.equals("/remove")) {
            this.remove(writer, name2, smClient);
        } else if (command.equals("/list")) {
            this.list(writer, smClient);
        } else if (command.equals("/start")) {
            this.start(writer, name2, smClient);
        } else if (command.equals("/stop")) {
            this.stop(writer, name2, smClient);
        } else if (command.equals("/persist")) {
            this.persist(writer, smClient);
        } else {
            writer.println(smClient.getString("hostManagerServlet.unknownCommand", command));
        }
        writer.flush();
        writer.close();
    }

    protected void add(HttpServletRequest request, PrintWriter writer, String name2, boolean htmlMode, StringManager smClient) {
        String aliases2 = request.getParameter("aliases");
        String appBase = request.getParameter("appBase");
        boolean manager = this.booleanParameter(request, "manager", false, htmlMode);
        boolean autoDeploy = this.booleanParameter(request, "autoDeploy", true, htmlMode);
        boolean deployOnStartup = this.booleanParameter(request, "deployOnStartup", true, htmlMode);
        boolean deployXML = this.booleanParameter(request, "deployXML", true, htmlMode);
        boolean unpackWARs = this.booleanParameter(request, "unpackWARs", true, htmlMode);
        boolean copyXML = this.booleanParameter(request, "copyXML", false, htmlMode);
        this.add(writer, name2, aliases2, appBase, manager, autoDeploy, deployOnStartup, deployXML, unpackWARs, copyXML, smClient);
    }

    protected boolean booleanParameter(HttpServletRequest request, String parameter, boolean theDefault, boolean htmlMode) {
        String value2 = request.getParameter(parameter);
        boolean booleanValue = theDefault;
        if (value2 != null) {
            if (htmlMode) {
                if (value2.equals("on")) {
                    booleanValue = true;
                }
            } else if (theDefault) {
                if (value2.equals("false")) {
                    booleanValue = false;
                }
            } else if (value2.equals("true")) {
                booleanValue = true;
            }
        } else if (htmlMode) {
            booleanValue = false;
        }
        return booleanValue;
    }

    @Override
    public void init() throws ServletException {
        if (this.wrapper == null || this.context == null) {
            throw new UnavailableException(sm.getString("hostManagerServlet.noWrapper"));
        }
        String value2 = null;
        try {
            value2 = this.getServletConfig().getInitParameter("debug");
            this.debug = Integer.parseInt(value2);
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
        }
    }

    protected synchronized void add(PrintWriter writer, String name2, String aliases2, String appBase, boolean manager, boolean autoDeploy, boolean deployOnStartup, boolean deployXML, boolean unpackWARs, boolean copyXML, StringManager smClient) {
        if (this.debug >= 1) {
            this.log(sm.getString("hostManagerServlet.add", name2));
        }
        if (name2 == null || name2.length() == 0) {
            writer.println(smClient.getString("hostManagerServlet.invalidHostName", name2));
            return;
        }
        if (this.engine.findChild(name2) != null) {
            writer.println(smClient.getString("hostManagerServlet.alreadyHost", name2));
            return;
        }
        File appBaseFile = null;
        File file2 = null;
        String applicationBase = appBase;
        if (applicationBase == null || applicationBase.length() == 0) {
            applicationBase = name2;
        }
        if (!(file2 = new File(applicationBase)).isAbsolute()) {
            file2 = new File(this.engine.getCatalinaBase(), file2.getPath());
        }
        try {
            appBaseFile = file2.getCanonicalFile();
        }
        catch (IOException e) {
            appBaseFile = file2;
        }
        if (!appBaseFile.mkdirs() && !appBaseFile.isDirectory()) {
            writer.println(smClient.getString("hostManagerServlet.appBaseCreateFail", appBaseFile.toString(), name2));
            return;
        }
        File configBaseFile = this.getConfigBase(name2);
        if (manager) {
            if (configBaseFile == null) {
                writer.println(smClient.getString("hostManagerServlet.configBaseCreateFail", name2));
                return;
            }
            try (InputStream is = this.getServletContext().getResourceAsStream("/WEB-INF/manager.xml");){
                if (is == null) {
                    writer.println(smClient.getString("hostManagerServlet.managerXml"));
                    return;
                }
                Path dest = new File(configBaseFile, "manager.xml").toPath();
                Files.copy(is, dest, new CopyOption[0]);
            }
            catch (IOException e) {
                writer.println(smClient.getString("hostManagerServlet.managerXml"));
                return;
            }
        }
        StandardHost host = new StandardHost();
        host.setAppBase(applicationBase);
        host.setName(name2);
        host.addLifecycleListener(new HostConfig());
        if (aliases2 != null && !aliases2.isEmpty()) {
            StringTokenizer tok = new StringTokenizer(aliases2, ", ");
            while (tok.hasMoreTokens()) {
                host.addAlias(tok.nextToken());
            }
        }
        host.setAutoDeploy(autoDeploy);
        host.setDeployOnStartup(deployOnStartup);
        host.setDeployXML(deployXML);
        host.setUnpackWARs(unpackWARs);
        host.setCopyXML(copyXML);
        try {
            this.engine.addChild(host);
        }
        catch (Exception e) {
            writer.println(smClient.getString("hostManagerServlet.exception", e.toString()));
            return;
        }
        host = (StandardHost)this.engine.findChild(name2);
        if (host != null) {
            writer.println(smClient.getString("hostManagerServlet.addSuccess", name2));
        } else {
            writer.println(smClient.getString("hostManagerServlet.addFailed", name2));
        }
    }

    protected synchronized void remove(PrintWriter writer, String name2, StringManager smClient) {
        if (this.debug >= 1) {
            this.log(sm.getString("hostManagerServlet.remove", name2));
        }
        if (name2 == null || name2.length() == 0) {
            writer.println(smClient.getString("hostManagerServlet.invalidHostName", name2));
            return;
        }
        if (this.engine.findChild(name2) == null) {
            writer.println(smClient.getString("hostManagerServlet.noHost", name2));
            return;
        }
        if (this.engine.findChild(name2) == this.installedHost) {
            writer.println(smClient.getString("hostManagerServlet.cannotRemoveOwnHost", name2));
            return;
        }
        try {
            Container child = this.engine.findChild(name2);
            this.engine.removeChild(child);
            if (child instanceof ContainerBase) {
                child.destroy();
            }
        }
        catch (Exception e) {
            writer.println(smClient.getString("hostManagerServlet.exception", e.toString()));
            return;
        }
        StandardHost host = (StandardHost)this.engine.findChild(name2);
        if (host == null) {
            writer.println(smClient.getString("hostManagerServlet.removeSuccess", name2));
        } else {
            writer.println(smClient.getString("hostManagerServlet.removeFailed", name2));
        }
    }

    protected void list(PrintWriter writer, StringManager smClient) {
        Container[] hosts;
        if (this.debug >= 1) {
            this.log(sm.getString("hostManagerServlet.list", this.engine.getName()));
        }
        writer.println(smClient.getString("hostManagerServlet.listed", this.engine.getName()));
        for (Container container : hosts = this.engine.findChildren()) {
            Host host = (Host)container;
            String name2 = host.getName();
            String[] aliases2 = host.findAliases();
            writer.println(String.format("[%s]:[%s]", name2, StringUtils.join(aliases2)));
        }
    }

    protected void start(PrintWriter writer, String name2, StringManager smClient) {
        if (this.debug >= 1) {
            this.log(sm.getString("hostManagerServlet.start", name2));
        }
        if (name2 == null || name2.length() == 0) {
            writer.println(smClient.getString("hostManagerServlet.invalidHostName", name2));
            return;
        }
        Container host = this.engine.findChild(name2);
        if (host == null) {
            writer.println(smClient.getString("hostManagerServlet.noHost", name2));
            return;
        }
        if (host == this.installedHost) {
            writer.println(smClient.getString("hostManagerServlet.cannotStartOwnHost", name2));
            return;
        }
        if (host.getState().isAvailable()) {
            writer.println(smClient.getString("hostManagerServlet.alreadyStarted", name2));
            return;
        }
        try {
            host.start();
            writer.println(smClient.getString("hostManagerServlet.started", name2));
        }
        catch (Exception e) {
            this.getServletContext().log(sm.getString("hostManagerServlet.startFailed", name2), e);
            writer.println(smClient.getString("hostManagerServlet.startFailed", name2));
            writer.println(smClient.getString("hostManagerServlet.exception", e.toString()));
        }
    }

    protected void stop(PrintWriter writer, String name2, StringManager smClient) {
        if (this.debug >= 1) {
            this.log(sm.getString("hostManagerServlet.stop", name2));
        }
        if (name2 == null || name2.length() == 0) {
            writer.println(smClient.getString("hostManagerServlet.invalidHostName", name2));
            return;
        }
        Container host = this.engine.findChild(name2);
        if (host == null) {
            writer.println(smClient.getString("hostManagerServlet.noHost", name2));
            return;
        }
        if (host == this.installedHost) {
            writer.println(smClient.getString("hostManagerServlet.cannotStopOwnHost", name2));
            return;
        }
        if (!host.getState().isAvailable()) {
            writer.println(smClient.getString("hostManagerServlet.alreadyStopped", name2));
            return;
        }
        try {
            host.stop();
            writer.println(smClient.getString("hostManagerServlet.stopped", name2));
        }
        catch (Exception e) {
            this.getServletContext().log(sm.getString("hostManagerServlet.stopFailed", name2), e);
            writer.println(smClient.getString("hostManagerServlet.stopFailed", name2));
            writer.println(smClient.getString("hostManagerServlet.exception", e.toString()));
        }
    }

    protected void persist(PrintWriter writer, StringManager smClient) {
        if (this.debug >= 1) {
            this.log(sm.getString("hostManagerServlet.persist"));
        }
        try {
            MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName oname = new ObjectName(this.engine.getDomain() + ":type=StoreConfig");
            platformMBeanServer.invoke(oname, "storeConfig", null, null);
            writer.println(smClient.getString("hostManagerServlet.persisted"));
        }
        catch (Exception e) {
            this.getServletContext().log(sm.getString("hostManagerServlet.persistFailed"), e);
            writer.println(smClient.getString("hostManagerServlet.persistFailed"));
            if (e instanceof InstanceNotFoundException) {
                writer.println(smClient.getString("hostManagerServlet.noStoreConfig"));
            }
            writer.println(smClient.getString("hostManagerServlet.exception", e.toString()));
        }
    }

    protected File getConfigBase(String hostName) {
        File configBase = new File(this.context.getCatalinaBase(), "conf");
        if (!configBase.exists()) {
            return null;
        }
        if (this.engine != null) {
            configBase = new File(configBase, this.engine.getName());
        }
        if (this.installedHost != null) {
            configBase = new File(configBase, hostName);
        }
        if (!configBase.mkdirs() && !configBase.isDirectory()) {
            return null;
        }
        return configBase;
    }
}

