/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.catalina.filters.FilterBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.http.Parameters;

public class FailedRequestFilter
extends FilterBase {
    private final Log log = LogFactory.getLog(FailedRequestFilter.class);

    @Override
    protected Log getLogger() {
        return this.log;
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain2) throws IOException, ServletException {
        if (!this.isGoodRequest(request)) {
            int status2;
            Parameters.FailReason reason2 = (Parameters.FailReason)((Object)request.getAttribute("org.apache.catalina.parameter_parse_failed_reason"));
            switch (reason2) {
                case IO_ERROR: {
                    status2 = 500;
                    break;
                }
                case POST_TOO_LARGE: {
                    status2 = 413;
                    break;
                }
                default: {
                    status2 = 400;
                }
            }
            try {
                ((HttpServletResponse)response).sendError(status2);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            return;
        }
        chain2.doFilter(request, response);
    }

    private boolean isGoodRequest(ServletRequest request) {
        request.getParameter("none");
        return request.getAttribute("org.apache.catalina.parameter_parse_failed") == null;
    }

    @Override
    protected boolean isConfigProblemFatal() {
        return true;
    }
}

