/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.catalina.filters.FilterBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class AddDefaultCharsetFilter
extends FilterBase {
    private final Log log = LogFactory.getLog(AddDefaultCharsetFilter.class);
    private static final String DEFAULT_ENCODING = "ISO-8859-1";
    private String encoding;

    public void setEncoding(String encoding2) {
        this.encoding = encoding2;
    }

    @Override
    protected Log getLogger() {
        return this.log;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        if (this.encoding == null || this.encoding.length() == 0 || this.encoding.equalsIgnoreCase("default")) {
            this.encoding = DEFAULT_ENCODING;
        } else if (this.encoding.equalsIgnoreCase("system")) {
            this.encoding = Charset.defaultCharset().name();
        } else if (!Charset.isSupported(this.encoding)) {
            throw new IllegalArgumentException(sm.getString("addDefaultCharset.unsupportedCharset", this.encoding));
        }
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain2) throws IOException, ServletException {
        if (response instanceof HttpServletResponse) {
            ResponseWrapper wrapped = new ResponseWrapper((HttpServletResponse)response, this.encoding);
            chain2.doFilter(request, wrapped);
        } else {
            chain2.doFilter(request, response);
        }
    }

    public static class ResponseWrapper
    extends HttpServletResponseWrapper {
        private String encoding;

        public ResponseWrapper(HttpServletResponse response, String encoding2) {
            super(response);
            this.encoding = encoding2;
        }

        @Override
        public void setContentType(String contentType) {
            if (contentType != null && contentType.startsWith("text/")) {
                if (!contentType.contains("charset=")) {
                    super.setContentType(contentType + ";charset=" + this.encoding);
                } else {
                    super.setContentType(contentType);
                    this.encoding = this.getCharacterEncoding();
                }
            } else {
                super.setContentType(contentType);
            }
        }

        @Override
        public void setHeader(String name2, String value2) {
            if (name2.trim().equalsIgnoreCase("content-type")) {
                this.setContentType(value2);
            } else {
                super.setHeader(name2, value2);
            }
        }

        @Override
        public void addHeader(String name2, String value2) {
            if (name2.trim().equalsIgnoreCase("content-type")) {
                this.setContentType(value2);
            } else {
                super.addHeader(name2, value2);
            }
        }

        @Override
        public void setCharacterEncoding(String charset) {
            super.setCharacterEncoding(charset);
            this.encoding = charset;
        }
    }
}

