/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.UnavailableException;
import jakarta.servlet.annotation.MultipartConfig;
import jakarta.servlet.http.HttpServlet;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerServlet;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapperFacade;
import org.apache.catalina.core.StandardWrapperValve;
import org.apache.catalina.security.SecurityUtil;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.PeriodicEventListener;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.log.SystemLogHandler;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.modeler.Util;

public class StandardWrapper
extends ContainerBase
implements ServletConfig,
Wrapper,
NotificationEmitter {
    private final Log log = LogFactory.getLog(StandardWrapper.class);
    protected static final String[] DEFAULT_SERVLET_METHODS = new String[]{"GET", "HEAD", "POST"};
    protected long available = 0L;
    protected final NotificationBroadcasterSupport broadcaster;
    protected final AtomicInteger countAllocated = new AtomicInteger(0);
    protected final StandardWrapperFacade facade = new StandardWrapperFacade(this);
    protected volatile Servlet instance = null;
    protected volatile boolean instanceInitialized = false;
    protected int loadOnStartup = -1;
    protected final ArrayList<String> mappings = new ArrayList();
    protected HashMap<String, String> parameters = new HashMap();
    protected HashMap<String, String> references = new HashMap();
    protected String runAs = null;
    protected long sequenceNumber = 0L;
    protected String servletClass = null;
    protected volatile boolean unloading = false;
    protected long unloadDelay = 2000L;
    protected boolean isJspServlet;
    protected ObjectName jspMonitorON;
    protected boolean swallowOutput = false;
    protected StandardWrapperValve swValve;
    protected long loadTime = 0L;
    protected int classLoadTime = 0;
    protected MultipartConfigElement multipartConfigElement = null;
    protected boolean asyncSupported = false;
    protected boolean enabled = true;
    private boolean overridable = false;
    protected static Class<?>[] classType = new Class[]{ServletConfig.class};
    private final ReentrantReadWriteLock parametersLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock mappingsLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock referencesLock = new ReentrantReadWriteLock();
    protected MBeanNotificationInfo[] notificationInfo;

    public StandardWrapper() {
        this.swValve = new StandardWrapperValve();
        this.pipeline.setBasic(this.swValve);
        this.broadcaster = new NotificationBroadcasterSupport();
    }

    @Override
    public boolean isOverridable() {
        return this.overridable;
    }

    @Override
    public void setOverridable(boolean overridable) {
        this.overridable = overridable;
    }

    @Override
    public long getAvailable() {
        return this.available;
    }

    @Override
    public void setAvailable(long available) {
        long oldAvailable = this.available;
        this.available = available > System.currentTimeMillis() ? available : 0L;
        this.support.firePropertyChange("available", oldAvailable, this.available);
    }

    public int getCountAllocated() {
        return this.countAllocated.get();
    }

    @Override
    public int getLoadOnStartup() {
        if (this.isJspServlet && this.loadOnStartup == -1) {
            return Integer.MAX_VALUE;
        }
        return this.loadOnStartup;
    }

    @Override
    public void setLoadOnStartup(int value2) {
        int oldLoadOnStartup = this.loadOnStartup;
        this.loadOnStartup = value2;
        this.support.firePropertyChange("loadOnStartup", (Object)oldLoadOnStartup, (Object)this.loadOnStartup);
    }

    public void setLoadOnStartupString(String value2) {
        try {
            this.setLoadOnStartup(Integer.parseInt(value2));
        }
        catch (NumberFormatException e) {
            this.setLoadOnStartup(0);
        }
    }

    public String getLoadOnStartupString() {
        return Integer.toString(this.getLoadOnStartup());
    }

    @Override
    public void setParent(Container container) {
        if (container != null && !(container instanceof Context)) {
            throw new IllegalArgumentException(sm.getString("standardWrapper.notContext"));
        }
        if (container instanceof StandardContext) {
            this.swallowOutput = ((StandardContext)container).getSwallowOutput();
            this.unloadDelay = ((StandardContext)container).getUnloadDelay();
        }
        super.setParent(container);
    }

    @Override
    public String getRunAs() {
        return this.runAs;
    }

    @Override
    public void setRunAs(String runAs) {
        String oldRunAs = this.runAs;
        this.runAs = runAs;
        this.support.firePropertyChange("runAs", oldRunAs, this.runAs);
    }

    @Override
    public String getServletClass() {
        return this.servletClass;
    }

    @Override
    public void setServletClass(String servletClass) {
        String oldServletClass = this.servletClass;
        this.servletClass = servletClass;
        this.support.firePropertyChange("servletClass", oldServletClass, this.servletClass);
        if ("org.apache.jasper.servlet.JspServlet".equals(servletClass)) {
            this.isJspServlet = true;
        }
    }

    public void setServletName(String name2) {
        this.setName(name2);
    }

    @Override
    public boolean isUnavailable() {
        if (!this.isEnabled()) {
            return true;
        }
        if (this.available == 0L) {
            return false;
        }
        if (this.available <= System.currentTimeMillis()) {
            this.available = 0L;
            return false;
        }
        return true;
    }

    @Override
    public String[] getServletMethods() throws ServletException {
        this.instance = this.loadServlet();
        Class<?> servletClazz = this.instance.getClass();
        if (!HttpServlet.class.isAssignableFrom(servletClazz)) {
            return DEFAULT_SERVLET_METHODS;
        }
        HashSet<String> allow = new HashSet<String>();
        allow.add("OPTIONS");
        if (this.isJspServlet) {
            allow.add("GET");
            allow.add("HEAD");
            allow.add("POST");
        } else {
            allow.add("TRACE");
            Method[] methods2 = this.getAllDeclaredMethods(servletClazz);
            for (int i2 = 0; methods2 != null && i2 < methods2.length; ++i2) {
                Method m = methods2[i2];
                if (m.getName().equals("doGet")) {
                    allow.add("GET");
                    allow.add("HEAD");
                    continue;
                }
                if (m.getName().equals("doPost")) {
                    allow.add("POST");
                    continue;
                }
                if (m.getName().equals("doPut")) {
                    allow.add("PUT");
                    continue;
                }
                if (!m.getName().equals("doDelete")) continue;
                allow.add("DELETE");
            }
        }
        return allow.toArray(new String[0]);
    }

    @Override
    public Servlet getServlet() {
        return this.instance;
    }

    @Override
    public void setServlet(Servlet servlet) {
        this.instance = servlet;
    }

    @Override
    public synchronized void backgroundProcess() {
        super.backgroundProcess();
        if (!this.getState().isAvailable()) {
            return;
        }
        if (this.getServlet() instanceof PeriodicEventListener) {
            ((PeriodicEventListener)((Object)this.getServlet())).periodicEvent();
        }
    }

    public static Throwable getRootCause(ServletException e) {
        Throwable rootCause = e;
        Throwable rootCauseCheck = null;
        int loops = 0;
        do {
            ++loops;
            rootCauseCheck = rootCause.getCause();
            if (rootCauseCheck == null) continue;
            rootCause = rootCauseCheck;
        } while (rootCauseCheck != null && loops < 20);
        return rootCause;
    }

    @Override
    public void addChild(Container child) {
        throw new IllegalStateException(sm.getString("standardWrapper.notChild"));
    }

    @Override
    public void addInitParameter(String name2, String value2) {
        this.parametersLock.writeLock().lock();
        try {
            this.parameters.put(name2, value2);
        }
        finally {
            this.parametersLock.writeLock().unlock();
        }
        this.fireContainerEvent("addInitParameter", name2);
    }

    @Override
    public void addMapping(String mapping) {
        this.mappingsLock.writeLock().lock();
        try {
            this.mappings.add(mapping);
        }
        finally {
            this.mappingsLock.writeLock().unlock();
        }
        if (this.parent.getState().equals((Object)LifecycleState.STARTED)) {
            this.fireContainerEvent("addMapping", mapping);
        }
    }

    @Override
    public void addSecurityReference(String name2, String link2) {
        this.referencesLock.writeLock().lock();
        try {
            this.references.put(name2, link2);
        }
        finally {
            this.referencesLock.writeLock().unlock();
        }
        this.fireContainerEvent("addSecurityReference", name2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Servlet allocate() throws ServletException {
        if (this.unloading) {
            throw new ServletException(sm.getString("standardWrapper.unloading", this.getName()));
        }
        boolean newInstance2 = false;
        if (this.instance == null || !this.instanceInitialized) {
            StandardWrapper standardWrapper = this;
            synchronized (standardWrapper) {
                if (this.instance == null) {
                    try {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("Allocating instance");
                        }
                        this.instance = this.loadServlet();
                        newInstance2 = true;
                        this.countAllocated.incrementAndGet();
                    }
                    catch (ServletException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        ExceptionUtils.handleThrowable(e);
                        throw new ServletException(sm.getString("standardWrapper.allocate"), e);
                    }
                }
                if (!this.instanceInitialized) {
                    this.initServlet(this.instance);
                }
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("  Returning instance");
        }
        if (!newInstance2) {
            this.countAllocated.incrementAndGet();
        }
        return this.instance;
    }

    @Override
    public void deallocate(Servlet servlet) throws ServletException {
        this.countAllocated.decrementAndGet();
    }

    @Override
    public String findInitParameter(String name2) {
        this.parametersLock.readLock().lock();
        try {
            String string2 = this.parameters.get(name2);
            return string2;
        }
        finally {
            this.parametersLock.readLock().unlock();
        }
    }

    @Override
    public String[] findInitParameters() {
        this.parametersLock.readLock().lock();
        try {
            String[] stringArray = this.parameters.keySet().toArray(new String[0]);
            return stringArray;
        }
        finally {
            this.parametersLock.readLock().unlock();
        }
    }

    @Override
    public String[] findMappings() {
        this.mappingsLock.readLock().lock();
        try {
            String[] stringArray = this.mappings.toArray(new String[0]);
            return stringArray;
        }
        finally {
            this.mappingsLock.readLock().unlock();
        }
    }

    @Override
    public String findSecurityReference(String name2) {
        String reference2 = null;
        this.referencesLock.readLock().lock();
        try {
            reference2 = this.references.get(name2);
        }
        finally {
            this.referencesLock.readLock().unlock();
        }
        if (this.getParent() instanceof Context) {
            Context context = (Context)this.getParent();
            reference2 = reference2 != null ? context.findRoleMapping(reference2) : context.findRoleMapping(name2);
        }
        return reference2;
    }

    @Override
    public String[] findSecurityReferences() {
        this.referencesLock.readLock().lock();
        try {
            String[] stringArray = this.references.keySet().toArray(new String[0]);
            return stringArray;
        }
        finally {
            this.referencesLock.readLock().unlock();
        }
    }

    @Override
    public synchronized void load() throws ServletException {
        this.instance = this.loadServlet();
        if (!this.instanceInitialized) {
            this.initServlet(this.instance);
        }
        if (this.isJspServlet) {
            StringBuilder oname = new StringBuilder(this.getDomain());
            oname.append(":type=JspMonitor");
            oname.append(this.getWebModuleKeyProperties());
            oname.append(",name=");
            oname.append(this.getName());
            oname.append(this.getJ2EEKeyProperties());
            try {
                this.jspMonitorON = new ObjectName(oname.toString());
                Registry.getRegistry(null, null).registerComponent((Object)this.instance, this.jspMonitorON, null);
            }
            catch (Exception ex) {
                this.log.warn(sm.getString("standardWrapper.jspMonitorError", this.instance));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Servlet loadServlet() throws ServletException {
        Servlet servlet;
        if (this.instance != null) {
            return this.instance;
        }
        PrintStream out = System.out;
        if (this.swallowOutput) {
            SystemLogHandler.startCapture();
        }
        try {
            MultipartConfig annotation;
            long t1 = System.currentTimeMillis();
            if (this.servletClass == null) {
                this.unavailable(null);
                throw new ServletException(sm.getString("standardWrapper.notClass", this.getName()));
            }
            InstanceManager instanceManager = ((StandardContext)this.getParent()).getInstanceManager();
            try {
                servlet = (Servlet)instanceManager.newInstance(this.servletClass);
            }
            catch (ClassCastException e) {
                this.unavailable(null);
                throw new ServletException(sm.getString("standardWrapper.notServlet", this.servletClass), e);
            }
            catch (Throwable e) {
                e = ExceptionUtils.unwrapInvocationTargetException(e);
                ExceptionUtils.handleThrowable(e);
                this.unavailable(null);
                if (this.log.isDebugEnabled()) {
                    this.log.debug(sm.getString("standardWrapper.instantiate", this.servletClass), e);
                }
                throw new ServletException(sm.getString("standardWrapper.instantiate", this.servletClass), e);
            }
            if (this.multipartConfigElement == null && (annotation = servlet.getClass().getAnnotation(MultipartConfig.class)) != null) {
                this.multipartConfigElement = new MultipartConfigElement(annotation);
            }
            if (servlet instanceof ContainerServlet) {
                ((ContainerServlet)((Object)servlet)).setWrapper(this);
            }
            this.classLoadTime = (int)(System.currentTimeMillis() - t1);
            this.initServlet(servlet);
            this.fireContainerEvent("load", this);
            this.loadTime = System.currentTimeMillis() - t1;
        }
        finally {
            String log3;
            if (this.swallowOutput && (log3 = SystemLogHandler.stopCapture()) != null && log3.length() > 0) {
                if (this.getServletContext() != null) {
                    this.getServletContext().log(log3);
                } else {
                    out.println(log3);
                }
            }
        }
        return servlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initServlet(Servlet servlet) throws ServletException {
        if (this.instanceInitialized) {
            return;
        }
        try {
            if (Globals.IS_SECURITY_ENABLED) {
                boolean success = false;
                try {
                    Object[] args2 = new Object[]{this.facade};
                    SecurityUtil.doAsPrivilege("init", servlet, classType, args2);
                    success = true;
                }
                finally {
                    if (!success) {
                        SecurityUtil.remove(servlet);
                    }
                }
            } else {
                servlet.init(this.facade);
            }
            this.instanceInitialized = true;
        }
        catch (UnavailableException f) {
            this.unavailable(f);
            throw f;
        }
        catch (ServletException f) {
            throw f;
        }
        catch (Throwable f) {
            ExceptionUtils.handleThrowable(f);
            this.getServletContext().log(sm.getString("standardWrapper.initException", this.getName()), f);
            throw new ServletException(sm.getString("standardWrapper.initException", this.getName()), f);
        }
    }

    @Override
    public void removeInitParameter(String name2) {
        this.parametersLock.writeLock().lock();
        try {
            this.parameters.remove(name2);
        }
        finally {
            this.parametersLock.writeLock().unlock();
        }
        this.fireContainerEvent("removeInitParameter", name2);
    }

    @Override
    public void removeMapping(String mapping) {
        this.mappingsLock.writeLock().lock();
        try {
            this.mappings.remove(mapping);
        }
        finally {
            this.mappingsLock.writeLock().unlock();
        }
        if (this.parent.getState().equals((Object)LifecycleState.STARTED)) {
            this.fireContainerEvent("removeMapping", mapping);
        }
    }

    @Override
    public void removeSecurityReference(String name2) {
        this.referencesLock.writeLock().lock();
        try {
            this.references.remove(name2);
        }
        finally {
            this.referencesLock.writeLock().unlock();
        }
        this.fireContainerEvent("removeSecurityReference", name2);
    }

    @Override
    public void unavailable(UnavailableException unavailable) {
        this.getServletContext().log(sm.getString("standardWrapper.unavailable", this.getName()));
        if (unavailable == null) {
            this.setAvailable(Long.MAX_VALUE);
        } else if (unavailable.isPermanent()) {
            this.setAvailable(Long.MAX_VALUE);
        } else {
            int unavailableSeconds = unavailable.getUnavailableSeconds();
            if (unavailableSeconds <= 0) {
                unavailableSeconds = 60;
            }
            this.setAvailable(System.currentTimeMillis() + (long)unavailableSeconds * 1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void unload() throws ServletException {
        if (this.instance == null) {
            return;
        }
        this.unloading = true;
        if (this.countAllocated.get() > 0) {
            long delay = this.unloadDelay / 20L;
            for (int nRetries = 0; nRetries < 21 && this.countAllocated.get() > 0; ++nRetries) {
                if (nRetries % 10 == 0) {
                    this.log.info(sm.getString("standardWrapper.waiting", this.countAllocated.toString(), this.getName()));
                }
                try {
                    Thread.sleep(delay);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.instanceInitialized) {
            String log3;
            PrintStream out;
            block29: {
                out = System.out;
                if (this.swallowOutput) {
                    SystemLogHandler.startCapture();
                }
                try {
                    if (Globals.IS_SECURITY_ENABLED) {
                        try {
                            SecurityUtil.doAsPrivilege("destroy", this.instance);
                        }
                        finally {
                            SecurityUtil.remove(this.instance);
                        }
                    } else {
                        this.instance.destroy();
                    }
                    if (((Context)this.getParent()).getIgnoreAnnotations()) break block29;
                }
                catch (Throwable t) {
                    try {
                        t = ExceptionUtils.unwrapInvocationTargetException(t);
                        ExceptionUtils.handleThrowable(t);
                        this.fireContainerEvent("unload", this);
                        this.unloading = false;
                        throw new ServletException(sm.getString("standardWrapper.destroyException", this.getName()), t);
                    }
                    catch (Throwable throwable) {
                        String log4;
                        if (!((Context)this.getParent()).getIgnoreAnnotations()) {
                            try {
                                ((Context)this.getParent()).getInstanceManager().destroyInstance(this.instance);
                            }
                            catch (Throwable t2) {
                                ExceptionUtils.handleThrowable(t2);
                                this.log.error(sm.getString("standardWrapper.destroyInstance", this.getName()), t2);
                            }
                        }
                        if (this.swallowOutput && (log4 = SystemLogHandler.stopCapture()) != null && log4.length() > 0) {
                            if (this.getServletContext() != null) {
                                this.getServletContext().log(log4);
                            } else {
                                out.println(log4);
                            }
                        }
                        this.instance = null;
                        this.instanceInitialized = false;
                        throw throwable;
                    }
                }
                try {
                    ((Context)this.getParent()).getInstanceManager().destroyInstance(this.instance);
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                    this.log.error(sm.getString("standardWrapper.destroyInstance", this.getName()), t);
                }
            }
            if (this.swallowOutput && (log3 = SystemLogHandler.stopCapture()) != null && log3.length() > 0) {
                if (this.getServletContext() != null) {
                    this.getServletContext().log(log3);
                } else {
                    out.println(log3);
                }
            }
            this.instance = null;
            this.instanceInitialized = false;
        }
        this.instance = null;
        if (this.isJspServlet && this.jspMonitorON != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.jspMonitorON);
        }
        this.unloading = false;
        this.fireContainerEvent("unload", this);
    }

    @Override
    public String getInitParameter(String name2) {
        return this.findInitParameter(name2);
    }

    @Override
    public Enumeration<String> getInitParameterNames() {
        this.parametersLock.readLock().lock();
        try {
            Enumeration<String> enumeration = Collections.enumeration(this.parameters.keySet());
            return enumeration;
        }
        finally {
            this.parametersLock.readLock().unlock();
        }
    }

    @Override
    public ServletContext getServletContext() {
        if (this.parent == null) {
            return null;
        }
        if (!(this.parent instanceof Context)) {
            return null;
        }
        return ((Context)this.parent).getServletContext();
    }

    @Override
    public String getServletName() {
        return this.getName();
    }

    public long getProcessingTime() {
        return this.swValve.getProcessingTime();
    }

    public long getMaxTime() {
        return this.swValve.getMaxTime();
    }

    public long getMinTime() {
        return this.swValve.getMinTime();
    }

    @Deprecated
    public int getRequestCount() {
        return this.swValve.getRequestCount();
    }

    @Deprecated
    public int getErrorCount() {
        return this.swValve.getErrorCount();
    }

    @Override
    public void incrementErrorCount() {
        this.swValve.incrementErrorCount();
    }

    public long getLoadTime() {
        return this.loadTime;
    }

    public int getClassLoadTime() {
        return this.classLoadTime;
    }

    @Override
    public MultipartConfigElement getMultipartConfigElement() {
        return this.multipartConfigElement;
    }

    @Override
    public void setMultipartConfigElement(MultipartConfigElement multipartConfigElement) {
        this.multipartConfigElement = multipartConfigElement;
    }

    @Override
    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    @Override
    public void setAsyncSupported(boolean asyncSupported) {
        this.asyncSupported = asyncSupported;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected Method[] getAllDeclaredMethods(Class<?> c) {
        if (c.equals(HttpServlet.class)) {
            return null;
        }
        Method[] parentMethods = this.getAllDeclaredMethods(c.getSuperclass());
        Method[] thisMethods = c.getDeclaredMethods();
        if (thisMethods.length == 0) {
            return parentMethods;
        }
        if (parentMethods != null && parentMethods.length > 0) {
            Method[] allMethods = new Method[parentMethods.length + thisMethods.length];
            System.arraycopy(parentMethods, 0, allMethods, 0, parentMethods.length);
            System.arraycopy(thisMethods, 0, allMethods, parentMethods.length, thisMethods.length);
            thisMethods = allMethods;
        }
        return thisMethods;
    }

    @Override
    protected void startInternal() throws LifecycleException {
        Notification notification;
        if (this.getObjectName() != null) {
            notification = new Notification("j2ee.state.starting", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
        super.startInternal();
        this.setAvailable(0L);
        if (this.getObjectName() != null) {
            notification = new Notification("j2ee.state.running", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        Notification notification;
        this.setAvailable(Long.MAX_VALUE);
        if (this.getObjectName() != null) {
            notification = new Notification("j2ee.state.stopping", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
        try {
            this.unload();
        }
        catch (ServletException e) {
            this.getServletContext().log(sm.getString("standardWrapper.unloadException", this.getName()), e);
        }
        super.stopInternal();
        if (this.getObjectName() != null) {
            notification = new Notification("j2ee.state.stopped", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
        notification = new Notification("j2ee.object.deleted", this.getObjectName(), this.sequenceNumber++);
        this.broadcaster.sendNotification(notification);
    }

    @Override
    protected String getObjectNameKeyProperties() {
        StringBuilder keyProperties = new StringBuilder("j2eeType=Servlet");
        keyProperties.append(this.getWebModuleKeyProperties());
        keyProperties.append(",name=");
        String name2 = this.getName();
        if (Util.objectNameValueNeedsQuote(name2)) {
            name2 = ObjectName.quote(name2);
        }
        keyProperties.append(name2);
        keyProperties.append(this.getJ2EEKeyProperties());
        return keyProperties.toString();
    }

    private String getWebModuleKeyProperties() {
        StringBuilder keyProperties = new StringBuilder(",WebModule=//");
        String hostName = this.getParent().getParent().getName();
        if (hostName == null) {
            keyProperties.append("DEFAULT");
        } else {
            keyProperties.append(hostName);
        }
        String contextName = this.getParent().getName();
        if (!contextName.startsWith("/")) {
            keyProperties.append('/');
        }
        keyProperties.append(contextName);
        return keyProperties.toString();
    }

    private String getJ2EEKeyProperties() {
        StringBuilder keyProperties = new StringBuilder(",J2EEApplication=");
        StandardContext ctx = null;
        if (this.parent instanceof StandardContext) {
            ctx = (StandardContext)this.getParent();
        }
        if (ctx == null) {
            keyProperties.append("none");
        } else {
            keyProperties.append(ctx.getJ2EEApplication());
        }
        keyProperties.append(",J2EEServer=");
        if (ctx == null) {
            keyProperties.append("none");
        } else {
            keyProperties.append(ctx.getJ2EEServer());
        }
        return keyProperties.toString();
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter2, Object object) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener, filter2, object);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.notificationInfo == null) {
            this.notificationInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"j2ee.object.created"}, Notification.class.getName(), "servlet is created"), new MBeanNotificationInfo(new String[]{"j2ee.state.starting"}, Notification.class.getName(), "servlet is starting"), new MBeanNotificationInfo(new String[]{"j2ee.state.running"}, Notification.class.getName(), "servlet is running"), new MBeanNotificationInfo(new String[]{"j2ee.state.stopped"}, Notification.class.getName(), "servlet start to stopped"), new MBeanNotificationInfo(new String[]{"j2ee.object.stopped"}, Notification.class.getName(), "servlet is stopped"), new MBeanNotificationInfo(new String[]{"j2ee.object.deleted"}, Notification.class.getName(), "servlet is deleted")};
        }
        return this.notificationInfo;
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter2, Object object) throws IllegalArgumentException {
        this.broadcaster.addNotificationListener(listener, filter2, object);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener);
    }
}

