/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.util.ArrayList;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.catalina.Contained;
import org.apache.catalina.Container;
import org.apache.catalina.JmxEnabled;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Valve;
import org.apache.catalina.util.LifecycleBase;
import org.apache.catalina.util.ToStringUtil;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public class StandardPipeline
extends LifecycleBase
implements Pipeline {
    private static final Log log = LogFactory.getLog(StandardPipeline.class);
    private static final StringManager sm = StringManager.getManager(StandardPipeline.class);
    protected Valve basic = null;
    protected Container container = null;
    protected Valve first = null;

    public StandardPipeline() {
        this(null);
    }

    public StandardPipeline(Container container) {
        this.setContainer(container);
    }

    @Override
    public boolean isAsyncSupported() {
        boolean supported;
        Valve valve = this.first != null ? this.first : this.basic;
        for (supported = true; supported && valve != null; supported &= valve.isAsyncSupported(), valve = valve.getNext()) {
        }
        return supported;
    }

    @Override
    public void findNonAsyncValves(Set<String> result2) {
        Valve valve;
        Valve valve2 = valve = this.first != null ? this.first : this.basic;
        while (valve != null) {
            if (!valve.isAsyncSupported()) {
                result2.add(valve.getClass().getName());
            }
            valve = valve.getNext();
        }
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        this.container = container;
    }

    @Override
    protected void initInternal() {
    }

    @Override
    protected void startInternal() throws LifecycleException {
        Valve current2 = this.first;
        if (current2 == null) {
            current2 = this.basic;
        }
        while (current2 != null) {
            if (current2 instanceof Lifecycle) {
                ((Lifecycle)((Object)current2)).start();
            }
            current2 = current2.getNext();
        }
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        Valve current2 = this.first;
        if (current2 == null) {
            current2 = this.basic;
        }
        while (current2 != null) {
            if (current2 instanceof Lifecycle) {
                ((Lifecycle)((Object)current2)).stop();
            }
            current2 = current2.getNext();
        }
    }

    @Override
    protected void destroyInternal() {
        Valve[] valves;
        for (Valve valve : valves = this.getValves()) {
            this.removeValve(valve);
        }
    }

    public String toString() {
        return ToStringUtil.toString(this);
    }

    @Override
    public Valve getBasic() {
        return this.basic;
    }

    @Override
    public void setBasic(Valve valve) {
        Valve oldBasic = this.basic;
        if (oldBasic == valve) {
            return;
        }
        if (oldBasic != null) {
            if (this.getState().isAvailable() && oldBasic instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)oldBasic)).stop();
                }
                catch (LifecycleException e) {
                    log.error(sm.getString("standardPipeline.basic.stop"), e);
                }
            }
            if (oldBasic instanceof Contained) {
                try {
                    ((Contained)((Object)oldBasic)).setContainer(null);
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                }
            }
        }
        if (valve == null) {
            return;
        }
        if (valve instanceof Contained) {
            ((Contained)((Object)valve)).setContainer(this.container);
        }
        if (this.getState().isAvailable() && valve instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)valve)).start();
            }
            catch (LifecycleException e) {
                log.error(sm.getString("standardPipeline.basic.start"), e);
                return;
            }
        }
        for (Valve current2 = this.first; current2 != null; current2 = current2.getNext()) {
            if (current2.getNext() != oldBasic) continue;
            current2.setNext(valve);
            break;
        }
        this.basic = valve;
    }

    @Override
    public void addValve(Valve valve) {
        if (valve instanceof Contained) {
            ((Contained)((Object)valve)).setContainer(this.container);
        }
        if (this.getState().isAvailable() && valve instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)valve)).start();
            }
            catch (LifecycleException e) {
                log.error(sm.getString("standardPipeline.valve.start"), e);
            }
        }
        if (this.first == null) {
            this.first = valve;
            valve.setNext(this.basic);
        } else {
            for (Valve current2 = this.first; current2 != null; current2 = current2.getNext()) {
                if (current2.getNext() != this.basic) continue;
                current2.setNext(valve);
                valve.setNext(this.basic);
                break;
            }
        }
        this.container.fireContainerEvent("addValve", valve);
    }

    @Override
    public Valve[] getValves() {
        ArrayList<Valve> valveList = new ArrayList<Valve>();
        Valve current2 = this.first;
        if (current2 == null) {
            current2 = this.basic;
        }
        while (current2 != null) {
            valveList.add(current2);
            current2 = current2.getNext();
        }
        return valveList.toArray(new Valve[0]);
    }

    public ObjectName[] getValveObjectNames() {
        ArrayList<ObjectName> valveList = new ArrayList<ObjectName>();
        Valve current2 = this.first;
        if (current2 == null) {
            current2 = this.basic;
        }
        while (current2 != null) {
            if (current2 instanceof JmxEnabled) {
                valveList.add(((JmxEnabled)((Object)current2)).getObjectName());
            }
            current2 = current2.getNext();
        }
        return valveList.toArray(new ObjectName[0]);
    }

    @Override
    public void removeValve(Valve valve) {
        Valve current2;
        if (this.first == valve) {
            this.first = this.first.getNext();
            current2 = null;
        } else {
            current2 = this.first;
        }
        while (current2 != null) {
            if (current2.getNext() == valve) {
                current2.setNext(valve.getNext());
                break;
            }
            current2 = current2.getNext();
        }
        if (this.first == this.basic) {
            this.first = null;
        }
        if (valve instanceof Contained) {
            ((Contained)((Object)valve)).setContainer(null);
        }
        if (valve instanceof Lifecycle) {
            if (this.getState().isAvailable()) {
                try {
                    ((Lifecycle)((Object)valve)).stop();
                }
                catch (LifecycleException e) {
                    log.error(sm.getString("standardPipeline.valve.stop"), e);
                }
            }
            try {
                ((Lifecycle)((Object)valve)).destroy();
            }
            catch (LifecycleException e) {
                log.error(sm.getString("standardPipeline.valve.destroy"), e);
            }
        }
        this.container.fireContainerEvent("removeValve", valve);
    }

    @Override
    public Valve getFirst() {
        if (this.first != null) {
            return this.first;
        }
        return this.basic;
    }
}

