/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.descriptor.web.ContextEnvironment;
import org.apache.tomcat.util.res.StringManager;

public class ContextNamingInfoListener
implements LifecycleListener {
    private static final String PATH_ENTRY_NAME = "context/path";
    private static final String ENCODED_PATH_ENTRY_NAME = "context/encodedPath";
    private static final String WEBAPP_VERSION_ENTRY_NAME = "context/webappVersion";
    private static final String NAME_ENTRY_NAME = "context/name";
    private static final String BASE_NAME_ENTRY_NAME = "context/baseName";
    private static final String DISPLAY_NAME_ENTRY_NAME = "context/displayName";
    private static final Log log = LogFactory.getLog(ContextNamingInfoListener.class);
    private static final StringManager sm = StringManager.getManager(ContextNamingInfoListener.class);
    private boolean emptyOnRoot = true;

    public void setEmptyOnRoot(boolean emptyOnRoot) {
        this.emptyOnRoot = emptyOnRoot;
    }

    public boolean isEmptyOnRoot() {
        return this.emptyOnRoot;
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event2) {
        if (event2.getType().equals("configure_start")) {
            if (!(event2.getLifecycle() instanceof Context)) {
                log.warn(sm.getString("listener.notContext", event2.getLifecycle().getClass().getSimpleName()));
                return;
            }
            Context context = (Context)event2.getLifecycle();
            String path2 = context.getPath();
            String encodedPath = context.getEncodedPath();
            Object name2 = context.getName();
            if (!this.emptyOnRoot && path2.isEmpty()) {
                encodedPath = "/";
                path2 = "/";
                name2 = "ROOT" + (String)name2;
            }
            this.addEnvEntry(context, PATH_ENTRY_NAME, path2);
            this.addEnvEntry(context, ENCODED_PATH_ENTRY_NAME, encodedPath);
            this.addEnvEntry(context, WEBAPP_VERSION_ENTRY_NAME, context.getWebappVersion());
            this.addEnvEntry(context, NAME_ENTRY_NAME, (String)name2);
            this.addEnvEntry(context, BASE_NAME_ENTRY_NAME, context.getBaseName());
            this.addEnvEntry(context, DISPLAY_NAME_ENTRY_NAME, context.getDisplayName());
        }
    }

    private void addEnvEntry(Context context, String name2, String value2) {
        ContextEnvironment ce = new ContextEnvironment();
        ce.setName(name2);
        ce.setOverride(true);
        ce.setType("java.lang.String");
        ce.setValue(value2);
        if (log.isDebugEnabled()) {
            log.info(sm.getString("contextNamingInfoListener.envEntry", name2, value2));
        }
        context.getNamingResources().addEnvironment(ce);
    }
}

