/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;

public class AsyncListenerWrapper {
    private AsyncListener listener = null;
    private ServletRequest servletRequest = null;
    private ServletResponse servletResponse = null;

    public void fireOnStartAsync(AsyncEvent event2) throws IOException {
        this.listener.onStartAsync(this.customizeEvent(event2));
    }

    public void fireOnComplete(AsyncEvent event2) throws IOException {
        this.listener.onComplete(this.customizeEvent(event2));
    }

    public void fireOnTimeout(AsyncEvent event2) throws IOException {
        this.listener.onTimeout(this.customizeEvent(event2));
    }

    public void fireOnError(AsyncEvent event2) throws IOException {
        this.listener.onError(this.customizeEvent(event2));
    }

    public AsyncListener getListener() {
        return this.listener;
    }

    public void setListener(AsyncListener listener) {
        this.listener = listener;
    }

    public void setServletRequest(ServletRequest servletRequest) {
        this.servletRequest = servletRequest;
    }

    public void setServletResponse(ServletResponse servletResponse) {
        this.servletResponse = servletResponse;
    }

    private AsyncEvent customizeEvent(AsyncEvent event2) {
        if (this.servletRequest != null && this.servletResponse != null) {
            return new AsyncEvent(event2.getAsyncContext(), this.servletRequest, this.servletResponse, event2.getThrowable());
        }
        return event2;
    }
}

