/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.PushBuilder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.catalina.Context;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Request;
import org.apache.catalina.util.SessionConfig;
import org.apache.coyote.ActionCode;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.collections.CaseInsensitiveKeyMap;
import org.apache.tomcat.util.http.CookieProcessor;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.res.StringManager;

public class ApplicationPushBuilder
implements PushBuilder {
    private static final StringManager sm = StringManager.getManager(ApplicationPushBuilder.class);
    private static final Set<String> DISALLOWED_METHODS = new HashSet<String>();
    private final HttpServletRequest baseRequest;
    private final Request catalinaRequest;
    private final org.apache.coyote.Request coyoteRequest;
    private final String sessionCookieName;
    private final String sessionPathParameterName;
    private final boolean addSessionCookie;
    private final boolean addSessionPathParameter;
    private final Map<String, List<String>> headers = new CaseInsensitiveKeyMap<List<String>>();
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private String method = "GET";
    private String path;
    private String queryString;
    private String sessionId;
    private String userName;

    public ApplicationPushBuilder(Request catalinaRequest, HttpServletRequest request) {
        this.baseRequest = request;
        this.catalinaRequest = catalinaRequest;
        this.coyoteRequest = catalinaRequest.getCoyoteRequest();
        Enumeration<String> headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = headerNames.nextElement();
            ArrayList<String> values2 = new ArrayList<String>();
            this.headers.put(headerName, values2);
            Enumeration<String> headerValues = request.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                values2.add(headerValues.nextElement());
            }
        }
        this.headers.remove("if-match");
        this.headers.remove("if-none-match");
        this.headers.remove("if-modified-since");
        this.headers.remove("if-unmodified-since");
        this.headers.remove("if-range");
        this.headers.remove("range");
        this.headers.remove("expect");
        this.headers.remove("authorization");
        this.headers.remove("referer");
        this.headers.remove("cookie");
        StringBuffer referer = request.getRequestURL();
        if (request.getQueryString() != null) {
            referer.append('?');
            referer.append(request.getQueryString());
        }
        this.addHeader("referer", referer.toString());
        Context context = catalinaRequest.getContext();
        this.sessionCookieName = SessionConfig.getSessionCookieName(context);
        this.sessionPathParameterName = SessionConfig.getSessionUriParamName(context);
        HttpSession session = request.getSession(false);
        if (session != null) {
            this.sessionId = session.getId();
        }
        if (this.sessionId == null) {
            this.sessionId = request.getRequestedSessionId();
        }
        if (!request.isRequestedSessionIdFromCookie() && !request.isRequestedSessionIdFromURL() && this.sessionId != null) {
            Set<SessionTrackingMode> sessionTrackingModes = request.getServletContext().getEffectiveSessionTrackingModes();
            this.addSessionCookie = sessionTrackingModes.contains((Object)SessionTrackingMode.COOKIE);
            this.addSessionPathParameter = sessionTrackingModes.contains((Object)SessionTrackingMode.URL);
        } else {
            this.addSessionCookie = request.isRequestedSessionIdFromCookie();
            this.addSessionPathParameter = request.isRequestedSessionIdFromURL();
        }
        if (request.getCookies() != null) {
            this.cookies.addAll(Arrays.asList(request.getCookies()));
        }
        for (Cookie responseCookie : catalinaRequest.getResponse().getCookies()) {
            if (responseCookie.getMaxAge() < 0) {
                this.cookies.removeIf(cookie -> cookie.getName().equals(responseCookie.getName()));
                continue;
            }
            this.cookies.add(new Cookie(responseCookie.getName(), responseCookie.getValue()));
        }
        if (this.cookies.size() > 0) {
            ArrayList<String> cookieValues = new ArrayList<String>(1);
            cookieValues.add(ApplicationPushBuilder.generateCookieHeader(this.cookies, catalinaRequest.getContext().getCookieProcessor()));
            this.headers.put("cookie", cookieValues);
        }
        if (catalinaRequest.getPrincipal() != null) {
            if (session == null || catalinaRequest.getSessionInternal(false).getPrincipal() == null || !(context.getAuthenticator() instanceof AuthenticatorBase) || !((AuthenticatorBase)context.getAuthenticator()).getCache()) {
                this.userName = catalinaRequest.getPrincipal().getName();
            }
            this.setHeader("authorization", "x-push");
        }
    }

    @Override
    public PushBuilder path(String path2) {
        if (path2.startsWith("/")) {
            this.path = path2;
        } else {
            String contextPath = this.baseRequest.getContextPath();
            int len = contextPath.length() + path2.length() + 1;
            StringBuilder sb = new StringBuilder(len);
            sb.append(contextPath);
            sb.append('/');
            sb.append(path2);
            this.path = sb.toString();
        }
        return this;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public PushBuilder method(String method2) {
        String upperMethod = method2.trim().toUpperCase(Locale.ENGLISH);
        if (DISALLOWED_METHODS.contains(upperMethod) || upperMethod.length() == 0) {
            throw new IllegalArgumentException(sm.getString("applicationPushBuilder.methodInvalid", upperMethod));
        }
        if (!HttpParser.isToken(upperMethod)) {
            throw new IllegalArgumentException(sm.getString("applicationPushBuilder.methodNotToken", upperMethod));
        }
        this.method = method2;
        return this;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public PushBuilder queryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public PushBuilder sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public PushBuilder addHeader(String name2, String value2) {
        this.headers.computeIfAbsent(name2, k -> new ArrayList()).add(value2);
        return this;
    }

    @Override
    public PushBuilder setHeader(String name2, String value2) {
        List<String> values2 = this.headers.get(name2);
        if (values2 == null) {
            values2 = new ArrayList<String>();
            this.headers.put(name2, values2);
        } else {
            values2.clear();
        }
        values2.add(value2);
        return this;
    }

    @Override
    public PushBuilder removeHeader(String name2) {
        this.headers.remove(name2);
        return this;
    }

    @Override
    public Set<String> getHeaderNames() {
        return Collections.unmodifiableSet(this.headers.keySet());
    }

    @Override
    public String getHeader(String name2) {
        List<String> values2 = this.headers.get(name2);
        if (values2 == null) {
            return null;
        }
        return values2.get(0);
    }

    @Override
    public void push() {
        Object pushPath;
        if (this.path == null) {
            throw new IllegalStateException(sm.getString("pushBuilder.noPath"));
        }
        org.apache.coyote.Request pushTarget = new org.apache.coyote.Request();
        pushTarget.method().setString(this.method);
        pushTarget.serverName().setString(this.baseRequest.getServerName());
        pushTarget.setServerPort(this.baseRequest.getServerPort());
        pushTarget.scheme().setString(this.baseRequest.getScheme());
        for (Map.Entry<String, List<String>> header : this.headers.entrySet()) {
            for (String value2 : header.getValue()) {
                pushTarget.getMimeHeaders().addValue(header.getKey()).setString(value2);
            }
        }
        int queryIndex = this.path.indexOf(63);
        String pushQueryString = null;
        if (queryIndex > -1) {
            pushPath = this.path.substring(0, queryIndex);
            if (queryIndex + 1 < this.path.length()) {
                pushQueryString = this.path.substring(queryIndex + 1);
            }
        } else {
            pushPath = this.path;
        }
        if (this.sessionId != null) {
            if (this.addSessionPathParameter) {
                pushPath = (String)pushPath + ";" + this.sessionPathParameterName + "=" + this.sessionId;
                pushTarget.addPathParameter(this.sessionPathParameterName, this.sessionId);
            }
            if (this.addSessionCookie) {
                String sessionCookieHeader = this.sessionCookieName + "=" + this.sessionId;
                MessageBytes mb = pushTarget.getMimeHeaders().getValue("cookie");
                if (mb == null) {
                    mb = pushTarget.getMimeHeaders().addValue("cookie");
                    mb.setString(sessionCookieHeader);
                } else {
                    mb.setString(mb.getString() + ";" + sessionCookieHeader);
                }
            }
        }
        pushTarget.requestURI().setString((String)pushPath);
        pushTarget.decodedURI().setString(ApplicationPushBuilder.decode((String)pushPath, this.catalinaRequest.getConnector().getURICharset()));
        if (pushQueryString == null && this.queryString != null) {
            pushTarget.queryString().setString(this.queryString);
        } else if (pushQueryString != null && this.queryString == null) {
            pushTarget.queryString().setString(pushQueryString);
        } else if (pushQueryString != null && this.queryString != null) {
            pushTarget.queryString().setString(pushQueryString + "&" + this.queryString);
        }
        if (this.userName != null) {
            pushTarget.getRemoteUser().setString(this.userName);
            pushTarget.setRemoteUserNeedsAuthorization(true);
        }
        this.coyoteRequest.action(ActionCode.PUSH_REQUEST, pushTarget);
        this.path = null;
        this.headers.remove("if-none-match");
        this.headers.remove("if-modified-since");
    }

    static String decode(String input, Charset charset) {
        int start2 = input.indexOf(37);
        int end2 = 0;
        if (start2 == -1) {
            return input;
        }
        StringBuilder result2 = new StringBuilder(input.length());
        while (start2 != -1) {
            result2.append(input.substring(end2, start2));
            for (end2 = start2 + 3; end2 < input.length() && input.charAt(end2) == '%'; end2 += 3) {
            }
            result2.append(ApplicationPushBuilder.decodePercentSequence(input.substring(start2, end2), charset));
            start2 = input.indexOf(37, end2);
        }
        result2.append(input.substring(end2));
        return result2.toString();
    }

    private static String decodePercentSequence(String sequence, Charset charset) {
        byte[] bytes2 = new byte[sequence.length() / 3];
        for (int i2 = 0; i2 < bytes2.length; i2 += 3) {
            bytes2[i2] = (byte)((HexUtils.getDec(sequence.charAt(1 + 3 * i2)) << 4) + HexUtils.getDec(sequence.charAt(2 + 3 * i2)));
        }
        return new String(bytes2, charset);
    }

    private static String generateCookieHeader(List<Cookie> cookies, CookieProcessor cookieProcessor) {
        StringBuilder result2 = new StringBuilder();
        boolean first2 = true;
        for (Cookie cookie : cookies) {
            if (first2) {
                first2 = false;
            } else {
                result2.append(';');
            }
            result2.append(cookieProcessor.generateHeader(cookie, null));
        }
        return result2.toString();
    }

    static {
        DISALLOWED_METHODS.add("POST");
        DISALLOWED_METHODS.add("PUT");
        DISALLOWED_METHODS.add("DELETE");
        DISALLOWED_METHODS.add("CONNECT");
        DISALLOWED_METHODS.add("OPTIONS");
        DISALLOWED_METHODS.add("TRACE");
    }
}

