/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.http.Part;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.tomcat.util.http.fileupload.FileItem;
import org.apache.tomcat.util.http.fileupload.ParameterParser;
import org.apache.tomcat.util.http.fileupload.disk.DiskFileItem;
import org.apache.tomcat.util.http.parser.HttpParser;

public class ApplicationPart
implements Part {
    private final FileItem fileItem;
    private final File location;

    public ApplicationPart(FileItem fileItem, File location) {
        this.fileItem = fileItem;
        this.location = location;
    }

    @Override
    public void delete() throws IOException {
        this.fileItem.delete();
    }

    @Override
    public String getContentType() {
        return this.fileItem.getContentType();
    }

    @Override
    public String getHeader(String name2) {
        if (this.fileItem instanceof DiskFileItem) {
            return this.fileItem.getHeaders().getHeader(name2);
        }
        return null;
    }

    @Override
    public Collection<String> getHeaderNames() {
        if (this.fileItem instanceof DiskFileItem) {
            LinkedHashSet<String> headerNames = new LinkedHashSet<String>();
            Iterator<String> iter = this.fileItem.getHeaders().getHeaderNames();
            while (iter.hasNext()) {
                headerNames.add(iter.next());
            }
            return headerNames;
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<String> getHeaders(String name2) {
        if (this.fileItem instanceof DiskFileItem) {
            LinkedHashSet<String> headers = new LinkedHashSet<String>();
            Iterator<String> iter = this.fileItem.getHeaders().getHeaders(name2);
            while (iter.hasNext()) {
                headers.add(iter.next());
            }
            return headers;
        }
        return Collections.emptyList();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.fileItem.getInputStream();
    }

    @Override
    public String getName() {
        return this.fileItem.getFieldName();
    }

    @Override
    public long getSize() {
        return this.fileItem.getSize();
    }

    @Override
    public void write(String fileName) throws IOException {
        File file2 = new File(fileName);
        if (!file2.isAbsolute()) {
            file2 = new File(this.location, fileName);
        }
        try {
            this.fileItem.write(file2);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public String getString(String encoding2) throws UnsupportedEncodingException, IOException {
        return this.fileItem.getString(encoding2);
    }

    @Override
    public String getSubmittedFileName() {
        String cdl;
        String fileName = null;
        String cd = this.getHeader("Content-Disposition");
        if (cd != null && ((cdl = cd.toLowerCase(Locale.ENGLISH)).startsWith("form-data") || cdl.startsWith("attachment"))) {
            ParameterParser paramParser = new ParameterParser();
            paramParser.setLowerCaseNames(true);
            Map<String, String> params2 = paramParser.parse(cd, ';');
            if (params2.containsKey("filename")) {
                fileName = params2.get("filename");
                fileName = fileName != null ? (fileName.indexOf(92) > -1 ? HttpParser.unquote(fileName.trim()) : fileName.trim()) : "";
            }
        }
        return fileName;
    }
}

