/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestWrapper;
import jakarta.servlet.http.HttpServletMapping;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.PushBuilder;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.util.ParameterMap;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.URLEncoder;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.Parameters;
import org.apache.tomcat.util.res.StringManager;

class ApplicationHttpRequest
extends HttpServletRequestWrapper {
    private static final StringManager sm = StringManager.getManager(ApplicationHttpRequest.class);
    protected static final String[] specials = new String[]{"jakarta.servlet.include.request_uri", "jakarta.servlet.include.context_path", "jakarta.servlet.include.servlet_path", "jakarta.servlet.include.path_info", "jakarta.servlet.include.query_string", "jakarta.servlet.include.mapping", "jakarta.servlet.forward.request_uri", "jakarta.servlet.forward.context_path", "jakarta.servlet.forward.servlet_path", "jakarta.servlet.forward.path_info", "jakarta.servlet.forward.query_string", "jakarta.servlet.forward.mapping"};
    private static final Map<String, Integer> specialsMap = new HashMap<String, Integer>();
    private static final int shortestSpecialNameLength;
    private static final int SPECIALS_FIRST_FORWARD_INDEX = 6;
    protected final Context context;
    protected String contextPath = null;
    protected final boolean crossContext;
    protected DispatcherType dispatcherType = null;
    protected Map<String, String[]> parameters = null;
    private boolean parsedParams = false;
    protected String pathInfo = null;
    private String queryParamString = null;
    protected String queryString = null;
    protected Object requestDispatcherPath = null;
    protected String requestURI = null;
    protected String servletPath = null;
    private HttpServletMapping mapping = null;
    protected Session session = null;
    protected final Object[] specialAttributes = new Object[specials.length];

    ApplicationHttpRequest(HttpServletRequest request, Context context, boolean crossContext) {
        super(request);
        this.context = context;
        this.crossContext = crossContext;
        this.setRequest(request);
    }

    @Override
    public ServletContext getServletContext() {
        if (this.context == null) {
            return null;
        }
        return this.context.getServletContext();
    }

    @Override
    public Object getAttribute(String name2) {
        if (name2.equals("org.apache.catalina.core.DISPATCHER_TYPE")) {
            return this.dispatcherType;
        }
        if (name2.equals("org.apache.catalina.core.DISPATCHER_REQUEST_PATH")) {
            if (this.requestDispatcherPath != null) {
                return this.requestDispatcherPath.toString();
            }
            return null;
        }
        int pos2 = this.getSpecial(name2);
        if (pos2 == -1) {
            return this.getRequest().getAttribute(name2);
        }
        if (this.specialAttributes[pos2] == null && this.specialAttributes[6] == null && pos2 >= 6) {
            return this.getRequest().getAttribute(name2);
        }
        return this.specialAttributes[pos2];
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return new AttributeNamesEnumerator();
    }

    @Override
    public void removeAttribute(String name2) {
        if (!this.removeSpecial(name2)) {
            this.getRequest().removeAttribute(name2);
        }
    }

    @Override
    public void setAttribute(String name2, Object value2) {
        if (name2.equals("org.apache.catalina.core.DISPATCHER_TYPE")) {
            this.dispatcherType = (DispatcherType)((Object)value2);
            return;
        }
        if (name2.equals("org.apache.catalina.core.DISPATCHER_REQUEST_PATH")) {
            this.requestDispatcherPath = value2;
            return;
        }
        if (!this.setSpecial(name2, value2)) {
            this.getRequest().setAttribute(name2, value2);
        }
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path2) {
        if (this.context == null) {
            return null;
        }
        if (path2 == null) {
            return null;
        }
        int fragmentPos = path2.indexOf(35);
        if (fragmentPos > -1) {
            this.context.getLogger().warn(sm.getString("applicationHttpRequest.fragmentInDispatchPath", path2));
            path2 = path2.substring(0, fragmentPos);
        }
        if (path2.startsWith("/")) {
            return this.context.getServletContext().getRequestDispatcher(path2);
        }
        String servletPath = (String)this.getAttribute("jakarta.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = this.getServletPath();
        }
        String pathInfo = this.getPathInfo();
        Object requestPath = null;
        requestPath = pathInfo == null ? servletPath : servletPath + pathInfo;
        int pos2 = ((String)requestPath).lastIndexOf(47);
        String relative = null;
        relative = this.context.getDispatchersUseEncodedPaths() ? (pos2 >= 0 ? URLEncoder.DEFAULT.encode(((String)requestPath).substring(0, pos2 + 1), StandardCharsets.UTF_8) + path2 : URLEncoder.DEFAULT.encode((String)requestPath, StandardCharsets.UTF_8) + path2) : (pos2 >= 0 ? ((String)requestPath).substring(0, pos2 + 1) + path2 : (String)requestPath + path2);
        return this.context.getServletContext().getRequestDispatcher(relative);
    }

    @Override
    public DispatcherType getDispatcherType() {
        return this.dispatcherType;
    }

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public String getParameter(String name2) {
        this.parseParameters();
        String[] value2 = this.parameters.get(name2);
        if (value2 == null) {
            return null;
        }
        return value2[0];
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        this.parseParameters();
        return this.parameters;
    }

    @Override
    public Enumeration<String> getParameterNames() {
        this.parseParameters();
        return Collections.enumeration(this.parameters.keySet());
    }

    @Override
    public String[] getParameterValues(String name2) {
        this.parseParameters();
        return this.parameters.get(name2);
    }

    @Override
    public String getPathInfo() {
        return this.pathInfo;
    }

    @Override
    public String getPathTranslated() {
        if (this.getPathInfo() == null || this.getServletContext() == null) {
            return null;
        }
        return this.getServletContext().getRealPath(this.getPathInfo());
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public String getRequestURI() {
        return this.requestURI;
    }

    @Override
    public StringBuffer getRequestURL() {
        return RequestUtil.getRequestURL(this);
    }

    @Override
    public String getServletPath() {
        return this.servletPath;
    }

    @Override
    public HttpServletMapping getHttpServletMapping() {
        return this.mapping;
    }

    @Override
    public HttpSession getSession() {
        return this.getSession(true);
    }

    @Override
    public HttpSession getSession(boolean create2) {
        if (this.crossContext) {
            if (this.context == null) {
                return null;
            }
            if (this.session != null && this.session.isValid()) {
                return this.session.getSession();
            }
            HttpSession other = super.getSession(false);
            if (create2 && other == null) {
                other = super.getSession(true);
            }
            if (other != null) {
                Session localSession = null;
                try {
                    localSession = this.context.getManager().findSession(other.getId());
                    if (localSession != null && !localSession.isValid()) {
                        localSession = null;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (localSession == null && create2) {
                    localSession = this.context.getManager().createSession(other.getId());
                }
                if (localSession != null) {
                    localSession.access();
                    this.session = localSession;
                    return this.session.getSession();
                }
            }
            return null;
        }
        return super.getSession(create2);
    }

    @Override
    public boolean isRequestedSessionIdValid() {
        if (this.crossContext) {
            String requestedSessionId = this.getRequestedSessionId();
            if (requestedSessionId == null) {
                return false;
            }
            if (this.context == null) {
                return false;
            }
            Manager manager = this.context.getManager();
            if (manager == null) {
                return false;
            }
            Session session = null;
            try {
                session = manager.findSession(requestedSessionId);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return session != null && session.isValid();
        }
        return super.isRequestedSessionIdValid();
    }

    @Override
    public PushBuilder newPushBuilder() {
        ServletRequest current2 = this.getRequest();
        while (current2 instanceof ServletRequestWrapper) {
            current2 = ((ServletRequestWrapper)current2).getRequest();
        }
        if (current2 instanceof RequestFacade) {
            return ((RequestFacade)current2).newPushBuilder(this);
        }
        return null;
    }

    public void recycle() {
        if (this.session != null) {
            try {
                this.session.endAccess();
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                this.context.getLogger().warn(sm.getString("applicationHttpRequest.sessionEndAccessFail"), t);
            }
        }
    }

    void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    void setRequest(HttpServletRequest request) {
        super.setRequest(request);
        this.dispatcherType = (DispatcherType)((Object)request.getAttribute("org.apache.catalina.core.DISPATCHER_TYPE"));
        this.requestDispatcherPath = request.getAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH");
        this.contextPath = request.getContextPath();
        this.pathInfo = request.getPathInfo();
        this.queryString = request.getQueryString();
        this.requestURI = request.getRequestURI();
        this.servletPath = request.getServletPath();
        this.mapping = request.getHttpServletMapping();
    }

    void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    void parseParameters() {
        if (this.parsedParams) {
            return;
        }
        this.parameters = new ParameterMap<String, String[]>();
        this.parameters.putAll(this.getRequest().getParameterMap());
        this.mergeParameters();
        ((ParameterMap)this.parameters).setLocked(true);
        this.parsedParams = true;
    }

    void setQueryParams(String queryString) {
        this.queryParamString = queryString;
    }

    void setMapping(HttpServletMapping mapping) {
        this.mapping = mapping;
    }

    protected boolean isSpecial(String name2) {
        if (name2.length() < shortestSpecialNameLength) {
            return false;
        }
        return specialsMap.containsKey(name2);
    }

    protected int getSpecial(String name2) {
        if (name2.length() < shortestSpecialNameLength) {
            return -1;
        }
        Integer index2 = specialsMap.get(name2);
        if (index2 == null) {
            return -1;
        }
        return index2;
    }

    protected boolean setSpecial(String name2, Object value2) {
        if (name2.length() < shortestSpecialNameLength) {
            return false;
        }
        Integer index2 = specialsMap.get(name2);
        if (index2 == null) {
            return false;
        }
        this.specialAttributes[index2.intValue()] = value2;
        return true;
    }

    protected boolean removeSpecial(String name2) {
        return this.setSpecial(name2, null);
    }

    private String[] mergeValues(String[] values1, String[] values2) {
        ArrayList<String> results = new ArrayList<String>();
        if (values1 != null) {
            results.addAll(Arrays.asList(values1));
        }
        if (values2 != null) {
            results.addAll(Arrays.asList(values2));
        }
        return results.toArray(new String[0]);
    }

    private void mergeParameters() {
        if (this.queryParamString == null || this.queryParamString.length() < 1) {
            return;
        }
        Parameters paramParser = new Parameters();
        MessageBytes queryMB = MessageBytes.newInstance();
        queryMB.setString(this.queryParamString);
        String encoding2 = this.getCharacterEncoding();
        Charset charset = null;
        if (encoding2 != null) {
            try {
                charset = B2CConverter.getCharset(encoding2);
                queryMB.setCharset(charset);
            }
            catch (UnsupportedEncodingException e) {
                charset = StandardCharsets.ISO_8859_1;
            }
        }
        paramParser.setQuery(queryMB);
        paramParser.setQueryStringCharset(charset);
        paramParser.handleQueryParameters();
        Enumeration<String> dispParamNames = paramParser.getParameterNames();
        while (dispParamNames.hasMoreElements()) {
            String dispParamName = dispParamNames.nextElement();
            String[] dispParamValues = paramParser.getParameterValues(dispParamName);
            String[] originalValues = this.parameters.get(dispParamName);
            if (originalValues == null) {
                this.parameters.put(dispParamName, dispParamValues);
                continue;
            }
            this.parameters.put(dispParamName, this.mergeValues(dispParamValues, originalValues));
        }
    }

    static {
        for (int i2 = 0; i2 < specials.length; ++i2) {
            specialsMap.put(specials[i2], i2);
        }
        shortestSpecialNameLength = specialsMap.keySet().stream().mapToInt(s2 -> s2.length()).min().getAsInt();
    }

    protected class AttributeNamesEnumerator
    implements Enumeration<String> {
        protected int pos = -1;
        protected final int last;
        protected final Enumeration<String> parentEnumeration;
        protected String next = null;

        public AttributeNamesEnumerator() {
            int last2 = -1;
            this.parentEnumeration = ApplicationHttpRequest.this.getRequest().getAttributeNames();
            for (int i2 = ApplicationHttpRequest.this.specialAttributes.length - 1; i2 >= 0; --i2) {
                if (ApplicationHttpRequest.this.getAttribute(specials[i2]) == null) continue;
                last2 = i2;
                break;
            }
            this.last = last2;
        }

        @Override
        public boolean hasMoreElements() {
            return this.pos != this.last || this.next != null || (this.next = this.findNext()) != null;
        }

        @Override
        public String nextElement() {
            if (this.pos != this.last) {
                for (int i2 = this.pos + 1; i2 <= this.last; ++i2) {
                    if (ApplicationHttpRequest.this.getAttribute(specials[i2]) == null) continue;
                    this.pos = i2;
                    return specials[i2];
                }
            }
            String result2 = this.next;
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.next = this.findNext();
            return result2;
        }

        protected String findNext() {
            String result2 = null;
            while (result2 == null && this.parentEnumeration.hasMoreElements()) {
                String current2 = this.parentEnumeration.nextElement();
                if (ApplicationHttpRequest.this.isSpecial(current2)) continue;
                result2 = current2;
            }
            return result2;
        }
    }
}

