/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.Set;
import org.apache.catalina.Globals;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.security.SecurityUtil;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public final class ApplicationFilterChain
implements FilterChain {
    private static final ThreadLocal<ServletRequest> lastServicedRequest = new ThreadLocal();
    private static final ThreadLocal<ServletResponse> lastServicedResponse = new ThreadLocal();
    public static final int INCREMENT = 10;
    private ApplicationFilterConfig[] filters = new ApplicationFilterConfig[0];
    private int pos = 0;
    private int n = 0;
    private Servlet servlet = null;
    private boolean servletSupportsAsync = false;
    private boolean dispatcherWrapsSameObject = false;
    private static final StringManager sm = StringManager.getManager(ApplicationFilterChain.class);
    private static final Class<?>[] classType = new Class[]{ServletRequest.class, ServletResponse.class, FilterChain.class};
    private static final Class<?>[] classTypeUsedInService = new Class[]{ServletRequest.class, ServletResponse.class};

    @Override
    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (Globals.IS_SECURITY_ENABLED) {
            ServletRequest req = request;
            ServletResponse res = response;
            try {
                AccessController.doPrivileged(() -> {
                    this.internalDoFilter(req, res);
                    return null;
                });
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                if (e instanceof ServletException) {
                    throw (ServletException)e;
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new ServletException(e.getMessage(), e);
            }
        } else {
            this.internalDoFilter(request, response);
        }
    }

    private void internalDoFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (this.pos < this.n) {
            ApplicationFilterConfig filterConfig = this.filters[this.pos++];
            try {
                Filter filter2 = filterConfig.getFilter();
                if (request.isAsyncSupported() && !filterConfig.getFilterDef().getAsyncSupportedBoolean()) {
                    request.setAttribute("org.apache.catalina.ASYNC_SUPPORTED", Boolean.FALSE);
                }
                if (Globals.IS_SECURITY_ENABLED) {
                    ServletRequest req = request;
                    ServletResponse res = response;
                    Principal principal2 = ((HttpServletRequest)req).getUserPrincipal();
                    Object[] args2 = new Object[]{req, res, this};
                    SecurityUtil.doAsPrivilege("doFilter", filter2, classType, args2, principal2);
                } else {
                    filter2.doFilter(request, response, this);
                }
            }
            catch (ServletException | IOException | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                e = ExceptionUtils.unwrapInvocationTargetException(e);
                ExceptionUtils.handleThrowable(e);
                throw new ServletException(sm.getString("filterChain.filter"), e);
            }
            return;
        }
        try {
            if (this.dispatcherWrapsSameObject) {
                lastServicedRequest.set(request);
                lastServicedResponse.set(response);
            }
            if (request.isAsyncSupported() && !this.servletSupportsAsync) {
                request.setAttribute("org.apache.catalina.ASYNC_SUPPORTED", Boolean.FALSE);
            }
            if (request instanceof HttpServletRequest && response instanceof HttpServletResponse && Globals.IS_SECURITY_ENABLED) {
                ServletRequest req = request;
                ServletResponse res = response;
                Principal principal3 = ((HttpServletRequest)req).getUserPrincipal();
                Object[] args3 = new Object[]{req, res};
                SecurityUtil.doAsPrivilege("service", this.servlet, classTypeUsedInService, args3, principal3);
            } else {
                this.servlet.service(request, response);
            }
        }
        catch (ServletException | IOException | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            e = ExceptionUtils.unwrapInvocationTargetException(e);
            ExceptionUtils.handleThrowable(e);
            throw new ServletException(sm.getString("filterChain.servlet"), e);
        }
        finally {
            if (this.dispatcherWrapsSameObject) {
                lastServicedRequest.set(null);
                lastServicedResponse.set(null);
            }
        }
    }

    public static ServletRequest getLastServicedRequest() {
        return lastServicedRequest.get();
    }

    public static ServletResponse getLastServicedResponse() {
        return lastServicedResponse.get();
    }

    void addFilter(ApplicationFilterConfig filterConfig) {
        for (int i2 = 0; i2 < this.n; ++i2) {
            if (this.filters[i2] != filterConfig) continue;
            return;
        }
        if (this.n == this.filters.length) {
            this.filters = Arrays.copyOf(this.filters, this.n + 10);
        }
        this.filters[this.n++] = filterConfig;
    }

    void release() {
        for (int i2 = 0; i2 < this.n; ++i2) {
            this.filters[i2] = null;
        }
        this.n = 0;
        this.pos = 0;
        this.servlet = null;
        this.servletSupportsAsync = false;
        this.dispatcherWrapsSameObject = false;
    }

    void reuse() {
        this.pos = 0;
    }

    void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    void setServletSupportsAsync(boolean servletSupportsAsync) {
        this.servletSupportsAsync = servletSupportsAsync;
    }

    void setDispatcherWrapsSameObject(boolean dispatcherWrapsSameObject) {
        this.dispatcherWrapsSameObject = dispatcherWrapsSameObject;
    }

    public void findNonAsyncFilters(Set<String> result2) {
        for (int i2 = 0; i2 < this.n; ++i2) {
            ApplicationFilterConfig filter2 = this.filters[i2];
            if (filter2.getFilterDef().getAsyncSupportedBoolean()) continue;
            result2.add(filter2.getFilterClass());
        }
    }
}

