/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestWrapper;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.ServletResponseWrapper;
import jakarta.servlet.UnavailableException;
import jakarta.servlet.http.HttpServletMapping;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.catalina.AsyncDispatcher;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.connector.Response;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.catalina.core.ApplicationFilterChain;
import org.apache.catalina.core.ApplicationFilterFactory;
import org.apache.catalina.core.ApplicationHttpRequest;
import org.apache.catalina.core.ApplicationHttpResponse;
import org.apache.catalina.core.ApplicationRequest;
import org.apache.catalina.core.ApplicationResponse;
import org.apache.catalina.core.StandardWrapper;
import org.apache.coyote.BadRequestException;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

final class ApplicationDispatcher
implements AsyncDispatcher,
RequestDispatcher {
    private final Context context;
    private final String name;
    private final String pathInfo;
    private final String queryString;
    private final String requestURI;
    private final String servletPath;
    private final HttpServletMapping mapping;
    private static final StringManager sm = StringManager.getManager(ApplicationDispatcher.class);
    private final Wrapper wrapper;

    ApplicationDispatcher(Wrapper wrapper, String requestURI, String servletPath, String pathInfo, String queryString, HttpServletMapping mapping, String name2) {
        this.wrapper = wrapper;
        this.context = (Context)wrapper.getParent();
        this.requestURI = requestURI;
        this.servletPath = servletPath;
        this.pathInfo = pathInfo;
        this.queryString = queryString;
        this.mapping = mapping;
        this.name = name2;
    }

    @Override
    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (Globals.IS_SECURITY_ENABLED) {
            try {
                PrivilegedForward dp = new PrivilegedForward(request, response);
                AccessController.doPrivileged(dp);
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                if (e instanceof ServletException) {
                    throw (ServletException)e;
                }
                throw (IOException)e;
            }
        } else {
            this.doForward(request, response);
        }
    }

    private void doForward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest hrequest;
        ApplicationHttpRequest wrequest;
        if (response.isCommitted()) {
            throw new IllegalStateException(sm.getString("applicationDispatcher.forward.ise"));
        }
        response.resetBuffer();
        State state2 = new State(request, response, false);
        if (this.context.getDispatcherWrapsSameObject()) {
            this.checkSameObjects(request, response);
        }
        this.wrapResponse(state2);
        if (this.servletPath == null && this.pathInfo == null) {
            wrequest = (ApplicationHttpRequest)this.wrapRequest(state2);
            hrequest = state2.hrequest;
            wrequest.setRequestURI(hrequest.getRequestURI());
            wrequest.setContextPath(hrequest.getContextPath());
            wrequest.setServletPath(hrequest.getServletPath());
            wrequest.setPathInfo(hrequest.getPathInfo());
            wrequest.setQueryString(hrequest.getQueryString());
            this.processRequest(request, response, state2);
        } else {
            wrequest = (ApplicationHttpRequest)this.wrapRequest(state2);
            hrequest = state2.hrequest;
            if (hrequest.getAttribute("jakarta.servlet.forward.request_uri") == null) {
                wrequest.setAttribute("jakarta.servlet.forward.request_uri", hrequest.getRequestURI());
                wrequest.setAttribute("jakarta.servlet.forward.context_path", hrequest.getContextPath());
                wrequest.setAttribute("jakarta.servlet.forward.servlet_path", hrequest.getServletPath());
                wrequest.setAttribute("jakarta.servlet.forward.path_info", hrequest.getPathInfo());
                wrequest.setAttribute("jakarta.servlet.forward.query_string", hrequest.getQueryString());
                wrequest.setAttribute("jakarta.servlet.forward.mapping", hrequest.getHttpServletMapping());
            }
            wrequest.setContextPath(this.context.getEncodedPath());
            wrequest.setRequestURI(this.requestURI);
            wrequest.setServletPath(this.servletPath);
            wrequest.setPathInfo(this.pathInfo);
            if (this.queryString != null) {
                wrequest.setQueryString(this.queryString);
                wrequest.setQueryParams(this.queryString);
            }
            wrequest.setMapping(this.mapping);
            this.processRequest(request, response, state2);
        }
        if (request.isAsyncStarted()) {
            return;
        }
        if (this.wrapper.getLogger().isTraceEnabled()) {
            this.wrapper.getLogger().trace(" Disabling the response for further output");
        }
        boolean finished = false;
        if (response instanceof ResponseFacade) {
            finished = true;
            ((ResponseFacade)response).finish();
        } else if (this.context.getSuspendWrappedResponseAfterForward() && response instanceof ServletResponseWrapper) {
            ServletResponse baseResponse = response;
            while ((baseResponse = ((ServletResponseWrapper)baseResponse).getResponse()) instanceof ServletResponseWrapper) {
            }
            if (baseResponse instanceof ResponseFacade) {
                finished = true;
                ((ResponseFacade)baseResponse).finish();
            }
        }
        if (!finished) {
            if (this.wrapper.getLogger().isDebugEnabled()) {
                this.wrapper.getLogger().debug(sm.getString("applicationDispatcher.customResponse", response.getClass()));
            }
            try {
                PrintWriter writer = response.getWriter();
                writer.close();
            }
            catch (IllegalStateException e) {
                try {
                    ServletOutputStream stream = response.getOutputStream();
                    stream.close();
                }
                catch (IOException | IllegalStateException exception2) {}
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void processRequest(ServletRequest request, ServletResponse response, State state2) throws IOException, ServletException {
        DispatcherType disInt = (DispatcherType)((Object)request.getAttribute("org.apache.catalina.core.DISPATCHER_TYPE"));
        if (disInt != null) {
            boolean doInvoke = true;
            if (this.context.getFireRequestListenersOnForwards() && !this.context.fireRequestInitEvent(request)) {
                doInvoke = false;
            }
            if (doInvoke) {
                if (disInt != DispatcherType.ERROR) {
                    state2.outerRequest.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", this.getCombinedPath());
                    state2.outerRequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", (Object)DispatcherType.FORWARD);
                    this.invoke(state2.outerRequest, response, state2);
                } else {
                    this.invoke(state2.outerRequest, response, state2);
                }
                if (this.context.getFireRequestListenersOnForwards()) {
                    this.context.fireRequestDestroyEvent(request);
                }
            }
        }
    }

    private String getCombinedPath() {
        if (this.servletPath == null) {
            return null;
        }
        if (this.pathInfo == null) {
            return this.servletPath;
        }
        return this.servletPath + this.pathInfo;
    }

    @Override
    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (Globals.IS_SECURITY_ENABLED) {
            try {
                PrivilegedInclude dp = new PrivilegedInclude(request, response);
                AccessController.doPrivileged(dp);
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                if (e instanceof ServletException) {
                    throw (ServletException)e;
                }
                throw (IOException)e;
            }
        } else {
            this.doInclude(request, response);
        }
    }

    private void doInclude(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        State state2 = new State(request, response, true);
        if (this.context.getDispatcherWrapsSameObject()) {
            this.checkSameObjects(request, response);
        }
        this.wrapResponse(state2);
        if (this.name != null) {
            ApplicationHttpRequest wrequest = (ApplicationHttpRequest)this.wrapRequest(state2);
            wrequest.setAttribute("org.apache.catalina.NAMED", this.name);
            if (this.servletPath != null) {
                wrequest.setServletPath(this.servletPath);
            }
            wrequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", (Object)DispatcherType.INCLUDE);
            wrequest.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", this.getCombinedPath());
            this.invoke(state2.outerRequest, state2.outerResponse, state2);
        } else {
            ApplicationHttpRequest wrequest = (ApplicationHttpRequest)this.wrapRequest(state2);
            String contextPath = this.context.getPath();
            if (this.requestURI != null) {
                wrequest.setAttribute("jakarta.servlet.include.request_uri", this.requestURI);
            }
            if (contextPath != null) {
                wrequest.setAttribute("jakarta.servlet.include.context_path", contextPath);
            }
            if (this.servletPath != null) {
                wrequest.setAttribute("jakarta.servlet.include.servlet_path", this.servletPath);
            }
            if (this.pathInfo != null) {
                wrequest.setAttribute("jakarta.servlet.include.path_info", this.pathInfo);
            }
            if (this.queryString != null) {
                wrequest.setAttribute("jakarta.servlet.include.query_string", this.queryString);
                wrequest.setQueryParams(this.queryString);
            }
            if (this.mapping != null) {
                wrequest.setAttribute("jakarta.servlet.include.mapping", this.mapping);
            }
            wrequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", (Object)DispatcherType.INCLUDE);
            wrequest.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", this.getCombinedPath());
            this.invoke(state2.outerRequest, state2.outerResponse, state2);
        }
    }

    @Override
    public void dispatch(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (Globals.IS_SECURITY_ENABLED) {
            try {
                PrivilegedDispatch dp = new PrivilegedDispatch(request, response);
                AccessController.doPrivileged(dp);
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                if (e instanceof ServletException) {
                    throw (ServletException)e;
                }
                throw (IOException)e;
            }
        } else {
            this.doDispatch(request, response);
        }
    }

    private void doDispatch(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        State state2 = new State(request, response, false);
        this.wrapResponse(state2);
        ApplicationHttpRequest wrequest = (ApplicationHttpRequest)this.wrapRequest(state2);
        HttpServletRequest hrequest = state2.hrequest;
        wrequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", (Object)DispatcherType.ASYNC);
        wrequest.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", this.getCombinedPath());
        wrequest.setAttribute("jakarta.servlet.async.mapping", hrequest.getHttpServletMapping());
        wrequest.setContextPath(this.context.getEncodedPath());
        wrequest.setRequestURI(this.requestURI);
        wrequest.setServletPath(this.servletPath);
        wrequest.setPathInfo(this.pathInfo);
        if (this.queryString != null) {
            wrequest.setQueryString(this.queryString);
            wrequest.setQueryParams(this.queryString);
        }
        wrequest.setMapping(this.mapping);
        this.invoke(state2.outerRequest, state2.outerResponse, state2);
    }

    private void invoke(ServletRequest request, ServletResponse response, State state2) throws IOException, ServletException {
        ClassLoader oldCCL = this.context.bind(false, null);
        HttpServletResponse hresponse = state2.hresponse;
        Servlet servlet = null;
        IOException ioException = null;
        ServletException servletException = null;
        RuntimeException runtimeException = null;
        boolean unavailable = false;
        if (this.wrapper.isUnavailable()) {
            this.wrapper.getLogger().warn(sm.getString("applicationDispatcher.isUnavailable", this.wrapper.getName()));
            long available = this.wrapper.getAvailable();
            if (available > 0L && available < Long.MAX_VALUE) {
                hresponse.setDateHeader("Retry-After", available);
            }
            hresponse.sendError(503, sm.getString("applicationDispatcher.isUnavailable", this.wrapper.getName()));
            unavailable = true;
        }
        try {
            if (!unavailable) {
                servlet = this.wrapper.allocate();
            }
        }
        catch (ServletException e) {
            this.wrapper.getLogger().error(sm.getString("applicationDispatcher.allocateException", this.wrapper.getName()), StandardWrapper.getRootCause(e));
            servletException = e;
        }
        catch (Throwable e) {
            ExceptionUtils.handleThrowable(e);
            this.wrapper.getLogger().error(sm.getString("applicationDispatcher.allocateException", this.wrapper.getName()), e);
            servletException = new ServletException(sm.getString("applicationDispatcher.allocateException", this.wrapper.getName()), e);
            servlet = null;
        }
        ApplicationFilterChain filterChain = ApplicationFilterFactory.createFilterChain(request, this.wrapper, servlet);
        try {
            if (servlet != null && filterChain != null) {
                filterChain.doFilter(request, response);
            }
        }
        catch (BadRequestException e) {
            ioException = e;
        }
        catch (IOException e) {
            this.wrapper.getLogger().error(sm.getString("applicationDispatcher.serviceException", this.wrapper.getName()), e);
            ioException = e;
        }
        catch (UnavailableException e) {
            this.wrapper.getLogger().error(sm.getString("applicationDispatcher.serviceException", this.wrapper.getName()), e);
            servletException = e;
            this.wrapper.unavailable(e);
        }
        catch (ServletException e) {
            Throwable rootCause = StandardWrapper.getRootCause(e);
            if (!(rootCause instanceof BadRequestException)) {
                this.wrapper.getLogger().error(sm.getString("applicationDispatcher.serviceException", this.wrapper.getName()), rootCause);
            }
            servletException = e;
        }
        catch (RuntimeException e) {
            this.wrapper.getLogger().error(sm.getString("applicationDispatcher.serviceException", this.wrapper.getName()), e);
            runtimeException = e;
        }
        if (filterChain != null) {
            filterChain.release();
        }
        try {
            if (servlet != null) {
                this.wrapper.deallocate(servlet);
            }
        }
        catch (ServletException e) {
            this.wrapper.getLogger().error(sm.getString("applicationDispatcher.deallocateException", this.wrapper.getName()), e);
            servletException = e;
        }
        catch (Throwable e) {
            ExceptionUtils.handleThrowable(e);
            this.wrapper.getLogger().error(sm.getString("applicationDispatcher.deallocateException", this.wrapper.getName()), e);
            servletException = new ServletException(sm.getString("applicationDispatcher.deallocateException", this.wrapper.getName()), e);
        }
        this.context.unbind(false, oldCCL);
        this.unwrapRequest(state2);
        this.unwrapResponse(state2);
        this.recycleRequestWrapper(state2);
        if (ioException != null) {
            throw ioException;
        }
        if (servletException != null) {
            throw servletException;
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
    }

    private void unwrapRequest(State state2) {
        if (state2.wrapRequest == null) {
            return;
        }
        if (state2.outerRequest.isAsyncStarted() && !state2.outerRequest.getAsyncContext().hasOriginalRequestAndResponse()) {
            return;
        }
        ServletRequest previous = null;
        ServletRequest current2 = state2.outerRequest;
        while (current2 != null && !(current2 instanceof Request) && !(current2 instanceof RequestFacade)) {
            if (current2 == state2.wrapRequest) {
                ServletRequest next2 = ((ServletRequestWrapper)current2).getRequest();
                if (previous == null) {
                    state2.outerRequest = next2;
                    break;
                }
                ((ServletRequestWrapper)previous).setRequest(next2);
                break;
            }
            previous = current2;
            current2 = ((ServletRequestWrapper)current2).getRequest();
        }
    }

    private void unwrapResponse(State state2) {
        if (state2.wrapResponse == null) {
            return;
        }
        if (state2.outerRequest.isAsyncStarted() && !state2.outerRequest.getAsyncContext().hasOriginalRequestAndResponse()) {
            return;
        }
        ServletResponse previous = null;
        ServletResponse current2 = state2.outerResponse;
        while (current2 != null && !(current2 instanceof Response) && !(current2 instanceof ResponseFacade)) {
            if (current2 == state2.wrapResponse) {
                ServletResponse next2 = ((ServletResponseWrapper)current2).getResponse();
                if (previous == null) {
                    state2.outerResponse = next2;
                    break;
                }
                ((ServletResponseWrapper)previous).setResponse(next2);
                break;
            }
            previous = current2;
            current2 = ((ServletResponseWrapper)current2).getResponse();
        }
    }

    private ServletRequest wrapRequest(State state2) {
        ServletRequest previous = null;
        ServletRequest current2 = state2.outerRequest;
        while (current2 != null) {
            if (state2.hrequest == null && current2 instanceof HttpServletRequest) {
                state2.hrequest = (HttpServletRequest)current2;
            }
            if (!(current2 instanceof ServletRequestWrapper) || current2 instanceof ApplicationHttpRequest || current2 instanceof ApplicationRequest) break;
            previous = current2;
            current2 = ((ServletRequestWrapper)current2).getRequest();
        }
        ServletRequestWrapper wrapper = null;
        if (current2 instanceof ApplicationHttpRequest || current2 instanceof Request || current2 instanceof HttpServletRequest) {
            HttpServletRequest hcurrent = (HttpServletRequest)current2;
            boolean crossContext = false;
            if (state2.outerRequest instanceof ApplicationHttpRequest || state2.outerRequest instanceof Request || state2.outerRequest instanceof HttpServletRequest) {
                HttpServletRequest houterRequest = (HttpServletRequest)state2.outerRequest;
                Object contextPath = houterRequest.getAttribute("jakarta.servlet.include.context_path");
                if (contextPath == null) {
                    contextPath = houterRequest.getContextPath();
                }
                crossContext = !this.context.getPath().equals(contextPath);
            }
            wrapper = new ApplicationHttpRequest(hcurrent, this.context, crossContext);
        } else {
            wrapper = new ApplicationRequest(current2);
        }
        if (previous == null) {
            state2.outerRequest = wrapper;
        } else {
            ((ServletRequestWrapper)previous).setRequest(wrapper);
        }
        state2.wrapRequest = wrapper;
        return wrapper;
    }

    private ServletResponse wrapResponse(State state2) {
        ServletResponse previous = null;
        ServletResponse current2 = state2.outerResponse;
        while (current2 != null) {
            if (state2.hresponse == null && current2 instanceof HttpServletResponse) {
                state2.hresponse = (HttpServletResponse)current2;
                if (!state2.including) {
                    return null;
                }
            }
            if (!(current2 instanceof ServletResponseWrapper) || current2 instanceof ApplicationHttpResponse || current2 instanceof ApplicationResponse) break;
            previous = current2;
            current2 = ((ServletResponseWrapper)current2).getResponse();
        }
        ServletResponseWrapper wrapper = null;
        wrapper = current2 instanceof ApplicationHttpResponse || current2 instanceof Response || current2 instanceof HttpServletResponse ? new ApplicationHttpResponse((HttpServletResponse)current2, state2.including) : new ApplicationResponse(current2, state2.including);
        if (previous == null) {
            state2.outerResponse = wrapper;
        } else {
            ((ServletResponseWrapper)previous).setResponse(wrapper);
        }
        state2.wrapResponse = wrapper;
        return wrapper;
    }

    private void checkSameObjects(ServletRequest appRequest, ServletResponse appResponse) throws ServletException {
        ServletRequest originalRequest = ApplicationFilterChain.getLastServicedRequest();
        ServletResponse originalResponse = ApplicationFilterChain.getLastServicedResponse();
        if (originalRequest == null || originalResponse == null) {
            return;
        }
        boolean same2 = false;
        ServletRequest dispatchedRequest = appRequest;
        while (originalRequest instanceof ServletRequestWrapper && ((ServletRequestWrapper)originalRequest).getRequest() != null) {
            originalRequest = ((ServletRequestWrapper)originalRequest).getRequest();
        }
        while (!same2) {
            if (originalRequest.equals(dispatchedRequest)) {
                same2 = true;
            }
            if (same2 || !(dispatchedRequest instanceof ServletRequestWrapper)) break;
            dispatchedRequest = ((ServletRequestWrapper)dispatchedRequest).getRequest();
        }
        if (!same2) {
            throw new ServletException(sm.getString("applicationDispatcher.specViolation.request"));
        }
        same2 = false;
        ServletResponse dispatchedResponse = appResponse;
        while (originalResponse instanceof ServletResponseWrapper && ((ServletResponseWrapper)originalResponse).getResponse() != null) {
            originalResponse = ((ServletResponseWrapper)originalResponse).getResponse();
        }
        while (!same2) {
            if (originalResponse.equals(dispatchedResponse)) {
                same2 = true;
            }
            if (same2 || !(dispatchedResponse instanceof ServletResponseWrapper)) break;
            dispatchedResponse = ((ServletResponseWrapper)dispatchedResponse).getResponse();
        }
        if (!same2) {
            throw new ServletException(sm.getString("applicationDispatcher.specViolation.response"));
        }
    }

    private void recycleRequestWrapper(State state2) {
        if (state2.wrapRequest instanceof ApplicationHttpRequest) {
            ((ApplicationHttpRequest)state2.wrapRequest).recycle();
        }
    }

    protected class PrivilegedForward
    implements PrivilegedExceptionAction<Void> {
        private final ServletRequest request;
        private final ServletResponse response;

        PrivilegedForward(ServletRequest request, ServletResponse response) {
            this.request = request;
            this.response = response;
        }

        @Override
        public Void run() throws Exception {
            ApplicationDispatcher.this.doForward(this.request, this.response);
            return null;
        }
    }

    private static class State {
        ServletRequest outerRequest = null;
        ServletResponse outerResponse = null;
        ServletRequest wrapRequest = null;
        ServletResponse wrapResponse = null;
        boolean including = false;
        HttpServletRequest hrequest = null;
        HttpServletResponse hresponse = null;

        State(ServletRequest request, ServletResponse response, boolean including) {
            this.outerRequest = request;
            this.outerResponse = response;
            this.including = including;
        }
    }

    protected class PrivilegedInclude
    implements PrivilegedExceptionAction<Void> {
        private final ServletRequest request;
        private final ServletResponse response;

        PrivilegedInclude(ServletRequest request, ServletResponse response) {
            this.request = request;
            this.response = response;
        }

        @Override
        public Void run() throws ServletException, IOException {
            ApplicationDispatcher.this.doInclude(this.request, this.response);
            return null;
        }
    }

    protected class PrivilegedDispatch
    implements PrivilegedExceptionAction<Void> {
        private final ServletRequest request;
        private final ServletResponse response;

        PrivilegedDispatch(ServletRequest request, ServletResponse response) {
            this.request = request;
            this.response = response;
        }

        @Override
        public Void run() throws ServletException, IOException {
            ApplicationDispatcher.this.doDispatch(this.request, this.response);
            return null;
        }
    }
}

