/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextAttributeEvent;
import jakarta.servlet.ServletContextAttributeListener;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.ServletRequestAttributeListener;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.ServletSecurityElement;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.descriptor.JspConfigDescriptor;
import jakarta.servlet.http.HttpServletMapping;
import jakarta.servlet.http.HttpSessionAttributeListener;
import jakarta.servlet.http.HttpSessionIdListener;
import jakarta.servlet.http.HttpSessionListener;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Globals;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Service;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.ApplicationContextFacade;
import org.apache.catalina.core.ApplicationDispatcher;
import org.apache.catalina.core.ApplicationFilterRegistration;
import org.apache.catalina.core.ApplicationMapping;
import org.apache.catalina.core.ApplicationServletRegistration;
import org.apache.catalina.core.ApplicationSessionCookieConfig;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.mapper.MappingData;
import org.apache.catalina.util.Introspection;
import org.apache.catalina.util.ServerInfo;
import org.apache.catalina.util.URLEncoder;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.buf.UDecoder;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.http.RequestUtil;
import org.apache.tomcat.util.res.StringManager;

public class ApplicationContext
implements ServletContext {
    protected Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private final Map<String, String> readOnlyAttributes = new ConcurrentHashMap<String, String>();
    private final StandardContext context;
    private final Service service;
    private final ServletContext facade = new ApplicationContextFacade(this);
    private final Map<String, String> parameters = new ConcurrentHashMap<String, String>();
    private static final StringManager sm = StringManager.getManager(ApplicationContext.class);
    private final ThreadLocal<DispatchData> dispatchData = new ThreadLocal();
    private SessionCookieConfig sessionCookieConfig;
    private Set<SessionTrackingMode> sessionTrackingModes = null;
    private Set<SessionTrackingMode> defaultSessionTrackingModes = null;
    private Set<SessionTrackingMode> supportedSessionTrackingModes = null;
    private boolean newServletContextListenerAllowed = true;

    public ApplicationContext(StandardContext context) {
        this.context = context;
        this.service = ((Engine)context.getParent().getParent()).getService();
        this.sessionCookieConfig = new ApplicationSessionCookieConfig(context);
        this.populateSessionTrackingModes();
    }

    @Override
    public Object getAttribute(String name2) {
        return this.attributes.get(name2);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        HashSet<String> names2 = new HashSet<String>(this.attributes.keySet());
        return Collections.enumeration(names2);
    }

    @Override
    public ServletContext getContext(String uri) {
        if (uri == null || !uri.startsWith("/")) {
            return null;
        }
        Context child = null;
        try {
            Container host = this.context.getParent();
            child = (Context)host.findChild(uri);
            if (child != null && !child.getState().isAvailable()) {
                child = null;
            }
            if (child == null) {
                int i2 = uri.indexOf("##");
                if (i2 > -1) {
                    uri = uri.substring(0, i2);
                }
                MessageBytes hostMB = MessageBytes.newInstance();
                hostMB.setString(host.getName());
                MessageBytes pathMB = MessageBytes.newInstance();
                pathMB.setString(uri);
                MappingData mappingData = new MappingData();
                this.service.getMapper().map(hostMB, pathMB, null, mappingData);
                child = mappingData.context;
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            return null;
        }
        if (child == null) {
            return null;
        }
        if (this.context.getCrossContext()) {
            return child.getServletContext();
        }
        if (child == this.context) {
            return this.context.getServletContext();
        }
        return null;
    }

    @Override
    public String getContextPath() {
        return this.context.getPath();
    }

    @Override
    public String getInitParameter(String name2) {
        if ("org.apache.jasper.XML_VALIDATE_TLD".equals(name2) && this.context.getTldValidation()) {
            return "true";
        }
        if ("org.apache.jasper.XML_BLOCK_EXTERNAL".equals(name2) && !this.context.getXmlBlockExternal()) {
            return "false";
        }
        return this.parameters.get(name2);
    }

    @Override
    public Enumeration<String> getInitParameterNames() {
        HashSet<String> names2 = new HashSet<String>(this.parameters.keySet());
        if (this.context.getTldValidation()) {
            names2.add("org.apache.jasper.XML_VALIDATE_TLD");
        }
        if (!this.context.getXmlBlockExternal()) {
            names2.add("org.apache.jasper.XML_BLOCK_EXTERNAL");
        }
        return Collections.enumeration(names2);
    }

    @Override
    public int getMajorVersion() {
        return 6;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public String getMimeType(String file2) {
        if (file2 == null) {
            return null;
        }
        int period = file2.lastIndexOf(46);
        if (period < 0) {
            return null;
        }
        String extension = file2.substring(period + 1);
        if (extension.length() < 1) {
            return null;
        }
        return this.context.findMimeMapping(extension);
    }

    @Override
    public RequestDispatcher getNamedDispatcher(String name2) {
        if (name2 == null) {
            return null;
        }
        Wrapper wrapper = (Wrapper)this.context.findChild(name2);
        if (wrapper == null) {
            return null;
        }
        return new ApplicationDispatcher(wrapper, null, null, null, null, null, name2);
    }

    @Override
    public String getRealPath(String path2) {
        String validatedPath = this.validateResourcePath(path2, true);
        return this.context.getRealPath(validatedPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestDispatcher getRequestDispatcher(String path2) {
        String queryString;
        Object uri;
        if (path2 == null) {
            return null;
        }
        if (!path2.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("applicationContext.requestDispatcher.iae", path2));
        }
        int pos2 = path2.indexOf(63);
        if (pos2 >= 0) {
            uri = path2.substring(0, pos2);
            queryString = path2.substring(pos2 + 1);
        } else {
            uri = path2;
            queryString = null;
        }
        String uriNoParams = ApplicationContext.stripPathParams((String)uri);
        String normalizedUri = RequestUtil.normalize(uriNoParams);
        if (normalizedUri == null) {
            return null;
        }
        if (this.getContext().getDispatchersUseEncodedPaths()) {
            String decodedUri = UDecoder.URLDecode(normalizedUri, StandardCharsets.UTF_8);
            if (!decodedUri.equals(normalizedUri = RequestUtil.normalize(decodedUri))) {
                this.getContext().getLogger().warn(sm.getString("applicationContext.illegalDispatchPath", path2), new IllegalArgumentException());
                return null;
            }
            uri = URLEncoder.DEFAULT.encode(this.getContextPath(), StandardCharsets.UTF_8) + (String)uri;
        } else {
            uri = URLEncoder.DEFAULT.encode(this.getContextPath() + (String)uri, StandardCharsets.UTF_8);
        }
        DispatchData dd = this.dispatchData.get();
        if (dd == null) {
            dd = new DispatchData();
            this.dispatchData.set(dd);
        }
        MessageBytes uriMB = dd.uriMB;
        MappingData mappingData = dd.mappingData;
        try {
            uriMB.setChars(MessageBytes.EMPTY_CHAR_ARRAY, 0, 0);
            CharChunk uriCC = uriMB.getCharChunk();
            try {
                uriCC.append(this.context.getPath());
                uriCC.append(normalizedUri);
                this.service.getMapper().map(this.context, uriMB, mappingData);
                if (mappingData.wrapper == null) {
                    RequestDispatcher requestDispatcher = null;
                    return requestDispatcher;
                }
            }
            catch (Exception e) {
                this.log(sm.getString("applicationContext.mapping.error"), e);
                RequestDispatcher requestDispatcher = null;
                return requestDispatcher;
            }
            Wrapper wrapper = mappingData.wrapper;
            String wrapperPath = mappingData.wrapperPath.toString();
            String pathInfo = mappingData.pathInfo.toString();
            HttpServletMapping mapping = new ApplicationMapping(mappingData).getHttpServletMapping();
            ApplicationDispatcher applicationDispatcher = new ApplicationDispatcher(wrapper, (String)uri, wrapperPath, pathInfo, queryString, mapping, null);
            return applicationDispatcher;
        }
        finally {
            uriMB.recycle();
            mappingData.recycle();
        }
    }

    static String stripPathParams(String input) {
        if (input.indexOf(59) < 0) {
            return input;
        }
        StringBuilder sb = new StringBuilder(input.length());
        int pos2 = 0;
        int limit2 = input.length();
        while (pos2 < limit2) {
            int nextSemiColon = input.indexOf(59, pos2);
            if (nextSemiColon < 0) {
                nextSemiColon = limit2;
            }
            sb.append(input.substring(pos2, nextSemiColon));
            int followingSlash = input.indexOf(47, nextSemiColon);
            if (followingSlash < 0) {
                pos2 = limit2;
                continue;
            }
            pos2 = followingSlash;
        }
        return sb.toString();
    }

    @Override
    public URL getResource(String path2) throws MalformedURLException {
        String validatedPath = this.validateResourcePath(path2, !this.context.getContextGetResourceRequiresSlash());
        if (validatedPath == null) {
            throw new MalformedURLException(sm.getString("applicationContext.requestDispatcher.iae", path2));
        }
        WebResourceRoot resources = this.context.getResources();
        if (resources != null) {
            return resources.getResource(validatedPath).getURL();
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String path2) {
        String validatedPath = this.validateResourcePath(path2, !this.context.getContextGetResourceRequiresSlash());
        if (validatedPath == null) {
            return null;
        }
        WebResourceRoot resources = this.context.getResources();
        if (resources != null) {
            return resources.getResource(validatedPath).getInputStream();
        }
        return null;
    }

    private String validateResourcePath(String path2, boolean addMissingInitialSlash) {
        if (path2 == null) {
            return null;
        }
        if (!path2.startsWith("/")) {
            if (addMissingInitialSlash) {
                return "/" + path2;
            }
            return null;
        }
        return path2;
    }

    @Override
    public Set<String> getResourcePaths(String path2) {
        if (path2 == null) {
            return null;
        }
        if (!path2.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("applicationContext.resourcePaths.iae", path2));
        }
        WebResourceRoot resources = this.context.getResources();
        if (resources != null) {
            return resources.listWebAppPaths(path2);
        }
        return null;
    }

    @Override
    public String getServerInfo() {
        return ServerInfo.getServerInfo();
    }

    @Override
    public String getServletContextName() {
        return this.context.getDisplayName();
    }

    @Override
    public void log(String message2) {
        this.context.getLogger().info(message2);
    }

    @Override
    public void log(String message2, Throwable throwable) {
        this.context.getLogger().error(message2, throwable);
    }

    @Override
    public void removeAttribute(String name2) {
        Object value2 = null;
        if (this.readOnlyAttributes.containsKey(name2)) {
            return;
        }
        value2 = this.attributes.remove(name2);
        if (value2 == null) {
            return;
        }
        Object[] listeners = this.context.getApplicationEventListeners();
        if (listeners == null || listeners.length == 0) {
            return;
        }
        ServletContextAttributeEvent event2 = new ServletContextAttributeEvent(this.context.getServletContext(), name2, value2);
        for (Object obj : listeners) {
            if (!(obj instanceof ServletContextAttributeListener)) continue;
            ServletContextAttributeListener listener = (ServletContextAttributeListener)obj;
            try {
                this.context.fireContainerEvent("beforeContextAttributeRemoved", listener);
                listener.attributeRemoved(event2);
                this.context.fireContainerEvent("afterContextAttributeRemoved", listener);
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                this.context.fireContainerEvent("afterContextAttributeRemoved", listener);
                this.log(sm.getString("applicationContext.attributeEvent"), t);
            }
        }
    }

    @Override
    public void setAttribute(String name2, Object value2) {
        if (name2 == null) {
            throw new NullPointerException(sm.getString("applicationContext.setAttribute.namenull"));
        }
        if (value2 == null) {
            this.removeAttribute(name2);
            return;
        }
        if (this.readOnlyAttributes.containsKey(name2)) {
            return;
        }
        Object oldValue = this.attributes.put(name2, value2);
        boolean replaced = oldValue != null;
        Object[] listeners = this.context.getApplicationEventListeners();
        if (listeners == null || listeners.length == 0) {
            return;
        }
        ServletContextAttributeEvent event2 = null;
        event2 = replaced ? new ServletContextAttributeEvent(this.context.getServletContext(), name2, oldValue) : new ServletContextAttributeEvent(this.context.getServletContext(), name2, value2);
        for (Object obj : listeners) {
            if (!(obj instanceof ServletContextAttributeListener)) continue;
            ServletContextAttributeListener listener = (ServletContextAttributeListener)obj;
            try {
                if (replaced) {
                    this.context.fireContainerEvent("beforeContextAttributeReplaced", listener);
                    listener.attributeReplaced(event2);
                    this.context.fireContainerEvent("afterContextAttributeReplaced", listener);
                    continue;
                }
                this.context.fireContainerEvent("beforeContextAttributeAdded", listener);
                listener.attributeAdded(event2);
                this.context.fireContainerEvent("afterContextAttributeAdded", listener);
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                if (replaced) {
                    this.context.fireContainerEvent("afterContextAttributeReplaced", listener);
                } else {
                    this.context.fireContainerEvent("afterContextAttributeAdded", listener);
                }
                this.log(sm.getString("applicationContext.attributeEvent"), t);
            }
        }
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        return this.addFilter(filterName, className, null);
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter2) {
        return this.addFilter(filterName, null, filter2);
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        return this.addFilter(filterName, filterClass.getName(), null);
    }

    private FilterRegistration.Dynamic addFilter(String filterName, String filterClass, Filter filter2) throws IllegalStateException {
        if (filterName == null || filterName.equals("")) {
            throw new IllegalArgumentException(sm.getString("applicationContext.invalidFilterName", filterName));
        }
        this.checkState("applicationContext.addFilter.ise");
        FilterDef filterDef = this.context.findFilterDef(filterName);
        if (filterDef == null) {
            filterDef = new FilterDef();
            filterDef.setFilterName(filterName);
            this.context.addFilterDef(filterDef);
        } else if (filterDef.getFilterName() != null && filterDef.getFilterClass() != null) {
            return null;
        }
        if (filter2 == null) {
            filterDef.setFilterClass(filterClass);
        } else {
            filterDef.setFilterClass(filter2.getClass().getName());
            filterDef.setFilter(filter2);
        }
        return new ApplicationFilterRegistration(filterDef, this.context);
    }

    @Override
    public <T extends Filter> T createFilter(Class<T> c) throws ServletException {
        try {
            Filter filter2 = (Filter)this.context.getInstanceManager().newInstance(c.getName());
            return (T)filter2;
        }
        catch (InvocationTargetException e) {
            ExceptionUtils.handleThrowable(e.getCause());
            throw new ServletException(e);
        }
        catch (ReflectiveOperationException | NamingException e) {
            throw new ServletException(e);
        }
    }

    @Override
    public FilterRegistration getFilterRegistration(String filterName) {
        FilterDef filterDef = this.context.findFilterDef(filterName);
        if (filterDef == null) {
            return null;
        }
        return new ApplicationFilterRegistration(filterDef, this.context);
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        return this.addServlet(servletName, className, null, null);
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        return this.addServlet(servletName, null, servlet, null);
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        return this.addServlet(servletName, servletClass.getName(), null, null);
    }

    @Override
    public ServletRegistration.Dynamic addJspFile(String jspName, String jspFile) {
        if (jspFile == null || !jspFile.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("applicationContext.addJspFile.iae", jspFile));
        }
        String jspServletClassName = null;
        HashMap<String, String> jspFileInitParams = new HashMap<String, String>();
        Wrapper jspServlet = (Wrapper)this.context.findChild("jsp");
        if (jspServlet == null) {
            jspServletClassName = "org.apache.jasper.servlet.JspServlet";
        } else {
            String[] params2;
            jspServletClassName = jspServlet.getServletClass();
            for (String param : params2 = jspServlet.findInitParameters()) {
                jspFileInitParams.put(param, jspServlet.findInitParameter(param));
            }
        }
        jspFileInitParams.put("jspFile", jspFile);
        return this.addServlet(jspName, jspServletClassName, null, jspFileInitParams);
    }

    private ServletRegistration.Dynamic addServlet(String servletName, String servletClass, Servlet servlet, Map<String, String> initParams) throws IllegalStateException {
        if (servletName == null || servletName.equals("")) {
            throw new IllegalArgumentException(sm.getString("applicationContext.invalidServletName", servletName));
        }
        this.checkState("applicationContext.addServlet.ise");
        Wrapper wrapper = (Wrapper)this.context.findChild(servletName);
        if (wrapper == null) {
            wrapper = this.context.createWrapper();
            wrapper.setName(servletName);
            this.context.addChild(wrapper);
        } else if (wrapper.getName() != null && wrapper.getServletClass() != null) {
            if (wrapper.isOverridable()) {
                wrapper.setOverridable(false);
            } else {
                return null;
            }
        }
        ServletSecurity annotation = null;
        if (servlet == null) {
            wrapper.setServletClass(servletClass);
            Class<?> clazz = Introspection.loadClass(this.context, servletClass);
            if (clazz != null) {
                annotation = clazz.getAnnotation(ServletSecurity.class);
            }
        } else {
            wrapper.setServletClass(servlet.getClass().getName());
            wrapper.setServlet(servlet);
            if (this.context.wasCreatedDynamicServlet(servlet)) {
                annotation = servlet.getClass().getAnnotation(ServletSecurity.class);
            }
        }
        if (initParams != null) {
            for (Map.Entry entry : initParams.entrySet()) {
                wrapper.addInitParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
        ApplicationServletRegistration registration = new ApplicationServletRegistration(wrapper, this.context);
        if (annotation != null) {
            registration.setServletSecurity(new ServletSecurityElement(annotation));
        }
        return registration;
    }

    @Override
    public <T extends Servlet> T createServlet(Class<T> c) throws ServletException {
        try {
            Servlet servlet = (Servlet)this.context.getInstanceManager().newInstance(c.getName());
            this.context.dynamicServletCreated(servlet);
            return (T)servlet;
        }
        catch (InvocationTargetException e) {
            ExceptionUtils.handleThrowable(e.getCause());
            throw new ServletException(e);
        }
        catch (ReflectiveOperationException | NamingException e) {
            throw new ServletException(e);
        }
    }

    @Override
    public ServletRegistration getServletRegistration(String servletName) {
        Wrapper wrapper = (Wrapper)this.context.findChild(servletName);
        if (wrapper == null) {
            return null;
        }
        return new ApplicationServletRegistration(wrapper, this.context);
    }

    @Override
    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return this.defaultSessionTrackingModes;
    }

    private void populateSessionTrackingModes() {
        Connector[] connectors;
        this.defaultSessionTrackingModes = EnumSet.of(SessionTrackingMode.URL);
        this.supportedSessionTrackingModes = EnumSet.of(SessionTrackingMode.URL);
        if (this.context.getCookies()) {
            this.defaultSessionTrackingModes.add(SessionTrackingMode.COOKIE);
            this.supportedSessionTrackingModes.add(SessionTrackingMode.COOKIE);
        }
        for (Connector connector : connectors = this.service.findConnectors()) {
            if (!Boolean.TRUE.equals(connector.getProperty("SSLEnabled"))) continue;
            this.supportedSessionTrackingModes.add(SessionTrackingMode.SSL);
            break;
        }
    }

    @Override
    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        if (this.sessionTrackingModes != null) {
            return this.sessionTrackingModes;
        }
        return this.defaultSessionTrackingModes;
    }

    @Override
    public SessionCookieConfig getSessionCookieConfig() {
        return this.sessionCookieConfig;
    }

    @Override
    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        this.checkState("applicationContext.setSessionTracking.ise");
        for (SessionTrackingMode sessionTrackingMode : sessionTrackingModes) {
            if (this.supportedSessionTrackingModes.contains((Object)sessionTrackingMode)) continue;
            throw new IllegalArgumentException(sm.getString("applicationContext.setSessionTracking.iae.invalid", sessionTrackingMode.toString(), this.getContextPath()));
        }
        if (sessionTrackingModes.contains((Object)SessionTrackingMode.SSL) && sessionTrackingModes.size() > 1) {
            throw new IllegalArgumentException(sm.getString("applicationContext.setSessionTracking.iae.ssl", this.getContextPath()));
        }
        this.sessionTrackingModes = sessionTrackingModes;
    }

    @Override
    public boolean setInitParameter(String name2, String value2) {
        if (name2 == null) {
            throw new NullPointerException(sm.getString("applicationContext.setAttribute.namenull"));
        }
        this.checkState("applicationContext.setInitParam.ise");
        return this.parameters.putIfAbsent(name2, value2) == null;
    }

    @Override
    public void addListener(Class<? extends EventListener> listenerClass) {
        EventListener listener;
        try {
            listener = this.createListener(listenerClass);
        }
        catch (ServletException e) {
            throw new IllegalArgumentException(sm.getString("applicationContext.addListener.iae.init", listenerClass.getName()), e);
        }
        this.addListener(listener);
    }

    @Override
    public void addListener(String className) {
        try {
            if (this.context.getInstanceManager() != null) {
                Object obj = this.context.getInstanceManager().newInstance(className);
                if (!(obj instanceof EventListener)) {
                    throw new IllegalArgumentException(sm.getString("applicationContext.addListener.iae.wrongType", className));
                }
                EventListener listener = (EventListener)obj;
                this.addListener(listener);
            }
        }
        catch (InvocationTargetException e) {
            ExceptionUtils.handleThrowable(e.getCause());
            throw new IllegalArgumentException(sm.getString("applicationContext.addListener.iae.cnfe", className), e);
        }
        catch (ReflectiveOperationException | NamingException e) {
            throw new IllegalArgumentException(sm.getString("applicationContext.addListener.iae.cnfe", className), e);
        }
    }

    @Override
    public <T extends EventListener> void addListener(T t) {
        this.checkState("applicationContext.addListener.ise");
        boolean match2 = false;
        if (t instanceof ServletContextAttributeListener || t instanceof ServletRequestListener || t instanceof ServletRequestAttributeListener || t instanceof HttpSessionIdListener || t instanceof HttpSessionAttributeListener) {
            this.context.addApplicationEventListener(t);
            match2 = true;
        }
        if (t instanceof HttpSessionListener || t instanceof ServletContextListener && this.newServletContextListenerAllowed) {
            this.context.addApplicationLifecycleListener(t);
            match2 = true;
        }
        if (match2) {
            return;
        }
        if (t instanceof ServletContextListener) {
            throw new IllegalArgumentException(sm.getString("applicationContext.addListener.iae.sclNotAllowed", t.getClass().getName()));
        }
        throw new IllegalArgumentException(sm.getString("applicationContext.addListener.iae.wrongType", t.getClass().getName()));
    }

    @Override
    public <T extends EventListener> T createListener(Class<T> c) throws ServletException {
        try {
            EventListener listener = (EventListener)this.context.getInstanceManager().newInstance(c);
            if (listener instanceof ServletContextListener || listener instanceof ServletContextAttributeListener || listener instanceof ServletRequestListener || listener instanceof ServletRequestAttributeListener || listener instanceof HttpSessionListener || listener instanceof HttpSessionIdListener || listener instanceof HttpSessionAttributeListener) {
                return (T)listener;
            }
            throw new IllegalArgumentException(sm.getString("applicationContext.addListener.iae.wrongType", listener.getClass().getName()));
        }
        catch (InvocationTargetException e) {
            ExceptionUtils.handleThrowable(e.getCause());
            throw new ServletException(e);
        }
        catch (ReflectiveOperationException | NamingException e) {
            throw new ServletException(e);
        }
    }

    @Override
    public void declareRoles(String ... roleNames) {
        this.checkState("applicationContext.addRole.ise");
        if (roleNames == null) {
            throw new IllegalArgumentException(sm.getString("applicationContext.roles.iae", this.getContextPath()));
        }
        for (String role : roleNames) {
            if (role == null || role.isEmpty()) {
                throw new IllegalArgumentException(sm.getString("applicationContext.role.iae", this.getContextPath()));
            }
            this.context.addSecurityRole(role);
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        ClassLoader result2 = this.context.getLoader().getClassLoader();
        if (Globals.IS_SECURITY_ENABLED) {
            ClassLoader parent;
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            for (parent = result2; parent != null && parent != tccl; parent = parent.getParent()) {
            }
            if (parent == null) {
                System.getSecurityManager().checkPermission(new RuntimePermission("getClassLoader"));
            }
        }
        return result2;
    }

    @Override
    public int getEffectiveMajorVersion() {
        return this.context.getEffectiveMajorVersion();
    }

    @Override
    public int getEffectiveMinorVersion() {
        return this.context.getEffectiveMinorVersion();
    }

    @Override
    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        FilterDef[] filterDefs;
        HashMap<String, ApplicationFilterRegistration> result2 = new HashMap<String, ApplicationFilterRegistration>();
        for (FilterDef filterDef : filterDefs = this.context.findFilterDefs()) {
            result2.put(filterDef.getFilterName(), new ApplicationFilterRegistration(filterDef, this.context));
        }
        return result2;
    }

    @Override
    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.context.getJspConfigDescriptor();
    }

    @Override
    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        Container[] wrappers;
        HashMap<String, ApplicationServletRegistration> result2 = new HashMap<String, ApplicationServletRegistration>();
        for (Container wrapper : wrappers = this.context.findChildren()) {
            result2.put(wrapper.getName(), new ApplicationServletRegistration((Wrapper)wrapper, this.context));
        }
        return result2;
    }

    @Override
    public String getVirtualServerName() {
        Container host = this.context.getParent();
        Container engine = host.getParent();
        return engine.getName() + "/" + host.getName();
    }

    @Override
    public int getSessionTimeout() {
        return this.context.getSessionTimeout();
    }

    @Override
    public void setSessionTimeout(int sessionTimeout) {
        this.checkState("applicationContext.setSessionTimeout.ise");
        this.context.setSessionTimeout(sessionTimeout);
    }

    @Override
    public String getRequestCharacterEncoding() {
        return this.context.getRequestCharacterEncoding();
    }

    @Override
    public void setRequestCharacterEncoding(String encoding2) {
        this.checkState("applicationContext.setRequestEncoding.ise");
        this.context.setRequestCharacterEncoding(encoding2);
    }

    @Override
    public String getResponseCharacterEncoding() {
        return this.context.getResponseCharacterEncoding();
    }

    @Override
    public void setResponseCharacterEncoding(String encoding2) {
        this.checkState("applicationContext.setResponseEncoding.ise");
        this.context.setResponseCharacterEncoding(encoding2);
    }

    private void checkState(String messageKey) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString(messageKey, this.getContextPath()));
        }
    }

    protected StandardContext getContext() {
        return this.context;
    }

    protected void clearAttributes() {
        ArrayList<String> list2 = new ArrayList<String>(this.attributes.keySet());
        for (String key2 : list2) {
            this.removeAttribute(key2);
        }
    }

    protected ServletContext getFacade() {
        return this.facade;
    }

    void setAttributeReadOnly(String name2) {
        if (this.attributes.containsKey(name2)) {
            this.readOnlyAttributes.put(name2, name2);
        }
    }

    protected void setNewServletContextListenerAllowed(boolean allowed) {
        this.newServletContextListenerAllowed = allowed;
    }

    private static final class DispatchData {
        public MessageBytes uriMB = MessageBytes.newInstance();
        public MappingData mappingData;

        DispatchData() {
            CharChunk uriCC = this.uriMB.getCharChunk();
            uriCC.setLimit(-1);
            this.mappingData = new MappingData();
        }
    }
}

