/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.catalina.Context;
import org.apache.catalina.Session;
import org.apache.catalina.connector.CoyoteOutputStream;
import org.apache.catalina.connector.CoyoteWriter;
import org.apache.catalina.connector.OutputBuffer;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.util.SessionConfig;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Constants;
import org.apache.coyote.ContinueResponseTiming;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.UEncoder;
import org.apache.tomcat.util.buf.UriUtil;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.parser.MediaTypeCache;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.security.Escape;

public class Response
implements HttpServletResponse {
    private static final Log log = LogFactory.getLog(Response.class);
    protected static final StringManager sm = StringManager.getManager(Response.class);
    private static final MediaTypeCache MEDIA_TYPE_CACHE = new MediaTypeCache(100);
    protected org.apache.coyote.Response coyoteResponse;
    protected final OutputBuffer outputBuffer;
    protected CoyoteOutputStream outputStream;
    protected CoyoteWriter writer;
    protected boolean appCommitted = false;
    protected boolean included = false;
    private boolean isCharacterEncodingSet = false;
    protected boolean usingOutputStream = false;
    protected boolean usingWriter = false;
    protected final UEncoder urlEncoder = new UEncoder(UEncoder.SafeCharsSet.WITH_SLASH);
    protected final CharChunk redirectURLCC = new CharChunk();
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private HttpServletResponse applicationResponse = null;
    protected Request request = null;
    protected ResponseFacade facade = null;

    public Response() {
        this(8192);
    }

    public Response(int outputBufferSize) {
        this.outputBuffer = new OutputBuffer(outputBufferSize);
    }

    public void setCoyoteResponse(org.apache.coyote.Response coyoteResponse) {
        this.coyoteResponse = coyoteResponse;
        this.outputBuffer.setResponse(coyoteResponse);
    }

    public org.apache.coyote.Response getCoyoteResponse() {
        return this.coyoteResponse;
    }

    public Context getContext() {
        return this.request.getContext();
    }

    public void recycle() {
        this.cookies.clear();
        this.outputBuffer.recycle();
        this.usingOutputStream = false;
        this.usingWriter = false;
        this.appCommitted = false;
        this.included = false;
        this.isCharacterEncodingSet = false;
        this.applicationResponse = null;
        if (this.getRequest().getDiscardFacades()) {
            if (this.facade != null) {
                this.facade.clear();
                this.facade = null;
            }
            if (this.outputStream != null) {
                this.outputStream.clear();
                this.outputStream = null;
            }
            if (this.writer != null) {
                this.writer.clear();
                this.writer = null;
            }
        } else if (this.writer != null) {
            this.writer.recycle();
        }
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public long getContentWritten() {
        return this.outputBuffer.getContentWritten();
    }

    public long getBytesWritten(boolean flush2) {
        if (flush2) {
            try {
                this.outputBuffer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.getCoyoteResponse().getBytesWritten(flush2);
    }

    public void setAppCommitted(boolean appCommitted) {
        this.appCommitted = appCommitted;
    }

    public boolean isAppCommitted() {
        return this.appCommitted || this.isCommitted() || this.isSuspended() || this.getContentLength() > 0 && this.getContentWritten() >= (long)this.getContentLength();
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public HttpServletResponse getResponse() {
        if (this.facade == null) {
            this.facade = new ResponseFacade(this);
        }
        if (this.applicationResponse == null) {
            this.applicationResponse = this.facade;
        }
        return this.applicationResponse;
    }

    public void setResponse(HttpServletResponse applicationResponse) {
        ServletResponse r = applicationResponse;
        while (r instanceof HttpServletResponseWrapper) {
            r = ((HttpServletResponseWrapper)r).getResponse();
        }
        if (r != this.facade) {
            throw new IllegalArgumentException(sm.getString("response.illegalWrap"));
        }
        this.applicationResponse = applicationResponse;
    }

    public void setSuspended(boolean suspended) {
        this.outputBuffer.setSuspended(suspended);
    }

    public boolean isSuspended() {
        return this.outputBuffer.isSuspended();
    }

    public boolean isClosed() {
        return this.outputBuffer.isClosed();
    }

    @Deprecated
    public boolean setError() {
        return this.getCoyoteResponse().setError();
    }

    public boolean isError() {
        return this.getCoyoteResponse().isError();
    }

    public boolean isErrorReportRequired() {
        return this.getCoyoteResponse().isErrorReportRequired();
    }

    public boolean setErrorReported() {
        return this.getCoyoteResponse().setErrorReported();
    }

    public void resetError() {
        this.getCoyoteResponse().resetError();
    }

    public void finishResponse() throws IOException {
        this.outputBuffer.close();
    }

    public int getContentLength() {
        return this.getCoyoteResponse().getContentLength();
    }

    @Override
    public String getContentType() {
        return this.getCoyoteResponse().getContentType();
    }

    public PrintWriter getReporter() throws IOException {
        if (this.outputBuffer.isNew()) {
            this.outputBuffer.checkConverter();
            if (this.writer == null) {
                this.writer = new CoyoteWriter(this.outputBuffer);
            }
            return this.writer;
        }
        return null;
    }

    @Override
    public void flushBuffer() throws IOException {
        this.outputBuffer.flush();
    }

    @Override
    public int getBufferSize() {
        return this.outputBuffer.getBufferSize();
    }

    @Override
    public String getCharacterEncoding() {
        String charset = this.getCoyoteResponse().getCharacterEncoding();
        if (charset != null) {
            return charset;
        }
        Context context = this.getContext();
        String result2 = null;
        if (context != null) {
            result2 = context.getResponseCharacterEncoding();
        }
        if (result2 == null) {
            result2 = Constants.DEFAULT_BODY_CHARSET.name();
        }
        return result2;
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        if (this.usingWriter) {
            throw new IllegalStateException(sm.getString("coyoteResponse.getOutputStream.ise"));
        }
        this.usingOutputStream = true;
        if (this.outputStream == null) {
            this.outputStream = new CoyoteOutputStream(this.outputBuffer);
        }
        return this.outputStream;
    }

    @Override
    public Locale getLocale() {
        return this.getCoyoteResponse().getLocale();
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        if (this.usingOutputStream) {
            throw new IllegalStateException(sm.getString("coyoteResponse.getWriter.ise"));
        }
        if (this.request.getConnector().getEnforceEncodingInGetWriter()) {
            this.setCharacterEncoding(this.getCharacterEncoding());
        }
        this.usingWriter = true;
        this.outputBuffer.checkConverter();
        if (this.writer == null) {
            this.writer = new CoyoteWriter(this.outputBuffer);
        }
        return this.writer;
    }

    @Override
    public boolean isCommitted() {
        return this.getCoyoteResponse().isCommitted();
    }

    @Override
    public void reset() {
        if (this.included) {
            return;
        }
        this.getCoyoteResponse().reset();
        this.outputBuffer.reset();
        this.usingOutputStream = false;
        this.usingWriter = false;
        this.isCharacterEncodingSet = false;
    }

    @Override
    public void resetBuffer() {
        this.resetBuffer(false);
    }

    public void resetBuffer(boolean resetWriterStreamFlags) {
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString("coyoteResponse.resetBuffer.ise"));
        }
        this.outputBuffer.reset(resetWriterStreamFlags);
        if (resetWriterStreamFlags) {
            this.usingOutputStream = false;
            this.usingWriter = false;
            this.isCharacterEncodingSet = false;
        }
    }

    @Override
    public void setBufferSize(int size2) {
        if (this.isCommitted() || !this.outputBuffer.isNew()) {
            throw new IllegalStateException(sm.getString("coyoteResponse.setBufferSize.ise"));
        }
        this.outputBuffer.setBufferSize(size2);
    }

    @Override
    public void setContentLength(int length2) {
        this.setContentLengthLong(length2);
    }

    @Override
    public void setContentLengthLong(long length2) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.getCoyoteResponse().setContentLength(length2);
    }

    @Override
    public void setContentType(String type2) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        if (type2 == null) {
            this.getCoyoteResponse().setContentType(null);
            try {
                this.getCoyoteResponse().setCharacterEncoding(null);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.isCharacterEncodingSet = false;
            return;
        }
        String[] m = MEDIA_TYPE_CACHE.parse(type2);
        if (m == null) {
            this.getCoyoteResponse().setContentTypeNoCharset(type2);
            return;
        }
        if (m[1] == null) {
            this.getCoyoteResponse().setContentTypeNoCharset(type2);
        } else {
            this.getCoyoteResponse().setContentTypeNoCharset(m[0]);
            if (!this.usingWriter) {
                try {
                    this.getCoyoteResponse().setCharacterEncoding(m[1]);
                }
                catch (UnsupportedEncodingException e) {
                    log.warn(sm.getString("coyoteResponse.encoding.invalid", m[1]), e);
                }
                this.isCharacterEncodingSet = true;
            }
        }
    }

    @Override
    public void setCharacterEncoding(String encoding2) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        if (this.usingWriter) {
            return;
        }
        try {
            this.getCoyoteResponse().setCharacterEncoding(encoding2);
        }
        catch (UnsupportedEncodingException e) {
            log.warn(sm.getString("coyoteResponse.encoding.invalid", encoding2), e);
            return;
        }
        this.isCharacterEncodingSet = encoding2 != null;
    }

    @Override
    public void setLocale(Locale locale) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.getCoyoteResponse().setLocale(locale);
        if (this.usingWriter) {
            return;
        }
        if (this.isCharacterEncodingSet) {
            return;
        }
        if (locale == null) {
            try {
                this.getCoyoteResponse().setCharacterEncoding(null);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else {
            String charset;
            Context context = this.getContext();
            if (context != null && (charset = context.getCharset(locale)) != null) {
                try {
                    this.getCoyoteResponse().setCharacterEncoding(charset);
                }
                catch (UnsupportedEncodingException e) {
                    log.warn(sm.getString("coyoteResponse.encoding.invalid", charset), e);
                }
            }
        }
    }

    @Override
    public String getHeader(String name2) {
        return this.getCoyoteResponse().getMimeHeaders().getHeader(name2);
    }

    @Override
    public Collection<String> getHeaderNames() {
        MimeHeaders headers = this.getCoyoteResponse().getMimeHeaders();
        int n = headers.size();
        ArrayList<String> result2 = new ArrayList<String>(n);
        for (int i2 = 0; i2 < n; ++i2) {
            result2.add(headers.getName(i2).toString());
        }
        return result2;
    }

    @Override
    public Collection<String> getHeaders(String name2) {
        Enumeration<String> enumeration = this.getCoyoteResponse().getMimeHeaders().values(name2);
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        while (enumeration.hasMoreElements()) {
            result2.add(enumeration.nextElement());
        }
        return result2;
    }

    public String getMessage() {
        return this.getCoyoteResponse().getMessage();
    }

    @Override
    public int getStatus() {
        return this.getCoyoteResponse().getStatus();
    }

    @Override
    public void addCookie(Cookie cookie) {
        if (this.included || this.isCommitted()) {
            return;
        }
        this.cookies.add(cookie);
        String header = this.generateCookieString(cookie);
        this.addHeader("Set-Cookie", header, this.getContext().getCookieProcessor().getCharset());
    }

    public void addSessionCookieInternal(Cookie cookie) {
        if (this.isCommitted()) {
            return;
        }
        String name2 = cookie.getName();
        String headername = "Set-Cookie";
        String startsWith = name2 + "=";
        String header = this.generateCookieString(cookie);
        boolean set2 = false;
        MimeHeaders headers = this.getCoyoteResponse().getMimeHeaders();
        int n = headers.size();
        for (int i2 = 0; i2 < n; ++i2) {
            if (!headers.getName(i2).toString().equals("Set-Cookie") || !headers.getValue(i2).toString().startsWith(startsWith)) continue;
            headers.getValue(i2).setString(header);
            set2 = true;
        }
        if (!set2) {
            this.addHeader("Set-Cookie", header);
        }
    }

    public String generateCookieString(Cookie cookie) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new PrivilegedGenerateCookieString(this.getContext(), cookie, this.request.getRequest()));
        }
        return this.getContext().getCookieProcessor().generateHeader(cookie, this.request.getRequest());
    }

    @Override
    public void addDateHeader(String name2, long value2) {
        if (name2 == null || name2.length() == 0) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.addHeader(name2, FastHttpDateFormat.formatDate(value2));
    }

    @Override
    public void addHeader(String name2, String value2) {
        this.addHeader(name2, value2, null);
    }

    private void addHeader(String name2, String value2, Charset charset) {
        if (name2 == null || name2.length() == 0 || value2 == null) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        char cc = name2.charAt(0);
        if ((cc == 'C' || cc == 'c') && this.checkSpecialHeader(name2, value2)) {
            return;
        }
        this.getCoyoteResponse().addHeader(name2, value2, charset);
    }

    private boolean checkSpecialHeader(String name2, String value2) {
        if (name2.equalsIgnoreCase("Content-Type")) {
            this.setContentType(value2);
            return true;
        }
        return false;
    }

    @Override
    public void addIntHeader(String name2, int value2) {
        if (name2 == null || name2.length() == 0) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.addHeader(name2, "" + value2);
    }

    @Override
    public boolean containsHeader(String name2) {
        char cc = name2.charAt(0);
        if (cc == 'C' || cc == 'c') {
            if (name2.equalsIgnoreCase("Content-Type")) {
                return this.getCoyoteResponse().getContentType() != null;
            }
            if (name2.equalsIgnoreCase("Content-Length")) {
                return this.getCoyoteResponse().getContentLengthLong() != -1L;
            }
        }
        return this.getCoyoteResponse().containsHeader(name2);
    }

    @Override
    public void setTrailerFields(Supplier<Map<String, String>> supplier) {
        this.getCoyoteResponse().setTrailerFields(supplier);
    }

    @Override
    public Supplier<Map<String, String>> getTrailerFields() {
        return this.getCoyoteResponse().getTrailerFields();
    }

    @Override
    public String encodeRedirectURL(String url) {
        if (this.isEncodeable(this.toAbsolute(url))) {
            return this.toEncoded(url, this.request.getSessionInternal().getIdInternal());
        }
        return url;
    }

    @Override
    public String encodeURL(String url) {
        String absolute;
        try {
            absolute = this.toAbsolute((String)url);
        }
        catch (IllegalArgumentException iae) {
            return url;
        }
        if (this.isEncodeable(absolute)) {
            if (((String)url).equalsIgnoreCase("")) {
                url = absolute;
            } else if (((String)url).equals(absolute) && !this.hasPath((String)url)) {
                url = (String)url + "/";
            }
            return this.toEncoded((String)url, this.request.getSessionInternal().getIdInternal());
        }
        return url;
    }

    public void sendAcknowledgement(ContinueResponseTiming continueResponseTiming) throws IOException {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.getCoyoteResponse().action(ActionCode.ACK, (Object)continueResponseTiming);
    }

    public void sendEarlyHints() {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.getCoyoteResponse().action(ActionCode.EARLY_HINTS, null);
    }

    @Override
    public void sendError(int status2) throws IOException {
        this.sendError(status2, null);
    }

    @Override
    public void sendError(int status2, String message2) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString("coyoteResponse.sendError.ise"));
        }
        if (this.included) {
            return;
        }
        this.setError();
        this.getCoyoteResponse().setStatus(status2);
        this.getCoyoteResponse().setMessage(message2);
        this.resetBuffer();
        this.setSuspended(true);
    }

    @Override
    public void sendRedirect(String location) throws IOException {
        this.sendRedirect(location, 302);
    }

    public void sendRedirect(String location, int status2) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString("coyoteResponse.sendRedirect.ise"));
        }
        if (this.included) {
            return;
        }
        this.resetBuffer(true);
        try {
            Context context = this.getContext();
            String locationUri = this.getRequest().getCoyoteRequest().getSupportsRelativeRedirects() && (context == null || context.getUseRelativeRedirects()) ? location : this.toAbsolute(location);
            this.setStatus(status2);
            this.setHeader("Location", locationUri);
            if (context != null && context.getSendRedirectBody()) {
                PrintWriter writer = this.getWriter();
                writer.print(sm.getString("coyoteResponse.sendRedirect.note", Escape.htmlElementContent(locationUri)));
                this.flushBuffer();
            }
        }
        catch (IllegalArgumentException e) {
            log.warn(sm.getString("response.sendRedirectFail", location), e);
            this.setStatus(404);
        }
        this.setSuspended(true);
    }

    @Override
    public void setDateHeader(String name2, long value2) {
        if (name2 == null || name2.length() == 0) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.setHeader(name2, FastHttpDateFormat.formatDate(value2));
    }

    @Override
    public void setHeader(String name2, String value2) {
        if (name2 == null || name2.length() == 0 || value2 == null) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        char cc = name2.charAt(0);
        if ((cc == 'C' || cc == 'c') && this.checkSpecialHeader(name2, value2)) {
            return;
        }
        this.getCoyoteResponse().setHeader(name2, value2);
    }

    @Override
    public void setIntHeader(String name2, int value2) {
        if (name2 == null || name2.length() == 0) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.setHeader(name2, "" + value2);
    }

    @Override
    public void setStatus(int status2) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.getCoyoteResponse().setStatus(status2);
    }

    protected boolean isEncodeable(String location) {
        if (location == null) {
            return false;
        }
        if (location.startsWith("#")) {
            return false;
        }
        Request hreq = this.request;
        Session session = hreq.getSessionInternal(false);
        if (session == null) {
            return false;
        }
        if (hreq.isRequestedSessionIdFromCookie()) {
            return false;
        }
        if (!hreq.getServletContext().getEffectiveSessionTrackingModes().contains((Object)SessionTrackingMode.URL)) {
            return false;
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            Boolean result2 = AccessController.doPrivileged(new PrivilegedDoIsEncodable(this.getContext(), hreq, session, location));
            return result2;
        }
        return Response.doIsEncodeable(this.getContext(), hreq, session, location);
    }

    private static boolean doIsEncodeable(Context context, Request hreq, Session session, String location) {
        int urlPort;
        URL url = null;
        try {
            URI uri = new URI(location);
            url = uri.toURL();
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            return false;
        }
        if (!hreq.getScheme().equalsIgnoreCase(url.getProtocol())) {
            return false;
        }
        if (!hreq.getServerName().equalsIgnoreCase(url.getHost())) {
            return false;
        }
        int serverPort = hreq.getServerPort();
        if (serverPort == -1) {
            serverPort = "https".equals(hreq.getScheme()) ? 443 : 80;
        }
        if ((urlPort = url.getPort()) == -1) {
            urlPort = "https".equals(url.getProtocol()) ? 443 : 80;
        }
        if (serverPort != urlPort) {
            return false;
        }
        String contextPath = context.getPath();
        if (contextPath != null) {
            String file2 = url.getFile();
            if (!file2.startsWith(contextPath)) {
                return false;
            }
            String tok = ";" + SessionConfig.getSessionUriParamName(context) + "=" + session.getIdInternal();
            if (file2.indexOf(tok, contextPath.length()) >= 0) {
                return false;
            }
        }
        return true;
    }

    protected String toAbsolute(String location) {
        if (location == null) {
            return location;
        }
        boolean leadingSlash = location.startsWith("/");
        if (location.startsWith("//")) {
            this.redirectURLCC.recycle();
            String scheme = this.request.getScheme();
            try {
                this.redirectURLCC.append(scheme, 0, scheme.length());
                this.redirectURLCC.append(':');
                this.redirectURLCC.append(location, 0, location.length());
                return this.redirectURLCC.toString();
            }
            catch (IOException e) {
                throw new IllegalArgumentException(location, e);
            }
        }
        if (leadingSlash || !UriUtil.hasScheme(location)) {
            this.redirectURLCC.recycle();
            String scheme = this.request.getScheme();
            String name2 = this.request.getServerName();
            int port = this.request.getServerPort();
            try {
                this.redirectURLCC.append(scheme, 0, scheme.length());
                this.redirectURLCC.append("://", 0, 3);
                this.redirectURLCC.append(name2, 0, name2.length());
                if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
                    this.redirectURLCC.append(':');
                    String portS = "" + port;
                    this.redirectURLCC.append(portS, 0, portS.length());
                }
                if (!leadingSlash) {
                    String relativePath = this.request.getDecodedRequestURI();
                    int pos2 = relativePath.lastIndexOf(47);
                    CharChunk encodedURI = null;
                    if (SecurityUtil.isPackageProtectionEnabled()) {
                        try {
                            encodedURI = AccessController.doPrivileged(new PrivilegedEncodeUrl(this.urlEncoder, relativePath, pos2));
                        }
                        catch (PrivilegedActionException pae) {
                            throw new IllegalArgumentException(location, pae.getException());
                        }
                    } else {
                        encodedURI = this.urlEncoder.encodeURL(relativePath, 0, pos2);
                    }
                    this.redirectURLCC.append(encodedURI);
                    encodedURI.recycle();
                    this.redirectURLCC.append('/');
                }
                this.redirectURLCC.append(location, 0, location.length());
                this.normalize(this.redirectURLCC);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(location, e);
            }
            return this.redirectURLCC.toString();
        }
        return location;
    }

    private void normalize(CharChunk cc) {
        int truncate2 = cc.indexOf('?');
        if (truncate2 == -1) {
            truncate2 = cc.indexOf('#');
        }
        char[] truncateCC = null;
        if (truncate2 > -1) {
            truncateCC = Arrays.copyOfRange(cc.getBuffer(), cc.getStart() + truncate2, cc.getEnd());
            cc.setEnd(cc.getStart() + truncate2);
        }
        if (cc.endsWith("/.") || cc.endsWith("/..")) {
            try {
                cc.append('/');
            }
            catch (IOException e) {
                throw new IllegalArgumentException(cc.toString(), e);
            }
        }
        char[] c = cc.getChars();
        int start2 = cc.getStart();
        int end2 = cc.getEnd();
        int index2 = 0;
        int startIndex = 0;
        for (int i2 = 0; i2 < 3; ++i2) {
            startIndex = cc.indexOf('/', startIndex + 1);
        }
        index2 = startIndex;
        while ((index2 = cc.indexOf("/./", 0, 3, index2)) >= 0) {
            this.copyChars(c, start2 + index2, start2 + index2 + 2, end2 - start2 - index2 - 2);
            cc.setEnd(end2 -= 2);
        }
        index2 = startIndex;
        while ((index2 = cc.indexOf("/../", 0, 4, index2)) >= 0) {
            if (index2 == startIndex) {
                throw new IllegalArgumentException();
            }
            int index22 = -1;
            for (int pos2 = start2 + index2 - 1; pos2 >= 0 && index22 < 0; --pos2) {
                if (c[pos2] != '/') continue;
                index22 = pos2;
            }
            this.copyChars(c, start2 + index22, start2 + index2 + 3, end2 - start2 - index2 - 3);
            end2 = end2 + index22 - index2 - 3;
            cc.setEnd(end2);
            index2 = index22;
        }
        if (truncateCC != null) {
            try {
                cc.append(truncateCC, 0, truncateCC.length);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException(ioe);
            }
        }
    }

    private void copyChars(char[] c, int dest, int src, int len) {
        System.arraycopy(c, src, c, dest, len);
    }

    private boolean hasPath(String uri) {
        int pos2 = uri.indexOf("://");
        if (pos2 < 0) {
            return false;
        }
        return (pos2 = uri.indexOf(47, pos2 + 3)) >= 0;
    }

    protected String toEncoded(String url, String sessionId) {
        StringBuilder sb;
        int pound;
        if (url == null || sessionId == null) {
            return url;
        }
        String path2 = url;
        String query = "";
        String anchor = "";
        int question = url.indexOf(63);
        if (question >= 0) {
            path2 = url.substring(0, question);
            query = url.substring(question);
        }
        if ((pound = path2.indexOf(35)) >= 0) {
            anchor = path2.substring(pound);
            path2 = path2.substring(0, pound);
        }
        if ((sb = new StringBuilder(path2)).length() > 0) {
            sb.append(';');
            sb.append(SessionConfig.getSessionUriParamName(this.request.getContext()));
            sb.append('=');
            sb.append(sessionId);
        }
        sb.append(anchor);
        sb.append(query);
        return sb.toString();
    }

    private static class PrivilegedGenerateCookieString
    implements PrivilegedAction<String> {
        private final Context context;
        private final Cookie cookie;
        private final HttpServletRequest request;

        PrivilegedGenerateCookieString(Context context, Cookie cookie, HttpServletRequest request) {
            this.context = context;
            this.cookie = cookie;
            this.request = request;
        }

        @Override
        public String run() {
            return this.context.getCookieProcessor().generateHeader(this.cookie, this.request);
        }
    }

    private static class PrivilegedDoIsEncodable
    implements PrivilegedAction<Boolean> {
        private final Context context;
        private final Request hreq;
        private final Session session;
        private final String location;

        PrivilegedDoIsEncodable(Context context, Request hreq, Session session, String location) {
            this.context = context;
            this.hreq = hreq;
            this.session = session;
            this.location = location;
        }

        @Override
        public Boolean run() {
            return Response.doIsEncodeable(this.context, this.hreq, this.session, this.location);
        }
    }

    private static class PrivilegedEncodeUrl
    implements PrivilegedExceptionAction<CharChunk> {
        private final UEncoder urlEncoder;
        private final String relativePath;
        private final int end;

        PrivilegedEncodeUrl(UEncoder urlEncoder, String relativePath, int end2) {
            this.urlEncoder = urlEncoder;
            this.relativePath = relativePath;
            this.end = end2;
        }

        @Override
        public CharChunk run() throws IOException {
            return this.urlEncoder.encodeURL(this.relativePath, 0, this.end);
        }
    }
}

