/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConnection;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletMapping;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import jakarta.servlet.http.PushBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import org.apache.catalina.Globals;
import org.apache.catalina.connector.Request;
import org.apache.catalina.security.SecurityUtil;
import org.apache.tomcat.util.res.StringManager;

public class RequestFacade
implements HttpServletRequest {
    private static final StringManager sm = StringManager.getManager(RequestFacade.class);
    protected Request request = null;

    public RequestFacade(Request request) {
        this.request = request;
    }

    public void clear() {
        this.request = null;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public Object getAttribute(String name2) {
        this.checkFacade();
        return this.request.getAttribute(name2);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        this.checkFacade();
        if (Globals.IS_SECURITY_ENABLED) {
            return AccessController.doPrivileged(new GetAttributePrivilegedAction());
        }
        return this.request.getAttributeNames();
    }

    @Override
    public String getCharacterEncoding() {
        this.checkFacade();
        if (Globals.IS_SECURITY_ENABLED) {
            return AccessController.doPrivileged(new GetCharacterEncodingPrivilegedAction());
        }
        return this.request.getCharacterEncoding();
    }

    @Override
    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.checkFacade();
        this.request.setCharacterEncoding(env);
    }

    @Override
    public int getContentLength() {
        this.checkFacade();
        return this.request.getContentLength();
    }

    @Override
    public String getContentType() {
        this.checkFacade();
        return this.request.getContentType();
    }

    @Override
    public ServletInputStream getInputStream() throws IOException {
        this.checkFacade();
        return this.request.getInputStream();
    }

    @Override
    public String getParameter(String name2) {
        this.checkFacade();
        if (Globals.IS_SECURITY_ENABLED) {
            return AccessController.doPrivileged(new GetParameterPrivilegedAction(name2));
        }
        return this.request.getParameter(name2);
    }

    @Override
    public Enumeration<String> getParameterNames() {
        this.checkFacade();
        if (Globals.IS_SECURITY_ENABLED) {
            return AccessController.doPrivileged(new GetParameterNamesPrivilegedAction());
        }
        return this.request.getParameterNames();
    }

    @Override
    public String[] getParameterValues(String name2) {
        this.checkFacade();
        String[] ret = null;
        if (SecurityUtil.isPackageProtectionEnabled()) {
            ret = AccessController.doPrivileged(new GetParameterValuePrivilegedAction(name2));
            if (ret != null) {
                ret = (String[])ret.clone();
            }
        } else {
            ret = this.request.getParameterValues(name2);
        }
        return ret;
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        this.checkFacade();
        if (Globals.IS_SECURITY_ENABLED) {
            return AccessController.doPrivileged(new GetParameterMapPrivilegedAction());
        }
        return this.request.getParameterMap();
    }

    @Override
    public String getProtocol() {
        this.checkFacade();
        return this.request.getProtocol();
    }

    @Override
    public String getScheme() {
        this.checkFacade();
        return this.request.getScheme();
    }

    @Override
    public String getServerName() {
        this.checkFacade();
        return this.request.getServerName();
    }

    @Override
    public int getServerPort() {
        this.checkFacade();
        return this.request.getServerPort();
    }

    @Override
    public BufferedReader getReader() throws IOException {
        this.checkFacade();
        return this.request.getReader();
    }

    @Override
    public String getRemoteAddr() {
        this.checkFacade();
        return this.request.getRemoteAddr();
    }

    @Override
    public String getRemoteHost() {
        this.checkFacade();
        return this.request.getRemoteHost();
    }

    @Override
    public void setAttribute(String name2, Object o) {
        this.checkFacade();
        this.request.setAttribute(name2, o);
    }

    @Override
    public void removeAttribute(String name2) {
        this.checkFacade();
        this.request.removeAttribute(name2);
    }

    @Override
    public Locale getLocale() {
        this.checkFacade();
        if (Globals.IS_SECURITY_ENABLED) {
            return AccessController.doPrivileged(new GetLocalePrivilegedAction());
        }
        return this.request.getLocale();
    }

    @Override
    public Enumeration<Locale> getLocales() {
        this.checkFacade();
        if (Globals.IS_SECURITY_ENABLED) {
            return AccessController.doPrivileged(new GetLocalesPrivilegedAction());
        }
        return this.request.getLocales();
    }

    @Override
    public boolean isSecure() {
        this.checkFacade();
        return this.request.isSecure();
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path2) {
        this.checkFacade();
        if (Globals.IS_SECURITY_ENABLED) {
            return AccessController.doPrivileged(new GetRequestDispatcherPrivilegedAction(path2));
        }
        return this.request.getRequestDispatcher(path2);
    }

    @Override
    public String getAuthType() {
        this.checkFacade();
        return this.request.getAuthType();
    }

    @Override
    public Cookie[] getCookies() {
        this.checkFacade();
        Cookie[] ret = null;
        if (SecurityUtil.isPackageProtectionEnabled()) {
            ret = AccessController.doPrivileged(new GetCookiesPrivilegedAction());
            if (ret != null) {
                ret = (Cookie[])ret.clone();
            }
        } else {
            ret = this.request.getCookies();
        }
        return ret;
    }

    @Override
    public long getDateHeader(String name2) {
        this.checkFacade();
        return this.request.getDateHeader(name2);
    }

    @Override
    public String getHeader(String name2) {
        this.checkFacade();
        return this.request.getHeader(name2);
    }

    @Override
    public Enumeration<String> getHeaders(String name2) {
        this.checkFacade();
        if (Globals.IS_SECURITY_ENABLED) {
            return AccessController.doPrivileged(new GetHeadersPrivilegedAction(name2));
        }
        return this.request.getHeaders(name2);
    }

    @Override
    public Enumeration<String> getHeaderNames() {
        this.checkFacade();
        if (Globals.IS_SECURITY_ENABLED) {
            return AccessController.doPrivileged(new GetHeaderNamesPrivilegedAction());
        }
        return this.request.getHeaderNames();
    }

    @Override
    public int getIntHeader(String name2) {
        this.checkFacade();
        return this.request.getIntHeader(name2);
    }

    @Override
    public HttpServletMapping getHttpServletMapping() {
        this.checkFacade();
        return this.request.getHttpServletMapping();
    }

    @Override
    public String getMethod() {
        this.checkFacade();
        return this.request.getMethod();
    }

    @Override
    public String getPathInfo() {
        this.checkFacade();
        return this.request.getPathInfo();
    }

    @Override
    public String getPathTranslated() {
        this.checkFacade();
        return this.request.getPathTranslated();
    }

    @Override
    public String getContextPath() {
        this.checkFacade();
        return this.request.getContextPath();
    }

    @Override
    public String getQueryString() {
        this.checkFacade();
        return this.request.getQueryString();
    }

    @Override
    public String getRemoteUser() {
        this.checkFacade();
        return this.request.getRemoteUser();
    }

    @Override
    public boolean isUserInRole(String role) {
        this.checkFacade();
        return this.request.isUserInRole(role);
    }

    @Override
    public Principal getUserPrincipal() {
        this.checkFacade();
        return this.request.getUserPrincipal();
    }

    @Override
    public String getRequestedSessionId() {
        this.checkFacade();
        return this.request.getRequestedSessionId();
    }

    @Override
    public String getRequestURI() {
        this.checkFacade();
        return this.request.getRequestURI();
    }

    @Override
    public StringBuffer getRequestURL() {
        this.checkFacade();
        return this.request.getRequestURL();
    }

    @Override
    public String getServletPath() {
        this.checkFacade();
        return this.request.getServletPath();
    }

    @Override
    public HttpSession getSession(boolean create2) {
        this.checkFacade();
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new GetSessionPrivilegedAction(create2));
        }
        return this.request.getSession(create2);
    }

    @Override
    public HttpSession getSession() {
        return this.getSession(true);
    }

    @Override
    public String changeSessionId() {
        this.checkFacade();
        return this.request.changeSessionId();
    }

    @Override
    public boolean isRequestedSessionIdValid() {
        this.checkFacade();
        return this.request.isRequestedSessionIdValid();
    }

    @Override
    public boolean isRequestedSessionIdFromCookie() {
        this.checkFacade();
        return this.request.isRequestedSessionIdFromCookie();
    }

    @Override
    public boolean isRequestedSessionIdFromURL() {
        this.checkFacade();
        return this.request.isRequestedSessionIdFromURL();
    }

    @Override
    public String getLocalAddr() {
        this.checkFacade();
        return this.request.getLocalAddr();
    }

    @Override
    public String getLocalName() {
        this.checkFacade();
        return this.request.getLocalName();
    }

    @Override
    public int getLocalPort() {
        this.checkFacade();
        return this.request.getLocalPort();
    }

    @Override
    public int getRemotePort() {
        this.checkFacade();
        return this.request.getRemotePort();
    }

    @Override
    public ServletContext getServletContext() {
        this.checkFacade();
        return this.request.getServletContext();
    }

    @Override
    public AsyncContext startAsync() throws IllegalStateException {
        this.checkFacade();
        return this.request.startAsync();
    }

    @Override
    public AsyncContext startAsync(ServletRequest request, ServletResponse response) throws IllegalStateException {
        this.checkFacade();
        return this.request.startAsync(request, response);
    }

    @Override
    public boolean isAsyncStarted() {
        this.checkFacade();
        return this.request.isAsyncStarted();
    }

    @Override
    public boolean isAsyncSupported() {
        this.checkFacade();
        return this.request.isAsyncSupported();
    }

    @Override
    public AsyncContext getAsyncContext() {
        this.checkFacade();
        return this.request.getAsyncContext();
    }

    @Override
    public DispatcherType getDispatcherType() {
        this.checkFacade();
        return this.request.getDispatcherType();
    }

    @Override
    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        this.checkFacade();
        return this.request.authenticate(response);
    }

    @Override
    public void login(String username, String password) throws ServletException {
        this.checkFacade();
        this.request.login(username, password);
    }

    @Override
    public void logout() throws ServletException {
        this.checkFacade();
        this.request.logout();
    }

    @Override
    public Collection<Part> getParts() throws IllegalStateException, IOException, ServletException {
        this.checkFacade();
        return this.request.getParts();
    }

    @Override
    public Part getPart(String name2) throws IllegalStateException, IOException, ServletException {
        this.checkFacade();
        return this.request.getPart(name2);
    }

    public boolean getAllowTrace() {
        this.checkFacade();
        return this.request.getConnector().getAllowTrace();
    }

    @Override
    public long getContentLengthLong() {
        this.checkFacade();
        return this.request.getContentLengthLong();
    }

    @Override
    public <T extends HttpUpgradeHandler> T upgrade(Class<T> httpUpgradeHandlerClass) throws IOException, ServletException {
        this.checkFacade();
        return this.request.upgrade(httpUpgradeHandlerClass);
    }

    @Override
    public PushBuilder newPushBuilder() {
        this.checkFacade();
        return this.request.newPushBuilder();
    }

    public PushBuilder newPushBuilder(HttpServletRequest request) {
        this.checkFacade();
        return this.request.newPushBuilder(request);
    }

    @Override
    public boolean isTrailerFieldsReady() {
        this.checkFacade();
        return this.request.isTrailerFieldsReady();
    }

    @Override
    public Map<String, String> getTrailerFields() {
        this.checkFacade();
        return this.request.getTrailerFields();
    }

    @Override
    public String getRequestId() {
        this.checkFacade();
        return this.request.getRequestId();
    }

    @Override
    public String getProtocolRequestId() {
        this.checkFacade();
        return this.request.getProtocolRequestId();
    }

    @Override
    public ServletConnection getServletConnection() {
        this.checkFacade();
        return this.request.getServletConnection();
    }

    private void checkFacade() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
    }

    private final class GetAttributePrivilegedAction
    implements PrivilegedAction<Enumeration<String>> {
        private GetAttributePrivilegedAction() {
        }

        @Override
        public Enumeration<String> run() {
            return RequestFacade.this.request.getAttributeNames();
        }
    }

    private final class GetCharacterEncodingPrivilegedAction
    implements PrivilegedAction<String> {
        private GetCharacterEncodingPrivilegedAction() {
        }

        @Override
        public String run() {
            return RequestFacade.this.request.getCharacterEncoding();
        }
    }

    private final class GetParameterPrivilegedAction
    implements PrivilegedAction<String> {
        public String name;

        GetParameterPrivilegedAction(String name2) {
            this.name = name2;
        }

        @Override
        public String run() {
            return RequestFacade.this.request.getParameter(this.name);
        }
    }

    private final class GetParameterNamesPrivilegedAction
    implements PrivilegedAction<Enumeration<String>> {
        private GetParameterNamesPrivilegedAction() {
        }

        @Override
        public Enumeration<String> run() {
            return RequestFacade.this.request.getParameterNames();
        }
    }

    private final class GetParameterValuePrivilegedAction
    implements PrivilegedAction<String[]> {
        public String name;

        GetParameterValuePrivilegedAction(String name2) {
            this.name = name2;
        }

        @Override
        public String[] run() {
            return RequestFacade.this.request.getParameterValues(this.name);
        }
    }

    private final class GetParameterMapPrivilegedAction
    implements PrivilegedAction<Map<String, String[]>> {
        private GetParameterMapPrivilegedAction() {
        }

        @Override
        public Map<String, String[]> run() {
            return RequestFacade.this.request.getParameterMap();
        }
    }

    private final class GetLocalePrivilegedAction
    implements PrivilegedAction<Locale> {
        private GetLocalePrivilegedAction() {
        }

        @Override
        public Locale run() {
            return RequestFacade.this.request.getLocale();
        }
    }

    private final class GetLocalesPrivilegedAction
    implements PrivilegedAction<Enumeration<Locale>> {
        private GetLocalesPrivilegedAction() {
        }

        @Override
        public Enumeration<Locale> run() {
            return RequestFacade.this.request.getLocales();
        }
    }

    private final class GetRequestDispatcherPrivilegedAction
    implements PrivilegedAction<RequestDispatcher> {
        private final String path;

        GetRequestDispatcherPrivilegedAction(String path2) {
            this.path = path2;
        }

        @Override
        public RequestDispatcher run() {
            return RequestFacade.this.request.getRequestDispatcher(this.path);
        }
    }

    private final class GetCookiesPrivilegedAction
    implements PrivilegedAction<Cookie[]> {
        private GetCookiesPrivilegedAction() {
        }

        @Override
        public Cookie[] run() {
            return RequestFacade.this.request.getCookies();
        }
    }

    private final class GetHeadersPrivilegedAction
    implements PrivilegedAction<Enumeration<String>> {
        private final String name;

        GetHeadersPrivilegedAction(String name2) {
            this.name = name2;
        }

        @Override
        public Enumeration<String> run() {
            return RequestFacade.this.request.getHeaders(this.name);
        }
    }

    private final class GetHeaderNamesPrivilegedAction
    implements PrivilegedAction<Enumeration<String>> {
        private GetHeaderNamesPrivilegedAction() {
        }

        @Override
        public Enumeration<String> run() {
            return RequestFacade.this.request.getHeaderNames();
        }
    }

    private final class GetSessionPrivilegedAction
    implements PrivilegedAction<HttpSession> {
        private final boolean create;

        GetSessionPrivilegedAction(boolean create2) {
            this.create = create2;
        }

        @Override
        public HttpSession run() {
            return RequestFacade.this.request.getSession(this.create);
        }
    }
}

