/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator.jaspic;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.config.ServerAuthConfig;
import jakarta.security.auth.message.config.ServerAuthContext;
import jakarta.security.auth.message.module.ServerAuthModule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.apache.catalina.authenticator.jaspic.SimpleServerAuthContext;
import org.apache.tomcat.util.res.StringManager;

public class SimpleServerAuthConfig
implements ServerAuthConfig {
    private static StringManager sm = StringManager.getManager(SimpleServerAuthConfig.class);
    private static final String SERVER_AUTH_MODULE_KEY_PREFIX = "org.apache.catalina.authenticator.jaspic.ServerAuthModule.";
    private final String layer;
    private final String appContext;
    private final CallbackHandler handler;
    private final Map<String, Object> properties;
    private volatile ServerAuthContext serverAuthContext;

    public SimpleServerAuthConfig(String layer, String appContext, CallbackHandler handler, Map<String, Object> properties) {
        this.layer = layer;
        this.appContext = appContext;
        this.handler = handler;
        this.properties = properties;
    }

    @Override
    public String getMessageLayer() {
        return this.layer;
    }

    @Override
    public String getAppContext() {
        return this.appContext;
    }

    @Override
    public String getAuthContextID(MessageInfo messageInfo) {
        return messageInfo.toString();
    }

    @Override
    public void refresh() {
        this.serverAuthContext = null;
    }

    @Override
    public boolean isProtected() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerAuthContext getAuthContext(String authContextID, Subject serviceSubject, Map<String, Object> properties) throws AuthException {
        ServerAuthContext serverAuthContext = this.serverAuthContext;
        if (serverAuthContext == null) {
            SimpleServerAuthConfig simpleServerAuthConfig = this;
            synchronized (simpleServerAuthConfig) {
                if (this.serverAuthContext == null) {
                    HashMap<String, Object> mergedProperties = new HashMap<String, Object>();
                    if (this.properties != null) {
                        mergedProperties.putAll(this.properties);
                    }
                    if (properties != null) {
                        mergedProperties.putAll(properties);
                    }
                    ArrayList<ServerAuthModule> modules = new ArrayList<ServerAuthModule>();
                    int moduleIndex = 1;
                    String key2 = SERVER_AUTH_MODULE_KEY_PREFIX + moduleIndex;
                    Object moduleClassName = mergedProperties.get(key2);
                    while (moduleClassName instanceof String) {
                        try {
                            Class<?> clazz = Class.forName((String)moduleClassName);
                            ServerAuthModule module = (ServerAuthModule)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                            module.initialize(null, null, this.handler, mergedProperties);
                            modules.add(module);
                        }
                        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
                            AuthException ae = new AuthException();
                            ae.initCause(e);
                            throw ae;
                        }
                        key2 = SERVER_AUTH_MODULE_KEY_PREFIX + ++moduleIndex;
                        moduleClassName = mergedProperties.get(key2);
                    }
                    if (modules.size() == 0) {
                        throw new AuthException(sm.getString("simpleServerAuthConfig.noModules"));
                    }
                    this.serverAuthContext = this.createServerAuthContext(modules);
                }
                serverAuthContext = this.serverAuthContext;
            }
        }
        return serverAuthContext;
    }

    protected ServerAuthContext createServerAuthContext(List<ServerAuthModule> modules) {
        return new SimpleServerAuthContext(modules);
    }
}

