/*
 * Decompiled with CFR 0.152.
 */
package jakarta.websocket;

import jakarta.websocket.WebSocketContainer;
import java.util.Iterator;
import java.util.ServiceLoader;

public abstract class ContainerProvider {
    private static final String DEFAULT_PROVIDER_CLASS_NAME = "org.apache.tomcat.websocket.WsWebSocketContainer";

    public static WebSocketContainer getWebSocketContainer() {
        WebSocketContainer result2 = null;
        ServiceLoader<ContainerProvider> serviceLoader = ServiceLoader.load(ContainerProvider.class);
        Iterator<ContainerProvider> iter = serviceLoader.iterator();
        while (result2 == null && iter.hasNext()) {
            result2 = iter.next().getContainer();
        }
        if (result2 == null) {
            try {
                Class<?> clazz = Class.forName(DEFAULT_PROVIDER_CLASS_NAME);
                result2 = (WebSocketContainer)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException exception2) {
                // empty catch block
            }
        }
        return result2;
    }

    protected abstract WebSocketContainer getContainer();
}

