/*
 * Decompiled with CFR 0.152.
 */
package jakarta.servlet.http;

import jakarta.servlet.http.CookieNameValidator;
import jakarta.servlet.http.RFC6265Validator;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;

public class Cookie
implements Cloneable,
Serializable {
    private static final String LSTRING_FILE = "jakarta.servlet.http.LocalStrings";
    private static final ResourceBundle LSTRINGS = ResourceBundle.getBundle("jakarta.servlet.http.LocalStrings");
    private static final CookieNameValidator validation = new RFC6265Validator();
    private static final long serialVersionUID = 2L;
    private final String name;
    private String value;
    private volatile Map<String, String> attributes;
    private static final String DOMAIN = "Domain";
    private static final String MAX_AGE = "Max-Age";
    private static final String PATH = "Path";
    private static final String SECURE = "Secure";
    private static final String HTTP_ONLY = "HttpOnly";

    public Cookie(String name2, String value2) {
        validation.validate(name2);
        this.name = name2;
        this.value = value2;
    }

    @Deprecated(since="Servlet 6.0", forRemoval=true)
    public void setComment(String purpose) {
    }

    @Deprecated(since="Servlet 6.0", forRemoval=true)
    public String getComment() {
        return null;
    }

    public void setDomain(String pattern) {
        if (pattern == null) {
            this.setAttributeInternal(DOMAIN, null);
        } else {
            this.setAttributeInternal(DOMAIN, pattern.toLowerCase(Locale.ENGLISH));
        }
    }

    public String getDomain() {
        return this.getAttribute(DOMAIN);
    }

    public void setMaxAge(int expiry) {
        this.setAttributeInternal(MAX_AGE, Integer.toString(expiry));
    }

    public int getMaxAge() {
        String maxAge = this.getAttribute(MAX_AGE);
        if (maxAge == null) {
            return -1;
        }
        return Integer.parseInt(maxAge);
    }

    public void setPath(String uri) {
        this.setAttributeInternal(PATH, uri);
    }

    public String getPath() {
        return this.getAttribute(PATH);
    }

    public void setSecure(boolean flag) {
        this.setAttributeInternal(SECURE, Boolean.toString(flag));
    }

    public boolean getSecure() {
        return Boolean.parseBoolean(this.getAttribute(SECURE));
    }

    public String getName() {
        return this.name;
    }

    public void setValue(String newValue) {
        this.value = newValue;
    }

    public String getValue() {
        return this.value;
    }

    @Deprecated(since="Servlet 6.0", forRemoval=true)
    public int getVersion() {
        return 0;
    }

    @Deprecated(since="Servlet 6.0", forRemoval=true)
    public void setVersion(int v) {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void setHttpOnly(boolean httpOnly) {
        this.setAttributeInternal(HTTP_ONLY, Boolean.toString(httpOnly));
    }

    public boolean isHttpOnly() {
        return Boolean.parseBoolean(this.getAttribute(HTTP_ONLY));
    }

    public void setAttribute(String name2, String value2) {
        if (name2 == null) {
            throw new IllegalArgumentException(LSTRINGS.getString("cookie.attribute.invalidName.null"));
        }
        if (!validation.isToken(name2)) {
            String msg = LSTRINGS.getString("cookie.attribute.invalidName.notToken");
            throw new IllegalArgumentException(MessageFormat.format(msg, name2));
        }
        if (name2.equalsIgnoreCase(MAX_AGE)) {
            if (value2 == null) {
                this.setAttributeInternal(MAX_AGE, null);
            } else {
                this.setMaxAge(Integer.parseInt(value2));
            }
        } else {
            this.setAttributeInternal(name2, value2);
        }
    }

    private void setAttributeInternal(String name2, String value2) {
        if (this.attributes == null) {
            if (value2 == null) {
                return;
            }
            this.attributes = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        }
        if (value2 == null) {
            this.attributes.remove(name2);
        } else {
            this.attributes.put(name2, value2);
        }
    }

    public String getAttribute(String name2) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name2);
    }

    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.attributes);
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.attributes == null ? 0 : this.attributes.hashCode());
        result2 = 31 * result2 + (this.name == null ? 0 : this.name.hashCode());
        result2 = 31 * result2 + (this.value == null ? 0 : this.value.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cookie other = (Cookie)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

