/*
 * Decompiled with CFR 0.152.
 */
package jakarta.servlet;

import jakarta.servlet.HttpConstraintElement;
import jakarta.servlet.HttpMethodConstraintElement;
import jakarta.servlet.annotation.HttpMethodConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ServletSecurityElement
extends HttpConstraintElement {
    private final Map<String, HttpMethodConstraintElement> methodConstraints = new HashMap<String, HttpMethodConstraintElement>();

    public ServletSecurityElement() {
    }

    public ServletSecurityElement(HttpConstraintElement httpConstraintElement) {
        this(httpConstraintElement, null);
    }

    public ServletSecurityElement(Collection<HttpMethodConstraintElement> httpMethodConstraints) {
        this.addHttpMethodConstraints(httpMethodConstraints);
    }

    public ServletSecurityElement(HttpConstraintElement httpConstraintElement, Collection<HttpMethodConstraintElement> httpMethodConstraints) {
        super(httpConstraintElement.getEmptyRoleSemantic(), httpConstraintElement.getTransportGuarantee(), httpConstraintElement.getRolesAllowed());
        this.addHttpMethodConstraints(httpMethodConstraints);
    }

    public ServletSecurityElement(ServletSecurity annotation) {
        this(new HttpConstraintElement(annotation.value().value(), annotation.value().transportGuarantee(), annotation.value().rolesAllowed()));
        ArrayList<HttpMethodConstraintElement> l = new ArrayList<HttpMethodConstraintElement>();
        HttpMethodConstraint[] constraints = annotation.httpMethodConstraints();
        if (constraints != null) {
            for (HttpMethodConstraint constraint : constraints) {
                HttpMethodConstraintElement e = new HttpMethodConstraintElement(constraint.value(), new HttpConstraintElement(constraint.emptyRoleSemantic(), constraint.transportGuarantee(), constraint.rolesAllowed()));
                l.add(e);
            }
        }
        this.addHttpMethodConstraints(l);
    }

    public Collection<HttpMethodConstraintElement> getHttpMethodConstraints() {
        HashSet<HttpMethodConstraintElement> result2 = new HashSet<HttpMethodConstraintElement>(this.methodConstraints.values());
        return result2;
    }

    public Collection<String> getMethodNames() {
        HashSet<String> result2 = new HashSet<String>(this.methodConstraints.keySet());
        return result2;
    }

    private void addHttpMethodConstraints(Collection<HttpMethodConstraintElement> httpMethodConstraints) {
        if (httpMethodConstraints == null) {
            return;
        }
        for (HttpMethodConstraintElement constraint : httpMethodConstraints) {
            String method2 = constraint.getMethodName();
            if (this.methodConstraints.containsKey(method2)) {
                throw new IllegalArgumentException("Duplicate method name: " + method2);
            }
            this.methodConstraints.put(method2, constraint);
        }
    }
}

