/*
 * Decompiled with CFR 0.152.
 */
package jakarta.servlet;

import jakarta.servlet.WriteListener;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public abstract class ServletOutputStream
extends OutputStream {
    private static final String LSTRING_FILE = "jakarta.servlet.LocalStrings";
    private static final ResourceBundle lStrings = ResourceBundle.getBundle("jakarta.servlet.LocalStrings");

    protected ServletOutputStream() {
    }

    public void print(String s2) throws IOException {
        if (s2 == null) {
            s2 = "null";
        }
        int len = s2.length();
        byte[] buffer = new byte[len];
        for (int i2 = 0; i2 < len; ++i2) {
            char c = s2.charAt(i2);
            if ((c & 0xFF00) != 0) {
                String errMsg = lStrings.getString("err.not_iso8859_1");
                Object[] errArgs = new Object[]{Character.valueOf(c)};
                errMsg = MessageFormat.format(errMsg, errArgs);
                throw new CharConversionException(errMsg);
            }
            buffer[i2] = (byte)(c & 0xFF);
        }
        this.write(buffer);
    }

    public void print(boolean b2) throws IOException {
        String msg = b2 ? lStrings.getString("value.true") : lStrings.getString("value.false");
        this.print(msg);
    }

    public void print(char c) throws IOException {
        this.print(String.valueOf(c));
    }

    public void print(int i2) throws IOException {
        this.print(String.valueOf(i2));
    }

    public void print(long l) throws IOException {
        this.print(String.valueOf(l));
    }

    public void print(float f) throws IOException {
        this.print(String.valueOf(f));
    }

    public void print(double d) throws IOException {
        this.print(String.valueOf(d));
    }

    public void println() throws IOException {
        this.print("\r\n");
    }

    public void println(String s2) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(s2);
        sb.append("\r\n");
        this.print(sb.toString());
    }

    public void println(boolean b2) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (b2) {
            sb.append(lStrings.getString("value.true"));
        } else {
            sb.append(lStrings.getString("value.false"));
        }
        sb.append("\r\n");
        this.print(sb.toString());
    }

    public void println(char c) throws IOException {
        this.println(String.valueOf(c));
    }

    public void println(int i2) throws IOException {
        this.println(String.valueOf(i2));
    }

    public void println(long l) throws IOException {
        this.println(String.valueOf(l));
    }

    public void println(float f) throws IOException {
        this.println(String.valueOf(f));
    }

    public void println(double d) throws IOException {
        this.println(String.valueOf(d));
    }

    public abstract boolean isReady();

    public abstract void setWriteListener(WriteListener var1);
}

