/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ExpressionFactory;
import jakarta.el.MethodNotFoundException;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class Util {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final boolean IS_SECURITY_ENABLED;
    private static final boolean GET_CLASSLOADER_USE_PRIVILEGED;
    private static final CacheValue nullTcclFactory;
    private static final Map<CacheKey, CacheValue> factoryCache;

    Util() {
    }

    static void handleThrowable(Throwable t) {
        if (t instanceof ThreadDeath) {
            throw (ThreadDeath)t;
        }
        if (t instanceof VirtualMachineError) {
            throw (VirtualMachineError)t;
        }
    }

    static String message(ELContext context, String name2, Object ... props) {
        Locale locale = null;
        if (context != null) {
            locale = context.getLocale();
        }
        if (locale == null && (locale = Locale.getDefault()) == null) {
            return "";
        }
        ResourceBundle bundle = ResourceBundle.getBundle("jakarta.el.LocalStrings", locale);
        try {
            String template = bundle.getString(name2);
            if (props != null) {
                template = MessageFormat.format(template, props);
            }
            return template;
        }
        catch (MissingResourceException e) {
            return "Missing Resource: '" + name2 + "' for Locale " + locale.getDisplayName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ExpressionFactory getExpressionFactory() {
        ClassLoader tccl = Util.getContextClassLoader();
        CacheValue cacheValue = null;
        ExpressionFactory factory = null;
        if (tccl == null) {
            cacheValue = nullTcclFactory;
        } else {
            CacheValue newCacheValue;
            CacheKey key2 = new CacheKey(tccl);
            cacheValue = factoryCache.get(key2);
            if (cacheValue == null && (cacheValue = factoryCache.putIfAbsent(key2, newCacheValue = new CacheValue())) == null) {
                cacheValue = newCacheValue;
            }
        }
        Lock readLock = cacheValue.getLock().readLock();
        readLock.lock();
        try {
            factory = cacheValue.getExpressionFactory();
        }
        finally {
            readLock.unlock();
        }
        if (factory == null) {
            Lock writeLock = cacheValue.getLock().writeLock();
            writeLock.lock();
            try {
                factory = cacheValue.getExpressionFactory();
                if (factory == null) {
                    factory = ExpressionFactory.newInstance();
                    cacheValue.setExpressionFactory(factory);
                }
            }
            finally {
                writeLock.unlock();
            }
        }
        return factory;
    }

    static Method findMethod(ELContext context, Class<?> clazz, Object base, String methodName, Class<?>[] paramTypes, Object[] paramValues) {
        if (clazz == null || methodName == null) {
            throw new MethodNotFoundException(Util.message(null, "util.method.notfound", clazz, methodName, Util.paramString(paramTypes)));
        }
        if (paramTypes == null) {
            paramTypes = Util.getTypesFromValues(paramValues);
        }
        Method[] methods2 = clazz.getMethods();
        List wrappers = Wrapper.wrap(methods2, methodName);
        Wrapper result2 = Util.findWrapper(context, clazz, wrappers, methodName, paramTypes, paramValues);
        return Util.getMethod(clazz, base, (Method)result2.unWrap());
    }

    private static <T> Wrapper<T> findWrapper(ELContext context, Class<?> clazz, List<Wrapper<T>> wrappers, String name2, Class<?>[] paramTypes, Object[] paramValues) {
        HashMap<Wrapper<T>, MatchResult> candidates = new HashMap<Wrapper<T>, MatchResult>();
        int paramCount = paramTypes.length;
        for (Wrapper<T> w : wrappers) {
            Class<?>[] mParamTypes = w.getParameterTypes();
            int mParamCount = mParamTypes == null ? 0 : mParamTypes.length;
            if (!w.isVarArgs() && paramCount != mParamCount || w.isVarArgs() && paramCount < mParamCount - 1 || w.isVarArgs() && paramCount == mParamCount && paramValues != null && paramValues.length > paramCount && !paramTypes[mParamCount - 1].isArray() || w.isVarArgs() && paramCount > mParamCount && paramValues != null && paramValues.length != paramCount || !w.isVarArgs() && paramValues != null && paramCount != paramValues.length) continue;
            int exactMatch = 0;
            int assignableMatch = 0;
            int coercibleMatch = 0;
            int varArgsMatch = 0;
            boolean noMatch = false;
            block1: for (int i2 = 0; i2 < mParamCount; ++i2) {
                if (w.isVarArgs() && i2 == mParamCount - 1) {
                    if (i2 == paramCount || paramValues != null && paramValues.length == i2) {
                        varArgsMatch = Integer.MAX_VALUE;
                        break;
                    }
                    Class<?> varType = mParamTypes[i2].getComponentType();
                    for (int j = i2; j < paramCount; ++j) {
                        if (Util.isAssignableFrom(paramTypes[j], varType)) {
                            ++assignableMatch;
                            ++varArgsMatch;
                            continue;
                        }
                        if (paramValues == null) {
                            noMatch = true;
                            continue block1;
                        }
                        if (Util.isCoercibleFrom(context, paramValues[j], varType)) {
                            ++coercibleMatch;
                            ++varArgsMatch;
                            continue;
                        }
                        noMatch = true;
                        continue block1;
                    }
                    continue;
                }
                if (mParamTypes[i2].equals(paramTypes[i2])) {
                    ++exactMatch;
                    continue;
                }
                if (paramTypes[i2] != null && Util.isAssignableFrom(paramTypes[i2], mParamTypes[i2])) {
                    ++assignableMatch;
                    continue;
                }
                if (paramValues == null) {
                    noMatch = true;
                    break;
                }
                if (Util.isCoercibleFrom(context, paramValues[i2], mParamTypes[i2])) {
                    ++coercibleMatch;
                    continue;
                }
                noMatch = true;
                break;
            }
            if (noMatch) continue;
            if (exactMatch == paramCount && varArgsMatch == 0) {
                return w;
            }
            candidates.put(w, new MatchResult(w.isVarArgs(), exactMatch, assignableMatch, coercibleMatch, varArgsMatch, w.isBridge()));
        }
        MatchResult bestMatch = new MatchResult(true, 0, 0, 0, 0, true);
        Wrapper match2 = null;
        boolean multiple = false;
        for (Map.Entry entry : candidates.entrySet()) {
            int cmp2 = ((MatchResult)entry.getValue()).compareTo(bestMatch);
            if (cmp2 > 0 || match2 == null) {
                bestMatch = (MatchResult)entry.getValue();
                match2 = (Wrapper)entry.getKey();
                multiple = false;
                continue;
            }
            if (cmp2 != 0) continue;
            multiple = true;
        }
        if (multiple && (match2 = bestMatch.getExactCount() == paramCount - 1 ? Util.resolveAmbiguousWrapper(candidates.keySet(), paramTypes) : null) == null) {
            throw new MethodNotFoundException(Util.message(null, "util.method.ambiguous", clazz, name2, Util.paramString(paramTypes)));
        }
        if (match2 == null) {
            throw new MethodNotFoundException(Util.message(null, "util.method.notfound", clazz, name2, Util.paramString(paramTypes)));
        }
        return match2;
    }

    private static String paramString(Class<?>[] types) {
        if (types != null) {
            StringBuilder sb = new StringBuilder();
            for (Class<?> type2 : types) {
                if (type2 == null) {
                    sb.append("null, ");
                    continue;
                }
                sb.append(type2.getName()).append(", ");
            }
            if (sb.length() > 2) {
                sb.setLength(sb.length() - 2);
            }
            return sb.toString();
        }
        return null;
    }

    private static <T> Wrapper<T> resolveAmbiguousWrapper(Set<Wrapper<T>> candidates, Class<?>[] paramTypes) {
        Wrapper<T> w = candidates.iterator().next();
        int nonMatchIndex = 0;
        Class<?> nonMatchClass = null;
        for (int i2 = 0; i2 < paramTypes.length; ++i2) {
            if (w.getParameterTypes()[i2] == paramTypes[i2]) continue;
            nonMatchIndex = i2;
            nonMatchClass = paramTypes[i2];
            break;
        }
        if (nonMatchClass == null) {
            return null;
        }
        for (Wrapper<T> c : candidates) {
            if (c.getParameterTypes()[nonMatchIndex] != paramTypes[nonMatchIndex]) continue;
            return null;
        }
        for (Class superClass = nonMatchClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            for (Wrapper wrapper : candidates) {
                if (!wrapper.getParameterTypes()[nonMatchIndex].equals(superClass)) continue;
                return wrapper;
            }
        }
        Wrapper<T> match2 = null;
        if (Number.class.isAssignableFrom(nonMatchClass)) {
            for (Wrapper<T> c : candidates) {
                Class<?> candidateType = c.getParameterTypes()[nonMatchIndex];
                if (!Number.class.isAssignableFrom(candidateType) && !candidateType.isPrimitive()) continue;
                if (match2 == null) {
                    match2 = c;
                    continue;
                }
                match2 = null;
                break;
            }
        }
        return match2;
    }

    static boolean isAssignableFrom(Class<?> src, Class<?> target2) {
        if (src == null) {
            return true;
        }
        Class<Object> targetClass = target2.isPrimitive() ? (target2 == Boolean.TYPE ? Boolean.class : (target2 == Character.TYPE ? Character.class : (target2 == Byte.TYPE ? Byte.class : (target2 == Short.TYPE ? Short.class : (target2 == Integer.TYPE ? Integer.class : (target2 == Long.TYPE ? Long.class : (target2 == Float.TYPE ? Float.class : Double.class))))))) : target2;
        return targetClass.isAssignableFrom(src);
    }

    private static boolean isCoercibleFrom(ELContext context, Object src, Class<?> target2) {
        try {
            context.convertToType(src, target2);
        }
        catch (ELException e) {
            return false;
        }
        return true;
    }

    private static Class<?>[] getTypesFromValues(Object[] values2) {
        if (values2 == null) {
            return EMPTY_CLASS_ARRAY;
        }
        Class[] result2 = new Class[values2.length];
        for (int i2 = 0; i2 < values2.length; ++i2) {
            result2[i2] = values2[i2] == null ? null : values2[i2].getClass();
        }
        return result2;
    }

    static Method getMethod(Class<?> type2, Object base, Method m) {
        if (m == null || Modifier.isPublic(type2.getModifiers()) && (Modifier.isStatic(m.getModifiers()) && Util.canAccess(null, m) || Util.canAccess(base, m))) {
            return m;
        }
        Class<?>[] interfaces2 = type2.getInterfaces();
        Method mp = null;
        for (Class<?> iface : interfaces2) {
            try {
                mp = iface.getMethod(m.getName(), m.getParameterTypes());
                mp = Util.getMethod(mp.getDeclaringClass(), base, mp);
                if (mp == null) continue;
                return mp;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        Class<?> sup = type2.getSuperclass();
        if (sup != null) {
            try {
                mp = sup.getMethod(m.getName(), m.getParameterTypes());
                mp = Util.getMethod(mp.getDeclaringClass(), base, mp);
                if (mp != null) {
                    return mp;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    static Constructor<?> findConstructor(ELContext context, Class<?> clazz, Class<?>[] paramTypes, Object[] paramValues) {
        String methodName = "<init>";
        if (clazz == null) {
            throw new MethodNotFoundException(Util.message(null, "util.method.notfound", null, methodName, Util.paramString(paramTypes)));
        }
        if (paramTypes == null) {
            paramTypes = Util.getTypesFromValues(paramValues);
        }
        Constructor<?>[] constructors2 = clazz.getConstructors();
        List wrappers = Wrapper.wrap(constructors2);
        Wrapper wrapper = Util.findWrapper(context, clazz, wrappers, methodName, paramTypes, paramValues);
        Constructor constructor2 = (Constructor)wrapper.unWrap();
        if (!Modifier.isPublic(clazz.getModifiers()) || !Util.canAccess(null, constructor2)) {
            throw new MethodNotFoundException(Util.message(null, "util.method.notfound", clazz, methodName, Util.paramString(paramTypes)));
        }
        return constructor2;
    }

    static boolean canAccess(Object base, AccessibleObject accessibleObject) {
        try {
            return accessibleObject.canAccess(base);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    static Object[] buildParameters(ELContext context, Class<?>[] parameterTypes, boolean isVarArgs, Object[] params2) {
        Object[] parameters2 = null;
        if (parameterTypes.length > 0) {
            parameters2 = new Object[parameterTypes.length];
            if (params2 == null) {
                params2 = EMPTY_OBJECT_ARRAY;
            }
            int paramCount = params2.length;
            if (isVarArgs) {
                int varArgIndex = parameterTypes.length - 1;
                for (int i2 = 0; i2 < varArgIndex; ++i2) {
                    parameters2[i2] = context.convertToType(params2[i2], parameterTypes[i2]);
                }
                Class<?> varArgClass = parameterTypes[varArgIndex].getComponentType();
                Object varargs = Array.newInstance(varArgClass, paramCount - varArgIndex);
                for (int i3 = varArgIndex; i3 < paramCount; ++i3) {
                    Array.set(varargs, i3 - varArgIndex, context.convertToType(params2[i3], varArgClass));
                }
                parameters2[varArgIndex] = varargs;
            } else {
                parameters2 = new Object[parameterTypes.length];
                for (int i4 = 0; i4 < parameterTypes.length; ++i4) {
                    parameters2[i4] = context.convertToType(params2[i4], parameterTypes[i4]);
                }
            }
        }
        return parameters2;
    }

    static ClassLoader getContextClassLoader() {
        ClassLoader tccl;
        if (IS_SECURITY_ENABLED && GET_CLASSLOADER_USE_PRIVILEGED) {
            PrivilegedGetTccl pa = new PrivilegedGetTccl();
            tccl = AccessController.doPrivileged(pa);
        } else {
            tccl = Thread.currentThread().getContextClassLoader();
        }
        return tccl;
    }

    static {
        boolean bl = IS_SECURITY_ENABLED = System.getSecurityManager() != null;
        if (IS_SECURITY_ENABLED) {
            String value2 = AccessController.doPrivileged(() -> System.getProperty("org.apache.el.GET_CLASSLOADER_USE_PRIVILEGED", "true"));
            GET_CLASSLOADER_USE_PRIVILEGED = Boolean.parseBoolean(value2);
        } else {
            GET_CLASSLOADER_USE_PRIVILEGED = false;
        }
        nullTcclFactory = new CacheValue();
        factoryCache = new ConcurrentHashMap<CacheKey, CacheValue>();
    }

    private static class CacheValue {
        private final ReadWriteLock lock = new ReentrantReadWriteLock();
        private WeakReference<ExpressionFactory> ref;

        CacheValue() {
        }

        public ReadWriteLock getLock() {
            return this.lock;
        }

        public ExpressionFactory getExpressionFactory() {
            return this.ref != null ? (ExpressionFactory)this.ref.get() : null;
        }

        public void setExpressionFactory(ExpressionFactory factory) {
            this.ref = new WeakReference<ExpressionFactory>(factory);
        }
    }

    private static class CacheKey {
        private final int hash;
        private final WeakReference<ClassLoader> ref;

        CacheKey(ClassLoader key2) {
            this.hash = key2.hashCode();
            this.ref = new WeakReference<ClassLoader>(key2);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            ClassLoader thisKey = (ClassLoader)this.ref.get();
            if (thisKey == null) {
                return false;
            }
            return thisKey == ((CacheKey)obj).ref.get();
        }
    }

    private static abstract class Wrapper<T> {
        private Wrapper() {
        }

        public static List<Wrapper<Method>> wrap(Method[] methods2, String name2) {
            ArrayList<Wrapper<Method>> result2 = new ArrayList<Wrapper<Method>>();
            for (Method method2 : methods2) {
                if (!method2.getName().equals(name2)) continue;
                result2.add(new MethodWrapper(method2));
            }
            return result2;
        }

        public static List<Wrapper<Constructor<?>>> wrap(Constructor<?>[] constructors2) {
            ArrayList result2 = new ArrayList();
            for (Constructor<?> constructor2 : constructors2) {
                result2.add(new ConstructorWrapper(constructor2));
            }
            return result2;
        }

        public abstract T unWrap();

        public abstract Class<?>[] getParameterTypes();

        public abstract boolean isVarArgs();

        public abstract boolean isBridge();
    }

    private static class MatchResult
    implements Comparable<MatchResult> {
        private final boolean varArgs;
        private final int exactCount;
        private final int assignableCount;
        private final int coercibleCount;
        private final int varArgsCount;
        private final boolean bridge;

        MatchResult(boolean varArgs, int exactCount, int assignableCount, int coercibleCount, int varArgsCount, boolean bridge) {
            this.varArgs = varArgs;
            this.exactCount = exactCount;
            this.assignableCount = assignableCount;
            this.coercibleCount = coercibleCount;
            this.varArgsCount = varArgsCount;
            this.bridge = bridge;
        }

        public boolean isVarArgs() {
            return this.varArgs;
        }

        public int getExactCount() {
            return this.exactCount;
        }

        public int getAssignableCount() {
            return this.assignableCount;
        }

        public int getCoercibleCount() {
            return this.coercibleCount;
        }

        public int getVarArgsCount() {
            return this.varArgsCount;
        }

        public boolean isBridge() {
            return this.bridge;
        }

        @Override
        public int compareTo(MatchResult o) {
            int cmp2 = Boolean.compare(o.isVarArgs(), this.isVarArgs());
            if (cmp2 == 0 && (cmp2 = Integer.compare(this.getExactCount(), o.getExactCount())) == 0 && (cmp2 = Integer.compare(this.getAssignableCount(), o.getAssignableCount())) == 0 && (cmp2 = Integer.compare(this.getCoercibleCount(), o.getCoercibleCount())) == 0 && (cmp2 = Integer.compare(o.getVarArgsCount(), this.getVarArgsCount())) == 0) {
                cmp2 = Boolean.compare(o.isBridge(), this.isBridge());
            }
            return cmp2;
        }

        public boolean equals(Object o) {
            return o == this || null != o && this.getClass().equals(o.getClass()) && ((MatchResult)o).getExactCount() == this.getExactCount() && ((MatchResult)o).getAssignableCount() == this.getAssignableCount() && ((MatchResult)o).getCoercibleCount() == this.getCoercibleCount() && ((MatchResult)o).getVarArgsCount() == this.getVarArgsCount() && ((MatchResult)o).isVarArgs() == this.isVarArgs() && ((MatchResult)o).isBridge() == this.isBridge();
        }

        public int hashCode() {
            int prime = 31;
            int result2 = 1;
            result2 = 31 * result2 + this.assignableCount;
            result2 = 31 * result2 + (this.bridge ? 1231 : 1237);
            result2 = 31 * result2 + this.coercibleCount;
            result2 = 31 * result2 + this.exactCount;
            result2 = 31 * result2 + (this.varArgs ? 1231 : 1237);
            result2 = 31 * result2 + this.varArgsCount;
            return result2;
        }
    }

    private static class PrivilegedGetTccl
    implements PrivilegedAction<ClassLoader> {
        private PrivilegedGetTccl() {
        }

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }

    private static class ConstructorWrapper
    extends Wrapper<Constructor<?>> {
        private final Constructor<?> c;

        ConstructorWrapper(Constructor<?> c) {
            this.c = c;
        }

        @Override
        public Constructor<?> unWrap() {
            return this.c;
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.c.getParameterTypes();
        }

        @Override
        public boolean isVarArgs() {
            return this.c.isVarArgs();
        }

        @Override
        public boolean isBridge() {
            return false;
        }
    }

    private static class MethodWrapper
    extends Wrapper<Method> {
        private final Method m;

        MethodWrapper(Method m) {
            this.m = m;
        }

        @Override
        public Method unWrap() {
            return this.m;
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.m.getParameterTypes();
        }

        @Override
        public boolean isVarArgs() {
            return this.m.isVarArgs();
        }

        @Override
        public boolean isBridge() {
            return this.m.isBridge();
        }
    }
}

