/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.ELClass;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ELResolver;
import jakarta.el.MethodNotFoundException;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.PropertyNotWritableException;
import jakarta.el.Util;
import java.beans.FeatureDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.Objects;

public class StaticFieldELResolver
extends ELResolver {
    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        if (base instanceof ELClass && property instanceof String) {
            context.setPropertyResolved(base, property);
            Class<?> clazz = ((ELClass)base).getKlass();
            String name2 = (String)property;
            Exception exception2 = null;
            try {
                Field field = clazz.getField(name2);
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers) && Util.canAccess(null, field)) {
                    return field.get(null);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                exception2 = e;
            }
            String msg = Util.message(context, "staticFieldELResolver.notFound", name2, clazz.getName());
            if (exception2 == null) {
                throw new PropertyNotFoundException(msg);
            }
            throw new PropertyNotFoundException(msg, exception2);
        }
        return null;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value2) {
        Objects.requireNonNull(context);
        if (base instanceof ELClass && property instanceof String) {
            Class<?> clazz = ((ELClass)base).getKlass();
            String name2 = (String)property;
            throw new PropertyNotWritableException(Util.message(context, "staticFieldELResolver.notWritable", name2, clazz.getName()));
        }
    }

    @Override
    public Object invoke(ELContext context, Object base, Object method2, Class<?>[] paramTypes, Object[] params2) {
        Objects.requireNonNull(context);
        if (base instanceof ELClass && method2 instanceof String) {
            context.setPropertyResolved(base, method2);
            Class<?> clazz = ((ELClass)base).getKlass();
            String methodName = (String)method2;
            if ("<init>".equals(methodName)) {
                Constructor<?> match2 = Util.findConstructor(context, clazz, paramTypes, params2);
                Object[] parameters2 = Util.buildParameters(context, match2.getParameterTypes(), match2.isVarArgs(), params2);
                Object result2 = null;
                try {
                    result2 = match2.newInstance(parameters2);
                }
                catch (InvocationTargetException e) {
                    Throwable cause2 = e.getCause();
                    Util.handleThrowable(cause2);
                    throw new ELException(cause2);
                }
                catch (ReflectiveOperationException e) {
                    throw new ELException(e);
                }
                return result2;
            }
            Method match3 = Util.findMethod(context, clazz, null, methodName, paramTypes, params2);
            if (match3 == null) {
                throw new MethodNotFoundException(Util.message(context, "staticFieldELResolver.methodNotFound", methodName, clazz.getName()));
            }
            Object[] parameters3 = Util.buildParameters(context, match3.getParameterTypes(), match3.isVarArgs(), params2);
            Object result3 = null;
            try {
                result3 = match3.invoke(null, parameters3);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new ELException(e);
            }
            catch (InvocationTargetException e) {
                Throwable cause3 = e.getCause();
                Util.handleThrowable(cause3);
                throw new ELException(cause3);
            }
            return result3;
        }
        return null;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        if (base instanceof ELClass && property instanceof String) {
            context.setPropertyResolved(base, property);
            Class<?> clazz = ((ELClass)base).getKlass();
            String name2 = (String)property;
            Exception exception2 = null;
            try {
                Field field = clazz.getField(name2);
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers) && Util.canAccess(null, field)) {
                    return null;
                }
            }
            catch (IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                exception2 = e;
            }
            String msg = Util.message(context, "staticFieldELResolver.notFound", name2, clazz.getName());
            if (exception2 == null) {
                throw new PropertyNotFoundException(msg);
            }
            throw new PropertyNotFoundException(msg, exception2);
        }
        return null;
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        if (base instanceof ELClass && property instanceof String) {
            context.setPropertyResolved(base, property);
        }
        return true;
    }

    @Override
    @Deprecated(forRemoval=true, since="EL 5.0")
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return String.class;
    }
}

