/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.ArrayELResolver;
import jakarta.el.BeanELResolver;
import jakarta.el.BeanNameELResolver;
import jakarta.el.BeanNameResolver;
import jakarta.el.CompositeELResolver;
import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.ExpressionFactory;
import jakarta.el.FunctionMapper;
import jakarta.el.ListELResolver;
import jakarta.el.MapELResolver;
import jakarta.el.PropertyNotWritableException;
import jakarta.el.ResourceBundleELResolver;
import jakarta.el.StaticFieldELResolver;
import jakarta.el.ValueExpression;
import jakarta.el.VariableMapper;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class StandardELContext
extends ELContext {
    private final ELContext wrappedContext;
    private final VariableMapper variableMapper;
    private final FunctionMapper functionMapper;
    private final CompositeELResolver standardResolver;
    private final CompositeELResolver customResolvers;
    private final Map<String, Object> localBeans = new HashMap<String, Object>();

    public StandardELContext(ExpressionFactory factory) {
        this.wrappedContext = null;
        this.variableMapper = new StandardVariableMapper();
        this.functionMapper = new StandardFunctionMapper(factory.getInitFunctionMap());
        this.standardResolver = new CompositeELResolver();
        this.customResolvers = new CompositeELResolver();
        ELResolver streamResolver = factory.getStreamELResolver();
        this.standardResolver.add(new BeanNameELResolver(new StandardBeanNameResolver(this.localBeans)));
        this.standardResolver.add(this.customResolvers);
        if (streamResolver != null) {
            this.standardResolver.add(streamResolver);
        }
        this.standardResolver.add(new StaticFieldELResolver());
        this.standardResolver.add(new MapELResolver());
        this.standardResolver.add(new ResourceBundleELResolver());
        this.standardResolver.add(new ListELResolver());
        this.standardResolver.add(new ArrayELResolver());
        this.standardResolver.add(new BeanELResolver());
    }

    public StandardELContext(ELContext context) {
        this.wrappedContext = context;
        this.variableMapper = context.getVariableMapper();
        this.functionMapper = context.getFunctionMapper();
        this.standardResolver = new CompositeELResolver();
        this.customResolvers = new CompositeELResolver();
        this.standardResolver.add(new BeanNameELResolver(new StandardBeanNameResolver(this.localBeans)));
        this.standardResolver.add(this.customResolvers);
        this.standardResolver.add(context.getELResolver());
    }

    @Override
    public void putContext(Class<?> key2, Object contextObject) {
        if (this.wrappedContext == null) {
            super.putContext(key2, contextObject);
        } else {
            this.wrappedContext.putContext(key2, contextObject);
        }
    }

    @Override
    public Object getContext(Class<?> key2) {
        if (this.wrappedContext == null) {
            return super.getContext(key2);
        }
        return this.wrappedContext.getContext(key2);
    }

    @Override
    public ELResolver getELResolver() {
        return this.standardResolver;
    }

    public void addELResolver(ELResolver resolver) {
        this.customResolvers.add(resolver);
    }

    @Override
    public FunctionMapper getFunctionMapper() {
        return this.functionMapper;
    }

    @Override
    public VariableMapper getVariableMapper() {
        return this.variableMapper;
    }

    Map<String, Object> getLocalBeans() {
        return this.localBeans;
    }

    private static class StandardVariableMapper
    extends VariableMapper {
        private Map<String, ValueExpression> vars;

        private StandardVariableMapper() {
        }

        @Override
        public ValueExpression resolveVariable(String variable) {
            if (this.vars == null) {
                return null;
            }
            return this.vars.get(variable);
        }

        @Override
        public ValueExpression setVariable(String variable, ValueExpression expression) {
            if (this.vars == null) {
                this.vars = new HashMap<String, ValueExpression>();
            }
            if (expression == null) {
                return this.vars.remove(variable);
            }
            return this.vars.put(variable, expression);
        }
    }

    private static class StandardFunctionMapper
    extends FunctionMapper {
        private final Map<String, Method> methods = new HashMap<String, Method>();

        StandardFunctionMapper(Map<String, Method> initFunctionMap) {
            if (initFunctionMap != null) {
                this.methods.putAll(initFunctionMap);
            }
        }

        @Override
        public Method resolveFunction(String prefix, String localName) {
            String key2 = prefix + ":" + localName;
            return this.methods.get(key2);
        }

        @Override
        public void mapFunction(String prefix, String localName, Method method2) {
            String key2 = prefix + ":" + localName;
            if (method2 == null) {
                this.methods.remove(key2);
            } else {
                this.methods.put(key2, method2);
            }
        }
    }

    private static class StandardBeanNameResolver
    extends BeanNameResolver {
        private final Map<String, Object> beans;

        StandardBeanNameResolver(Map<String, Object> beans2) {
            this.beans = beans2;
        }

        @Override
        public boolean isNameResolved(String beanName) {
            return this.beans.containsKey(beanName);
        }

        @Override
        public Object getBean(String beanName) {
            return this.beans.get(beanName);
        }

        @Override
        public void setBeanValue(String beanName, Object value2) throws PropertyNotWritableException {
            this.beans.put(beanName, value2);
        }

        @Override
        public boolean isReadOnly(String beanName) {
            return false;
        }

        @Override
        public boolean canCreateBean(String beanName) {
            return true;
        }
    }
}

