/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.Util;
import jakarta.el.ValueExpression;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LambdaExpression {
    private final List<String> formalParameters;
    private final ValueExpression expression;
    private final Map<String, Object> nestedArguments = new HashMap<String, Object>();
    private ELContext context = null;

    public LambdaExpression(List<String> formalParameters, ValueExpression expression) {
        this.formalParameters = formalParameters;
        this.expression = expression;
    }

    public void setELContext(ELContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(ELContext context, Object ... args2) throws ELException {
        Objects.requireNonNull(context);
        int formalParamCount = 0;
        if (this.formalParameters != null) {
            formalParamCount = this.formalParameters.size();
        }
        int argCount = 0;
        if (args2 != null) {
            argCount = args2.length;
        }
        if (formalParamCount > argCount) {
            throw new ELException(Util.message(context, "lambdaExpression.tooFewArgs", argCount, formalParamCount));
        }
        HashMap<String, Object> lambdaArguments = new HashMap<String, Object>(this.nestedArguments);
        for (int i2 = 0; i2 < formalParamCount; ++i2) {
            lambdaArguments.put(this.formalParameters.get(i2), args2[i2]);
        }
        context.enterLambdaScope(lambdaArguments);
        try {
            Object result2 = this.expression.getValue(context);
            if (result2 instanceof LambdaExpression) {
                ((LambdaExpression)result2).nestedArguments.putAll(lambdaArguments);
            }
            Object t = result2;
            return t;
        }
        finally {
            context.exitLambdaScope();
        }
    }

    public Object invoke(Object ... args2) {
        return this.invoke(this.context, args2);
    }
}

