/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.ELContext;
import jakarta.el.ELManager;
import jakarta.el.ExpressionFactory;
import jakarta.el.ImportHandler;
import jakarta.el.Util;
import jakarta.el.ValueExpression;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;

public class ELProcessor {
    private static final Set<String> PRIMITIVES = new HashSet<String>();
    private static final String[] EMPTY_STRING_ARRAY;
    private final ELManager manager = new ELManager();
    private final ELContext context = this.manager.getELContext();
    private final ExpressionFactory factory = ELManager.getExpressionFactory();

    public ELManager getELManager() {
        return this.manager;
    }

    public <T> T eval(String expression) {
        Object result2 = this.getValue(expression, Object.class);
        return (T)result2;
    }

    public <T> T getValue(String expression, Class<T> expectedType) {
        ValueExpression ve = this.factory.createValueExpression(this.context, ELProcessor.bracket(expression), expectedType);
        return ve.getValue(this.context);
    }

    public void setValue(String expression, Object value2) {
        ValueExpression ve = this.factory.createValueExpression(this.context, ELProcessor.bracket(expression), Object.class);
        ve.setValue(this.context, value2);
    }

    public void setVariable(String variable, String expression) {
        if (expression == null) {
            this.manager.setVariable(variable, null);
        } else {
            ValueExpression ve = this.factory.createValueExpression(this.context, ELProcessor.bracket(expression), Object.class);
            this.manager.setVariable(variable, ve);
        }
    }

    public void defineFunction(String prefix, String function, String className, String methodName) throws ClassNotFoundException, NoSuchMethodException {
        Method[] methods2;
        if (prefix == null || function == null || className == null || methodName == null) {
            throw new NullPointerException(Util.message(this.context, "elProcessor.defineFunctionNullParams", new Object[0]));
        }
        Class<?> clazz = this.context.getImportHandler().resolveClass(className);
        if (clazz == null) {
            clazz = Class.forName(className, true, Util.getContextClassLoader());
        }
        if (!Modifier.isPublic(clazz.getModifiers())) {
            throw new ClassNotFoundException(Util.message(this.context, "elProcessor.defineFunctionInvalidClass", className));
        }
        MethodSignature sig = new MethodSignature(this.context, methodName, className);
        if (function.length() == 0) {
            function = sig.getName();
        }
        for (Method method2 : methods2 = clazz.getMethods()) {
            String[] typeNames;
            if (!Modifier.isStatic(method2.getModifiers()) || !Util.canAccess(null, method2) || !method2.getName().equals(sig.getName())) continue;
            if (sig.getParamTypeNames() == null) {
                this.manager.mapFunction(prefix, function, method2);
                return;
            }
            if (sig.getParamTypeNames().length != method2.getParameterTypes().length) continue;
            if (sig.getParamTypeNames().length == 0) {
                this.manager.mapFunction(prefix, function, method2);
                return;
            }
            Class<?>[] types = method2.getParameterTypes();
            if (types.length != (typeNames = sig.getParamTypeNames()).length) continue;
            boolean match2 = true;
            for (int i2 = 0; i2 < types.length; ++i2) {
                if (i2 == types.length - 1 && method2.isVarArgs()) {
                    String typeName = typeNames[i2];
                    if (typeName.endsWith("...")) {
                        if ((typeName = typeName.substring(0, typeName.length() - 3)).equals(types[i2].getName())) continue;
                        match2 = false;
                        continue;
                    }
                    match2 = false;
                    continue;
                }
                if (types[i2].getName().equals(typeNames[i2])) continue;
                match2 = false;
                break;
            }
            if (!match2) continue;
            this.manager.mapFunction(prefix, function, method2);
            return;
        }
        throw new NoSuchMethodException(Util.message(this.context, "elProcessor.defineFunctionNoMethod", methodName, className));
    }

    public void defineFunction(String prefix, String function, Method method2) throws NoSuchMethodException {
        if (prefix == null || function == null || method2 == null) {
            throw new NullPointerException(Util.message(this.context, "elProcessor.defineFunctionNullParams", new Object[0]));
        }
        int modifiers = method2.getModifiers();
        if (!Modifier.isStatic(modifiers) || !Util.canAccess(null, method2)) {
            throw new NoSuchMethodException(Util.message(this.context, "elProcessor.defineFunctionInvalidMethod", method2.getName(), method2.getDeclaringClass().getName()));
        }
        this.manager.mapFunction(prefix, function, method2);
    }

    public void defineBean(String name2, Object bean2) {
        this.manager.defineBean(name2, bean2);
    }

    private static String bracket(String expression) {
        return "${" + expression + "}";
    }

    static {
        PRIMITIVES.add("boolean");
        PRIMITIVES.add("byte");
        PRIMITIVES.add("char");
        PRIMITIVES.add("double");
        PRIMITIVES.add("float");
        PRIMITIVES.add("int");
        PRIMITIVES.add("long");
        PRIMITIVES.add("short");
        EMPTY_STRING_ARRAY = new String[0];
    }

    private static class MethodSignature {
        private final String name;
        private final String[] parameterTypeNames;

        MethodSignature(ELContext context, String methodName, String className) throws NoSuchMethodException {
            int paramIndex = methodName.indexOf(40);
            if (paramIndex == -1) {
                this.name = methodName.trim();
                this.parameterTypeNames = null;
            } else {
                String returnTypeAndName = methodName.substring(0, paramIndex).trim();
                int wsPos = -1;
                for (int i2 = 0; i2 < returnTypeAndName.length(); ++i2) {
                    if (!Character.isWhitespace(returnTypeAndName.charAt(i2))) continue;
                    wsPos = i2;
                    break;
                }
                if (wsPos == -1) {
                    throw new NoSuchMethodException();
                }
                this.name = returnTypeAndName.substring(wsPos).trim();
                String paramString = methodName.substring(paramIndex).trim();
                if (!paramString.endsWith(")")) {
                    throw new NoSuchMethodException(Util.message(context, "elProcessor.defineFunctionInvalidParameterList", paramString, methodName, className));
                }
                if ((paramString = paramString.substring(1, paramString.length() - 1).trim()).length() == 0) {
                    this.parameterTypeNames = EMPTY_STRING_ARRAY;
                } else {
                    this.parameterTypeNames = paramString.split(",");
                    ImportHandler importHandler = context.getImportHandler();
                    for (int i3 = 0; i3 < this.parameterTypeNames.length; ++i3) {
                        boolean isPrimitive;
                        Object parameterTypeName = this.parameterTypeNames[i3].trim();
                        int dimension = 0;
                        int bracketPos = ((String)parameterTypeName).indexOf(91);
                        if (bracketPos > -1) {
                            String parameterTypeNameOnly = ((String)parameterTypeName).substring(0, bracketPos).trim();
                            while (bracketPos > -1) {
                                ++dimension;
                                bracketPos = ((String)parameterTypeName).indexOf(91, bracketPos + 1);
                            }
                            parameterTypeName = parameterTypeNameOnly;
                        }
                        boolean varArgs = false;
                        if (((String)parameterTypeName).endsWith("...")) {
                            varArgs = true;
                            dimension = 1;
                            parameterTypeName = ((String)parameterTypeName).substring(0, ((String)parameterTypeName).length() - 3).trim();
                        }
                        if ((isPrimitive = PRIMITIVES.contains(parameterTypeName)) && dimension > 0) {
                            switch (parameterTypeName) {
                                case "boolean": {
                                    parameterTypeName = "Z";
                                    break;
                                }
                                case "byte": {
                                    parameterTypeName = "B";
                                    break;
                                }
                                case "char": {
                                    parameterTypeName = "C";
                                    break;
                                }
                                case "double": {
                                    parameterTypeName = "D";
                                    break;
                                }
                                case "float": {
                                    parameterTypeName = "F";
                                    break;
                                }
                                case "int": {
                                    parameterTypeName = "I";
                                    break;
                                }
                                case "long": {
                                    parameterTypeName = "J";
                                    break;
                                }
                                case "short": {
                                    parameterTypeName = "S";
                                    break;
                                }
                            }
                        } else if (!isPrimitive && !((String)parameterTypeName).contains(".")) {
                            Class<?> clazz = importHandler.resolveClass((String)parameterTypeName);
                            if (clazz == null) {
                                throw new NoSuchMethodException(Util.message(context, "elProcessor.defineFunctionInvalidParameterTypeName", this.parameterTypeNames[i3], methodName, className));
                            }
                            parameterTypeName = clazz.getName();
                        }
                        if (dimension > 0) {
                            StringBuilder sb = new StringBuilder();
                            for (int j = 0; j < dimension; ++j) {
                                sb.append('[');
                            }
                            if (!isPrimitive) {
                                sb.append('L');
                            }
                            sb.append((String)parameterTypeName);
                            if (!isPrimitive) {
                                sb.append(';');
                            }
                            parameterTypeName = sb.toString();
                        }
                        if (varArgs) {
                            parameterTypeName = (String)parameterTypeName + "...";
                        }
                        this.parameterTypeNames[i3] = parameterTypeName;
                    }
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public String[] getParamTypeNames() {
            return this.parameterTypeNames;
        }
    }
}

