/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.ELManager;
import jakarta.el.ELResolver;
import jakarta.el.EvaluationListener;
import jakarta.el.FunctionMapper;
import jakarta.el.ImportHandler;
import jakarta.el.LambdaExpression;
import jakarta.el.Util;
import jakarta.el.VariableMapper;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public abstract class ELContext {
    private Locale locale;
    private Map<Class<?>, Object> map;
    private boolean resolved = false;
    private ImportHandler importHandler = null;
    private List<EvaluationListener> listeners;
    private Deque<Map<String, Object>> lambdaArguments = new ArrayDeque<Map<String, Object>>();

    public void setPropertyResolved(boolean resolved) {
        this.resolved = resolved;
    }

    public void setPropertyResolved(Object base, Object property) {
        this.setPropertyResolved(true);
        this.notifyPropertyResolved(base, property);
    }

    public boolean isPropertyResolved() {
        return this.resolved;
    }

    public void putContext(Class<?> key2, Object contextObject) {
        Objects.requireNonNull(key2);
        Objects.requireNonNull(contextObject);
        if (this.map == null) {
            this.map = new HashMap();
        }
        this.map.put(key2, contextObject);
    }

    public Object getContext(Class<?> key2) {
        Objects.requireNonNull(key2);
        if (this.map == null) {
            return null;
        }
        return this.map.get(key2);
    }

    public abstract ELResolver getELResolver();

    public ImportHandler getImportHandler() {
        if (this.importHandler == null) {
            this.importHandler = new ImportHandler();
        }
        return this.importHandler;
    }

    public abstract FunctionMapper getFunctionMapper();

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public abstract VariableMapper getVariableMapper();

    public void addEvaluationListener(EvaluationListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<EvaluationListener>();
        }
        this.listeners.add(listener);
    }

    public List<EvaluationListener> getEvaluationListeners() {
        return this.listeners == null ? Collections.emptyList() : this.listeners;
    }

    public void notifyBeforeEvaluation(String expression) {
        if (this.listeners == null) {
            return;
        }
        for (EvaluationListener listener : this.listeners) {
            try {
                listener.beforeEvaluation(this, expression);
            }
            catch (Throwable t) {
                Util.handleThrowable(t);
            }
        }
    }

    public void notifyAfterEvaluation(String expression) {
        if (this.listeners == null) {
            return;
        }
        for (EvaluationListener listener : this.listeners) {
            try {
                listener.afterEvaluation(this, expression);
            }
            catch (Throwable t) {
                Util.handleThrowable(t);
            }
        }
    }

    public void notifyPropertyResolved(Object base, Object property) {
        if (this.listeners == null) {
            return;
        }
        for (EvaluationListener listener : this.listeners) {
            try {
                listener.propertyResolved(this, base, property);
            }
            catch (Throwable t) {
                Util.handleThrowable(t);
            }
        }
    }

    public boolean isLambdaArgument(String name2) {
        for (Map<String, Object> arguments : this.lambdaArguments) {
            if (!arguments.containsKey(name2)) continue;
            return true;
        }
        return false;
    }

    public Object getLambdaArgument(String name2) {
        for (Map<String, Object> arguments : this.lambdaArguments) {
            Object result2 = arguments.get(name2);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    public void enterLambdaScope(Map<String, Object> arguments) {
        this.lambdaArguments.push(arguments);
    }

    public void exitLambdaScope() {
        this.lambdaArguments.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T convertToType(Object obj, Class<T> type2) {
        boolean originalResolved = this.isPropertyResolved();
        this.setPropertyResolved(false);
        try {
            ELResolver resolver = this.getELResolver();
            if (resolver != null) {
                T result2 = resolver.convertToType(this, obj, type2);
                if (this.isPropertyResolved()) {
                    T t = result2;
                    return t;
                }
            }
        }
        finally {
            this.setPropertyResolved(originalResolved);
        }
        if (obj instanceof LambdaExpression && ELContext.isFunctionalInterface(type2)) {
            ((LambdaExpression)obj).setELContext(this);
        }
        return ELManager.getExpressionFactory().coerceToType(obj, type2);
    }

    static boolean isFunctionalInterface(Class<?> type2) {
        Method[] methods2;
        if (!type2.isInterface()) {
            return false;
        }
        boolean foundAbstractMethod = false;
        for (Method method2 : methods2 = type2.getMethods()) {
            if (!Modifier.isAbstract(method2.getModifiers()) || ELContext.overridesObjectMethod(method2)) continue;
            if (foundAbstractMethod) {
                return false;
            }
            foundAbstractMethod = true;
        }
        return foundAbstractMethod;
    }

    private static boolean overridesObjectMethod(Method method2) {
        return "equals".equals(method2.getName()) ? method2.getReturnType().equals(Boolean.TYPE) && method2.getParameterCount() == 1 && method2.getParameterTypes()[0].equals(Object.class) : ("hashCode".equals(method2.getName()) ? method2.getReturnType().equals(Integer.TYPE) && method2.getParameterCount() == 0 : "toString".equals(method2.getName()) && method2.getReturnType().equals(String.class) && method2.getParameterCount() == 0);
    }
}

