/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.BeanNameResolver;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ELResolver;
import jakarta.el.PropertyNotWritableException;
import jakarta.el.Util;
import java.beans.FeatureDescriptor;
import java.util.Iterator;
import java.util.Objects;

public class BeanNameELResolver
extends ELResolver {
    private final BeanNameResolver beanNameResolver;

    public BeanNameELResolver(BeanNameResolver beanNameResolver) {
        this.beanNameResolver = beanNameResolver;
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        if (base != null || !(property instanceof String)) {
            return null;
        }
        String beanName = (String)property;
        if (this.beanNameResolver.isNameResolved(beanName)) {
            try {
                Object result2 = this.beanNameResolver.getBean(beanName);
                context.setPropertyResolved(base, property);
                return result2;
            }
            catch (Throwable t) {
                Util.handleThrowable(t);
                throw new ELException(t);
            }
        }
        return null;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value2) {
        boolean isReadOnly;
        Objects.requireNonNull(context);
        if (base != null || !(property instanceof String)) {
            return;
        }
        String beanName = (String)property;
        boolean isResolved = context.isPropertyResolved();
        try {
            isReadOnly = this.isReadOnly(context, base, property);
        }
        catch (Throwable t) {
            Util.handleThrowable(t);
            throw new ELException(t);
        }
        finally {
            context.setPropertyResolved(isResolved);
        }
        if (isReadOnly) {
            throw new PropertyNotWritableException(Util.message(context, "beanNameELResolver.beanReadOnly", beanName));
        }
        if (this.beanNameResolver.isNameResolved(beanName) || this.beanNameResolver.canCreateBean(beanName)) {
            try {
                this.beanNameResolver.setBeanValue(beanName, value2);
                context.setPropertyResolved(base, property);
            }
            catch (Throwable t) {
                Util.handleThrowable(t);
                throw new ELException(t);
            }
        }
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        if (base != null || !(property instanceof String)) {
            return null;
        }
        String beanName = (String)property;
        try {
            if (this.beanNameResolver.isNameResolved(beanName)) {
                Class<?> result2 = this.beanNameResolver.getBean(beanName).getClass();
                context.setPropertyResolved(base, property);
                if (this.beanNameResolver.isReadOnly((String)property)) {
                    return null;
                }
                return result2;
            }
        }
        catch (Throwable t) {
            Util.handleThrowable(t);
            throw new ELException(t);
        }
        return null;
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        if (base != null || !(property instanceof String)) {
            return false;
        }
        String beanName = (String)property;
        if (this.beanNameResolver.isNameResolved(beanName)) {
            boolean result2;
            try {
                result2 = this.beanNameResolver.isReadOnly(beanName);
            }
            catch (Throwable t) {
                Util.handleThrowable(t);
                throw new ELException(t);
            }
            context.setPropertyResolved(base, property);
            return result2;
        }
        return false;
    }

    @Override
    @Deprecated(forRemoval=true, since="EL 5.0")
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return String.class;
    }
}

