/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ELManager;
import jakarta.el.ELResolver;
import jakarta.el.ExpressionFactory;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.PropertyNotWritableException;
import jakarta.el.Util;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public class BeanELResolver
extends ELResolver {
    private static final int CACHE_SIZE = System.getSecurityManager() == null ? Integer.getInteger("org.apache.el.BeanELResolver.CACHE_SIZE", 1000).intValue() : AccessController.doPrivileged(() -> Integer.getInteger(CACHE_SIZE_PROP, 1000)).intValue();
    private static final String CACHE_SIZE_PROP = "org.apache.el.BeanELResolver.CACHE_SIZE";
    private final boolean readOnly;
    private final ConcurrentCache<String, BeanProperties> cache = new ConcurrentCache(CACHE_SIZE);

    public BeanELResolver() {
        this.readOnly = false;
    }

    public BeanELResolver(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        if (base == null || property == null) {
            return null;
        }
        context.setPropertyResolved(base, property);
        BeanProperty beanProperty = this.property(context, base, property);
        if (this.readOnly || beanProperty.isReadOnly(base)) {
            return null;
        }
        return beanProperty.getPropertyType();
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        if (base == null || property == null) {
            return null;
        }
        context.setPropertyResolved(base, property);
        Method m = this.property(context, base, property).read(context, base);
        try {
            return m.invoke(base, (Object[])null);
        }
        catch (InvocationTargetException e) {
            Throwable cause2 = e.getCause();
            Util.handleThrowable(cause2);
            throw new ELException(Util.message(context, "propertyReadError", base.getClass().getName(), property.toString()), cause2);
        }
        catch (Exception e) {
            throw new ELException(e);
        }
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value2) {
        Objects.requireNonNull(context);
        if (base == null || property == null) {
            return;
        }
        context.setPropertyResolved(base, property);
        if (this.readOnly) {
            throw new PropertyNotWritableException(Util.message(context, "resolverNotWritable", base.getClass().getName()));
        }
        Method m = this.property(context, base, property).write(context, base);
        try {
            m.invoke(base, value2);
        }
        catch (InvocationTargetException e) {
            Throwable cause2 = e.getCause();
            Util.handleThrowable(cause2);
            throw new ELException(Util.message(context, "propertyWriteError", base.getClass().getName(), property.toString()), cause2);
        }
        catch (Exception e) {
            throw new ELException(e);
        }
    }

    @Override
    public Object invoke(ELContext context, Object base, Object method2, Class<?>[] paramTypes, Object[] params2) {
        Objects.requireNonNull(context);
        if (base == null || method2 == null) {
            return null;
        }
        ExpressionFactory factory = ELManager.getExpressionFactory();
        String methodName = factory.coerceToType(method2, String.class);
        Method matchingMethod = Util.findMethod(context, base.getClass(), base, methodName, paramTypes, params2);
        Object[] parameters2 = Util.buildParameters(context, matchingMethod.getParameterTypes(), matchingMethod.isVarArgs(), params2);
        Object result2 = null;
        try {
            result2 = matchingMethod.invoke(base, parameters2);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new ELException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause2 = e.getCause();
            Util.handleThrowable(cause2);
            throw new ELException(cause2);
        }
        context.setPropertyResolved(base, method2);
        return result2;
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        if (base == null || property == null) {
            return false;
        }
        context.setPropertyResolved(base, property);
        return this.readOnly || this.property(context, base, property).isReadOnly(base);
    }

    @Override
    @Deprecated(forRemoval=true, since="EL 5.0")
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (base == null) {
            return null;
        }
        try {
            PropertyDescriptor[] pds;
            BeanInfo info = Introspector.getBeanInfo(base.getClass());
            for (PropertyDescriptor pd : pds = info.getPropertyDescriptors()) {
                pd.setValue("resolvableAtDesignTime", Boolean.TRUE);
                pd.setValue("type", pd.getPropertyType());
            }
            return Arrays.asList((FeatureDescriptor[])pds).iterator();
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base != null) {
            return Object.class;
        }
        return null;
    }

    private BeanProperty property(ELContext ctx, Object base, Object property) {
        Class<?> type2 = base.getClass();
        String prop = property.toString();
        BeanProperties props = this.cache.get(type2.getName());
        if (props == null || type2 != props.getType()) {
            props = new BeanProperties(type2);
            this.cache.put(type2.getName(), props);
        }
        return props.get(ctx, prop);
    }

    private static final class ConcurrentCache<K, V> {
        private final int size;
        private final Map<K, V> eden;
        private final Map<K, V> longterm;

        ConcurrentCache(int size2) {
            this.size = size2;
            this.eden = new ConcurrentHashMap(size2);
            this.longterm = new WeakHashMap(size2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V get(K key2) {
            V value2 = this.eden.get(key2);
            if (value2 == null) {
                Map<K, V> map2 = this.longterm;
                synchronized (map2) {
                    value2 = this.longterm.get(key2);
                }
                if (value2 != null) {
                    this.eden.put(key2, value2);
                }
            }
            return value2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(K key2, V value2) {
            if (this.eden.size() >= this.size) {
                Map<K, V> map2 = this.longterm;
                synchronized (map2) {
                    this.longterm.putAll(this.eden);
                }
                this.eden.clear();
            }
            this.eden.put(key2, value2);
        }
    }

    static final class BeanProperty {
        private final Class<?> type;
        private final Class<?> owner;
        private final PropertyDescriptor descriptor;
        private Method read;
        private Method write;

        BeanProperty(Class<?> owner2, PropertyDescriptor descriptor) {
            this.owner = owner2;
            this.descriptor = descriptor;
            this.type = descriptor.getPropertyType();
        }

        public Class<?> getPropertyType() {
            return this.type;
        }

        public boolean isReadOnly(Object base) {
            return this.write == null && null == (this.write = Util.getMethod(this.owner, base, this.descriptor.getWriteMethod()));
        }

        private Method write(ELContext ctx, Object base) {
            if (this.write == null) {
                this.write = Util.getMethod(this.owner, base, this.descriptor.getWriteMethod());
                if (this.write == null) {
                    throw new PropertyNotWritableException(Util.message(ctx, "propertyNotWritable", this.owner.getName(), this.descriptor.getName()));
                }
            }
            return this.write;
        }

        private Method read(ELContext ctx, Object base) {
            if (this.read == null) {
                this.read = Util.getMethod(this.owner, base, this.descriptor.getReadMethod());
                if (this.read == null) {
                    throw new PropertyNotFoundException(Util.message(ctx, "propertyNotReadable", this.owner.getName(), this.descriptor.getName()));
                }
            }
            return this.read;
        }
    }

    static final class BeanProperties {
        private final Map<String, BeanProperty> properties;
        private final Class<?> type;

        BeanProperties(Class<?> type2) throws ELException {
            this.type = type2;
            this.properties = new HashMap<String, BeanProperty>();
            try {
                PropertyDescriptor[] pds;
                BeanInfo info = Introspector.getBeanInfo(this.type);
                for (PropertyDescriptor pd : pds = info.getPropertyDescriptors()) {
                    this.properties.put(pd.getName(), new BeanProperty(type2, pd));
                }
                this.populateFromInterfaces(type2);
            }
            catch (IntrospectionException ie) {
                throw new ELException(ie);
            }
        }

        private void populateFromInterfaces(Class<?> aClass) throws IntrospectionException {
            Class<?> superclass2;
            Class<?>[] interfaces2 = aClass.getInterfaces();
            if (interfaces2.length > 0) {
                for (Class<?> ifs : interfaces2) {
                    PropertyDescriptor[] pds;
                    BeanInfo info = Introspector.getBeanInfo(ifs);
                    for (PropertyDescriptor pd : pds = info.getPropertyDescriptors()) {
                        if (this.properties.containsKey(pd.getName())) continue;
                        this.properties.put(pd.getName(), new BeanProperty(this.type, pd));
                    }
                    this.populateFromInterfaces(ifs);
                }
            }
            if ((superclass2 = aClass.getSuperclass()) != null) {
                this.populateFromInterfaces(superclass2);
            }
        }

        private BeanProperty get(ELContext ctx, String name2) {
            BeanProperty property = this.properties.get(name2);
            if (property == null) {
                throw new PropertyNotFoundException(Util.message(ctx, "propertyNotFound", this.type.getName(), name2));
            }
            return property;
        }

        private Class<?> getType() {
            return this.type;
        }
    }
}

