/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.common.util;

import io.micrometer.common.lang.Nullable;

public final class StringUtils {
    public static boolean isBlank(@Nullable String string2) {
        if (StringUtils.isEmpty(string2)) {
            return true;
        }
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            if (Character.isWhitespace(string2.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(@Nullable String string2) {
        return !StringUtils.isBlank(string2);
    }

    public static boolean isEmpty(@Nullable String string2) {
        return string2 == null || string2.isEmpty();
    }

    public static boolean isNotEmpty(@Nullable String string2) {
        return !StringUtils.isEmpty(string2);
    }

    public static String truncate(String string2, int maxLength) {
        if (string2.length() > maxLength) {
            return string2.substring(0, maxLength);
        }
        return string2;
    }

    public static String truncate(String string2, int maxLength, String truncationIndicator) {
        if (truncationIndicator.length() >= maxLength) {
            throw new IllegalArgumentException("maxLength must be greater than length of truncationIndicator");
        }
        if (string2.length() > maxLength) {
            int remainingLength = maxLength - truncationIndicator.length();
            return string2.substring(0, remainingLength) + truncationIndicator;
        }
        return string2;
    }

    private StringUtils() {
    }
}

